<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	
	<?php wp_head(); ?>
	
</head>
<body <?php body_class(); ?>>
<div class="kd-menu-effect"></div>
	<?php
		$kingdom_core = kingdom()->coreFunctions;
		$enable_display = get_theme_mod('enable_display', $kingdom_core->defaults_theme["enable_display"]);
		$enable_top_bar = get_theme_mod('enable_top_bar', $kingdom_core->defaults_theme["enable_top_bar"]);
		$email = get_theme_mod('email', $kingdom_core->defaults_theme["email"]);
		$phone_no = get_theme_mod('phone_no', $kingdom_core->defaults_theme["phone_no"]);
		$head_cart = get_theme_mod('head_cart', $kingdom_core->defaults_theme["head_cart"]);
		$head_search = get_theme_mod('head_search', $kingdom_core->defaults_theme["head_search"]);
		$head_search_in = get_theme_mod('head_search_in', $kingdom_core->defaults_theme["head_search_in"]);
		$head_facebook_url_on = get_theme_mod('head_facebook_url_on', $kingdom_core->defaults_theme["head_facebook_url_on"]);
		$head_facebook_url = get_theme_mod('head_facebook_url', $kingdom_core->defaults_theme["head_facebook_url"]);	
		$head_twitter_url_on = get_theme_mod('head_twitter_url_on', $kingdom_core->defaults_theme["head_twitter_url_on"]);
		$head_twitter_url = get_theme_mod('head_twitter_url', $kingdom_core->defaults_theme["head_twitter_url"]);
		$head_youtube_url_on = get_theme_mod('head_youtube_url_on', $kingdom_core->defaults_theme["head_youtube_url_on"]);
		$head_youtube_url = get_theme_mod('head_youtube_url', $kingdom_core->defaults_theme["head_youtube_url"]);
		$head_gplus_url_on = get_theme_mod('head_gplus_url_on', $kingdom_core->defaults_theme["head_gplus_url_on"]);
		$head_gplus_url = get_theme_mod('head_gplus_url', $kingdom_core->defaults_theme["head_gplus_url"]);
		$head_instagram_url_on = get_theme_mod('head_instagram_url_on', $kingdom_core->defaults_theme["head_instagram_url_on"]);
		$head_instagram_url = get_theme_mod('head_instagram_url', $kingdom_core->defaults_theme["head_instagram_url"]);
		$head_pinterest_url_on = get_theme_mod('head_pinterest_url_on', $kingdom_core->defaults_theme["head_pinterest_url_on"]);
		$head_pinterest_url = get_theme_mod('head_pinterest_url', $kingdom_core->defaults_theme["head_pinterest_url"]);
	?>
	<?php if( $enable_top_bar == 'YES' ) { ?>
		<div class="kd_header_top">
			<div class="container ">
				<div class="row">
					<div class="col-lg-6 col-md-5 col-sm-4 col-xs-12">
						<?php
						if(has_nav_menu( 'top_nav' )){
						?>
							<!-- Main Menu -->
							<nav class="kd_header_top_menu">
								<?php
								wp_nav_menu(array(
									'theme_location' => 'top_nav',
									'menu_id' => 'top_nav'
								));
								?>
							</nav>
						<?php
						}
						?>
					</div>
					<div class="col-lg-6 col-md-7 col-sm-8 col-xs-12">
						<?php if( $email ){ ?>
							<div class="kd_email_support">
								<a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a>
							</div>
						<?php } ?>
						
						<?php if( $phone_no ){ ?>
							<div class="kd_phone_support">
								<a href="tel:<?php echo $phone_no; ?>"><?php echo $phone_no; ?></a>	
							</div>
						<?php } ?>
						
						<ul class="kd_header_social_list">
							<?php if( $head_facebook_url_on == 'YES' ) { ?>
								<li>
									<a href="<?php echo esc_url( $head_facebook_url ); ?>" target="_blank">
										<i class="fa fa-facebook" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
							<?php if( $head_twitter_url_on == 'YES' ) { ?>
								<li>
									<a href="<?php echo esc_url( $head_twitter_url ); ?>" target="_blank">
										<i class="fa fa-twitter" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
							<?php if( $head_youtube_url_on == 'YES' ) { ?>
								<li>
									<a href="<?php echo esc_url( $head_youtube_url ); ?>" target="_blank">
										<i class="fa fa-youtube-play" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
							<?php if( $head_gplus_url_on == 'YES' ) { ?>
								<li>
									<a href="<?php echo esc_url( $head_gplus_url ); ?>" target="_blank">
										<i class="fa fa-google-plus" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
							<?php if( $head_instagram_url_on == 'YES' ) { ?>
								<li>
									<a href="<?php echo esc_url( $head_instagram_url ); ?>" target="_blank">
										<i class="fa fa-instagram" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
							<?php if( $head_pinterest_url_on == 'YES' ) { ?>
								<li>
									<a href="<?php echo esc_url( $head_pinterest_url ); ?>" target="_blank">
										<i class="fa fa-pinterest" aria-hidden="true"></i>
									</a>
								</li>
							<?php } ?>
							
						</ul>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>
	<!-- Header Elements -->
	<div class="kd_header_bg_color">
	<div class="container ">
		<div class="kd_header_elements">
			<div class="row">
				<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
					<?php
						$logo_width = get_theme_mod('logo_width', $kingdom_core->defaults_theme["logo_width"]);
						$logo_width = ( $logo_width ) ? $logo_width : '100%';
						$logo_height = get_theme_mod('logo_height', $kingdom_core->defaults_theme["logo_height"]);
						$logo_height = ( $logo_height ) ? $logo_height : '100%';
						$logo = get_theme_mod('logo', $kingdom_core->defaults_theme["logo"]);
					?>
					<div class="kd_logo" style="max-width: <?php echo $logo_width; ?>; max-height: <?php echo $logo_height; ?>;">
						<a href="<?php echo esc_url( home_url('/') );?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
							<?php if( $logo ){
								echo '<img style="max-width: ' . $logo_width . '; max-height:  ' . $logo_height . ';" src="' .  $logo . '" alt="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '">';
							} else {
								echo '<img style="max-width: ' . $logo_width . '; max-height:  ' . $logo_height . ';" src="' . esc_url( (kingdom()->cfg['paths']['theme_dir_url']) . '/images/kd_logo.png' ) . '" alt="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '">';
							}
							?>
						</a>
					</div>
					
				</div>
				<?php if( $head_search == 'YES' || $head_cart == 'YES' ) { ?>
					<div class="col-lg-8 col-md-6 col-sm-6 col-xs-12">
						<?php if( $head_search == 'YES' ) { ?>
						<div class="kd_search">
							<form role="search" action="<?php echo esc_url( home_url('/') ); ?>" method="get">
								<?php if( $head_search_in == 'PRODUCTS' ) { ?>
									<input type="hidden" name="post_type" value="product" />
								<?php } ?>
								<button type="submit" class="kd_search_submit" value="<?php esc_html_e( 'Search', 'kingdom');?>" ><i class="fa fa-search" aria-hidden="true"></i></button>
								<input type="text" id="search" name="s" placeholder="<?php esc_html_e( 'type to search', 'kingdom'); ?>" />
							</form>
						</div>
						<?php } ?>
						<?php
						if( kingdom()->is_woo_activated() && $head_cart == 'YES' ) {
						?>
						<div id="kd_checkout_wrap">
							<a href="<?php echo wc_get_checkout_url(); ?>" class="kd_checkout_button"><?php esc_html_e( 'Checkout', 'kingdom'); ?></a>
							<div class="kd_small-cart">
								<div class="kd_cart-title">
										<i class="micon icon-cart5"></i>
										<?php global $woocommerce; ?>
										<a class="cart-contents" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_attr_e('View your shopping cart', 'kingdom'); ?>"><?php esc_html_e( 'Cart', 'kingdom' ); ?>: 
											<span><?php echo $woocommerce->cart->get_cart_total(); ?></span></a> - 
											<span class="kd_cart-itemsnumber">(<?php echo sprintf(_n('%d item', '%d items', $woocommerce->cart->cart_contents_count, 'kingdom'), $woocommerce->cart->cart_contents_count);?> )</span>
								</div>
								
								<div class="cart-details-wrapper">
									<?php
									//wc_get_template( 'cart/mini-cart.php' ); 
									?>
								</div>
							</div>
						</div>
						<?php
						}
						?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div><!-- END HEADER ELEMENTS -->
	</div>
	
	<!-- Main Menu -->
	<nav class="navigationbar <?php echo has_nav_menu( 'alternate_nav' ) ? 'kd_has_alternate_nav' : ''; ?>" >
		<div class="container">

			<?php
			if( has_nav_menu('alternate_nav') ) {
				$menu_name = 'alternate_nav';
				$locations = get_nav_menu_locations();
				$menu_id = $locations[ $menu_name ] ;
				$menu = wp_get_nav_menu_object($menu_id);
				
				echo '<div id="alternate_menu"><span>' . ( $menu->name ) . '</span>';
				wp_nav_menu(array(
					'theme_location' => 'alternate_nav',
					'menu_class' => 'kd_alternate_menu ' . ( $enable_display == 'YES' ? "kd_default_open_hp" : '') . '',
					'walker' => new kingdom_themeWalkerMainNav() 
				));
				echo '</div>';
			}
			//if( has_nav_menu( 'main_nav' ) ) {
			?>
			<div class="menu-headline">
				<span data-alttext="<?php esc_attr_e('Close Main Menu', 'kingdom'); ?>"><?php esc_attr_e('Main menu', 'kingdom'); ?></span>
				<i class="micon icon-menu7"></i>
			</div>
			<?php
				wp_nav_menu(array(
					'theme_location' => 'main_nav',
					'menu_class' => 'kd_main_menu',
					'fallback_cb' => 'wp_page_menu',
					'walker' => new kingdom_themeWalkerMainNav() 
				));
			//}
			?>
		</div>
	</nav>
	
	<?php  
	if( is_search() == false ) {
		if( isset(kingdom()->coreFunctions->data['layout']) && isset(kingdom()->coreFunctions->data['layout']['revolution_slider_select']) ) {
			$revslider_select = kingdom()->coreFunctions->data['layout']['revolution_slider_select'];
			//var_dump($revslider_select);
			//die;
			if( isset($revslider_select) && $revslider_select != '' && $revslider_select != 'no-slider' ) { 
				echo do_shortcode('[rev_slider alias="' . $revslider_select . '"]');
			}
		}
	}
	?>
	
	<!-- Breadcrumbs -->
	<?php
	if( !is_front_page() ){
	?>
		<div class="kd_breadcrumbs_bk">
			<div class="container">
				<div class="row">
					<?php echo kingdom()->coreFunctions->display_breadcrumbs();?>
				</div>
			</div>
		</div>
	<?php
	}
	?>
	
	<?php kingdom()->coreFunctions->printSidebar( 'top' ); ?>