<?php 
/**
 * @package WordPress
 * @subpackage:
 *	Name: 	Kingdom - Woocommerce Amazon Affiliate Theme
 *	Author: AA-Team
 *	Name: 	http://themeforest.net/user/AA-Team/portfolio
 *	
**/
! defined( 'ABSPATH' ) and exit;

// load the AA-Freamwork init file
$kingdom_theme_path = get_template_directory() . '/';
if(class_exists('kingdom') != true) {
    require_once( $kingdom_theme_path . 'aa-framework/freamwork.class.php' );

	// Initalize the theme
	$kingdom = new kingdom(); 

	// Add an activation hook
	add_action( "after_switch_theme", array( $kingdom, 'activate' ), 10 , 2); 
}


if ( ! function_exists( 'kingdom' ) ) {
	/**
	 * TMDB manager.
	 * @since 1.0
	 * @return TMDB
	 */
	function kingdom() {
		global $kingdom;

		return $kingdom;
	}
}

add_filter( 'woocommerce_product_add_to_cart_text' , 'kingdom_woocommerce_product_add_to_cart_text' );
add_filter( 'wp_calculate_image_srcset_meta', '__return_null' );
/**
* custom_woocommerce_template_loop_add_to_cart
*/
function kingdom_woocommerce_product_add_to_cart_text() {
	global $product;
	$product_type = method_exists( $product, 'get_type' ) ? $product->get_type() : $product->product_type;
	switch ( $product_type ) {
		case 'external':
			return esc_html__( 'Buy product', 'kingdom' );
		break;
		case 'grouped':
			return esc_html__( 'View products', 'kingdom' );
		break;
		case 'simple':
			return esc_html__( 'Add to cart', 'kingdom' );
		break;
		case 'variable':
			return esc_html__( 'Select options', 'kingdom' );
		break;
		default:
			return esc_html__( 'Read more', 'kingdom' );
	}
}

function kingdom_sanitize_html_field( $str ) {
	return $str;
}

add_theme_support( 'wc-product-gallery-lightbox' );
add_theme_support( 'wc-product-gallery-slider' );
