	<!-- Footer -->
	<?php 
	$kingdom_core = kingdom()->coreFunctions;
	$show_related_products = get_theme_mod('show_related_products', $kingdom_core->defaults_theme["show_related_products"]);
	if( kingdom()->is_woocommerce ){
		if( is_product() && $show_related_products == 'YES' ){
			woocommerce_output_related_products(); 
		}
	} 
	 
	kingdom()->coreFunctions->printSidebar( 'bottom' );
	?>
	
	<div class="clear"></div>
	
	<?php 
	$show_footer_partners = get_theme_mod('show_footer_partners', $kingdom_core->defaults_theme["show_footer_partners"]);
	$footer_sidebar_on = get_theme_mod('footer_sidebar_on', $kingdom_core->defaults_theme["footer_sidebar_on"]);
	$footer_copyright_text = get_theme_mod('footer_copyright_text', $kingdom_core->defaults_theme["footer_copyright_text"]);
	
	$footer_amazon_url = get_theme_mod('footer_amazon_url', $kingdom_core->defaults_theme["footer_amazon_url"]);
	$footer_discover_url = get_theme_mod('footer_discover_url', $kingdom_core->defaults_theme["footer_discover_url"]);
	$footer_money_url = get_theme_mod('footer_money_url', $kingdom_core->defaults_theme["footer_money_url"]);
	$footer_visa_url = get_theme_mod('footer_visa_url', $kingdom_core->defaults_theme["footer_visa_url"]);
	$footer_paypal_url = get_theme_mod('footer_paypal_url', $kingdom_core->defaults_theme["footer_paypal_url"]);
	$footer_mastercard_url = get_theme_mod('footer_mastercard_url', $kingdom_core->defaults_theme["footer_mastercard_url"]);
	
	if( post_type_exists('partners') && $show_footer_partners == 'YES'  ){ 
		$args = array(
			'post_type' => 'partners',
			'posts_per_page' => '-1'
		);
		$the_partners = get_posts( $args );
		  
		if( isset($the_partners) && count($the_partners) > 0 ){
		?>
			<!-- Partners Carousel -->
			<div class="kd_footer_partners_container" <?php if( $footer_sidebar_on == 'NO' ) { echo ' style="margin-bottom: 0px;"'; } ?>>
				<div class="container">			
					<div id="kd_footer_partners">
						<?php
						foreach ( $the_partners as $post ) : setup_postdata( $post );
							$partner_url = get_post_meta( $post->ID, '_partner_url', true);
							$partner_image = get_post_meta( $post->ID, '_partner_image', true);
						?>
							<div class="item">
								<a href="<?php echo esc_url($partner_url);?>"><?php echo wp_get_attachment_image( $partner_image, 'full' );?></a>
							</div>
						<?php
						endforeach;
						?>
					</div>
				</div>
			</div>
		<?php 
		}
	}
	?>
	<?php if( $footer_sidebar_on == 'YES' ) { ?>
		<!-- Footer Menu -->
		<div class="container">	
			<div class="row kd_footercolumns">
				<?php 
				if ( is_active_sidebar( 'footercontent' ) ) {
					dynamic_sidebar( 'footercontent' );
				}
				?>
			</div><!-- END row -->
		</div><!-- END Container -->
	<?php } ?>

	<div class="kd_footer_smallmenu" <?php if( $footer_sidebar_on == 'NO' ) { echo ' style="margin-top: 0px;"'; } ?>>
		<div class="container">
			<div class="row">
				<div class="col-md-8">
					<div class="kd_copy_text">
						<?php if( $footer_copyright_text ){ ?>
							<p><?php echo $footer_copyright_text; ?></p>
						<?php } ?>
					</div>
				</div>
				<div class="col-md-4">
					<div class="kd_credit_cards">
						<?php
						if( $footer_amazon_url ) {
							echo '<a href="' . $footer_amazon_url . '"><i class="fa fa-amazon"></i></a>';
						}
						if( $footer_discover_url ) {
							echo '<a href="' . $footer_discover_url . '"><i class="fa fa-cc-discover"></i></a>';
						}
						if( $footer_money_url ) {
							echo '<a href="' . $footer_money_url . '"><i class="fa fa-cc-amex"></i></a>';
						}
						if( $footer_visa_url ) {
							echo '<a href="' . $footer_visa_url . '"><i class="fa fa-cc-visa"></i></a>';
						}
						if( $footer_paypal_url ) {
							echo '<a href="' . $footer_paypal_url . '"><i class="fa fa-paypal"></i></a>';
						}
						if( $footer_mastercard_url ) {
							echo '<a href="' . $footer_mastercard_url . '"><i class="fa fa-cc-mastercard"></i></a>';
						}
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<a href="#" class="kd-go-top"><?php esc_html_e('Back to top', 'kingdom');?></a>
	<?php 
		kingdom()->coreFunctions->data_debug();
		wp_footer(); 
	?>
	<?php echo '<!-- ' . basename( get_page_template() ) . ' -->' . PHP_EOL; ?>
</body>
</html>