<?php
! defined( 'ABSPATH' ) and exit;
if(class_exists('WE_Customize') != true) {

	if(class_exists('Custom_Html_Control') != true && class_exists('WP_Customize_Control') == true )
	{
		class Custom_Html_Control extends WP_Customize_Control
		{
	        public $type = 'customhtml';
	        public $extra = ''; // we add this for the extra description
	        public function render_content() {
	        ?>
		        <label>
					<?php if ( ! empty( $this->label ) ) : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
					<?php endif;
					if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo $this->description; ?></span>
					<?php endif; ?>
					<textarea style="width: 100%; min-height: 100px;" <?php $this->link(); ?>><?php echo esc_textarea( $this->value() ); ?></textarea>
				</label>
	        <?php
	        }
	    }
	}

	class kingdom_Customize
	{
		public $the_theme = null;

		/* 1. The class constructor
		=========================== */
		public function __construct( $the_theme=array() )
		{
			$this->the_theme = $the_theme;
			  
			define( 'O2_DIRECTORY', $this->the_theme->template_directory_path . '/lib/icon-picker/' );
			define( 'O2_DIRECTORY_URI', $this->the_theme->template_directory . '/lib/icon-picker/' );
			require_once( $this->the_theme->template_directory_path . '/lib/icon-picker/icon-picker-control.php' );

			add_action( 'customize_register', array( $this, 'theme_customizer' ) );
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'customizer_js' ) );
		}

		public function theme_customizer( $wp_customize )
		{
			// TOP BAR OPTIONS
		    $wp_customize->add_section( 'top_bar_section' , array(
			    'title'       => __( 'Top Bar', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Modify top bar options like: Phone Number',
			) );


			$wp_customize->add_setting( 'enable_top_bar', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_top_bar', array(
		        'label'	   => __( 'Enable Top Bar', 'kingdom' ),
		        'section'  => 'top_bar_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'phone_no', array(
		        'default'           => '+4 122 3344 5567',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'phone_no', array(
		        'label'	   => __( 'Phone Number', 'kingdom' ),
		        'section'  => 'top_bar_section'
		    ) );


			 $wp_customize->add_section( 'menu_display_hp' , array(
			    'title'       => __( 'Departments Menu', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Choose to have the departments menu open on homepage or not by default',
			) );

		    $wp_customize->add_setting( 'enable_display', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_display', array(
		        'label'	   => __( 'Departments menu to be open on homepepage by default', 'kingdom' ),
		        'section'  => 'menu_display_hp',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			// LOGO OPTONS
		    $wp_customize->add_section( 'logo_section' , array(
			    'title'       => __( 'Logo', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Upload a logo to replace the default logo from header.',
			) );

			$wp_customize->add_setting( 'logo', array(
				'sanitize_callback' => 'esc_url_raw',
			) );

			$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'logo', array(
				'label'    => __( 'Logo', 'kingdom' ),
				'section'  => 'logo_section',
				'settings' => 'logo',
			) ) );
			
			$wp_customize->add_setting( 'logo_width', array(
		        'default'           => '100%',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'logo_width', array(
		        'label'	   => __( 'Logo Width', 'kingdom' ),
		        'section'  => 'logo_section'
		    ) );
			
			$wp_customize->add_setting( 'logo_height', array(
		        'default'           => '100%',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'logo_height', array(
		        'label'	   => __( 'Logo Height', 'kingdom' ),
		        'section'  => 'logo_section'
		    ) );
			
			// HEADER SOCIAL
		    $wp_customize->add_section( 'header_section' , array(
			    'title'       => __( 'Header Options', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Modify header options',
			) );
			
			// header cart
			$wp_customize->add_setting( 'head_cart', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_cart', array(
		        'label'	   => __( 'Enable Cart on Header', 'kingdom' ),
		        'section'  => 'header_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			// header search
			$wp_customize->add_setting( 'head_search', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_search', array(
		        'label'	   => __( 'Enable Search on Header', 'kingdom' ),
		        'section'  => 'header_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_search_in', array(
		        'default'           => 'PRODUCTS',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_search_in', array(
		        'label'	   => __( 'Search in Products / All post types', 'kingdom' ),
		        'section'  => 'header_section',
		        'type'	   => 'select',
		        'choices'  => array( 'PRODUCTS' => 'PRODUCTS', 'ALL POST TYPES' => 'ALL POST TYPES' )
		    ) );
			
			// HEADER SOCIAL
		    $wp_customize->add_section( 'header_social_section' , array(
			    'title'       => __( 'Header Social Options', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Modify header social options like: facebook, instagram, youtube, google+',
			) );
			
			// Facebook
			$wp_customize->add_setting( 'head_facebook_url_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_facebook_url_on', array(
		        'label'	   => __( 'Enable Facebook Page', 'kingdom' ),
		        'section'  => 'header_social_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_facebook_url', array(
		        'default'           => 'http://facebook.com/kingdom/',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			$wp_customize->add_control( 'head_facebook_url', array(
		        'label'	   => __( 'Facebook Official Page', 'kingdom' ),
		        'section'  => 'header_social_section'
		    ) );
			
			// Twitter
			$wp_customize->add_setting( 'head_twitter_url_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_twitter_url_on', array(
		        'label'	   => __( 'Enable Twitter Page', 'kingdom' ),
		        'section'  => 'header_social_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_twitter_url', array(
		        'default'           => 'http://twitter.com/kingdom/',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			$wp_customize->add_control( 'head_twitter_url', array(
		        'label'	   => __( 'Twitter Official Page', 'kingdom' ),
		        'section'  => 'header_social_section'
		    ) );
			
			// Instagram
			$wp_customize->add_setting( 'head_instagram_url_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_instagram_url_on', array(
		        'label'	   => __( 'Enable Instagram Page', 'kingdom' ),
		        'section'  => 'header_social_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_instagram_url', array(
		        'default'           => 'http://instagram.com/kingdom/',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			$wp_customize->add_control( 'head_instagram_url', array(
		        'label'	   => __( 'Instagram Official Page', 'kingdom' ),
		        'section'  => 'header_social_section'
		    ) );
			
			// Google+
			$wp_customize->add_setting( 'head_gplus_url_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_gplus_url_on', array(
		        'label'	   => __( 'Enable Google+ Page', 'kingdom' ),
		        'section'  => 'header_social_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_gplus_url', array(
		        'default'           => 'http://plus.google.com/kingdom/',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'head_gplus_url', array(
		        'label'	   => __( 'Google+ Official Page', 'kingdom' ),
		        'section'  => 'header_social_section'
		    ) );
			
			// Pinterest
			$wp_customize->add_setting( 'head_pinterest_url_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_pinterest_url_on', array(
		        'label'	   => __( 'Enable Pinterest Page', 'kingdom' ),
		        'section'  => 'header_social_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_pinterest_url', array(
		        'default'           => 'http://pinterest.com/kingdom/',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'head_pinterest_url', array(
		        'label'	   => __( 'Pinterest Official Page', 'kingdom' ),
		        'section'  => 'header_social_section'
		    ) );
			
			// Youtube
			$wp_customize->add_setting( 'head_youtube_url_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'head_youtube_url_on', array(
		        'label'	   => __( 'Enable Youtube Page', 'kingdom' ),
		        'section'  => 'header_social_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'head_youtube_url', array(
		        'default'           => 'http://youtube.com/kingdom/',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'head_youtube_url', array(
		        'label'	   => __( 'Youtube Official Page', 'kingdom' ),
		        'section'  => 'header_social_section'
		    ) );
			
			// Site colors
			if( count($this->the_theme->colors) > 0 ){
				foreach ($this->the_theme->colors as $key => $color) {

				    $wp_customize->add_setting( $key, array(
				        'default'           => $color['color'],
				        'transport'         => 'refresh',
				        'sanitize_callback' => 'sanitize_hex_color',
				    ) );

				    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key, array(
				        'label'	   => $color['name'],
				        'section'  => 'colors',
				        'settings' => $key
				    ) ) );
				}
			}

			// Site fonts
			$google_fonts = $this->the_theme->getAllGfonts();
			if( count($google_fonts) > 0 ) {
				$wp_customize->add_section( 'fonts_section' , array(
				    'title'       => __( 'Theme Fonts', 'kingdom' ),
				    'priority'    => 30,
				    'description' => 'Select your desired theme fonts from Google Fonts collection.',
				) );

				$wp_customize->add_setting( 'font_main', array(
			        'default'           => 'Rajdhani',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				$wp_customize->add_control( 'font_main', array(
			        'label'	   => __( 'Main font', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => $google_fonts
			    ) );
				
				$wp_customize->add_setting( 'font_main_size', array(
			        'default'           => '14px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				$wp_customize->add_control( 'font_main_size', array(
			        'label'	   => __( 'Main font size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
			    $wp_customize->add_setting( 'font_headings', array(
			        'default'           => 'Abril Fatface',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				$wp_customize->add_control( 'font_headings', array(
			        'label'	   => __( 'Headings font', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => $google_fonts
			    ) );
				
				$wp_customize->add_setting( 'main_menu_font', array(
			        'default'           => 'Abril Fatface',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				$wp_customize->add_control( 'main_menu_font', array(
			        'label'	   => __( 'Main Menu font', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => $google_fonts
			    ) );
				
				$wp_customize->add_setting( 'main_menu_font_size', array(
			        'default'           => '17px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_font_size', array(
			        'label'	   => __( 'Main Menu Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'main_menu_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_font_weight', array(
			        'label'	   => __( 'Main Menu Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'main_menu_submenu_font_size', array(
			        'default'           => '17px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_submenu_font_size', array(
			        'label'	   => __( 'Main Menu Submenu Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'main_menu_subment_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_subment_font_weight', array(
			        'label'	   => __( 'Main Menu Submenu Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				
				$wp_customize->add_setting( 'main_menu_vertical_spacing', array(
			        'default'           => '20px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_vertical_spacing', array(
			        'label'	   => __( 'Main Menu Vertical Spacing', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'main_menu_horizontal_spacing', array(
			        'default'           => '29px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_horizontal_spacing', array(
			        'label'	   => __( 'Main Menu Horizontal Spacing', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'main_menu_submenu_top_margin', array(
			        'default'           => '81px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_menu_submenu_top_margin', array(
			        'label'	   => __( 'Main Menu Submenu Top Margin', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'main_content_font_size', array(
			        'default'           => '18px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_content_font_size', array(
			        'label'	   => __( 'Main Menu Content Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'main_content_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'main_content_font_weight', array(
			        'label'	   => __( 'Main Content Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'h1_font_size', array(
			        'default'           => '32px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h1_font_size', array(
			        'label'	   => __( 'H1 Headings Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'h1_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h1_font_weight', array(
			        'label'	   => __( 'H1 Headings Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'h2_font_size', array(
			        'default'           => '28px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h2_font_size', array(
			        'label'	   => __( 'H2 Headings Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'h2_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h2_font_weight', array(
			        'label'	   => __( 'H2 Headings Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'h3_font_size', array(
			        'default'           => '24px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h3_font_size', array(
			        'label'	   => __( 'H3 Headings Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'h3_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h3_font_weight', array(
			        'label'	   => __( 'H3 Headings Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'h4_font_size', array(
			        'default'           => '20px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h4_font_size', array(
			        'label'	   => __( 'H4 Headings Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'h4_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h4_font_weight', array(
			        'label'	   => __( 'H4 Headings Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'h5_font_size', array(
			        'default'           => '16px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h5_font_size', array(
			        'label'	   => __( 'H5 Headings Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );
				
				$wp_customize->add_setting( 'h5_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h5_font_weight', array(
			        'label'	   => __( 'H5 Headings Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );
				
				$wp_customize->add_setting( 'h6_font_size', array(
			        'default'           => '12px',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h6_font_size', array(
			        'label'	   => __( 'H6 Headings Font Size', 'kingdom' ),
			        'section'  => 'fonts_section'
			    ) );	
				
				$wp_customize->add_setting( 'h6_font_weight', array(
			        'default'           => '400',
			        'sanitize_callback' => 'sanitize_text_field',
			    ) );
				
				$wp_customize->add_control( 'h6_font_weight', array(
			        'label'	   => __( 'H6 Headings Font Weight', 'kingdom' ),
			        'section'  => 'fonts_section',
			        'type'	   => 'select',
			        'choices'  => array( '400' => '400', '500' => '500', '600' => '600', '700' => '700' )
			    ) );

			}
			
			// Google API
		   $wp_customize->add_section( 'gapi_key_section' , array(
			    'title'       => __( 'Google Maps JavaScript API', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'This is used on the Contact page, if you wish to add a google map. You can get it from https://developers.google.com/maps/documentation/javascript/get-api-key ',
			) );

			$wp_customize->add_setting( 'google_api_key', array(
		        'default'           => 'AIzaSyC6SK37AoTgNoMy80k3M7_if1wVO3MWmZU',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'google_api_key', array(
		        'label'	   => __( 'Google API KEY', 'kingdom' ),
		        'section'  => 'gapi_key_section'
		    ) );
			
			// SHOP OPTONS
		    $wp_customize->add_section( 'shop_section' , array(
			    'title'       => __( 'Shop', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Change shop settings',
			) );

			$wp_customize->add_setting( 'shop_template', array(
		        'default'           => 'regular',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );

		    $wp_customize->add_control( 'shop_template', array(
		        'label'	   => __( 'Shop page template', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'regular' => 'Regular', 'alternate' => 'Alternate' )
		    ) );
			
			$wp_customize->add_setting( 'show_related_products', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'show_related_products', array(
		        'label'	   => __( 'Show Related Products', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );

			$wp_customize->add_setting( 'products_per_page', array(
		        'default'           => '12',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'products_per_page', array(
		        'label'	   => __( 'Numer of products/page on category pages', 'kingdom' ),
		        'section'  => 'shop_section'
		    ) );
			
			$wp_customize->add_setting( 'show_star_rating', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'show_star_rating', array(
		        'label'	   => __( 'Show Star Rating', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'rating_type', array(
		        'default'           => 'own',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'rating_type', array(
		        'label'	   => __( 'Star Rating Type', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'own' => 'own', 'amazon' => 'amazon' )
		    ) );
			
			$wp_customize->add_setting( 'enable_product_general_description', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_product_general_description', array(
		        'label'	   => __( 'Show product details general description', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'product_general_description_type', array(
		        'default'           => 'first_paragraph',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'product_general_description_type', array(
		        'label'	   => __( 'Product details general description uses', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'first_paragraph' => 'First paragraph from product content', 'short_desc' => 'Woocommerce short description' )
		    ) );
			
			$wp_customize->add_setting( 'enable_product_description_tab', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_product_description_tab', array(
		        'label'	   => __( 'Show product details description tab', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'enable_product_in_category', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_product_in_category', array(
		        'label'	   => __( 'Show product category', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'enable_product_tags', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_product_tags', array(
		        'label'	   => __( 'Show product tags', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			
		    $wp_customize->add_setting( 'enable_color_insteadofdropdown', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );

		    $wp_customize->add_control( 'enable_color_insteadofdropdown', array(
		        'label'	   => __( 'Show images color filter insted of "dropdown" ', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			

			$wp_customize->add_setting( 'enable_discount_percent', array(
		        'default'           => 'NO',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );


			$wp_customize->add_control( 'enable_discount_percent', array(
		        'label'	   => __( 'Show discount % insted of "SALE" label', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'only_discount_percent_above', array(
		        'default'           => '5',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'only_discount_percent_above', array(
		        'label'	   => __( 'Only show discount % equal or above', 'kingdom' ),
		        'section'  => 'shop_section',
		        'type'	   => 'text',
		    ) );
			
			$wp_customize->add_setting( 'enable_top_filters_sidebar', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_top_filters_sidebar', array(
		        'label'	   => __( 'Enable top filters', 'kingdom' ),
		        'description' => sprintf( __( 'see <a href="%s">Widgets</a> section. (Top Filters sidebar)', 'kingdom' ), admin_url('widgets.php') ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'enable_bottom_filters_sidebar', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'enable_bottom_filters_sidebar', array(
		        'label'	   => __( 'Enable bottom filters', 'kingdom' ),
		        'description' => sprintf( __( 'see <a href="%s">Widgets</a> section. (Bottom Filters sidebar)', 'kingdom' ), admin_url('widgets.php') ),
		        'section'  => 'shop_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			// BLOG OPTONS
		    $wp_customize->add_section( 'blog_section' , array(
			    'title'       => __( 'Blog', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Change blog settings',
			) );

			$wp_customize->add_setting( 'show_post_date_meta', array(
		        'default'           => 'YES',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'show_post_date_meta', array(
		        'label'	   => __( 'Show Post Date Meta', 'kingdom' ),
		        'section'  => 'blog_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'show_post_comments_meta', array(
		        'default'           => 'YES',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'show_post_comments_meta', array(
		        'label'	   => __( 'Show Post Comments Count Meta', 'kingdom' ),
		        'section'  => 'blog_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'show_post_category_meta', array(
		        'default'           => 'YES',
				'sanitize_callback' => 'sanitize_text_field',
		    ) );
			$wp_customize->add_control( 'show_post_category_meta', array(
		        'label'	   => __( 'Show Post Category Meta', 'kingdom' ),
		        'section'  => 'blog_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );

			// Configure sharing
			$wp_customize->add_section( 'sharing_section' , array(
			    'title'       => __( 'Configure Sharing', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'AddThis profile ID.',
			) );
			
			// Facebook share
			$wp_customize->add_setting( 'facebook_share_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'facebook_share_on', array(
		        'label'	   => __( 'Enable Facebook Sharing', 'kingdom' ),
		        'section'  => 'sharing_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			// Twitter share
			$wp_customize->add_setting( 'twitter_share_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'twitter_share_on', array(
		        'label'	   => __( 'Enable Twitter Sharing', 'kingdom' ),
		        'section'  => 'sharing_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			// Google+ share
			$wp_customize->add_setting( 'gplus_share_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'gplus_share_on', array(
		        'label'	   => __( 'Enable Google+ Sharing', 'kingdom' ),
		        'section'  => 'sharing_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			// Pinterest share
			$wp_customize->add_setting( 'pinterest_share_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'pinterest_share_on', array(
		        'label'	   => __( 'Enable Pinterest Share', 'kingdom' ),
		        'section'  => 'sharing_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );

			// FOOTER OPTIONS
		    $wp_customize->add_section( 'footer_section' , array(
			    'title'       => __( 'Footer Options', 'kingdom' ),
			    'priority'    => 30,
			    'description' => '',
			) );
			
			// Enable footer sidebar
			$wp_customize->add_setting( 'footer_sidebar_on', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'footer_sidebar_on', array(
		        'label'	   => __( 'Enable Footer Sidebar', 'kingdom' ),
		        'section'  => 'footer_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'footer_copyright_text', array(
		        'default'           => 'Copyright © 2017 <span>Kingdom</span>. Created by <a href="http://aa-team.com">AA-Team</a>. Powered by WooCommerce.',
				//'type'				=> 'customhtml',
				'sanitize_callback' => 'kingdom_sanitize_html_field'
		    ) );
			
			$wp_customize->add_control( 'footer_copyright_text', array(
		        'label'	   => __( 'Footer copyright text', 'kingdom' ),
		        'section'  => 'footer_section',
		        'type'	   => 'textarea',
		    ) );
			
			$wp_customize->add_setting( 'show_footer_partners', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'show_footer_partners', array(
		        'label'	   => __( 'Show Partners Module in footer', 'kingdom' ),
		        'section'  => 'footer_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
			
			$wp_customize->add_setting( 'footer_amazon_url', array(
		        'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'footer_amazon_url', array(
		        'label'	   => __( 'Amazon URL', 'kingdom' ),
		        'section'  => 'footer_section'
		    ) );
			
			$wp_customize->add_setting( 'footer_discover_url', array(
		        'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'footer_discover_url', array(
		        'label'	   => __( 'Discover URL', 'kingdom' ),
		        'section'  => 'footer_section'
		    ) );
			
			$wp_customize->add_setting( 'footer_money_url', array(
		        'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'footer_money_url', array(
		        'label'	   => __( 'Money URL', 'kingdom' ),
		        'section'  => 'footer_section'
		    ) );
			
			$wp_customize->add_setting( 'footer_visa_url', array(
		        'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'footer_visa_url', array(
		        'label'	   => __( 'Visa URL', 'kingdom' ),
		        'section'  => 'footer_section'
		    ) );
			
			$wp_customize->add_setting( 'footer_paypal_url', array(
		        'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'footer_paypal_url', array(
		        'label'	   => __( 'Paypal URL', 'kingdom' ),
		        'section'  => 'footer_section'
		    ) );
			
			$wp_customize->add_setting( 'footer_mastercard_url', array(
		        'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
		    ) );
			
			$wp_customize->add_control( 'footer_mastercard_url', array(
		        'label'	   => __( 'Mastercard URL', 'kingdom' ),
		        'section'  => 'footer_section'
		    ) );
			
			// Amazon Today Deals
		    $wp_customize->add_section( 'amazon_today_deals' , array(
			    'title'       => __( 'Amazon Today Deals', 'kingdom' ),
			    'priority'    => 30,
			    'description' => __('Cache lifetime for amazon today deals (in hours)', 'kingdom'),
			) );

			$wp_customize->add_setting( 'kd_amazon_cache_lifetime', array(
		        'default'           => '24',
		        'sanitize_callback' => 'sanitize_text_field'
		    ) );
			$wp_customize->add_control( 'kd_amazon_cache_lifetime', array(
		        'label'	   => __( 'Cache lifetime', 'kingdom' ),
		        'section'  => 'amazon_today_deals',
		    ) );
			
			
			// Carousel navigation arrows
		    $wp_customize->add_section( 'carousel_nav_arrows' , array(
			    'title'       => __( 'Carousel navigation arrows', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Modify the previous/next carousel navigation arrows',
			) );


			$wp_customize->add_setting( 'carousel_nav_icon_picker', array(
		        'default'    => 'icon-arrow-left8',
		        'capability' => 'edit_theme_options',
		         'sanitize_callback' => 'sanitize_text_field'
		    ) );
			
			$wp_customize->add_control(new O2_Customizer_Icon_Picker_Control($wp_customize, 'carousel_nav_icon_picker', array(
				'label' => __('Icons', 'kingdom'),
				'description' => __('Choose an icon type', 'kingdom'),
				'iconset' => 'micon',
				'section' => 'carousel_nav_arrows',
				'settings' => 'carousel_nav_icon_picker',
				'choices' => array(
					'icon-arrow-left' 	=> __('Normal 1', 'kingdom'),
					'icon-arrow-left2' 	=> __('Normal 2', 'kingdom'),
					'icon-arrow-left3' 	=> __('Normal 3', 'kingdom'),
					'icon-arrow-left4' 	=> __('Normal 4', 'kingdom'),
					'icon-arrow-left5' 	=> __('Normal 5', 'kingdom'),
					'icon-arrow-left6' 	=> __('Normal 6', 'kingdom'),
					'icon-arrow-left7' 	=> __('Normal 7', 'kingdom'),
					'icon-arrow-left8' 	=> __('Normal 8', 'kingdom'),
					'icon-arrow-left9' 	=> __('Normal 9', 'kingdom'),
					'icon-arrow-left10' => __('Normal 10', 'kingdom'),
					'icon-arrow-left11' => __('Normal 11', 'kingdom'),
					'icon-arrow-left12' => __('Normal 12', 'kingdom'),
					'icon-arrow-left13' => __('Normal 13', 'kingdom'),
					'icon-arrow-left14' => __('Normal 14', 'kingdom'),
					'icon-arrow-left15' => __('Normal 15', 'kingdom'),
					'icon-arrow-left16' => __('Normal 16', 'kingdom'),
					'icon-circle-left' 	=> __('Circle 1', 'kingdom'),
					'icon-circle-left2' => __('Circle 2', 'kingdom'),
					'icon-circle-left3' => __('Circle 3', 'kingdom'),
					'icon-circle-left4' => __('Circle 4', 'kingdom'),
					'icon-circle-left5' => __('Circle 5', 'kingdom'),
					'icon-circle-left6' => __('Circle 6', 'kingdom'),
					'icon-square-left' 	=> __('Square', 'kingdom')
				)
			)));
			
			$wp_customize->add_setting( 'carousel_nav_icon_size', array(
		        'default'           => '16',
		        'sanitize_callback' => 'sanitize_text_field'
		    ) );
			
			$wp_customize->add_control( 'carousel_nav_icon_size', array(
		        'label'	   => __( 'Icon size (px)', 'kingdom' ),
		        'section'  => 'carousel_nav_arrows',
		        'type'	   => 'select',
		        'choices'  => array_combine(range(15,50), range(15,50)),
		        'default'  => '16'
		    ) );
			
			// CACHING
		    $wp_customize->add_section( 'caching_section' , array(
			    'title'       => __( 'Caching Options', 'kingdom' ),
			    'priority'    => 30,
			    'description' => 'Caching options.',
			) );
			
			// Enable / disable caching
			$wp_customize->add_setting( 'css_cache', array(
		        'default'           => 'YES',
		        'sanitize_callback' => 'sanitize_text_field',
		    ) );
			
			$wp_customize->add_control( 'css_cache', array(
		        'label'	   => __( 'Enable CSS Caching', 'kingdom' ),
		        'section'  => 'caching_section',
		        'type'	   => 'select',
		        'choices'  => array( 'YES' => 'YES', 'NO' => 'NO' )
		    ) );
		}

		public function customizer_js()
		{
			wp_enqueue_script( $this->the_theme->alias . '-colors', $this->the_theme->template_directory . 'customizer/customizer.js', array( 'jquery' ), '1.0', true);
		}

	}
}