<?php
/**
 * AA-Team - http://www.aa-team.com
 * ===============================+
 *
 * @package		kingdomAdminMenu
 * @author		Andrei Dinca
 * @version		1.0
 */
! defined( 'ABSPATH' ) and exit;

if(class_exists('kingdomAdminMenu') != true) {
	class kingdomAdminMenu {
		
		/*
        * Some required plugin information
        */
        const VERSION = '1.0';

        /*
        * Store some helpers config
        */
		public $the_plugin = null;
		private $the_menu = array();
		private $current_menu = '';
		private $ln = '';

		static protected $_instance;

        /*
        * Required __construct() function that initalizes the AA-Team Framework
        */
        public function __construct()
        {
        	$this->the_plugin = kingdom();
			
			// update the menu tree
			$this->the_menu_tree();
			
			return $this;
        }

		/**
	    * Singleton pattern
	    *
	    * @return kingdomDashboard Singleton instance
	    */
	    static public function getInstance()
	    {
	        if (!self::$_instance) {
	            self::$_instance = new self;
	        }

	        return self::$_instance;
	    }
		
		private function the_menu_tree()
		{
			$this->the_menu['dashboard'] = array( 
				'title' => esc_html__( 'Dashboard', 'kingdom' ),
				'url' => admin_url("admin.php?page=kingdom#!/dashboard"),
				'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
				'menu_icon' => 'power2'
			);
			
			$this->the_menu['sidebars'] = array( 
				'title' => esc_html__( 'Sidebars', 'kingdom' ),
				'url' => "#!/",
				'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
				'menu_icon' => 'stack3',
				'submenu' => array(
					'sidebars' => array(
						'title' => esc_html__( 'Sidebars Manager', 'kingdom' ),
						'url' => admin_url("admin.php?page=kingdom#!/sidebars"),
						'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
						'menu_icon' => 'indent-increase2'
					),
					
					'sidebars_per_sections' => array(
						'title' => esc_html__( 'Sidebars Per Sections', 'kingdom' ),
						'url' => admin_url("admin.php?page=kingdom#!/sidebars_per_sections"),
						'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
						'menu_icon' => 'paragraph-justify3',

					),
				)
			);
			
			$this->the_menu['sidebars'] = array( 
				'title' => esc_html__( 'Sidebars', 'kingdom' ),
				'url' => "#!/",
				'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
				'menu_icon' => 'stack3',
				'submenu' => array(
					'sidebars' => array(
						'title' => esc_html__( 'Sidebars Manager', 'kingdom' ),
						'url' => admin_url("admin.php?page=kingdom#!/sidebars"),
						'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
						'menu_icon' => 'indent-increase2'
					),
					
					'sidebars_per_sections' => array(
						'title' => esc_html__( 'Sidebars Per Sections', 'kingdom' ),
						'url' => admin_url("admin.php?page=kingdom#!/sidebars_per_sections"),
						'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
						'menu_icon' => 'paragraph-justify3',

					),
				)
			);
			
			$this->the_menu['widgets_manager'] = array( 
				'title' => esc_html__( 'Widgets Manager', 'kingdom' ),
				'url' => admin_url("admin.php?page=kingdom#!/widgets_manager"),
				'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
				'menu_icon' => 'cogs'
			);
			
			$this->the_menu['bulk_products_colors_check'] = array( 
				'title' => esc_html__( 'Bulk Colors Check', 'kingdom' ),
				'url' => admin_url("admin.php?page=kingdom#!/bulk_products_colors_check"),
				'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
				'menu_icon' => 'palette2'
			);
			
			$this->the_menu['general'] = array( 
				'title' => esc_html__( 'Plugin Settings', 'kingdom' ),
				'url' => "#!/",
				'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
				'menu_icon' => 'puzzle3',
				'submenu' => array(
					/*'modules_manager' => array(
						'title' => esc_html__( 'Modules Manager', 'kingdom' ),
						'url' => admin_url("admin.php?page=kingdom#!/modules_manager"),
						'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
						'menu_icon' => 'puzzle3'
					),*/
					
					'setup_backup' => array(
						'title' => esc_html__( 'Setup / Backup', 'kingdom' ),
						'url' => admin_url("admin.php?page=kingdom#!/setup_backup"),
						'folder_uri' => $this->the_plugin->cfg['paths']['freamwork_dir_url'],
						'menu_icon' => 'database-menu'
					),
				)
			);
		}
		
		public function show_menu()
		{
			$plugin_data = $this->the_plugin->get_theme_data();
			//var_dump('<pre>',,'</pre>'); die;  
			$html = array();
			// id="kingdom-nav-dashboard" 
			$html[] = '<div id="kingdom-header">';
			$html[] = 	'<div id="kingdom-header-bottom">';
			$html[] = 		'<div id="kingdom-topMenu">';
			$html[] = 			'<a href="http://codecanyon.net/item/woocommerce-amazon-affiliates-wordpress-plugin/3057503?ref=AA-Team" target="_blank" class="kingdom-product-logo">
									<img src="' . ( $this->the_plugin->cfg['paths']['theme_dir_url'] ) . 'logo-kingdom.png" alt="">
									<h3> <span>V</span>' . ( $plugin_data['version'] ) . '</h3>
								</a>';
			$html[] = '<div class="kingdom-responsive-menu hide">Menu <i class="fa fa-bars" aria-hidden="true" original-title=""></i></div>';					
						
							$html[] ='<nav class="kingdom-nav">';	
								foreach ($this->the_menu as $key => $value) {
									if( $key == 'import' ) {
										//var_dump('<pre>',$value ,'</pre>'); die; 
									} 
									$html[] = '<ul>';
									if( $key != "dashboard" ){
										$html[] = '<li class="' . ( $this->the_plugin->alias ) . '-nav-title">' . ( $value['title'] ) . '</li>';
									}
								
									$html[] = '<li id="' . ( $this->the_plugin->alias ) . '-nav-' . ( $key ) . '" class="' . ( $this->the_plugin->alias ) . '-section-' . ( $key ) . '">';
									
									if( $value['url'] != "#!/" ){
					
										$html[] = 	'<a href="' . ( $value['url'] ) . '" class="' . ( isset($this->current_menu[0]) && ( $key == $this->current_menu[0] ) ? 'active' : '' ) . '">';
										if( isset($value['menu_icon']) ){
											$html[] = 	'<i class="' . ( $this->the_plugin->alias ) . '-micon ' . ( $this->the_plugin->alias ) . '-icon-' . ( $value['menu_icon'] ) . '"></i>';
										}
					
										$html[] = $value['title'] . '</a>';
									}
					
									if( isset($value['submenu']) ){
										//$html[] = 	'<ul class="' . ( $this->the_plugin->alias ) . '-sub-menu">';
										foreach ($value['submenu'] as $kk2 => $vv2) {
					
											if( ($kk2 != 'synchronization_log') && isset($this->the_plugin->cfg['activate_modules']) && is_array($this->the_plugin->cfg['activate_modules']) && !in_array( $kk2, array_keys($this->the_plugin->cfg['activate_modules'])) ) continue;
					
											$html[] = '<li class="' . ( $this->the_plugin->alias ) . '-section-' . ( $kk2 ) . '" id="WooZone-nav-' . ( $kk2 ) . '">';
											
											$html[] = 	'<a href="' . ( $vv2['url'] ) . '" class="' . ( isset($this->current_menu[1]) && $kk2 == $this->current_menu[1] ? 'active' : '' ) . '">';
											if( isset($vv2['menu_icon']) ){
												$html[] = 	'<i class="' . ( $this->the_plugin->alias ) . '-micon ' . ( $this->the_plugin->alias ) . '-icon-' . ( $vv2['menu_icon'] ) . '"></i>';
											}
											$html[] = $vv2['title'] . '</a>'; 
											
											if( isset($vv2['submenu']) ){
												$html[] = 	'<ul class="' . ( $this->the_plugin->alias ) . '-sub-sub-menu">';
												foreach ($vv2['submenu'] as $kk3 => $vv3) {
													$html[] = '<li id="' . ( $this->the_plugin->alias ) . '-sub-sub-nav-' . ( $kk3 ) . '">';
													$html[] = 	'<a href="' . ( $vv3['url'] ) . '">';
													if( isset($vv3['menu_icon']) ){
														$html[] = 	'<i class="' . ( $this->the_plugin->alias ) . '-icon-' . ( $vv3['menu_icon'] ) . '"></i>';
													}
													$html[] = 	$vv3['title'] . '</a>';
													$html[] = '</li>';
												}
												$html[] = 	'</ul>';
											}
											$html[] = '</li>';
										}
										//$html[] = 	'</ul>';
									}
									$html[] = '</li>';
									$html[] = '</ul>';
									
								}
			$html[] = 		'</div>';
			$html[] ='</nav>';
			$html[] = 	'</div>';
			
			$html[] = 	'<a href="http://codecanyon.net/user/AA-Team/portfolio?ref=AA-Team" class="kingdom-aateam-logo">AA-Team</a>';
			
			$html[] = '</div>';
			
			$html[] = '<script>
			(function($) {
				var kingdomMenu = $("#kingdom-topMenu");
				
				kingdomMenu.on("click", "a", function(e){
					
					var that = $(this),
						href = that.attr("href");
					
					if( href == "javascript: void(0)" ){
						var current_open = kingdomMenu.find("li.active");
						current_open.find(".kingdom-sub-menu").slideUp(350);
						current_open.removeClass("active");
						
						that.parent("li").eq(0).find(".kingdom-sub-menu").slideDown(350, function(){
							that.parent("li").eq(0).addClass("active");
						});
					}
				});
			})(jQuery);
			
			</script>';
			
			echo implode("\n", $html);
		}

		public function make_active( $section='' )
		{
			$this->current_menu = explode("|", $section);
			return $this;
		}
	}
}