<?php 
/*
Plugin Name: Kingdom - Core Functionality
Version: 1.0
Description: Add Core Functionality (create specific post_type, taxonomies, ... etc.) for Kingdom - Woocommerce Amazon Affiliates Theme
Plugin URI: http://themeforest.net/user/AA-Team/portfolio
Author: AA-Team
Author URI: http://www.aa-team.com
*/

// don't load directly
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

class kingdom_core {
	/**
	 * List of configs.
	 *
	 * @since 1.0
	 * @var array
	 */
	public $cfg= array();
	
	public $alias = 'kingdom';

	/**
	 * Constructor loads API functions, defines paths and adds required wp actions
	 *
	 * @since  1.0
	 */
	public function __construct() 
	{
		$dir = dirname( __FILE__ );
		$upload_dir = wp_upload_dir();
		
		/**
		 * Define path settings.
		 */
		$this->cfg['APP_ROOT'] = $dir;
		$this->cfg['WP_ROOT'] = preg_replace( '/$\//', '', ABSPATH );
		$this->cfg['APP_DIR'] = basename( $dir );
		$this->cfg['UPLOAD_BASE_URL'] = $upload_dir['baseurl'];
		$this->cfg['THEME_DIR'] = get_template_directory() . '/';
		$this->cfg['THEME_URI'] = get_template_directory_uri() . '/';
		$this->cfg['THEME_FRAMEWORK_PATH'] = $this->cfg['THEME_DIR'] . 'aa-framework/';
		
		$this->load_core_functionality();
	}
	
	private function load_core_functionality()
	{
		foreach( glob( $this->cfg['APP_ROOT'] . "/modules/*/init.php" ) as $init ){
			
			$this->cfg['CURRENT_PATH'] = $init;
			$this->cfg['CURRENT_URL'] = plugin_dir_url( $this->cfg['CURRENT_PATH'] );

			$GLOBALS['kingdom_core'] = $this;
			require_once( $init );
		}  
	}

	public function set_html_content_type() {
		return 'text/html';
	}
}

global $kingdom_core;
$kingdom_core = new kingdom_core();