<?php
// Add new input type "border"
if ( function_exists('smile_add_input_type'))
{
	smile_add_input_type('border' , 'cp_border_settings_field' );
}

add_action( 'admin_enqueue_scripts', 'enqueue_border_param_scripts' );
function enqueue_border_param_scripts( $hook ){

  	$cp_page = strpos( $hook, CP_PLUS_SLUG );
  	$data  =  get_option( 'convert_plug_debug' );   
  	if( $cp_page !== false && isset( $_GET['style-view'] ) && ( $_GET['style-view'] == "edit" || $_GET['style-view'] == "variant" ) ) {
  		wp_enqueue_script( 'jquery' );
  		wp_enqueue_script( 'jquery-ui-core' );
  		wp_enqueue_script( 'border-radius', SMILE_FRAMEWORK_URI . '/lib/fields/border/js/borderRadius.js', array('jquery') );
  		
  		wp_enqueue_style( 'jquery-ui' );
  		
  		if( isset( $data['cp-dev-mode'] ) && $data['cp-dev-mode'] == '1' ) {
  			wp_enqueue_style( 'border-layout', SMILE_FRAMEWORK_URI . '/lib/fields/border/css/layout.css' );
  		}
  	}
}

/**
* Function to handle new input type "border"
*
* @param $settings		- settings provided when using the input type "border"
* @param $value			- holds the default / updated value
* @return string/html 	- html output generated by the function
*/
function cp_border_settings_field($name, $settings, $value)
{
	$input_name = $name;
	$type = isset($settings['type']) ? $settings['type'] : '';
	$class = isset($settings['class']) ? $settings['class'] : '';

  //  Apply partials
  $partials = generate_partial_atts( $settings );

	$output = '<p><textarea id="border-code" class="content form-control smile-input smile-'.$type.' '.$input_name.' '.$type.' '.$class.'" name="' . $input_name . '" "'.$partials.'" rows="6" cols="6">'.$value.'</textarea></p>';

$pairs = explode("|", $value );
$settings = array();
if( is_array( $pairs ) && !empty( $pairs ) && count( $pairs ) > 1 ) {
	foreach( $pairs as $pair ){
		$values = explode(":", $pair);
		$settings[$values[0]] = $values[1];
	}
}

$allCorners 	= isset( $settings['br_all'] ) 	? $settings['br_all']        : 10;
$topLeft 		  = isset( $settings['br_tl'] ) 	? $settings['br_tl']         : 10;
$topRight 		= isset( $settings['br_tr'] ) 	? $settings['br_tr']         : 10;
$bottomLeft 	= isset( $settings['br_bl'] ) 	? $settings['br_bl']         : 10;
$bottomRight 	= isset( $settings['br_br'] ) 	? $settings['br_br']         : 10;
$borderStyle 	= isset( $settings['style'] ) 	? $settings['style']         : 'solid';
$borderColor 	= isset( $settings['color'] ) 	? $settings['color']         : 'rgb(68,68,68)';
$br_type      = isset( $settings['br_type'] ) ? $settings['br_type']       : 0;
$allsides     = isset( $settings['bw_all'] )  ? $settings['bw_all']        : 0;
$top          = isset( $settings['bw_t'] )    ? $settings['bw_t']          : 0;
$left         = isset( $settings['bw_l'] )    ? $settings['bw_l']          : 0;
$right        = isset( $settings['bw_r'] )    ? $settings['bw_r']          : 0;
$bottom       = isset( $settings['bw_b'] )    ? $settings['bw_b']          : 0;
$bw_type         = isset( $settings['bw_type'] )  ? $settings['bw_type']   : 0;
$br_switch_checked      = ($br_type) ? 'checked="checked"'                 : '';
$bw_switch_checked      = ($bw_type) ? 'checked="checked"'                 : '';

$borders = array(
    __( "Solid", "smile" ) 		=> "solid",
    __( "Dotted", "smile" )		=> "dotted",
    __( "Dashed", "smile" ) 	=> "dashed",
    __( "Double", "smile" ) 	=> "double",
    __( "Groove", "smile" ) 	=> "groove",
    __( "Ridge", "smile" ) 		=> "ridge",
    __( "Inset", "smile" ) 		=> "inset",
    __( "Outset", "smile" ) 	=> "outset",
    __( "None", "smile" ) 		=> "none"
);

$uniq = uniqid();

ob_start();
echo $output;
?>
<div class="box">
  <div class="holder">
    <div class="frame">
      <div class="setting-block">
        <div class="row">
          <strong><label for="vertical-length"><?php _e( "Border Style", "smile" ); ?></label></strong>
          <div class="text-1 border-selector">
            <select id="select-border" class="smile-input">
              <?php
                foreach( $borders as $title => $border) {
                  $selected = ( $borderStyle == $border ) ? 'selected="selected"' : '';
                  echo '<option value="'.$border.'" '.$selected.'>'.$title.'</option>';
                }
              ?>
            </select>
          </div>
        </div>
      </div> 
      <div class="setting-block" <?php if( $borderStyle == 'none' )  echo "style=display:none;" ?>>
        <div class="row bordercolor-block">
          <strong><label for="br-color"><?php _e( "Border Color", "smile" ); ?></label></strong>
          <div class="text-2">
            <input id="br-color" class="cs-wp-color-picker " data-default-color="<?php echo esc_attr( $borderColor ); ?>" type="text" value="<?php echo $borderColor; ?>">
          </div>
        </div>
      </div>
      <div class="setting-block" <?php if( $borderStyle == 'none' )  echo "style=display:none;" ?>>
          <div class="borderwidth-block">
              <div class="smile-param-lable">
                <strong><label for="border_radius"><?php _e( "Border Width", "smile" ); ?></label></strong>
              </div>     
              <div class="param-advanced-switch">
                <div class="switch-wrapper param-switch">
                    <input type="text" <?php echo $bw_switch_checked; ?> id="smile_adv_borderwidth_opt" class="form-control smile-input smile-switch-input"  value="<?php echo $bw_type; ?>" />
                    <input type="checkbox" <?php echo $bw_switch_checked; ?> id="smile_adv_borderwidth_opt_btn_'.$uniq.'" class="ios-toggle smile-input smile-switch-input switch-checkbox smile-switch-adv-options" value="<?php echo $bw_type; ?>" >
                    <label class="smile-switch-btn checkbox-label" data-on="ADVANCED"  data-off="BASIC" data-id="smile_adv_borderwidth_opt" for="smile_adv_borderwidth_opt_btn_'.$uniq.'">
                    </label>
                </div>
              </div>
              <div class="param-basic-block borderwidth-container <?php if($type) echo 'smile-param-hidden'; ?>">
                <div class="setting-block all-sides">
                    <div class="row">
                      <label class="align-right" for="width-allsides">px</label>
                      <div class="text-1">
                        <input id="width-allsides" class="sm-small-inputs" type="number" min="0" value="<?php echo $allsides; ?>">
                      </div>
                    </div>
                    <div id="slider-width-allsides" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#" style="left: 0%;"></a><span class="range-quantity" ></span></div>
                </div>   
              </div> 
              <div class="param-advanced-block borderwidth-container <?php if($type) echo 'smile-param-hidden'; ?>">
                <div class="setting-block">
                  <div class="row">
                    <label for="top"><?php _e( "Top", "smile" ); ?></label>
                    <label class="align-right" for="top">px</label>
                    <div class="text-1">
                      <input id="width-top" class="sm-small-inputs" type="number" min="0" value="<?php echo $top; ?>">
                    </div>
                  </div>
                  <div id="slider-width-top" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                  <div class="row mtop15">
                    <label for="width-left"><?php _e( "Left", "smile" ); ?></label>
                    <label class="align-right" for="left">px</label>
                    <div class="text-1">
                      <input id="width-left" class="sm-small-inputs" type="number" min="0" value="<?php echo $left; ?>">
                    </div>
                  </div>
                  <div id="slider-width-left" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                  <div class="row mtop15">
                    <label for="right"><?php _e( "Right", "smile" ); ?></label>
                    <label class="align-right" for="right">px</label>
                    <div class="text-1">
                      <input id="width-right" class="sm-small-inputs" type="number" min="0" value="<?php echo $right; ?>">
                    </div>
                  </div>
                  <div id="slider-width-right" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                  <div class="row mtop15">
                    <label for="bottom"><?php _e( "Bottom", "smile" ); ?></label>
                    <label class="align-right" for="bottom">px</label>
                    <div class="text-1">
                      <input id="width-bottom" class="sm-small-inputs" type="number" min="0" value="<?php echo $bottom; ?>">
                    </div>
                  </div>
                  <div id="slider-width-bottom" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                </div>
              </div> 
          </div> 
      </div>
      <div class="setting-block">
          <div class="borderradius-block">  
            <div class="param-advanced-switch">
              <div class="switch-wrapper param-switch">
                  <input type="text" <?php echo $br_switch_checked; ?> id="smile_adv_border_opt" class="form-control smile-input smile-switch-input"  value="<?php echo $br_type; ?>" />
                  <input type="checkbox" <?php echo $br_switch_checked; ?> id="smile_adv_border_opt_btn_'.$uniq.'" class="ios-toggle smile-input smile-switch-input switch-checkbox smile-switch-adv-options" value="<?php echo $br_type; ?>" >
                  <label class="smile-switch-btn checkbox-label" data-on="ADVANCED"  data-off="BASIC" data-id="smile_adv_border_opt" for="smile_adv_border_opt_btn_'.$uniq.'">
                  </label>
              </div>
            </div>
            <div class="smile-param-lable">
              <strong><label for="border_radius"><?php _e( "Border Radius", "smile" ); ?></label></strong>
            </div>
            <div class="param-basic-block border-container <?php if($type) echo 'smile-param-hidden'; ?>">
              <div class="setting-block radius-block">
                <div class="row">
                  <label class="align-right" for="all-corners">px</label>
                  <div class="text-1">
                    <input id="all-corners" class="sm-small-inputs" type="number" min="0" value="<?php echo $allCorners; ?>">
                  </div>
                </div>
                <div id="slider-all-corners" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
              </div>
            </div>
            <div class="param-advanced-block border-container <?php if(!$type) echo 'smile-param-hidden'; ?>">
              <div class="setting-block">
                <div class="row">
                  <label for="top-left"><?php _e( "Top Left", "smile" ); ?></label>
                  <label class="align-right" for="top-left">px</label>
                  <div class="text-1">
                    <input id="top-left" class="sm-small-inputs" type="number" min="0" value="<?php echo $topLeft; ?>">
                  </div>
                </div>
                <div id="slider-top-left" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                <div class="row mtop15">
                  <label for="top-right"><?php _e( "Top Right", "smile" ); ?></label>
                  <label class="align-right" for="top-right">px</label>
                  <div class="text-1">
                    <input id="top-right" class="sm-small-inputs" type="number" min="0" value="<?php echo $topRight; ?>">
                  </div>
                </div>
                <div id="slider-top-right" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                <div class="row mtop15">
                  <label for="bottom-left"><?php _e( "Bottom Left", "smile" ); ?></label>
                  <label class="align-right" for="bottom-left">px</label>
                  <div class="text-1">
                    <input id="bottom-left" class="sm-small-inputs" type="number" min="0" value="<?php echo $bottomLeft; ?>">
                  </div>
                </div>
                <div id="slider-bottom-left" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
                <div class="row mtop15">
                  <label for="bottom-right"><?php _e( "Bottom Right", "smile" ); ?></label>
                  <label class="align-right" for="bottom-right">px</label>
                  <div class="text-1">
                    <input id="bottom-right" class="sm-small-inputs" type="number" min="0" value="<?php echo $bottomRight; ?>">
                  </div>
                </div>
                <div id="slider-bottom-right" class="slider-bar large ui-slider ui-slider-horizontal ui-widget ui-widget-content ui-corner-all"><a class="ui-slider-handle ui-state-default ui-corner-all" href="#"></a><span class="range-quantity" ></span></div>
              </div>
            </div>
          </div>
      </div>
    </div>
  </div>
</div>
<?php
	return ob_get_clean();
}
