<?php
/**
 * Template part for displaying posts
 *
 * @package WP Shop Woocommerce
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="card-item card-blog-post">
		<?php
			// Get the post ID
			$post_id = get_the_ID();

			// Check if there are audio embedded in the post content
			$post = get_post($post_id);
			$wp_shop_woocommerce_content = do_shortcode(apply_filters('the_content', $post->post_content));
			$embeds = get_media_embedded_in_content($wp_shop_woocommerce_content);

			// Track displayed audio embeds
			$displayed_embeds = [];
			
			// Check if not in a singular view
			if (!is_singular() && !empty($embeds)) {
				foreach ($embeds as $embed) {
					if (strpos($embed, 'audio') !== false && !in_array($embed, $displayed_embeds)) {
						$displayed_embeds[] = $embed;
						?>
						<div class="custom-embedded-audio">
							<div class="media-container">
								<?php echo $embed; ?>
							</div>
						</div>
						<?php
					}
				}
			}
		?>

		<header class="entry-header">
			<?php
			if ( 'post' === get_post_type() ) :

				if (is_singular()) {
					do_action('wp_shop_woocommerce_breadcrumbs');
				}
				
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
				endif;

				?>
					<div class="entry-meta">
						<?php
						wp_shop_woocommerce_posted_on();
						wp_shop_woocommerce_posted_by();
						?>
					</div><!-- .entry-meta -->

			<?php endif; ?>
		</header>
		<?php 
		$wp_shop_woocommerce_blog_thumbnail = absint(get_theme_mod('wp_shop_woocommerce_enable_blog_post_image', 1));
		if($wp_shop_woocommerce_blog_thumbnail == 1 && is_singular()) { 
			if (has_post_thumbnail()) { ?>
				<div class="card-media">
					<?php wp_shop_woocommerce_post_thumbnail(); ?>
				</div>
			<?php } 
		} ?>
		<div class="entry-content">
			<?php
				if ( is_singular() ) :
					the_content();
				else :
					echo "<p>".wp_trim_words(get_the_excerpt(),get_theme_mod('wp_shop_woocommerce_excerpt_limit', 25))."</p>";
					?>
					<?php if ( get_theme_mod( 'wp_shop_woocommerce_read_more_text', __('Continue Reading....', 'wp-shop-woocommerce') ) ) : ?>
					<a href="<?php the_permalink(); ?>" class="btn read-btn text-uppercase">
						<?php echo esc_html( get_theme_mod( 'wp_shop_woocommerce_read_more_text', __('Continue Reading....', 'wp-shop-woocommerce') ) ); ?></a>
					<?php endif; ?>
				<?php endif; ?>
			<?php
			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'wp-shop-woocommerce' ),
					'after'  => '</div>',
				)
			);
			?>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->