<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


add_action( 'vc_load_default_templates_action','nectar_custom_studio_templates_for_vc' );


/**
 * Salient Studio templates.
 *
 * @since 1.0
 */
if( !function_exists('nectar_custom_studio_templates_for_vc') ) {

function nectar_custom_studio_templates_for_vc() {


	$hide_studio_button = get_option('salient_custom_branding_hide_studio', false);
	if ( $hide_studio_button === 'on' ) {
		return '';
	}

	$cat_display_names = array(
		'about' => esc_html__('About', 'salient-core'),
		'blog' => esc_html__('Blog', 'salient-core'),
		'cta' => esc_html__('Call To Action', 'salient-core'),
		'counters' => esc_html__('Counters', 'salient-core'),
		'general' => esc_html__('General', 'salient-core'),
		'icons' => esc_html__('Icons', 'salient-core'),
		'hero_section' => esc_html__('Hero Section', 'salient-core'),
		'google_map' => esc_html__('Map', 'salient-core'),
		'lottie' => esc_html__('Lottie', 'salient-core'),
		'portfolio' => esc_html__('Project', 'salient-core'),
		'pricing' => esc_html__('Pricing', 'salient-core'),
		'services' => esc_html__('Services', 'salient-core'),
		'team' => esc_html__('Team', 'salient-core'),
		'testimonials' => esc_html__('Testimonials', 'salient-core'),
		'shop' => esc_html__('Shop', 'salient-core'),
		'new' => esc_html__('New', 'salient-core')
	);


$data = array();
$data['name'] = esc_html__( 'Layered Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-06-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#262626" bg_image="https://themenectar.com/img/demo-media/unsplash/personal-portfolio-hero-greyscale.avif" bg_position="center center" background_image_loading="skip-lazy-load" bg_repeat="no-repeat" full_height="yes" columns_placement="bottom" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(0deg, rgb(0,0,0) 0%, rgba(0,0,0,252) 0%, rgba(0,0,0,0) 43%)" shape_divider_position="bottom" bg_image_animation="zoom-out" mobile_disable_bg_image_animation="true" parallax_bg="true" parallax_bg_speed="medium_fast" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column bottom_padding_desktop="40px" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="10px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="15%" right_padding_tablet="50%" right_padding_phone="15%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" font_size_max="108px" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Adrian Uchenna" text_direction="default" font_size="6vw" font_line_height="1" font_size_tablet="10vw" font_size_phone="12vw"][/split_line_heading][/vc_column_inner][vc_column_inner left_padding_desktop="30%" left_padding_tablet="0" right_padding_tablet="30%" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" delay="300" offset="vc_col-xs-9"][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="22px" font_size_desktop="1.3vw" font_line_height="1.6" text_direction="default" max_width="375px"]A multi-disciplinary designer currently based in Philadelphia, PA.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="500" offset="vc_col-xs-3"][nectar_cta btn_style="next-section" btn_type="minimal-arrow" alignment="right" alignment_tablet="right" alignment_phone="default" display_tablet="inherit" display_phone="inherit"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );

	


	$data = array();
$data['name'] = esc_html__( 'Layered Portfolio', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'general date-05-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-stacked.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="80" constrain_group_1="yes" bottom_padding="80" left_padding_desktop="40" constrain_group_2="yes" right_padding_desktop="40" top_padding_tablet="40" constrain_group_3="yes" bottom_padding_tablet="40" left_padding_tablet="6%" constrain_group_4="yes" right_padding_tablet="6%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="work" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="date" stack_animation_effect="blurred_scale" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="40px" grid_item_height="80vh" image_size="full" image_loading="lazy-load" heading_tag="h2" font_size_max="220px" enable_indicator="yes" mouse_indicator_style="tooltip_text" mouse_indicator_text="view" mouse_indicator_color="rgba(0,0,0,0.23)" mouse_indicator_text_color="#ffffff" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="static" category_style="see-through-button" category_display="parent_only" display_excerpt="yes" excerpt_display="default" display_date="yes" additional_meta_size="small" custom_fields_location="before_post_meta" custom_fields="%5B%5D" grid_style="content_overlaid" text_content_layout="all_middle" color_overlay="#141414" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.3" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="none" border_radius="25px" posts_per_page="5" display_type="stack" custom_font_size="12vw" font_size_tablet="12vw" image_loading_lazy_skip="1"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Layered Awards', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-04-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-awards.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="6%" top_padding_tablet="14%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="awards" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" right_padding_desktop="40%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" font_size_max="108px" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Professional Achievements" font_size="6vw" text_direction="default" font_line_height="1" font_size_tablet="7vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Nectar Studio" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2024"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="DesignWave" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Visionary" col_2_content="Web Awards" col_3_content="Best Innovation" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Lunar" col_2_content="MUSE Awards" col_3_content="Platinum Winner" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Pixel Forged" col_2_content="CSS Awards" col_3_content="Top UI Design" col_4_content="2022"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="NectarMade" col_2_content="AWWARDS" col_3_content="Developer Award" col_4_content="2022"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#ffffff" icon_family="none" icon_size="large" col_1_content="Personal Portfolio" col_2_content="CSS Awards" col_3_content="Site of the Day" col_4_content="2022"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layered Related Projects', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-03-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-related-projects.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="6%" bottom_padding="4%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="60px" font_size_desktop="3.5vw" text_direction="default" font_line_height="1.2" font_size_tablet="5vw"]
<h2>Explore More Work</h2>
[/nectar_responsive_text][nectar_post_grid post_type="portfolio" portfolio_category="all" order="DESC" orderby="rand" pagination="none" exclude_current_post="yes" columns="3" columns_tablet="2" columns_phone="2" grid_item_spacing="5px" grid_item_height="30vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-5" image_loading="default" animation="fade-in-from-bottom" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_max="40" display_categories="yes" category_functionality="static" category_position="below_title" category_style="underline" category_display="default" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="animated_underline_zoom" border_radius="5px" shadow_on_hover="yes" posts_per_page="3" display_type="grid" custom_font_size="2vw" css_class_name="related-projects"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layered Bold Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-02-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-copyright.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" bottom_padding="40" left_padding_desktop="40" constrain_group_2="yes" right_padding_desktop="40" bottom_padding_tablet="6%" left_padding_tablet="6%" constrain_group_4="yes" right_padding_tablet="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="© — `{`nectar_current_year`}`" text_direction="default" animation_offset="96%"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Layered Project Description', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'portfolio general date-01-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-project-desc.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_column_text css="" text_direction="default"]
<h6>The Challenge</h6>
[/vc_column_text][/vc_column_inner][vc_column_inner right_padding_desktop="15%" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_desktop="1.5em" font_line_height="1.6" text_direction="default" font_size_tablet="1em"]We were commissioned to design a comprehensive website and develop a cohesive brand identity for Spectral, a graphic design agency renowned for its creative and innovative approach to visual communication.

The website needed to reflect Spectral's artistic flair and design expertise, featuring an immersive user experience that showcases their portfolio, highlights their design process, and captures the essence of their brand. The branding elements, including a striking logo and unified visual style, were crafted to position Spectral as a leader in the graphic design industry.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1rem" link_text="View Website" margin_top="50" url="#"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Layered Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-01-July-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/layered-project-heading.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="3em" bottom_padding="3em" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" right_padding_desktop="20%" right_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" font_size_max="104px" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Solutions that transform ideas into masterpieces." text_direction="default" font_size="6vw" font_line_height="1.2"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][vc_column_text css="" text_direction="default"]
<h6>Year</h6>
[/vc_column_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]2023[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][vc_column_text css="" text_direction="default"]
<h6>Client</h6>
[/vc_column_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Spectral[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_project_categories style="outline" category_display="parent_only" alignment_desktop="right" alignment_tablet="default" alignment_phone="default" font_style="label" alignment="right"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/large-adventure.jpeg" image_size="large_featured" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="none" max_width_mobile="default"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Portfolio', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-30-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-portfolio.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_margin="10" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="100"][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" grid_item_height="30vh" enable_masonry="yes" 2_col_masonry_layout="default_alt" image_size="full" overlaid_aspect_ratio_image_size="yes" overlaid_custom_image_aspect_ratio="1-1" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="54px" display_categories="yes" category_functionality="static" category_position="overlaid" category_style="button" category_button_color="rgba(10,10,10,0.2)" category_display="default" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="corners" color_overlay="#0a0a0a" color_overlay_opacity="0" color_overlay_hover_opacity="0.2" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="25px" display_type="grid" custom_font_size="3vw" image_loading_lazy_skip="3" font_size_tablet="5vw" font_size_phone="34px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




	$data = array();
$data['name'] = esc_html__( 'Quantum Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'hero_section general date-29-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column bottom_padding_desktop="20" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10" constrain_group_1="yes" bottom_padding="10" top_padding_tablet="20" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Ronan Bradford" text_direction="default"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.5"]Web &amp; Digital Experiences
Design, Development, Brand Identity[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.5"]Philadelphia, PA
[nectar_current_year][/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



	$data = array();
$data['name'] = esc_html__( 'Quantum CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-29-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-cta.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ede8e4" scene_position="center" bottom_margin="20" text_color="custom" custom_text_color="#000000" text_align="left" row_border_radius="custom" row_border_radius_applies="bg" top_left_border_radius="25" top_right_border_radius="25" bottom_right_border_radius="25" bottom_left_border_radius="25" zindex="1000" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="30" constrain_group_100="yes" bottom_padding_desktop="30" left_padding_desktop="30" constrain_group_101="yes" right_padding_desktop="30" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][divider line_type="No Line" custom_height="4vw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_icon icon_family="pulsating-circle" icon_style="default" icon_color_type="custom" icon_color_custom="#55c91c" icon_padding="0px" pointer_events="all" icon_size="8"][nectar_responsive_text inherited_font_style="default" text_direction="default"]Available for Work[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal" heading_tag="h2" font_size_max="130px" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="7vw" link_text="Get in Touch" url="mailto:hello@themenectar.com" font_size_phone="10vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_alignment="center" column_element_spacing="10px" desktop_text_alignment="center" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Behance" url="https://behance.com" margin_left="10" margin_right="10"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Dribbble" url="https://dribbble.com" margin_left="10" margin_right="10"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Instagram" url="https://instagram.com" margin_left="10" margin_right="10"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_2="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="LinkedIn" url="https://linkedin.com" margin_left="10" margin_right="10"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="3vw"][vc_row_inner column_margin="10px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1"]
<h6>© [nectar_current_year]. All rights reserved.</h6>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="right" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1"]
<h6>Made by <a href="#">ThemeNectar</a></h6>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Quantum Related Projects', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-27-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-related-projects.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10" bottom_padding="10" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" style="default" outline_applies_to="text_only" text_repeat_number="4" text_repeat_divider="space" text_space_amount="medium" overflow="hidden" background_image_animation="None" custom_font_size="7vw" custom_font_size_mobile="10vw"]
<h2>Explore More</h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="portfolio" portfolio_category="all" portfolio_starting_category="all" order="DESC" orderby="rand" pagination="none" exclude_current_post="yes" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" grid_item_height="30vh" 2_col_masonry_layout="default" image_size="large" overlaid_aspect_ratio_image_size="yes" overlaid_custom_image_aspect_ratio="1-1" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="54px" display_categories="yes" category_functionality="static" category_position="default" category_style="button" category_button_color="rgba(10,10,10,0.2)" category_display="parent_only" additional_meta_size="default" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="corners" color_overlay="#000000" color_overlay_opacity="0.1" color_overlay_hover_opacity="0.2" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="25px" display_type="grid" posts_per_page="2" custom_font_size="3vw" font_size_tablet="5vw" font_size_phone="34px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Project', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-26-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-project.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="4%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding_phone="10" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="54px" text_direction="default" font_size_desktop="3vw" font_line_height="1.1" font_size_tablet="5vw" font_size_phone="34px"]
<h3>Neon Grove</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.2"]
<h5>What we did</h5>
[/nectar_responsive_text][nectar_project_categories style="default" category_display="default" alignment_desktop="left" alignment_tablet="default" alignment_phone="default" font_style="p"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-6"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.2"]
<h5>Industry</h5>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Tech[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default" font_line_height="1.2"]
<h5>Description</h5>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I collaborated with Neon Grove, an emerging force in the tech sector, to create a dynamic series of photographs. The work focused on showcasing their innovative products and sleek designs, capturing the essence of their technological vision through sharp, modern imagery.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/blue-guy.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="20px" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/blue-abstract.webp" image_size="portfolio-thumb_large" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="20px" box_shadow="none" image_loading="default" max_width="none" max_width_mobile="default"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Quantum About', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-26-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" top_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="scroll_pos_advanced" animation_trigger_offset="0.00,100.00" animation_end_translate_y="90%" animation_end_opacity="0" persist_animation_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_adv_start_end="end"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" font_size_max="200px" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Fullstack Developer" text_direction="default" font_size="11vw" font_line_height="0.9" font_size_tablet="11vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="20" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/salient/portfolio-quantum/wp-content/uploads/sites/43/2024/09/pexels-sherlocked124578-60778-scaled.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="20px" box_shadow="none" image_loading="skip-lazy-load" max_width="custom" max_width_custom="40%" max_width_custom_tablet="50%" max_width_custom_phone="60%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Quantum Text Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-26-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-text-inline.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="12%" bottom_padding="10%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" bottom_padding_tablet="15%" left_padding_tablet="18%" constrain_group_4="yes" right_padding_tablet="18%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_text_inline_images media_type="images" image_size="large__h_rect" image_effect="none" media_roundness="10px" image_loading="default" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="4vw" font_size_tablet="6vw" max_width="" font_size_phone="7vw" text_direction="default"]
<h3>I’m * passionate about creating seamless digital experiences, and I collaborate with businesses and agencies * worldwide to bring their visions to life through innovative * web solutions.</h3>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-25-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-services.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="90px" text_direction="default" font_size_desktop="5vw" font_line_height="1" font_size_tablet="7vw"]
<h3>Services</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I offer a comprehensive range of web services, carefully tailored to meet each client’s unique needs and their project budgets.[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>01</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Responsive Design</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Websites that function flawlessly on all devices, while also being optimized for speed, SEO, and accessibility.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="100"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>02</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>eCommerce</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Secure, user-friendly online stores that streamline sales, manage inventory, and enhance the shopping experience.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>03</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Maintenance</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I provide ongoing technical support, updates, and performance optimization to keep your website running smoothly.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="100"][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h6>04</h6>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]
<h4>Development</h4>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]Fully customized websites using the latest technologies to match your brand and business goals, ensuring a unique online presence.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Quantum Awards', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'general date-24-June-2024';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/quantum-about-awards.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text inherited_font_style="default" font_size_max="90px" text_direction="default" font_size_desktop="5vw" font_line_height="1" font_size_tablet="7vw"]
<h3>Awards</h3>
[/nectar_responsive_text][nectar_responsive_text inherited_font_style="default" text_direction="default"]I provide ongoing technical support, updates, and performance optimization to keep your website running smoothly.[/nectar_responsive_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Nectar Studio" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2024"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="DesignWave" col_2_content="AWWWARDS" col_3_content="Site Of The Day" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Visionary" col_2_content="Web Awards" col_3_content="Best Innovation" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Lunar" col_2_content="MUSE Awards" col_3_content="Platinum Winner" col_4_content="2023"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="even" responsive_display="multiple_columns" col_1_text_align="left" col_2_text_align="left" col_3_text_align="left" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="p" col_4_text_element="p" font_family="p" hover_effect="none" border_animation="true" border_color="#424242" icon_family="none" icon_size="large" col_1_content="Pixel Forged" col_2_content="CSS Awards" col_3_content="Top UI Design" col_4_content="2022"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Magazine Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-24-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="4%" top_padding_tablet="15" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin="-15px" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="easeOutSine" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="SALIENT MAG" font_size="13.6vw" font_line_height="1"][/split_line_heading][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="4" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="30vh" enable_masonry="yes" 4_col_masonry_layout="mixed" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-3" image_loading="skip-lazy-load" animation="zoom-out-reveal" animation_stagger="1" animation_easing="easeInOutCubic" parallax_scrolling="yes" heading_tag="default" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" additional_meta_display="large_items_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" custom_font_size="1.3vw" posts_per_page="5" display_type="grid" font_line_height="1.4"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Modern Blog Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-23-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-carousel.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" bottom_padding="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="30%" right_padding_phone="5%" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][vc_column_text]Featured Headlines[/vc_column_text][nectar_responsive_text font_size_min="20" font_size_max="44px" font_size_desktop="2.2vw" font_line_height="1.3"]
<h4>Check out the latest news from around the world</h4>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" link_text="View all"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" flickity_controls="touch_total" flickity_touch_total_style="tooltip_text" flickity_touch_total_blurred_bg="yes" flickity_touch_total_indicator_bg_color="rgba(255,255,255,0.25)" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="visible" flickity_wrap_around="no-wrap" columns="3" columns_tablet="default" columns_phone="default" desktop_small_cols_flickity="3" tablet_cols_flickity="2" phone_cols_flickity="1" grid_item_spacing="15px" grid_item_height="50vh" 3_col_masonry_layout="default" image_size="large" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_min="16px" font_size_max="28px" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="rgba(10,10,10,0.24)" mouse_indicator_text_color="#ffffff" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay="#0a0a0a" color_overlay_opacity="0" color_overlay_hover_opacity="0" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="animated_underline_zoom" border_radius="10px" custom_font_size="1.8vw" posts_per_page="5" display_type="carousel"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Posts Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-22-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-hot-posts-simple.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" bottom_padding="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-7.5%" top_margin_tablet="-10%" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" image_size="full" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="48px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="10px" content_overlaid_padding_desktop="50px" content_overlaid_padding_tablet="35px" posts_per_page="1" display_type="grid" custom_font_size="2.4vw" font_size_tablet="26px"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" 2_col_masonry_layout="default" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-3" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_under_image" card_design="yes" card_bg_color="#ffffff" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" custom_font_size="1.4vw" posts_per_page="2" display_type="grid" post_offset="1"][/vc_column][vc_column top_padding_desktop="6%" bottom_padding_desktop="2%" left_padding_desktop="14%" right_padding_desktop="5%" left_padding_tablet="0" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" image_size="portfolio-thumb_large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" content_next_to_image_image_width="33.3%" content_next_to_image_image_gap="10%" content_next_to_image_image_position="right" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="h3" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="static" category_position="default" category_style="underline" category_display="parent_only" display_date="yes" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_next_to_image" text_color="dark" content_next_to_image_vertical_align="middle" hover_effect="animated_underline" border_radius="10px" content_next_to_image_divider="yes" content_next_to_image_divider_color="#e5e5e5" posts_per_page="4" display_type="grid" custom_font_size="1.4vw" font_line_height="1.3" post_offset="3"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Friendly Sign Up Form', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-22-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-form.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_margin="4%" text_color="dark" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="6%" constrain_group_100="yes" bottom_padding_desktop="6%" left_padding_desktop="6%" constrain_group_101="yes" right_padding_desktop="6%" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="50" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets1.lottiefiles.com/packages/lf20_UyIC2q.json"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="20" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_phone="13%" constrain_group_6="yes" right_padding_phone="13%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_responsive_text font_size_min="20px" font_size_max="60px" font_size_desktop="3vw" font_line_height="1.3"]
<h3>Stay up to date and never miss out.</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]Add your form shortcode here[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/webp/ff1dfc85f81f.webp,https://themenectar.com/img/demo-media/unsplash/webp/fc2fcf082f87.webp,https://themenectar.com/img/demo-media/unsplash/webp/c5799533a786.webp" sizing="50px" positioning="overlapping" stacking_order="ltr" border_color="#f7f7f7" alignment_desktop="middle" alignment_tablet="inherit" alignment_phone="inherit" animation="none" image_size="nectar_small_square" image_loading="lazy-load" numerical_circle="true" alignment="left" text_content="Join the community" numerical_circle_number="+1k"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Single Featured Blog Post', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-22-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-recent-post.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][recent_posts style="single_large_featured" large_featured_padding="18%" button_color="Extra-Color-3" button_arrow_style="curved" load_in_animation="zoom_out_reveal" single_large_featured_content_side_spacing="default" single_large_featured_content_alignment="bottom" large_featured_content_max_width="default" font_size_max="48px" bg_overlay="diagonal_gradient" large_featured_heading_tag="h3" category="all" order="DESC" orderby="date" image_loading="lazy-load" single_large_featured_content_side-spacing="" large_featured_font_size="8vw" font_size_phone="26px" font_size_desktop="3vw" font_line_height="1.2" post_offset=""][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Mixed Style Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-21-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-triple.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="24%" right_padding_phone="5%" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][vc_column_text]Featured Headlines[/vc_column_text][nectar_responsive_text font_size_min="20" font_size_max="44px" font_size_desktop="2.2vw" font_line_height="1.3"]
<h4>Technology</h4>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" link_text="View all"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="4" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="50vh" enable_masonry="yes" 4_col_masonry_layout="vert_staggered_middle" image_size="full" image_loading="lazy-load" animation="zoom-out-reveal" animation_stagger="1" animation_easing="easeInOutCubic" heading_tag="default" font_size_min="16px" font_size_max="24px" additional_meta_display="large_items_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" shadow_on_hover="yes" custom_font_size="1.4vw" posts_per_page="3" display_type="grid"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Featured Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-20-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-dark.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0f0f0f" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" text_color="light" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column left_padding_desktop="13%" constrain_group_101="yes" right_padding_desktop="13%" bottom_margin="5%" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="1" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="75%"][vc_column_text]Business Mastery[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" font_size_max="130px" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="THE STRATEGIC ADVANTAGE" font_size="8vw" font_line_height="1"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column right_padding_tablet="15" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" zindex="10" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="1" columns_phone="1" grid_item_spacing="35px" grid_item_height="30vh" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="48px" display_categories="yes" category_functionality="default" category_position="overlaid" category_style="button" category_display="parent_only" display_excerpt="yes" excerpt_display="default" additional_meta_size="default" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="zoom" border_radius="10px" posts_per_page="2" display_type="grid" custom_font_size="2.4vw" font_line_height="1.2"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][vc_row_inner column_margin="custom" column_margin_custom="70" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="3/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" columns_tablet="1" columns_phone="1" grid_item_spacing="35px" grid_item_height="30vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="1-1" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_min="14px" font_size_max="24px" additional_meta_size="default" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="zoom" border_radius="10px" read_more_button="yes" posts_per_page="3" display_type="grid" custom_font_size="1.3vw" font_size_tablet="1.3vw" font_size_phone="14px" post_offset="3"][/vc_column_inner][vc_column_inner bottom_padding_desktop="100%" top_margin="35" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="10px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_cta btn_style="curved-arrow-animation" heading_tag="p" border_radius="200" button_color="default" text_color="#ffffff" button_border_color="#c1c1c1" button_border_color_hover="#ffffff" button_border_thickness="1px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" right_position_desktop="0" link_text="View all" font_size_desktop="1.2vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-20-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-dark-small.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="custom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0f0f0f" scene_position="center" top_padding="3%" constrain_group_1="yes" bottom_padding="3%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" text_color="light" text_align="left" row_border_radius="15px" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="custom" column_margin_custom="70" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="3/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" columns_tablet="1" columns_phone="1" grid_item_spacing="35px" grid_item_height="30vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="1-1" image_loading="default" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_min="14px" font_size_max="24px" additional_meta_size="default" grid_style="content_under_image" content_under_image_text_align="left" text_color="light" hover_effect="zoom" border_radius="10px" read_more_button="yes" posts_per_page="3" display_type="grid" custom_font_size="1.3vw" font_size_tablet="1.3vw" font_size_phone="14px" post_offset="3"][/vc_column_inner][vc_column_inner bottom_padding_desktop="100%" top_margin="35" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="10px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_cta btn_style="curved-arrow-animation" heading_tag="p" border_radius="200" button_color="default" text_color="#ffffff" button_border_color="#c1c1c1" button_border_color_hover="#ffffff" button_border_thickness="1px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" right_position_desktop="0" link_text="View all" font_size_desktop="1.2vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Posts Section With Creative Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-19-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-hot.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="1px" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" text_color="#0a0a0a" move_on_scroll_animation="yes" style="text_outline" outline_thickness="ultra-thin" outline_applies_to="text_only" text_repeat_number="3" text_repeat_divider="custom" text_repeat_divider_scale="half" text_repeat_divider_custom_color="#000000" text_repeat_divider_custom_spin_animation="yes" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="13vw" text_repeat_divider_custom="✱"]
<h2>HOT POSTS</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="auto" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="1px" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slow" text_color="#0a0a0a" move_on_scroll_animation="yes" style="text_outline" outline_thickness="ultra-thin" outline_applies_to="text_only" text_repeat_number="3" text_repeat_divider="custom" text_repeat_divider_scale="half" text_repeat_divider_custom_spin_animation="yes" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="13vw" text_repeat_divider_custom="✱"]
<h2>HOT POSTS</h2>
[/nectar_scrolling_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="0" left_position_desktop="0" max_width_desktop="100%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slow" text_color="#0a0a0a" move_on_scroll_animation="yes" style="text_outline" outline_thickness="ultra-thin" outline_applies_to="both" text_repeat_number="3" text_repeat_divider="custom" text_repeat_divider_scale="half" text_repeat_divider_custom_spin_animation="yes" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="13vw" text_repeat_divider_custom="✱"]
<h2><em>HOT POSTS</em></h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="2%" bottom_padding="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-7.5%" top_margin_tablet="-10%" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" image_size="full" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_max="48px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="multiline" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="zoom" border_radius="10px" content_overlaid_padding_desktop="50px" content_overlaid_padding_tablet="35px" posts_per_page="1" display_type="grid" custom_font_size="2.4vw" font_size_tablet="26px"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" columns="2" columns_tablet="default" columns_phone="default" grid_item_spacing="15px" grid_item_height="60vh" 2_col_masonry_layout="default" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="4-3" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" parallax_scrolling="yes" heading_tag="default" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_under_image" card_design="yes" card_bg_color="#ffffff" content_under_image_text_align="left" text_color="dark" hover_effect="zoom" border_radius="10px" custom_font_size="1.4vw" posts_per_page="2" display_type="grid" post_offset="1"][/vc_column][vc_column top_padding_desktop="6%" bottom_padding_desktop="2%" left_padding_desktop="14%" right_padding_desktop="5%" left_padding_tablet="0" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" blog_starting_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" columns="1" columns_tablet="default" columns_phone="default" grid_item_spacing="10px" image_size="portfolio-thumb_large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" content_next_to_image_image_width="33.3%" content_next_to_image_image_gap="10%" content_next_to_image_image_position="right" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="h3" font_size_min="16px" font_size_max="24px" display_categories="yes" category_functionality="static" category_position="default" category_style="underline" category_display="parent_only" display_date="yes" additional_meta_size="small" custom_fields_location="before_post_meta" grid_style="content_next_to_image" text_color="dark" content_next_to_image_vertical_align="middle" hover_effect="animated_underline" border_radius="10px" content_next_to_image_divider="yes" content_next_to_image_divider_color="#e5e5e5" posts_per_page="4" display_type="grid" custom_font_size="1.4vw" font_line_height="1.3" post_offset="3"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Scroll Opacity Reveal Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-9-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-text-fade.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="custom" column_margin_custom="5%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1525440584458-b53d13a848de.webp" background_image_position="center center" background_image_stacking="default" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="circle-rect" mask_size="contain" mask_alignment_desktop="left-top" column_padding_type="default" gradient_type="default" offset="vc_col-xs-3 vc_hidden-xs"][divider line_type="No Line" custom_height="45vh" custom_height_tablet="35vw" custom_height_phone="25vw"][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_column_text]Only the educated are free[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h3" font_size_max="90px" line_reveal_by_space_text_effect="scroll-opacity-reveal" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Reading is a passport to countless adventures and a key to unlocking the vast treasury of human wisdom." font_size="4.5vw" font_size_phone="3em" font_line_height="1.3" font_size_tablet="7vw"][/split_line_heading][divider line_type="No Line" custom_height="3vw"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" font_size_max="90px" line_reveal_by_space_text_effect="scroll-opacity-reveal" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="And the beautiful thing about learning is nobody can take it away from you." font_size="4.5vw" font_size_phone="3em" font_line_height="1.3" font_size_tablet="7vw"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" top_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner left_padding_desktop="10%" left_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text]From expert tips to step-by-step guides, our magazine serves as a trusted companion on your journey toward personal and professional growth.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Magazine Carousel Natural Aspect Ratio', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-18-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-carousel-2.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="24%" right_padding_phone="5%" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-xs-8"][vc_column_text]Updated Daily[/vc_column_text][nectar_responsive_text font_size_min="20" font_size_max="44px" font_size_desktop="2.6vw" font_line_height="1.3"]
<h4>All Categories</h4>
[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true" column_padding_type="default" gradient_type="default" offset="vc_col-xs-4"][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" link_text="View all"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" flickity_controls="touch_total" flickity_touch_total_style="tooltip_text" flickity_touch_total_blurred_bg="yes" flickity_touch_total_indicator_bg_color="rgba(255,255,255,0.46)" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="visible" flickity_wrap_around="no-wrap" columns="3" columns_tablet="default" columns_phone="default" desktop_small_cols_flickity="3" tablet_cols_flickity="2" phone_cols_flickity="1" grid_item_spacing="15px" grid_item_height="50vh" 3_col_masonry_layout="default" image_size="large" aspect_ratio_image_size="yes" custom_image_aspect_ratio="default" image_loading="lazy-load" animation="none" animation_stagger="90" animation_easing="default" heading_tag="default" font_size_max="24px" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="rgba(10,10,10,0.24)" mouse_indicator_text_color="#ffffff" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="default" category_position="overlaid" category_style="button" category_display="parent_only" display_excerpt="yes" excerpt_display="default" additional_meta_size="small" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="10px" read_more_button="yes" custom_font_size="1.8vw" posts_per_page="5" display_type="carousel"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Huge Impact Text Animation Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-grad-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" full_height="yes" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffc90a" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" left_padding_desktop="19%" constrain_group_2="yes" right_padding_desktop="19%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 1%, rgba(243,243,243,0) 32%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Transform" font_size="7vw" font_line_height="1.1" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="7vw" font_line_height="1.1" animation_delay="100" text_content="ideas" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" class="middle-heading"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="into" font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="200" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="beautiful," font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="300" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="5vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="fast" font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="400" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="twist-bottom-2" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="websites" font_size="7vw" font_line_height="1.1" animation_offset="100%" animation_delay="500" font_size_tablet="8vw" font_size_phone="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Dark Radial Gradient 404', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-dark-404.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" full_height="yes" video_bg="use_video" video_mp4="https://themenectar.com/salient/mag/wp-content/uploads/sites/41/2023/07/pexels-michael-james-16296844-2160p-1-1.mp4" background_video_loading="default" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="radial-gradient(circle at center, rgba(0,0,0,0) 19%, rgb(0,0,0) 77%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="radial"][vc_column top_padding_desktop="8%" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="20vw" font_line_height="1" font_size_tablet="23vw"]
<h1>404</h1>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="3%" left_padding_desktop="32%" constrain_group_101="yes" right_padding_desktop="32%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_line_height="1.3" font_size_tablet="4vw" font_size_phone="5vw"]
<h2>Oh, no! This page doesn't exist.</h2>
[/nectar_responsive_text][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_color="#919191" button_border_color_hover="#ffffff" button_border_thickness="1px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" font_size_desktop="1.1vw" link_text="Back to Home" url="https://themenectar.com/salient/mag" margin_top="60" padding_top="1em" padding_bottom="1em" padding_left="2em" padding_right="2em" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Video Mask 404', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-404-light.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" full_height="yes" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="8%" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="1" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" video_bg="use_video" video_mp4="https://themenectar.com/demo-media/dark-ink.mp4" background_video_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="custom" mask_custom_image="LOCAL_SVG_ASSET__404" mask_size="contain" column_padding_type="default" gradient_type="default"][divider line_type="No Line" custom_height="25vh" custom_height_tablet="25vw"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="1000" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="8%" bottom_padding_desktop="6%" left_padding_desktop="32%" constrain_group_101="yes" right_padding_desktop="32%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" top_margin="-5%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="0.2" background_hover_color_opacity="1" column_backdrop_filter="blur" column_backdrop_filter_blur="15" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="4vw" font_line_height="1.3" font_size_tablet="5vw" font_size_phone="6vw"]
<h2>Well, it seems like you're lost.</h2>
[/nectar_responsive_text][nectar_cta btn_style="curved-arrow-animation" heading_tag="h6" button_color="default" text_color="#000000" button_border_color="#3452ff" button_border_thickness="1px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" font_size_desktop="1.1vw" link_text="Back to Home" url="https://themenectar.com/salient/mag" margin_top="60" padding_top="1em" padding_bottom="1em" padding_left="2em" padding_right="2em" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Footer with Fit Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-mag-footer.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#111111" scene_position="center" top_padding="8%" bottom_padding="0" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="15%" constrain_group_2="yes" right_padding_desktop="15%" left_padding_phone="20%" constrain_group_6="yes" right_padding_phone="20%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_min="20px" text_color="#ffffff" font_size_desktop="1.8vw" font_line_height="1.2" font_size_tablet="20px" font_size_phone="20px"]
<h3>Subscribe and never miss out</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]
<p style="text-align: center;">Add your form shortcode here</p>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Home" padding_top="1em" padding_bottom="1em" padding_left="1em" padding_right="1em"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="About" padding_top="1em" padding_bottom="1em" padding_left="1em" padding_right="1em"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="More Demos" padding_top="1em" padding_bottom="1em" padding_left="1em" padding_right="1em"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" fit_text_to_container="true" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="SALIENT MAG" font_line_height="1"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'SVG Mask Quote Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ' ' . $cat_display_names['testimonials'];
$data['custom_class'] = 'general testimonials date-7-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-quote.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="3%" constrain_group_1="yes" bottom_padding="3%" bottom_padding_phone="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="custom" column_margin_custom="7%" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="7%" constrain_group_3="yes" bottom_padding_tablet="7%" top_padding_phone="0" constrain_group_5="yes" bottom_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_phone="10%" constrain_group_105="yes" right_padding_phone="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-600-guy.webp" image_size="large" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default" mask_enable="true" mask_shape="circle-rect" mask_size="contain"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_badge display_tag="label" badge_style="default" bg_color_type="global" color="accent-color" text_color="#ffffff" padding="small" border_radius="5px" display="block" text="Quality Work" margin_bottom="10"][nectar_responsive_text font_size_max="32px" font_size_desktop="2vw" font_line_height="1.5" font_size_phone="4.7vw" font_size_tablet="2.5vw"]
<h4>“I have used ThemeNectar 3 times and they have been fantastic every time. They communicated clearly upfront and delivered exactly what was promised right on time.”</h4>
[/nectar_responsive_text][nectar_responsive_text]Corey Barnes, SEO Mania[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Vertical Staggered Post Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-9-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-tight-masonry-post-grid.webp' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="rand" pagination="none" columns="3" columns_tablet="default" columns_phone="default" grid_item_spacing="5px" grid_item_height="40vh" enable_masonry="yes" 3_col_masonry_layout="vert_staggered" image_size="full" image_loading="lazy-load" animation="none" animation_stagger="100" animation_easing="easeInOutCubic" heading_tag="default" font_size_min="16px" font_size_max="24px" enable_indicator="yes" mouse_indicator_style="tooltip_text" mouse_indicator_text="read" mouse_indicator_color="rgba(255,255,255,0.25)" mouse_indicator_text_color="#000000" mouse_indicator_blurred_bg="yes" display_categories="yes" category_functionality="default" category_position="default" category_style="button" category_display="parent_only" display_date="yes" display_author="yes" author_functionality="default" author_position="default" additional_meta_size="small" grid_style="content_overlaid" text_content_layout="all_bottom_left_shadow" color_overlay_opacity="0.3" color_overlay_hover_opacity="0.4" text_color="light" text_color_hover="light" text_opacity="1" text_hover_opacity="1" hover_effect="animated_underline_zoom" border_radius="10px" custom_font_size="1.3vw" posts_per_page="9" display_type="grid" image_loading_lazy_skip="3" font_line_height="1.4"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Lottie Helpful Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ' ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-19-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2023-lottie-header.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" top_padding_phone="7%" constrain_group_5="yes" bottom_padding_phone="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_desktop="15%" right_padding_phone="0" bottom_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" right_padding_tablet="5%" right_padding_phone="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_badge display_tag="label" badge_style="line" text_color="#3452ff" line_width="15" text="Theme Partner" margin_left="-25px" margin_bottom="10"][nectar_responsive_text font_size_max="50px" font_size_desktop="3vw" font_line_height="1.2" font_size_phone="6vw" font_size_tablet="4vw"]
<h1>Professional Salient Customization</h1>
[/nectar_responsive_text][divider line_type="No Line" custom_height="20"][nectar_responsive_text font_size_min="16px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Get top-tier development services delivered by our handpicked network of skilled Salient and WordPress experts, exclusively through our partners at ThemeNectar.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2vw" top_padding_tablet="5vw" top_padding_phone="6vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start a project" padding_top="0.8em" padding_bottom="0.8em" padding_left="2.2em" padding_right="2.2em" margin_right="0.8em" font_size_desktop="1.1vw" font_size_tablet="14"][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore service" padding_top="4" padding_bottom="4" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#e3f3e2" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="100%" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" json_url="https://lottie.host/c2ca6359-99d3-4340-b4ce-46fc276f2a82/S5qDD0tPKS.json" class_name="multiply-blend"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Colorful Personal Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-June-2023';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/multi-grad-hero.webp' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="40" constrain_group_1="yes" bottom_padding="40" left_padding_desktop="40" constrain_group_2="yes" right_padding_desktop="40" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="radial" shape_divider_color="#ffffff" shape_divider_position="bottom" bg_image_animation="zoom-out" shape_type="curve" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="20" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="6%" constrain_group_100="yes" bottom_padding_desktop="6%" left_padding_desktop="10%" constrain_group_101="yes" right_padding_desktop="10%" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/mullti-gradient-large.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient="linear-gradient(0deg, rgba(243,243,243,0) 19%, rgb(255,255,255) 100%)" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="advanced" advanced_gradient_display_type="linear"][divider line_type="No Line" custom_height="10vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Hi, I'm Amelia! I like to share business wisdom as an entrepreneur to empower others." font_size="6vw" font_line_height="1.2" font_size_tablet="6vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="h5" button_color="default" text_color="#0a0a0a" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore" margin_top="40" padding_top="18" padding_bottom="18" font_size_desktop="20" font_size_tablet="18" font_size_phone="16"][divider line_type="No Line" custom_height="10vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SaaS Dark Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-11-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-header-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" animated_gradient_bg="true" animated_gradient_bg_color_1="#000775" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="organic" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="15" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="clip-path" clip_path_animation_type="default" clip_path_animation_applies="row" clip_path_start_top_desktop="0" clip_path_start_bottom_desktop="0" clip_path_start_left_desktop="0" clip_path_start_right_desktop="0" clip_path_end_top_desktop="80px" clip_path_end_bottom_desktop="0" clip_path_end_left_desktop="30px" clip_path_end_right_desktop="30px" clip_path_end_top_phone="50px" clip_path_end_bottom_phone="24px" clip_path_end_left_phone="24px" clip_path_end_right_phone="24px" clip_path_start_roundness="0" clip_path_end_roundness="20px" clip_path_animation_addon="fade" video_mute="true" shape_type="straight_section" gradient_type="default" bg_image_animation_delay="100"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="-4" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="custom" column_margin_custom="6vw" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="13%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="20%" top_padding_phone="25%" left_padding_phone="14%" constrain_group_6="yes" right_padding_phone="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_tablet="10%" constrain_group_103="yes" right_padding_tablet="10%" left_padding_phone="0" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="3/5" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced" delay="400"][nectar_highlighted_text scribble_color="#ffffff" style="scribble" scribble_shape="basic-underline" scribble_thickness="thin" scribble_speed="1.3s" scribble_easing="ease_in_out" custom_font_size="5vw" font_size_tablet="7vw" font_line_height="1.1" font_size_phone="8vw" delay="400"]
<h1><em><strong>Beautiful</strong></em> websites with less work</h1>
[/nectar_highlighted_text][divider line_type="No Line" custom_height="50" custom_height_tablet="30"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="default" button_color_hover="#3452ff" text_color="#ffffff" button_border_color="#3452ff" button_border_color_hover="#3452ff" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Explore Features" padding_top="1em" padding_bottom="1em" padding_left="2.3em" padding_right="2.3em" url="#features" margin_bottom="16" font_size_desktop="1.1vw" font_size_tablet="2vw" font_size_phone="16px"][/vc_column_inner][vc_column_inner left_padding_tablet="20%" constrain_group_103="yes" right_padding_tablet="20%" left_padding_phone="8%" constrain_group_105="yes" right_padding_phone="8%" top_margin_tablet="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="center" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/5" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" delay="500"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Salient is a next-generation WordPress theme that brings professional design results to anyone, without any coding required." font_size="1.3vw" font_line_height="1.4" animation_delay="400" font_size_tablet="2vw" font_size_phone="16px"][/split_line_heading][divider line_type="No Line" custom_height="30"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/webp/ff1dfc85f81f.webp,https://themenectar.com/img/demo-media/unsplash/webp/fc2fcf082f87.webp,https://themenectar.com/img/demo-media/unsplash/webp/c5799533a786.webp,https://themenectar.com/img/demo-media/unsplash/webp/adf270f4f417.webp" sizing="40px" positioning="overlapping" stacking_order="ltr" alignment_desktop="left" alignment_tablet="middle" alignment_phone="middle" animation="none" image_size="nectar_small_square" image_loading="skip-lazy-load" alignment="left"][nectar_responsive_text]<strong>6k+ reviews</strong> (4.8 of 5)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="7%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" left_padding_tablet="17%" constrain_group_4="yes" right_padding_tablet="17%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="rgba(255,255,255,0.06)" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="600"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/landing-toolbar.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-landing-builder.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="none" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Staggered Impact Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' .$cat_display_names['general'];
$data['custom_class'] = 'general hero_section date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-staggered-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="ENCHANT" font_size="10vw" font_line_height="0.9" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.7" width_desktop="8vw" width_tablet="10vw" width_phone="12vw" alignment="left" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets5.lottiefiles.com/packages/lf20_9r65d17y.json"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="YOUR" font_size="10vw" font_line_height="0.9" animation_offset="100%" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="AUDIENCE" font_size="10vw" font_line_height="0.9" animation_offset="100%" font_size_tablet="11vw" font_size_phone="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Split Gradient Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/design-split-gradient.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="padding-10-percent" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient="radial-gradient(circle at top right, rgb(251,189,16) 5%, rgba(193,202,215,255) 43%, rgb(192,202,218) 58%, rgb(51,97,255) 94%)" advanced_gradient_radial_position="top right" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#ffffff" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="DEEP SPACE EXPLORATION" font_size="4vw" font_line_height="1.1" font_size_tablet="7vw"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/511cafe4a5c7.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="custom" box_shadow="none" top_left_border_radius="200" top_right_border_radius="200" bottom_right_border_radius="200" bottom_left_border_radius="200" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="p" text_color="#ffffff" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Retention is key to successful business growth. Our platform gives your customers a better experience from start to finish in order for you to easily turn them into lifelong fans." font_size="1.1vw" font_line_height="1.7" animation_offset="96%" font_size_tablet="2.5vw" font_size_phone="16px"][/split_line_heading][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1658498042419-be460a938f93.webp" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][divider line_type="No Line" custom_height="40vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-14-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column top_padding_desktop="4vw" bottom_padding_desktop="6vw" left_padding_desktop="7vw" constrain_group_101="yes" right_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" right_padding_desktop="10%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" delay="900"][nectar_highlighted_text scribble_color="#ffce59" style="scribble" scribble_shape="basic-underline" scribble_thickness="regular" scribble_speed="0s" scribble_easing="ease_in_out" disable_mobile_animation="true" custom_font_size="5vw" font_size_tablet="7vw" font_line_height="1.1em"]
<h1>Where marketing &amp; automation <em>intersect.</em></h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="3vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="horizontal" column_element_direction_tablet="horizontal" column_element_direction_phone="horizontal" column_element_alignment="center" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1100" column_padding_type="default" animation_offset="100%"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Get started" padding_top="0.8em" padding_bottom="0.8em" padding_left="2.2em" padding_right="2.2em" margin_right="1em" font_size_desktop="1.1vw" url="https://themenectar.com/demo/resort" font_size_tablet="14"][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="inline" display_tablet="inherit" display_phone="inherit" icon_family="iconsmind" link_text="Explore features" padding_top="4" padding_bottom="4" font_size_desktop="1.1vw" icon_iconsmind="iconsmind-Leafs" url="#features" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column right_padding_desktop="7vw" top_padding_tablet="30" left_padding_tablet="7vw" constrain_group_103="yes" right_padding_tablet="7vw" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="hidden" advanced_gradient="radial-gradient(circle at bottom, rgb(43,198,255) 0%, rgb(47,86,255) 76%)" advanced_gradient_radial_position="bottom" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="left" animation_mask_shape="straight" mobile_disable_entrance_animation="true" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" column_padding_type="default" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="77vw" width_tablet="154vw" animation="grow-in" animation_disable_mobile="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="-50%" zindex="-1" animation_delay="30"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/sass-guy.webp" image_size="full" animation_type="entrance" animation="slide-up" disable_mobile_animation="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-35%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="20%" left_position_desktop="-1%" left_position_tablet="14%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="entrance_and_parallax" animation_movement_type="default" column_parallax_intensity="1.2" persist_movement_on_mobile="true" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" delay="900"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-sales.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="custom" box_shadow_method="default" image_loading="skip-lazy-load" max_width="custom" max_width_custom="18vw" custom_box_shadow="horizontal:50,vertical:60,blur:60,spread:-20,opacity:0.175" custom_sizes_attr="(min-width: 1000px) 18vw, 30vw" max_width_custom_tablet="30vw"][nectar_lottie trigger_type="play" mobile_func="remove" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="6vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="6%" left_position_desktop="5%" mobile_disable_css_animation="true" preserveaspectratio="center" json_url="https://assets4.lottiefiles.com/packages/lf20_d1q2zqsv.json" trigger_delay="900"][/vc_column_inner][/vc_row_inner]
[vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="0%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="70%" right_position_desktop="6%" right_position_tablet="4%" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="entrance_and_parallax" animation_movement_type="default" column_parallax_intensity="2" persist_movement_on_mobile="true" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1100" column_padding_type="default" animation_offset="120%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-user-badge.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="15px" box_shadow="custom" box_shadow_method="default" image_loading="skip-lazy-load" max_width="custom" max_width_custom="15vw" custom_sizes_attr="(min-width: 1000px) 15vw, 30vw" custom_box_shadow="horizontal:30,vertical:45,blur:50,spread:-20,opacity:0.175" max_width_custom_tablet="30vw"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Animated Gradient Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#0a0a0a" animated_gradient_bg="true" animated_gradient_bg_color_1="#233caf" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="1" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="13%" bottom_padding="11%" left_padding_desktop="20%" constrain_group_2="yes" right_padding_desktop="20%" top_padding_tablet="30%" bottom_padding_tablet="25%" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_highlighted_text scribble_color="#ffffff" style="scribble" scribble_shape="squiggle-underline-2" scribble_thickness="thin" scribble_speed="1.6s" scribble_easing="ease_in_out" custom_font_size="6vw" font_size_phone="8vw"]
<h1>Build a website that you are <strong><em>proud of</em></strong></h1>
[/nectar_highlighted_text][divider line_type="No Line" custom_height="5vw"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#f4f4f4" button_border_thickness="0px" link_type="new_tab" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Purchase Salient" padding_top="12" padding_bottom="12" padding_left="35" padding_right="35" url="#"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" left_padding_desktop="3%" constrain_group_2="yes" right_padding_desktop="3%" top_padding_phone="5%" constrain_group_5="yes" bottom_padding_phone="5%" left_padding_phone="5%" constrain_group_6="yes" right_padding_phone="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1659042013149{border-top-width: 1px !important;border-top-color: rgba(255,255,255,0.2) !important;border-top-style: solid !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-5"][nectar_responsive_text]<b>© </b>[nectar_current_year] Salient.[/nectar_responsive_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="right" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" offset="vc_col-xs-7"][nectar_cta btn_style="underline" heading_tag="p" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="right" alignment_phone="right" constrain_group_4="yes" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Docs" padding_left="15" padding_right="15"][nectar_cta btn_style="underline" heading_tag="p" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="right" alignment_phone="right" display="inline" display_tablet="inline-block" display_phone="inline-block" icon_family="none" link_text="Help Center" padding_left="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Hand-Drawn Underline Intro Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-text-intro.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="12%" bottom_padding="5%" left_padding_desktop="27vw" constrain_group_2="yes" right_padding_desktop="27vw" bottom_padding_tablet="12%" left_padding_tablet="20vw" constrain_group_4="yes" right_padding_tablet="20vw" left_padding_phone="7vw" constrain_group_6="yes" right_padding_phone="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="65" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="90%"][nectar_animated_shape shape_color="#ffffff" width_desktop="15vw" animation="none" animation_easing="default" animation_movement_type="transform_y" animation_movement_intensity="0.6" animation_movement_persist_on_mobile="true" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-30%" translate_x_desktop="-50%" zindex="-1"][nectar_highlighted_text scribble_color="#318fff" style="scribble" scribble_shape="squiggle-underline" scribble_thickness="thick" scribble_speed="1.6s" scribble_easing="ease_in_out" custom_font_size="3vw" id="circle-highlight2" font_line_height="1.4" font_size_tablet="4vw" font_size_phone="5vw"]
<h2>The best customer relationship management platform for just about <em>everything.</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Convert leads into customers and then turn those customers into loyal fans of your brand by leveraging next-generation automation and AI. Yes, it really can be automated, and no, you're not dreaming." font_size="1.2vw" max_width="90%" font_line_height="1.8" font_size_tablet="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clip Path Expanding Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-9-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" video_bg="use_video" video_external="https://www.youtube.com/watch?v=6oTurM7gESE" background_video_loading="lazy-load" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient="linear-gradient(0deg, rgba(0,0,0,0.478) 0%, rgba(243,243,243,0) 48%)" shape_divider_position="top" bg_image_animation="clip-path" clip_path_animation_type="scroll" clip_path_animation_applies="row" clip_path_start_left_desktop="14%" clip_path_start_right_desktop="14%" clip_path_end_left_desktop="0%" clip_path_end_right_desktop="0%" clip_path_start_roundness="20px" clip_path_end_roundness="0px" animation_trigger_offset="0.00,100.00" animation_trigger_origin="top" trigger_offset="30.00,60.00" gradient_type="advanced" shape_type="straight_section" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_video_player_self_hosted el_aspect_tablet="43" player_functionality="lightbox" play_button_style="follow_mouse" play_button_hide="yes" play_button_color="#0a0a0a" play_button_icon_color="#ffffff" border_radius="none" box_shadow="none" video_lightbox_url="https://vimeo.com/118023315" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="5vw" zindex="1000" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text text_color="#ffffff" font_size_desktop="2vw" font_size_tablet="4vw"]
<h3>Automate your growth</h3>
[/nectar_responsive_text][nectar_responsive_text text_color="#ffffff" font_size_desktop="1.2vw" font_line_height="2.5" font_size_tablet="14"]3:45 duration[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Trust-builder', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-above-testimonial.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" left_padding_desktop="25vw" constrain_group_2="yes" right_padding_desktop="25vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_text_inline_images media_type="images" image_size="large" image_effect="circle_fade_in" image_effect_stagger="yes" right_margin_desktop="-6%" image_loading="skip-lazy-load" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="4vw" font_size_tablet="4vw" max_width="" font_size_phone="5vw"]
<h2>Trusted by over 4,000 clients worldwide ***</h2>
[/nectar_text_inline_images][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'SAAS Testimonial Slider', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-8-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][testimonial_slider style="multiple_visible" color="accent-color-dark" slider_controls="next_prev_arrows" flickity_border_radius="20px" enable_shadow="true" custom_width_desktop="40%" font_size_desktop="1.3vw" font_line_height="1.7" shadow="horizontal:22,vertical:20,blur:60,spread:0,opacity:0.575" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175" font_size_tablet="16"][testimonial star_rating="none" title="Testimonial" id="1659387611495-9" name="Aura Brooks" subtitle="Marketing Director, Owl Eyes" quote="We checked out Salient to see what all the hype was about and here we are a year later with a 30% increased bottom line! If you're looking for the latest and greatest, I can't recommend this CRM platform enough." tab_id="1659387611495-2"][testimonial star_rating="none" title="Testimonial" id="1659387611509-0" name="Eve Crawford" subtitle="CEO at ThemeNectar" quote="Our productivity has noticably gone up since implementing the platform. We are now able to dedicate more time on our products while having the peace of mind that our customer experience has improved." tab_id="1659387611510-3"][testimonial star_rating="none" title="Testimonial" id="1659387611517-0" name="Jack Graham" subtitle="Project Manager, Coffee Inc" quote="Salient has enhanced our user experience and allowed us to move faster than ever and our company is now positioned to scale. We've seen a rediculous growth of 80% in just a few months!" tab_id="1659387611517-5"][testimonial star_rating="none" title="Testimonial" id="1659387611525-8" name="Zak Reid" subtitle="CTO at Envato" quote="Simply put, Salient is an excellent tool to accelerate growth and save time. We've been very pleased with the results from implementing the platform into our company." tab_id="1659387611525-4"][/testimonial_slider][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Feature Split #1', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-11-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-lottie-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="60vh" top_padding_tablet="50vh" top_padding_phone="40vh" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/saas/saas-feature-bg.webp" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="312" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="30" left_position_desktop="30" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="left_bottom" animation_mask_shape="circle" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" animation_offset="95%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="18vw" width_tablet="36vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" preserveaspectratio="center" json_url="https://assets10.lottiefiles.com/packages/lf20_erb8mppf.json" trigger_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Create loyal customers that love your brand" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="easeInOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.8"]Retention is key to successful business growth. Our platform gives your customers a better experience from start to finish in order for you to easily turn them into lifelong fans.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start your trial" padding_top="4" padding_bottom="4" url="#" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Box', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" id="studio" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column top_padding_desktop="7%" left_padding_desktop="18%" constrain_group_101="yes" right_padding_desktop="18%" top_padding_tablet="8vw" left_padding_phone="8vw" constrain_group_105="yes" right_padding_phone="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/promo/ecommerce-bg.jpeg" background_image_position="center center" background_image_stacking="default" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" column_padding_type="advanced" advanced_gradient_display_type="linear"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" left_padding_desktop="18%" constrain_group_2="yes" right_padding_desktop="18%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_desktop="1.8vw" font_line_height="1.3" font_size_tablet="22px"]
<h3>Powerful WooCommerce Functionality</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Unlock incredible store building potential with an AJAX off-canvas cart, product quickview, advanced reviews, premium gallery styles, collapsable product widget area, and much more.[/nectar_responsive_text][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="black" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View All Features" margin_top="40" padding_top="12" padding_bottom="12" padding_left="35" padding_right="35"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="5%" constrain_group_4="yes" right_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="15.00,100.00" frame_constraint="0.00,100.00" width_desktop="14vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" enable_shadow="true" position_desktop="absolute" top_position_desktop="50%" right_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="50%" json_url="https://assets7.lottiefiles.com/packages/lf20_thwjheep.json" zindex="10" custom_box_shadow="horizontal:0,vertical:25,blur:30,spread:0,opacity:0.2"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/ecommerce-robust-preview.jpeg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="custom" box_shadow="none" top_left_border_radius="20px" top_right_border_radius="20px" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Split #2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-feature-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" scene_position="center" top_padding="7%" constrain_group_1="yes" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column right_padding_desktop="7vw" left_padding_tablet="7vw" right_padding_tablet="0" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="AI driven solutions for exceptional outcomes" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" animation_easing="easeInOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][fancy-ul icon_type="standard_check" color="Accent-Color" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>AI-Powered marketing strategies</li>
 	<li>Live customer support chat widget</li>
 	<li>Automatic scaling campaign tools</li>
 	<li>Adaptive testing/reporting</li>
</ul>
[/fancy-ul][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="View A Demo" padding_top="4" padding_bottom="4" url="#" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" overflow="hidden" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#d3dbe1" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="hidden" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_animated_shape shape_color="rgba(0,0,0,0.11)" width_desktop="50vw" animation="grow-in" animation_disable_mobile="true" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" right_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="50%" zindex="-1" animation_offset="80%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-phone.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity=".7" animation_movement_persist_on_mobile="true" hover_animation="none" alignment="center" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="custom" max_width_custom="60%" custom_box_shadow="horizontal:30,vertical:60,blur:60,spread:-20,opacity:0.25" margin_bottom="-12%" margin_top="14%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Large Gradient Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-gradient-landing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="8%" equal_height="yes" content_placement="bottom" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient="radial-gradient(circle at top right, rgb(255,189,36) 4%, rgb(247,243,239) 81%)" advanced_gradient_radial_position="top right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" advanced_gradient_display_type="radial" shape_type=""][vc_column bottom_padding_desktop="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="center" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-2-percent" column_padding_position="all" bottom_margin="4vw" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" animation_offset="100%" offset="vc_col-xs-6"][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1.4" font_size_tablet="16px" font_size_phone="14px"]All that you need to create your own beautiful website.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Take a tour" font_size_desktop="1.3vw" font_size_tablet="16px" font_size_phone="14px" margin_top="20"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="padding-4-percent" column_padding_phone="padding-2-percent" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-xs-6"][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1.4" font_size_tablet="16px" font_size_phone="14px"]Innovative design that makes people stop and stare.[/nectar_responsive_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Sign up now" font_size_desktop="1.3vw" font_size_tablet="16px" font_size_phone="14px" margin_top="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_element_direction_desktop="default" column_element_spacing="5px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="salient" font_size="8vw" font_line_height="1" font_size_tablet="12vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="DESIGN" font_size="8vw" font_line_height="1" animation_delay="200" font_size_tablet="12vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="50%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="45%" right_position_desktop="0" top_position_tablet="40%" right_position_tablet="7%" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1587613727490-514da4285de3.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="custom" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="grow-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_size="custom" mask_scale="70" mask_alignment_desktop="center-center" column_padding_type="default" gradient_type="default" custom_box_shadow="horizontal:0,vertical:30,blur:40,spread:0,opacity:0.45"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="20px" zindex="10" pointer_events="all" position_desktop="absolute" top_position_desktop="50%" left_position_desktop="50%" translate_y_desktop="-50%" translate_x_desktop="-50%" icon_fontawesome="fa fa-play" icon_size="20"]
[image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/play-video-dark.png" image_size="full" animation_type="looped" loop_animation="rotate" animation_movement_type="transform_y" hover_animation="none" alignment="" img_link_target="lightbox" border_radius="none" image_loading="default" max_width="custom" position_desktop="relative" max_width_custom="8vw" img_link="https://www.youtube.com/watch?v=6oTurM7gESE" zindex="1000" max_width_custom_tablet="15vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_margin="-4vw" top_margin_tablet="-7vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#f7f3ef" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mask_enable="true" mask_shape="circle-rect" mask_size="cover" mask_alignment_desktop="center-top" column_padding_type="advanced" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/sunglasses-guy.webp" image_size="full" animation_type="entrance" animation="slide-up" animation_easing="default" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="125%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column bottom_padding_desktop="8vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_line_height="1.3"]
<h3>98%</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1"]
<h6>Customer</h6>
[/nectar_responsive_text][nectar_responsive_text font_size_desktop="1.3vw" font_line_height="1"]
<h6>Satisfaction</h6>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Feature Split #3', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-lottie-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="7%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="relative" advanced_gradient_angle="180" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="60vh" top_padding_tablet="50vh" top_padding_phone="40vh" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1587613727490-514da4285de3.webp" background_image_position="center center" background_image_stacking="front" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="312" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="30" right_position_desktop="30" zindex="500" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="mask-reveal" animation_mask_direction="right_bottom" animation_mask_shape="circle" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" animation_offset="95%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" width_desktop="18vw" width_tablet="36vw" alignment="center" preserve_aspect_ratio="xMidYMid meet" css_animation="fade-in" preserveaspectratio="center" json_url="https://assets4.lottiefiles.com/packages/lf20_yvkok161.json" trigger_delay="500"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column left_padding_desktop="7vw" column_element_direction_desktop="default" column_element_spacing="30px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="5%" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Seriously improve your lead conversion rate" font_size="3vw" font_line_height="1.3"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" animation_easing="easeOutQuad" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][fancy-ul icon_type="standard_check" color="Accent-Color" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>Intuitive customer analytics</li>
 	<li>Advertisement conversion events</li>
 	<li>Automation of sales/marketing</li>
</ul>
[/fancy-ul][nectar_cta btn_style="underline" heading_tag="span" button_color="default" text_color="#ff6b3d" button_border_thickness="0px" link_type="new_tab" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Start your trial" padding_top="4" padding_bottom="4" url="https://themenectar.com/salient" font_size_desktop="1.1vw" font_size_tablet="16"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Hand-drawn text underline', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-pricing-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" padding_type="default" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="24%" constrain_group_2="yes" right_padding_desktop="24%" left_padding_phone="5%" constrain_group_6="yes" right_padding_phone="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_highlighted_text scribble_color="#ffce59" style="scribble" scribble_shape="squiggle-underline-2" scribble_thickness="thick" scribble_speed="1.1s" scribble_easing="ease_in_out" custom_font_size="4vw"]
<h2>Tailored pricing plans <em>designed</em> for you</h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Toggle Pricing Tables', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing']. ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'pricing lottie date-9-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-pricing.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" left_padding_desktop="7%" constrain_group_2="yes" right_padding_desktop="7%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" padding_type="default" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-44px" translate_x="170px" rotate_desktop="350" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" left_position_desktop="50%" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="5px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default" offset="vc_hidden-xs"][nectar_badge display_tag="italic" badge_style="default" bg_color_type="custom" text_color="#000000" padding="none" border_radius="20px" display="block" text="Save 25%"][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="8.00,100.00" frame_constraint="0.00,100.00" speed="0.9" width_desktop="40px" alignment="left" preserve_aspect_ratio="xMidYMid meet" preserveaspectratio="center" json_url="https://assets2.lottiefiles.com/packages/lf20_ddvwtafj.json"][/vc_column_inner][/vc_row_inner][tabbed_section style="toggle_button" tab_change_animation="none" tab_color="Accent-Color" vs_content_animation="fade" vs_link_animation="opacity" vs_navigation_alignment="left" vs_navigation_width_2="25%" vs_navigation_func="default" vs_navigation_width="regular" vs_navigation_spacing="15px" vs_navigation_mobile_display="visible" vs_tab_spacing="5%" animation=""][tab icon_family="none" title="Pay Monthly" id="1659385701588-4" tab_id="1659385701589-2"][vc_row_inner equal_height="yes" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="custom" column_border_radius="15px" column_link_target="_self" zindex="100" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" padding_type="advanced" column_padding_type="advanced" column_shadow_custom="" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.2" width_desktop="150%" height_desktop="150%" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="25%" preserveaspectratio="none" json_url="https://assets1.lottiefiles.com/packages/lf20_w4NUp4.json" zindex="-1"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Plant"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16"]Basic[/nectar_responsive_text][nectar_responsive_text font_style="h3" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="4vw" font_size_tablet="7vw"]Free[/nectar_responsive_text][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Live chat widget</li>
<li>Email marketing</li>
<li>Custom Forms</li>
<li>Traffic analytics</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="white" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Leafs"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Premium[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="29" before_text="$" after_text="/ month" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in basic</li>
<li>Marketing automation</li>
<li>Advanced chatbot</li>
<li>Campaign management</li>
<li>Collaboration tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Flowerpot"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Platinum[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="59" before_text="$" after_text="/ month" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in premium</li>
<li>A/B testing sanbox</li>
<li>Custom permissions</li>
<li>Social media automation</li>
<li>Sales automation tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Pay Yearly" id="1659385701727-9" tab_id="1659385701727-7"][vc_row_inner equal_height="yes" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="custom" column_border_radius="15px" column_link_target="_self" zindex="100" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" padding_type="advanced" column_padding_type="advanced" column_shadow_custom="" custom_box_shadow="horizontal:40,vertical:60,blur:60,spread:-20,opacity:0.175"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.2" width_desktop="150%" height_desktop="150%" alignment="center" preserve_aspect_ratio="xMidYMid meet" position_desktop="absolute" top_position_desktop="0" left_position_desktop="0" translate_y_desktop="-50%" translate_x_desktop="25%" preserveaspectratio="none" json_url="https://assets1.lottiefiles.com/packages/lf20_w4NUp4.json" zindex="-1"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="white" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Plant"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16"]Basic[/nectar_responsive_text][nectar_responsive_text font_style="h3" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="4vw" font_size_tablet="7vw"]Free[/nectar_responsive_text][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Live chat widget</li>
<li>Email marketing</li>
<li>Custom Forms</li>
<li>Traffic analytics</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="white" text_color="#000000" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Leafs"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Premium[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="250" before_text="$" after_text="/ year" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in basic</li>
<li>Marketing automation</li>
<li>Advanced chatbot</li>
<li>Campaign management</li>
<li>Collaboration tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][vc_column_inner top_padding_desktop="40" constrain_group_100="yes" bottom_padding_desktop="40" left_padding_desktop="40" constrain_group_101="yes" right_padding_desktop="40" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_icon icon_family="iconsmind" icon_style="default" icon_color_type="color_scheme" icon_color="black" icon_padding="0px" pointer_events="all" icon_iconsmind="iconsmind-Flowerpot"][nectar_responsive_text font_style="h4" content_alignment="default" mobile_content_alignment="inherit" font_size="5vw" font_line_height="1" font_size_desktop="2vw" font_size_tablet="3vw" font_size_phone="16px"]Platinum[/nectar_responsive_text][nectar_price_typography before_text_scale="0.4" after_text_scale="0.4" font_style="h3" price_text="500" before_text="$" after_text="/ year" font_size_desktop="4vw" font_size_tablet="7vw" font_line_height="1.5"][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_desktop="1.1vw"]</p>
<ul>
<li>Everything in premium</li>
<li>A/B testing sanbox</li>
<li>Custom permissions</li>
<li>Social media automation</li>
<li>Sales automation tools</li>
</ul>
<p>[/fancy-ul][divider line_type="No Line" custom_height="90"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" position_desktop="absolute" bottom_position_desktop="40" left_position_desktop="40" right_position_desktop="40" padding_top="0.8em" padding_bottom="0.8em" padding_left="40" padding_right="40" link_text="Get Started"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Tilted Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-strips.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#318fff" scene_position="center" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" top_margin="5%" scale_desktop="1.02" rotate_desktop="2" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="-2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slowest" text_color="#0a0a0a" style="default" text_repeat_number="5" text_repeat_divider="space" text_space_amount="medium" overflow="visible" background_image_animation="None" custom_font_size="5vw" custom_font_size_mobile="9vw"]
<h2>Grow your business</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffce59" scene_position="center" top_padding="2%" constrain_group_1="yes" bottom_padding="2%" bottom_margin="5%" scale_desktop="1.02" rotate_desktop="358" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="20" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#0a0a0a" style="default" text_repeat_number="5" text_repeat_divider="space" text_space_amount="medium" overflow="visible" background_image_animation="None" custom_font_size="5vw" custom_font_size_mobile="9vw"]
<h2>Grow your business</h2>
[/nectar_scrolling_text][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Clip Path Connected Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-faq-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_highlighted_text style="none" custom_font_size="3vw" font_size_tablet="6vw" font_line_height="1.2"]
<h1>Frequently asked questions</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7vw" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f8f8f8" scene_position="center" top_padding="3%" bottom_padding="12%" left_padding_desktop="7vw" constrain_group_2="yes" right_padding_desktop="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="99%" bg_image_animation="clip-path" clip_path_animation_type="scroll" clip_path_animation_applies="default" clip_path_start_bottom_desktop="0" clip_path_start_left_desktop="0" clip_path_start_right_desktop="0" clip_path_end_bottom_desktop="4%" clip_path_end_left_desktop="4%" clip_path_end_right_desktop="4%" clip_path_start_roundness="0" clip_path_end_roundness="20" animation_trigger_offset="32.00,50.00" animation_trigger_origin="bottom" shape_type="straight_section" gradient_type="default"][vc_column left_padding_desktop="2vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="none"][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="What does CRM mean?"][vc_column_text]CRM stands for Content Relationship Management. Using a CRM platform gives everyone involved in your business a way to manage customer interactions to increase growth.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Is it really free to start?"][vc_column_text]Yes! You can opt to stay within the free tier for as long as you want to. It's a great way to get a feel for the platform before deciding to upgrade to take advantage of the more advanced features.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Can I import data?"][vc_column_text]Yes! Getting your existing data in is easy. Simply export your existing customers to a .csv file and import them within a couple of clicks.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column right_padding_desktop="2vw" top_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_radial_position="top right" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="65vw" animation="none" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" translate_y_desktop="10%" translate_x_desktop="-50%" zindex="-1" animation_offset="160%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-girl.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity="-0.8" hover_animation="none" alignment="" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="100%" max_width_mobile="default" custom_box_shadow="horizontal:-25,vertical:5,blur:25,spread:0,opacity:0" margin_bottom="-10%" margin_top="5%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="6vw" constrain_group_2="yes" right_padding_desktop="6vw" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-lg-8 vc_col-md-6"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Scale your brand and earn more revenue" font_size="4vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Testimonials" url="#features" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="300" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="+216 (0)40 3629 4753" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="hello@domain.com" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="h6" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1.1vw" link_text="Start your trial" url="#" padding_top="1em" padding_bottom="1em" padding_left="2.5em" padding_right="2.5em" font_size_tablet="16"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" animation_offset="110%"][nectar_responsive_text]©  [nectar_current_year]. Website built with <a href="https://themenectar.com/salient">Salient</a>.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Happy FAQ Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'];
$data['custom_class'] = 'about date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_highlighted_text style="none" custom_font_size="3vw" font_size_tablet="6vw" font_line_height="1.2"]
<h1>Frequently asked questions</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="custom" column_margin_custom="7vw" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f8f8f8" scene_position="center" top_padding="3%" bottom_padding="12%" left_padding_desktop="7vw" constrain_group_2="yes" right_padding_desktop="7vw" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="bottom" shape_divider_height="99%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column left_padding_desktop="2vw" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="none"][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="What does CRM mean?"][vc_column_text]CRM stands for Content Relationship Management. Using a CRM platform gives everyone involved in your business a way to manage customer interactions to increase growth.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Is it really free to start?"][vc_column_text]Yes! You can opt to stay within the free tier for as long as you want to. It's a great way to get a feel for the platform before deciding to upgrade to take advantage of the more advanced features.[/vc_column_text][/toggle][toggle color="Accent-Color" heading_tag="h3" heading_tag_functionality="default" title="Can I import data?"][vc_column_text]Yes! Getting your existing data in is easy. Simply export your existing customers to a .csv file and import them within a couple of clicks.[/vc_column_text][/toggle][/toggles][/vc_column][vc_column right_padding_desktop="2vw" top_margin_tablet="10%" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ff6b3d" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_radial_position="top right" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="advanced" advanced_gradient_display_type="radial"][nectar_animated_shape shape_color="#ffce59" width_desktop="65vw" animation="none" animation_easing="easeInOutCubic" animation_movement_type="transform_y" position_desktop="absolute" top_position_desktop="0" bottom_position_desktop="0" left_position_desktop="0" translate_y_desktop="10%" translate_x_desktop="-50%" zindex="-1" animation_offset="160%"][image_with_animation image_url="https://themenectar.com/img/demo-media/saas/saas-girl.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" animation_movement_intensity="-0.8" hover_animation="none" alignment="" border_radius="none" box_shadow="custom" box_shadow_method="filter" image_loading="default" max_width="100%" max_width_mobile="default" custom_box_shadow="horizontal:-25,vertical:5,blur:25,spread:0,opacity:0" margin_bottom="-10%" margin_top="5%"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Dark SAAS Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/saas-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="10%" left_padding_desktop="6vw" constrain_group_2="yes" right_padding_desktop="6vw" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default" offset="vc_col-lg-8 vc_col-md-6"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Scale your brand and earn more revenue" font_size="4vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Testimonials" url="#features" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Features" url="#features" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="300" offset="vc_col-lg-2 vc_col-md-3"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="+216 (0)40 3629 4753" margin_top="10" font_size_desktop="1.3vw" font_size_tablet="16px"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="hello@domain.com" font_size_desktop="1.3vw" font_size_tablet="16px"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_phone="30" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][nectar_cta btn_style="text-reveal-wave" heading_tag="h6" button_color="accent-color" text_color="#ffffff" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" font_size_desktop="1.1vw" link_text="Start your trial" url="#" padding_top="1em" padding_bottom="1em" padding_left="2.5em" padding_right="2.5em" font_size_tablet="16"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default" delay="150" animation_offset="110%"][nectar_responsive_text]©  [nectar_current_year]. Website built with <a href="https://themenectar.com/salient">Salient</a>.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Animated Gradient Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'hero_section lottie date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#edeef1" full_height="yes" columns_placement="stretch" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffb71e" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="15" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="clip-path" clip_path_animation_type="default" clip_path_animation_applies="row" clip_path_start_top_desktop="0px" clip_path_start_bottom_desktop="0px" clip_path_start_left_desktop="0px" clip_path_start_right_desktop="0px" clip_path_end_top_desktop="30px" clip_path_end_bottom_desktop="30px" clip_path_end_left_desktop="30px" clip_path_end_right_desktop="30px" clip_path_end_top_phone="50px" clip_path_end_bottom_phone="24px" clip_path_end_left_phone="24px" clip_path_end_right_phone="24px" clip_path_start_roundness="0" clip_path_end_roundness="20px" clip_path_animation_addon="none" video_mute="true" shape_type="straight_section" gradient_type="default" bg_image_animation_delay="1000"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="-4" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="medium_fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" bottom_padding="30" left_padding_desktop="22%" constrain_group_2="yes" right_padding_desktop="22%" left_padding_phone="14%" constrain_group_6="yes" right_padding_phone="14%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-twist" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced" delay="200"][nectar_highlighted_text scribble_color="#000000" style="scribble" scribble_shape="basic-underline" scribble_thickness="thin" scribble_speed="1.6s" scribble_easing="ease_out" custom_font_size="6vw" delay="1000" font_size_tablet="6vw" font_line_height="1.1" font_size_phone="10vw"]
<h1><strong><em>Beautiful</em></strong> websites with less work</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner left_padding_desktop="38%" constrain_group_101="yes" right_padding_desktop="38%" left_padding_tablet="30%" constrain_group_103="yes" right_padding_tablet="30%" left_padding_phone="20%" constrain_group_105="yes" right_padding_phone="20%" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="slight-twist" animation_easing="easeInOutCubic" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(255,255,255,0.22)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="A next-generation WordPress theme that brings professional design results to anyone, without any coding required." font_size="1.2vw" font_line_height="1.6" animation_delay="1200" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" left_position_desktop="60" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="10px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1300" animation_offset="100%" column_padding_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_circle_images images="https://themenectar.com/img/demo-media/unsplash/webp/ff1dfc85f81f.webp,https://themenectar.com/img/demo-media/unsplash/webp/fc2fcf082f87.webp,https://themenectar.com/img/demo-media/unsplash/webp/c5799533a786.webp,https://themenectar.com/img/demo-media/unsplash/webp/adf270f4f417.webp" sizing="40px" positioning="overlapping" stacking_order="ltr" alignment="left" animation="none" image_size="nectar_small_square" image_loading="default"][nectar_responsive_text]<strong>6k+ reviews</strong> (4.8 <em>of</em> 5)[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-50%" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" left_position_desktop="50%" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1500" animation_offset="100%" column_padding_type="default" offset="vc_hidden-lg vc_hidden-md"][nectar_cta btn_style="text-reveal-wave" heading_tag="span" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inherit" icon_family="none" link_text="Scroll Down" url="#intro"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="60" right_position_desktop="60" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="1300" animation_offset="100%" column_padding_type="default" offset="vc_hidden-sm vc_hidden-xs"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="55px" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets1.lottiefiles.com/packages/lf20_9r65d17y.json"][nectar_responsive_text font_line_height="1.3"]<strong>Salient</strong>[/nectar_responsive_text][nectar_responsive_text font_line_height="1.3" font_size_desktop="0.9em"]<em>by</em> ThemeNectar[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Sticky Media Sections', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-7-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-sticky-media.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="7%" bottom_padding="10%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" top_padding_phone="25%" left_padding_phone="24px" constrain_group_6="yes" right_padding_phone="24px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" id="features" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#0a0a0a" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" gradient_type="default" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_sticky_media_sections type="default" content_position="right" content_spacing="45vh" media_width="60%" media_height="75vh" mobile_aspect_ratio="4-3" border_radius="15px"][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-1.jpg" link_target="_self"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15vh" top_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Template library" font_size="3vw"][/split_line_heading][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]Not all templates are created equal. Salient offers access to a perpetually updated library of <strong>professional</strong> section templates, with currently over 400 to choose from — all created with passion and held to a high standard for aesthetic quality.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-2.jpg" link_target="_self"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Visual page builder" font_size="3vw"][/split_line_heading][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]Build like it's [nectar_current_year]. Experience a high-performing, modern take on the WPBakery page builder — The editor you already know, but with supercharged power to handle complex designs and the flexibility to <strong>create any type of website.</strong>[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][fancy-ul icon_type="standard_dot" alignment="left" spacing="10px" font_size_min="16px" font_size_max="21px" link_style="default" font_size_desktop="1.2vw"]
<ul>
 	<li>Set option values unique based on screen size</li>
 	<li>Sidebar &amp; modal editing layout options</li>
 	<li>Visually intuitive graphical settings UI</li>
 	<li>Front-end &amp; back-end editors</li>
 	<li>Reusable global sections</li>
 	<li>Tree-list element view</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][nectar_sticky_media_section section_type="image" image="https://themenectar.com/img/demo-media/promo/sticky-media-3.jpg" link_target="_self"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15vh" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Premium elements" font_size="3vw"][/split_line_heading][nectar_responsive_text inherited_font_style="default" font_size_min="16px" font_size_max="21px" font_size_desktop="1.2vw" font_line_height="1.7"]A unique collection of over <strong>65 elements</strong> that make building a beautiful site easy. The Salient element set brings the latest web trends to your fingertips without any coding needed. We actively seek to bring fresh innovation by pushing the boundaries of what's possible on the web.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][/nectar_sticky_media_section][/nectar_sticky_media_sections][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Trust-Building Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-5-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-trusted.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" animated_gradient_bg="true" animated_gradient_bg_color_1="#ffb10a" animated_gradient_bg_speed="850" animated_gradient_bg_blending_mode="linear" scene_position="center" top_padding="1%" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="2" overflow="visible" id="trusted" advanced_gradient="linear-gradient(0deg, rgb(255,255,255) 4%, rgba(255,255,255,0) 30%, rgba(255,255,255,0) 75%, rgb(255,255,255) 96%)" shape_divider_position="bottom" bg_image_animation="none" gradient_type="advanced" shape_type="" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="6" desktop_small_cols_flickity="6" tablet_cols_flickity="5" phone_cols_flickity="4" flickity_controls="none" color="default" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_spacing="default" flickity_column_vertical_alignment="middle" column_padding="custom" column_padding_custom="4vw" flickity_element_spacing="default" border_radius="none" autorotate="true" autorotate_type="ticker" ticker_speed="slow"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460849-3" title="Item" tab_id="1659369460849-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460857-0" title="Item" tab_id="1659369460857-3"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460865-3" title="Item" tab_id="1659369460865-3"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460873-1" title="Item" tab_id="1659369460873-7"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460885-5" title="Item" tab_id="1659369460886-9"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460897-0" title="Item" tab_id="1659369460898-7"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1659369460909-6" title="Item" tab_id="1659369460909-6"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/item][/carousel][divider line_type="No Line" custom_height="8vh" custom_height_phone="2vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Trusted by" font_size="6vw" font_line_height="1"][/split_line_heading][nectar_rotating_words_title heading_tag="h3" dynamic_text="130k websites, industry leaders, top designers" duration="3000" dynamic_heading_tag="default" element_animation="none" mobile_display="inline" font_size="6vw"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Features Grid #1', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-6-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" bottom_margin="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" bottom_padding_desktop="1vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_badge display_tag="label" badge_style="default" bg_color_type="custom" bg_color_custom="#3452ff" text_color="#ffffff" padding="small" border_radius="20px" display="block" text="New" margin_bottom="20"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Lottie Integration</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Tap into a vast library of free, beautiful animations or create your own using Adobe After Effects.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.8" width_desktop="90%" width_tablet="70%" width_phone="90%" alignment="center" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets2.lottiefiles.com/packages/lf20_f8xnmcvu.json"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" advanced_gradient_angle="135" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Mega Menu Builder</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Build gorgeous megamenus with columns, images, icons, and buttons all through an easy interface.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/megamenu.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="110%" max_width_mobile="default" margin_top="13%"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffc444" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Search With Substance</h3>
[/nectar_responsive_text][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="advanced" gradient_type="default"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Advanced AJAX search functionality with multiple layout options that are capable of bringing up results in real-time.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height_tablet="60vw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="152%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="-8%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="custom" top_left_border_radius="20px" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-search.jpg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Features Grid #2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-5-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(10,10,10,0.1)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_desktop="25%" right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#0a0000" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Responsive Editing</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Maximize your control and create intricate responsive layouts with the ability to control settings uniquely per each device viewport.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="10%" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" column_padding_type="default" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-responsive.jpg" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_badge display_tag="label" badge_style="default" bg_color_type="global" color="accent-color" text_color="#ffffff" padding="small" border_radius="20px" display="block" text="New" margin_bottom="20"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Global Sections</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]The easy way to manage a section that you place on multiple pages of your site. Edits made in one location will instantly reflect in all instances where the section is used.[/nectar_responsive_text][divider line_type="No Line" custom_height="1vh"][/vc_column_inner][/vc_row_inner][nectar_lottie trigger_type="play" mobile_func="default" trigger_offset="10.00,100.00" frame_constraint="0.00,100.00" width_desktop="80%" alignment="center" preserve_aspect_ratio="xMidYMid meet" enable_shadow="true" json_url="https://assets4.lottiefiles.com/packages/lf20_zxmqc93z.json" custom_box_shadow="horizontal:0,vertical:25,blur:14,spread:0,opacity:0.075"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Features Grid #4', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-3-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-4.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column top_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin_tablet="20" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffc444" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="150" width="5/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner right_padding_tablet="33vw" right_padding_phone="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<div class="wpb_text_column wpb_content_element vc_custom_1490624298920">
<div class="wpb_wrapper">
<h3>Free Updates for Life</h3>
</div>
</div>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Over the past 10 years, we've consistently released updates with new features and fixes. You'll get free access to all future updates with a single purchase.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="100%" row_position="relative" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-updates.png" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="default" max_width="custom" max_width_custom="90%"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="15px" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner equal_height="yes" content_placement="top" column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1659929996435{margin-bottom: 0px !important;}"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" right_padding_desktop="60%" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" right_padding_tablet="50%" right_padding_phone="40%" bottom_margin_tablet="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#3452ff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="15px" column_link_target="_self" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Google Fonts</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Choose from over 1,400 Google fonts with powerful responsive typography settings.[/nectar_responsive_text][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/promo-google-fonts-logo.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="right" border_radius="none" box_shadow="none" image_loading="default" max_width="custom" position_desktop="absolute" top_position_desktop="20%" right_position_desktop="5%" top_position_phone="50%" right_position_phone="10%" translate_y_phone="-50%" max_width_custom="23vw" max_width_custom_tablet="35vw" max_width_custom_phone="18vw"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin="0" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#0a0000" column_shadow="none" column_border_radius="20px" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Blazing Performance</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Salient is Built with modern tooling and includes a suite of simple to use, yet powerful performance options created to target page speed scoring. View the report from <a href="#" target="_blank" rel="noopener"><strong>GTMetrix</strong></a> or <a href="#" target="_blank" rel="noopener"><strong>Google Lighthouse</strong></a>.[/nectar_responsive_text][divider line_type="No Line" custom_height="1vh"][nectar_lottie trigger_type="play" mobile_func="default" loop="true" trigger_offset="0.00,100.00" frame_constraint="0.00,100.00" speed="0.7" width_desktop="50%" width_phone="100%" alignment="left" preserve_aspect_ratio="xMidYMid meet" json_url="https://assets7.lottiefiles.com/packages/lf20_xui5jtgp.json"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Features Grid #5', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['lottie'];
$data['custom_class'] = 'general lottie date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-features-5.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="20px" equal_height="yes" content_placement="top" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f0f2f6" scene_position="center" top_padding="4%" constrain_group_1="yes" bottom_padding="4%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="14px" constrain_group_6="yes" right_padding_phone="14px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="20px" column_element_direction_desktop="default" column_element_spacing="0px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" font_color="#000000" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_color="rgba(0,0,0,0.15)" column_border_style="solid" gradient_type="default" column_padding_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="24%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" constrain_group_101="yes" right_padding_desktop="4vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" constrain_group_103="yes" right_padding_tablet="8vw" bottom_margin="-5%" column_element_direction_desktop="default" column_element_spacing="10px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Salient Help Center</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]We offer hands-on support with a professional team of agents to ensure that your questions get answered in a timely manner.[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][image_with_animation image_url="https://themenectar.com/img/demo-media/promo/helpcenter.webp" image_size="full" animation_type="entrance" animation="None" animation_movement_type="transform_y" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="default" max_width="custom"][/vc_column][vc_column top_padding_desktop="4vw" constrain_group_100="yes" bottom_padding_desktop="4vw" left_padding_desktop="4vw" right_padding_desktop="22vw" top_padding_tablet="8vw" constrain_group_102="yes" bottom_padding_tablet="8vw" left_padding_tablet="8vw" right_padding_tablet="50vw" right_padding_phone="33vw" column_element_direction_desktop="default" column_element_spacing="20px" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/promo/promo-docs.jpeg" background_image_position="center top" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" font_color="#ffffff" column_shadow="none" column_border_radius="20px" column_link_target="_self" column_position="default" overflow="hidden" advanced_gradient_angle="0" width="1/2" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="minimum" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="advanced" advanced_gradient_display_type="linear" column_padding_type="advanced"][nectar_responsive_text font_size_desktop="1.8vw" font_size_tablet="22px" font_line_height="1.3"]
<h3>Demo Importer</h3>
[/nectar_responsive_text][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.5"]Easily import any of the demos with one click via our simple demo importer plugin.[/nectar_responsive_text][divider line_type="No Line" custom_height="30vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Minimal FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-2-July-2022';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/2022-promo-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="12%" bottom_padding="12%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="24px" constrain_group_6="yes" right_padding_phone="24px" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" centered_text="true" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_responsive_text font_size_desktop="3vw" font_size_tablet="5vw" font_size_phone="8vw" font_line_height="1.1"]
<h3>Frequently asked questions</h3>
[/nectar_responsive_text][/vc_column_inner][/vc_row_inner][toggles style="minimal_shadow" accordion="true" accordion_starting_functionality="default" border_radius="20px"][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Was this site built with Salient?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ultricies metus sed turpis pulvinar eleifend. Pellentesque a tempor turpis, quis congue odio.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Where can I purchase Salient?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Proin accumsan mauris ut sem gravida, vel aliquam orci ornare. Cras sed urna neque. Vivamus mauris odio, pretium ac nunc a, ornare faucibus augue. Praesent quis lorem magna.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="What is included with my purchase?"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px" font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]
<ul>
 	<li>Lorem ipsum dolor sit amet, consectetur.</li>
 	<li> adipiscing elit. Duis ultricies metus .</li>
 	<li>sed turpis pulvinar eleifend. Pellentesque.</li>
 	<li>a tempor turpis, quis congue odio.</li>
 	<li><strong>Aliquam tristique, quam sed vulputate lobortis.</strong></li>
</ul>
[/fancy-ul][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="How can I get support after purchasing?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Donec orci est, viverra a volutpat vel, tempus non ipsum. Donec pellentesque aliquam pharetra. Maecenas tincidunt molestie enim, quis fringilla nisi laoreet in. Etiam ac nibh eget odio porta laoreet a at dui.[/nectar_responsive_text][/toggle][toggle color="Default" heading_tag="h3" heading_tag_functionality="default" title="Why should I trust ThemeNectar?"][nectar_responsive_text font_size_min="14px" font_size_max="20px" font_size_desktop="1.1vw" font_line_height="1.6"]Aenean facilisis facilisis nulla, non accumsan mauris gravida faucibus. <strong>Sed commodo laoreet erat</strong>, id elementum ipsum. Aliquam erat volutpat. Nulla ac dignissim elit, sit amet sollicitudin eros. Cras facilisis neque nec dui dignissim congue. Vestibulum ac fringilla lorem. Nulla dignissim mollis consequat.[/nectar_responsive_text][/toggle][/toggles][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Project Testimonial', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-quote-image.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="40" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1548248823-ce16a73b6d49.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="70vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="The Outcome" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque ante quam, ultrices nec vulputate et, egestas et quam. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="35"][nectar_single_testimonial testimonial_style="basic" image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1472099645785-5658abf4ff4e.webp" quote="Alex was there every step of the way and brought my vision further than I could have imagined!" name="Josh Margolis" subtitle="Founder of DAF"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Project Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['portfolio'];
$data['custom_class'] = 'portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-project-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#566678" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1535056074155-0004ae6c6283.webp" bg_position="center center" background_image_loading="default" bg_repeat="no-repeat" scene_position="center" top_padding="12%" constrain_group_1="yes" bottom_padding="12%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="25%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" enable_gradient="true" color_overlay="rgba(10,10,10,0.4)" color_overlay_2="#0a0a0a" advanced_gradient_angle="0" overlay_strength="0.95" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="zoom-out-slow" parallax_bg="true" parallax_bg_speed="fast" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Penn Center" font_size="8vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="1%" constrain_group_1="yes" bottom_padding="1%" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="300"][divider line_type="Vertical Line" divider_color="white" custom_height="50" custom_height_tablet="25"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" left_padding_tablet="15%" constrain_group_4="yes" right_padding_tablet="15%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque ante quam, ultrices nec vulputate et, egestas et quam. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vestibulum, nunc in finibus condimentum." font_size="1.1vw" font_line_height="1.6" animation_delay="500" animation_offset="100%" font_size_tablet="18" font_size_phone="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Company Culture List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-culture.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="values" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Culture" font_size="9vw" font_size_tablet="8vw" font_size_phone="10vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Innovate each project with <strong><em>no exceptions</em></strong>.</h2>
[/nectar_highlighted_text][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="01" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Always <strong><em>overdeliver</em></strong> to our clients.</h2>
[/nectar_highlighted_text][vc_column_text]Vivamus risus quam, dapibus non libero eu, bibendum.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="02" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="Full Width Line" line_thickness="1" divider_color="black" animate="yes" custom_height="45"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-10"][nectar_highlighted_text color_type="gradient" highlight_color="#9ebee7" secondary_color="#dcf0ff" style="full_text" highlight_expansion="default" custom_font_size="2vw"]
<h2>Build things that <strong><em>inspire</em></strong> people.</h2>
[/nectar_highlighted_text][vc_column_text]Nam magna dui, venenatis dignissim pharetra.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-2"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="letter-reveal-bottom" content_alignment="right" mobile_content_alignment="inherit" link_target="_self" text_content="03" font_size="7vw" font_line_height="1" font_size_phone="46" font_size_tablet="70"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Text and Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-text-image-3jpg.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="about" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="40" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1610733374054-59454fe657cd.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height_tablet="75vh"][/vc_column_inner][vc_column_inner column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="30vh" custom_height_tablet="0"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Modern Architecture" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo. Lorem ipsum dolor sit amet, consectetur adipiscing elit." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#000000" button_color="default" button_border_color="#cccccc" button_border_color_hover="#0a0a0a" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" link_text="Contact Us" margin_top="50" padding_top="15" padding_bottom="15" padding_left="40" padding_right="40"][divider line_type="No Line" custom_height="30vh" custom_height_tablet="0" custom_height_phone="0"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Team Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']  . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-team.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" bottom_padding="5%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="10%" constrain_group_3="yes" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="team" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Meet The Team" font_size="3vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We're an award-winning multidisciplinary team based in Philadelphia with a passion for creating innovative architecture. We work with businesses and people to create a more beautiful world." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18" font_size_phone="16"][/split_line_heading][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="35"][nectar_single_testimonial testimonial_style="basic" image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1545803928-04e3f4cdd4ed.webp" quote="Alex was there every step of the way and brought my vision further than I could have imagined!" name="Josh Margolis" subtitle="Founder of DAF"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" top_padding_tablet="40" bottom_padding_tablet="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1633332755192-727a05c4013d.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1633332755192-727a05c4013d.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Phil Martinez" job_position="CEO, Founder" image_size="regular" social_icon_1="fa fa-instagram" social_link_1="#" social_icon_2="fa fa-twitter" social_link_2="#"]Consectetur adipiscing elit. Etiam id mi faucibus, malesuada quam eget, facilisis turpis. Quisque ac purus erat.

Donec id pharetra tellus, vitae vehicula dolor. Aenean leo lorem, tempor vel mauris in, interdum fringilla erat. Nam auctor sodales dapibus. Ut et nibh sed neque lobortis mollis. Cras mauris tellus, ornare sed vestibulum eu, sagittis vitae justo. Vivamus pellentesque augue in orci commodo dignissim. Fusce id mi lacus.

Nullam ultricies mollis lorem, ac gravida diam pretium eget. Ut porttitor scelerisque lacus, a fringilla felis blandit sed.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1580489944761-15a19d654956.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1580489944761-15a19d654956.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Alex Smith" job_position="CFO, Partner" image_size="regular" social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-envelope" social_link_2="#"]Consectetur adipiscing elit. Etiam id mi faucibus, malesuada quam eget, facilisis turpis. Quisque ac purus erat.Donec id pharetra tellus, vitae vehicula dolor. Aenean leo lorem, tempor vel mauris in, interdum fringilla erat.

Nam auctor sodales dapibus. Ut et nibh sed neque lobortis mollis. Cras mauris tellus, ornare sed vestibulum eu, sagittis vitae justo. Vivamus pellentesque augue in orci commodo dignissim. Fusce id mi lacus.

Nullam ultricies mollis lorem, ac gravida diam pretium eget. Ut porttitor scelerisque lacus, a fringilla felis blandit sed.[/team_member][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="30px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all" css=".vc_custom_1634415872169{margin-bottom: 0px !important;}"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1472099645785-5658abf4ff4e-2.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1472099645785-5658abf4ff4e.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Kara Cohen" job_position="Associate" image_size="regular" social_icon_1="fa fa-facebook" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#" social_icon_3="fa fa-github" social_link_3="#"]Quisque elit nisl, varius nec ullamcorper eget, egestas vitae mi. Nam hendrerit eros a sagittis tempus. Mauris hendrerit hendrerit consequat. Nunc eget dui pulvinar, auctor neque sed, convallis ipsum. Fusce sagittis, dui a malesuada ullamcorper, nulla dolor interdum ipsum.

Ac condimentum eros lacus vestibulum nunc. Nunc maximus, massa et dictum dictum, risus massa dignissim nisl, at vestibulum ligula ante id metus. Morbi fringilla rhoncus porta.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1562124638-724e13052daf.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1562124638-724e13052daf.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Justin Klein" job_position="Office Manager" image_size="regular" social_icon_1="fa fa-instagram" social_link_1="#"]Etiam nulla velit, pharetra vel leo a, pretium rhoncus eros. Fusce eu hendrerit ipsum, vitae volutpat dui. Nunc eget mi tincidunt, luctus turpis at, pharetra diam. Nam sit amet purus cursus, rhoncus nibh nec, volutpat purus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum id iaculis velit, vitae faucibus augue. In quis lectus nisi.[/team_member][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][team_member image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1542327897-acbfd35f0163.webp" bio_alt_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1542327897-acbfd35f0163.webp" team_memeber_style="bio_fullscreen_alt" bio_fullscreen_alt_parallax="true" bio_fullscreen_alt_hide_link_arrow="true" image_loading="default" team_member_bio_full_html="html" hide_link_arrow="true" name="Andy Morris" job_position="Designer" image_size="regular" social_icon_1="fa fa-twitter" social_link_1="#" social_icon_2="fa fa-instagram" social_link_2="#"]Etiam nulla velit, pharetra vel leo a, pretium rhoncus eros. Fusce eu hendrerit ipsum, vitae volutpat dui. Nunc eget mi tincidunt, luctus turpis at, pharetra diam. Nam sit amet purus cursus, rhoncus nibh nec, volutpat purus. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vestibulum id iaculis velit, vitae faucibus augue. In quis lectus nisi.

Quisque elit nisl, varius nec ullamcorper eget, egestas vitae mi. Nam hendrerit eros a sagittis tempus. Mauris hendrerit hendrerit consequat. Nunc eget dui pulvinar, auctor neque sed, convallis ipsum. Fusce sagittis, dui a malesuada ullamcorper, nulla dolor interdum ipsum, ac condimentum eros lacus vestibulum nunc. Nunc maximus, massa et dictum dictum, risus massa dignissim nisl, at vestibulum ligula ante id metus. Morbi fringilla rhoncus porta.[/team_member][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean text block', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-text-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" bottom_padding="5%" left_padding_desktop="27%" constrain_group_2="yes" right_padding_desktop="27%" top_padding_tablet="20%" bottom_padding_tablet="10%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="6%" constrain_group_6="yes" right_padding_phone="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="20px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin="20" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="80%"][vc_column_text]
<h5>COMPANY</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We are a professional architecture firm based in Philadelphia" font_size="4vw" font_size_phone="10vw"][/split_line_heading][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Page Header With Anchor Links', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-about-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" bottom_padding="10%" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_padding_tablet="20%" top_padding_phone="25%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="fade-in" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="4/5" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-md-9"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="About Salient" font_size="9vw" font_size_tablet="9vw" font_size_phone="10vw"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="500" offset="vc_col-md-3"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Team" url="#team" margin_right="25"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Values" url="#about" margin_right="25"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#0a0a0a" button_color="default" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" display_tablet="inherit" display_phone="inline-block" link_text="Culture" url="#values"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" top_margin="-5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1556761175-4b46a572b786.webp" background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="600"][divider line_type="No Line" custom_height="100vh" custom_height_tablet="70vh" custom_height_phone="50vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Parallax Typography Scene', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-typography-scene.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="15%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="10" overflow="hidden" advanced_gradient="linear-gradient(183deg, rgb(158, 190, 231) 5%, rgb(220,240,255) 90%)" advanced_gradient_angle="183" shape_divider_position="bottom" bg_image_animation="slight-zoom-out-reveal" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" zindex="10" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-13%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slower" text_color="#ffffff" style="default" text_repeat_number="3" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="11vw"]
<h1>salient architecture</h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="-2.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="rtl" scroll_speed="slower" text_color="#ffffff" style="default" text_repeat_number="3" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="10vw" custom_font_size_mobile="11vw"]
<h1>salient architecture</h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="-20vw" top_margin_tablet="-23vw" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][image_with_animation image_url="https://themenectar.com/img/demo-media/architect/red-building-gPvqQOAOXCw.png" image_size="full" animation_type="entrance" animation="None" hover_animation="none" alignment="center" border_radius="none" box_shadow="none" image_loading="skip-lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Sticky Text Vertical Post Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['portfolio'];
$data['custom_class'] = 'general portfolio date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-portfolio-sticky.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="padding-6-percent" column_padding_tablet="padding-5-percent" column_padding_phone="inherit" column_padding_position="left-right" column_element_spacing="default" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="middle" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>PORTFOLIO</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Making the world a more beautiful place." font_size="3vw" max_width="80%"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="5%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#000000" button_color="default" button_border_color="#cccccc" button_border_color_hover="#0a0a0a" button_border_thickness="1px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" display_tablet="inherit" display_phone="inherit" link_text="View All Projects" margin_top="30" padding_top="15" padding_bottom="15" padding_left="40" padding_right="40" url="https://themenectar.com/salient/architect/salient-architect-projects/"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="padding-5-percent" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="30px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="1" grid_item_spacing="35px" grid_item_height="60vh" image_size="large" image_loading="default" animation="none" heading_tag="h3" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#ff5149" display_categories="yes" category_functionality="static" category_position="default" display_excerpt="yes" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="none" posts_per_page="3" custom_font_size="2vw"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Text with Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-inline-images.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" left_padding_desktop="27%" constrain_group_2="yes" right_padding_desktop="27%" bottom_padding_tablet="15%" left_padding_tablet="18%" constrain_group_4="yes" right_padding_tablet="18%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_text_inline_images images="" image_size="nectar_small_square" image_effect="circle_fade_in" image_loading="default" line_reveal_by_space_text_effect="" content_alignment="" font_style="h1" font_size="3vw" font_line_height="1.4" font_size_desktop="3vw" font_size_tablet="4vw" max_width="" font_size_phone="5vw"]
<h2>We're * changing the way <a href="#"><strong>architecture</strong></a> is * built for clients by utilizing Virtual Reality * to provide * immersive previews during our <a href="#"><strong>build process</strong></a>.</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Scrolling Text Heading', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-scrolling-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="3.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#0a0a0a" style="text_outline" outline_thickness="ultra-thin" text_repeat_number="5" text_repeat_divider="none" overflow="visible" background_image_animation="None" custom_font_size="11vw" custom_font_size_mobile="15vw"]
<h1><em>innovation </em></h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Images and Text Alt', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-images-and-text-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1556761175-4b46a572b786.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="70vh" custom_height_phone="60vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" text_align="left" min_width_desktop="40%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" right_position_desktop="0" zindex="50" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1636366312163-456bd30acd11.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="x_large_depth" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2.25" persist_movement_on_mobile="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="50vh" custom_height_tablet="40vh" custom_height_phone="35vh"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-8-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10" top_padding_tablet="7%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>COMMERICAL</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="We create structural beauty by innovating" font_size="3vw"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Aliquam non lectus id purus cursus porta. Nullam vel felis elementum, ornare magna non, feugiat ex. Phasellus erat ligula, laoreet sit amet magna vel, aliquet facilisis libero." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18px" font_size_phone="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_badge display_tag="label" bg_color_type="custom" bg_color_custom="#efefef" text_color="#1e1c1c" padding="medium" border_radius="20px" display="inline" text="Award Winning" margin_bottom="15" margin_right="15"][nectar_badge display_tag="label" bg_color_type="custom" bg_color_custom="#efefef" text_color="#1e1c1c" padding="medium" border_radius="20px" display="inline" text="Established Team" margin_bottom="15" margin_right="15"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Architect Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-carousel-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="6%" left_padding_desktop="8%" right_padding_desktop="8%" top_padding_tablet="10%" bottom_padding_tablet="15%" left_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="top" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="4" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#ff5149" flickity_touch_total_indicator_icon_color="#ffffff" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="15px" flickity_column_vertical_alignment="default" column_padding="0" flickity_element_spacing="0" flickity_image_scale_on_drag="true" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600818-5" title="Item" tab_id="1636930600818-9"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1610733374054-59454fe657cd.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" link_screen_reader="Daily anti-aging cream"]
<h4>Perfect Exterior Lines</h4>
Lorem ipsum dolor sit amet, consectetur adipiscing elit.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600875-9" title="Item" tab_id="1636930600876-10"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1622372738946-62e02505feb3.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="100"]
<h4>Square footage optimzation</h4>
Praesent porttitor pharetra sodales. Sed quam elit, congue eget est.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600904-0" title="Item" tab_id="1636930600906-2"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1604014237744-2f4ab6bfbcc2.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="200"]
<h4>Aesthetic layouts</h4>
Vivamus tempor a mauris a consectetur. Duis lorem mauris, feugiat.[/fancy_box][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1604014237256-11d475e2a2d8.webp" simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600937-2" title="Item" tab_id="1636930600938-7"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1525440584458-b53d13a848de.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="300"]
<h4>Natural light utilization</h4>
interdum accumsan libero. Etiam pretium laoreet tincidunt. Morbi semper quam orci.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600970-8" title="Item" tab_id="1636930600971-9"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1549407704-aeb7ffce9a76.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="400"]
<h4>Precise details in every room</h4>
Praesent a urna non quam commodo scelerisque. Donec iaculis nunc.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636930600999-6" title="Item" tab_id="1636930601000-1"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1556761175-4b46a572b786.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" delay="500"]
<h4>Ultra modern designs</h4>
Donec venenatis faucibus nibh ut tristique. Mauris odio augue, pulvinar quis lacus at.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Parallax Images and Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-12-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-images-and-text-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" scene_position="center" top_padding="12%" bottom_padding="6%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="padding-8-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10" top_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>RESIDENTIAL</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Iconic architecture expertly developed" font_size="3vw"][/split_line_heading][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_tablet="25%" right_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam fringilla est sapien, nec semper neque auctor nec. Duis vehicula quis mi at vehicula. Vivamus at." font_size="1.1vw" font_line_height="1.7" font_size_tablet="18px" font_size_phone="16px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" top_padding_tablet="30" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-4"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="30+" font_size="2.5vw" font_line_height="1" animation_delay="200"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Years of experience" font_size="1.1vw" font_line_height="1.5" animation_delay="300" max_width="60%" font_size_tablet="16px" font_size_phone="13px"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_col-xs-4"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="default" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="10x" font_size="2.5vw" font_line_height="1" animation_delay="200"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Builder of the year" font_size="1.1vw" font_line_height="1.5" max_width="55%" animation_delay="300" font_size_tablet="16px" font_size_phone="13px"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="20%" left_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1549407294-0bf7c458df48.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="70vh" custom_height_phone="60vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" text_align="left" min_width_desktop="40%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="0" zindex="50" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1600585153206-c6ff50dfb3c6.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="x_large_depth" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2.25" persist_movement_on_mobile="true" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="50vh" custom_height_tablet="40vh" custom_height_phone="35vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fullscreen Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-13-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/architect-landing-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#2b323a" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1449247666642-264389f5f5b1.webp" bg_position="left top" background_image_loading="default" bg_repeat="no-repeat" full_height="yes" scene_position="center" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" overflow="hidden" color_overlay="rgba(0,0,0,0.78)" advanced_gradient_angle="0" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="fade-in" mobile_disable_bg_image_animation="true" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="static" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="13vw" constrain_group_2="yes" right_padding_desktop="13vw" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="10" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" stagger_animation="true" mobile_disable_animation="true" content_alignment="left" mobile_content_alignment="inherit" link_target="_self" text_content="Rethink architecture." font_size="9vw" font_line_height="0.95" font_size_tablet="10vw" animation_delay="150"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="55%" translate_x="-50%" text_align="left" min_width_desktop="175px" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="50%" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="1" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" mobile_disable_animation="true" gradient_type="default" column_link="#section-two" delay="600" animation_offset="100%"][image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/scroll-down-light.png" image_size="full" animation_type="looped" loop_animation="rotate" hover_animation="none" alignment="" border_radius="none" image_loading="skip-lazy-load" max_width="custom" max_width_custom="175"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Minimal Blog Grid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-news-full.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="175" bottom_padding="3%" top_padding_tablet="25%" top_padding_phone="35%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="THE" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="NEWS" font_size="13vw" font_line_height="0.8" animation_delay="150" font_size_tablet="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" left_padding_desktop="5%" constrain_group_2="yes" right_padding_desktop="5%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="500" animation_offset="99%"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="3" grid_item_spacing="35px" grid_item_height="50vh" image_size="full" aspect_ratio_image_size="yes" custom_image_aspect_ratio="3-2" image_loading="default" animation="none" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="read" mouse_indicator_color="#eddecc" mouse_indicator_text_color="#000000" display_categories="yes" category_functionality="default" category_position="default" display_excerpt="yes" grid_style="content_under_image" content_under_image_text_align="left" text_color="dark" hover_effect="animated_underline_zoom" border_radius="none" shadow_on_hover="yes" custom_font_size="2.8vw" posts_per_page="12"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Parallax Image Gallery With Captions', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-image-gallery.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="800"][vc_gallery type="flickity_static_height_style" images="" flickity_spacing="10px" flickity_controls="touch_total_alt" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#f4ece2" flickity_touch_total_indicator_icon_color="#000000" flickity_overflow="hidden" flickity_wrap_around="wrap" flickity_image_parallax="true" flickity_box_shadow="none" image_loading="default" display_title_caption="true" onclick="link_image" flickity_img_height="70vh" flickity_img_small_desktop_height="70vh" flickity_img_tablet_height="40vh" flickity_img_mobile_height="250px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Large Animated Header', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-page-heading.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="175" top_padding_tablet="25%" top_padding_phone="35%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="RESORT" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="GALLERY" font_size="13vw" font_line_height="0.8" animation_delay="200" font_size_tablet="13vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="3%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="600"][vc_column_text]
<h5>Explore the resort</h5>
[/vc_column_text][divider line_type="Vertical Line" divider_color="black" custom_height="100" custom_height_tablet="60" custom_height_phone="50"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Scrolling Tabbed Rooms', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-vertical-tabbed-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="8%" left_padding_desktop="8%" left_padding_tablet="8%" constrain_group_4="yes" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" enable_animation="true" animation="fade-in" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="400"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_func="active_link_only" vs_navigation_width="regular" vs_tab_spacing="35%" vs_tab_tag="h2" vs_cta_style="text-reveal-wave" vs_cta_text_color="#0a0a0a" vs_cta_bg_color="accent-color" vs_cta_heading_tag="h5" vs_sticky_aspect="default" vs_font_size="3vw" vs_sub_desc_font_size="1.05vw"][tab icon_family="none" title="Standard selection" id="1636819609648-4" tab_id="1636819609649-0" sub_desc="Get a good night's sleep in our luxurious standard room. Featuring king size beds, walk-in showers and wifi internet."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1616046229478-9901c5536a45.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="skip-lazy-load" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $200/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Junior Studio" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 2</li>
 	<li>Number of rooms: 30</li>
 	<li>Square Footage: 200</li>
 	<li>Beds: 1 Baths: 1</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Rooms with a view" id="1636819609781-9" tab_id="1636819609782-9" sub_desc="We offer highrise rooms to elevate your view of the ocean even further. The perfect romantic getaway spot for couples."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1559414059-34fe0a59e57a.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $350/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Highrise Suite" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 4</li>
 	<li>Number of rooms: 15</li>
 	<li>Square Footage: 350</li>
 	<li>Beds: 2 Baths: 2</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="For large groups" id="1636819609866-2" tab_id="1636819609867-8" sub_desc="Leave all of your troubles behind and enjoy the ultimate escape in our deluxe cabins, perfect for the vacationing family."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1572970385182-97a64c98205b.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" left_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $750/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Deluxe Villa" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 8</li>
 	<li>Number of rooms: 20</li>
 	<li>Square Footage: 800</li>
 	<li>Beds: 4 Baths: 3</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Exclusive experience" id="1636819609960-0" tab_id="1636819609961-0" sub_desc="A once in a lifetime experience awaits you. Stay on the water in one of our exclusive bungalows hundreds of feet out on the ocean"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1590523277581-658f9545acd2.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="12%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" translate_y="33%" translate_y_tablet="0" text_align="left" min_width_desktop="60%" row_position="absolute" row_position_tablet="relative" row_position_phone="inherit" bottom_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-4-percent" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="-20%" column_element_spacing="10px" background_color="#ffffff" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.5" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="From $1000/night" font_size="2vw" font_line_height="1" font_size_tablet="3vw" font_size_phone="5vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Water Bungalow" font_size="4vw" font_line_height="1" font_size_tablet="6vw" font_size_phone="8vw"][/split_line_heading][divider line_type="No Line" custom_height="15"][fancy-ul icon_type="standard_dot" alignment="left" spacing="5px"]
<ul>
 	<li>Capacity: 4</li>
 	<li>Number of rooms: 12</li>
 	<li>Square Footage: 550</li>
 	<li>Beds: 2 Baths: 2</li>
</ul>
[/fancy-ul][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Reserve Room" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35" margin_top="40"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Light Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f4ece2" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="12%" constrain_group_3="yes" bottom_padding_tablet="12%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="rgba(0,0,0,0.1)" shape_divider_position="both" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="advanced" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="40%" bottom_padding_tablet="10%" left_padding_phone="10%" constrain_group_6="yes" right_padding_phone="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h4>Do you believe in magic?</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="This entire website was built with Salient, a creative next-generation WordPress theme." font_size_tablet="16"][/split_line_heading][nectar_cta btn_style="text-reveal-wave" heading_tag="h5" text_color="#000000" button_color="accent-color" button_border_thickness="0px" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="I don't believe it" margin_top="35" padding_top="15" padding_bottom="15" padding_left="35" padding_right="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="50px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" bottom_margin_phone="40" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="150"][vc_column_text css=".vc_custom_1636697193664{margin-bottom: 10px !important;}"]
<h4>Address</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="The Castle" font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="345 2500 Castle Dr." font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="Port Douglas, Queensland" font_size_tablet="16"][/split_line_heading][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" bottom_margin_tablet="0" bottom_margin_phone="0" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="300"][vc_column_text css=".vc_custom_1636697263705{margin-bottom: 10px !important;}"]
<h4>Connect</h4>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="T: +216 (0)40 3629 4753" font_size_tablet="16"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" font_size="1.05vw" font_line_height="1.6" text_content="E: hello@themenectar.com" font_size_tablet="16"][/split_line_heading][vc_column_text] [/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f4ece2" scene_position="center" top_padding="28" constrain_group_1="yes" bottom_padding="28" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="6%" constrain_group_3="yes" bottom_padding_tablet="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="101%"][vc_column_text]<b>© </b>[nectar_current_year] Salient Hotel[/vc_column_text][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" animation_offset="101%"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="10" text_align="right" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="center" alignment_phone="default" constrain_group_4="yes" display="inline" link_text="Terms &amp; Conditions" padding_left="25" padding_right="25"][nectar_cta btn_style="underline" heading_tag="p" button_color="default" button_border_thickness="0px" link_type="regular" alignment="right" alignment_tablet="center" alignment_phone="default" constrain_group_4="yes" display="inline" link_text="Privacy Policy" padding_left="25" padding_right="25"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Cropped Parallax CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="10%" top_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" left_padding_desktop="30%" constrain_group_2="yes" right_padding_desktop="30%" bottom_padding_tablet="6%" left_padding_tablet="13%" constrain_group_4="yes" right_padding_tablet="13%" left_padding_phone="11%" constrain_group_6="yes" right_padding_phone="11%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>RESERVATIONS</h5>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="It's time for that vacation" font_line_height="1" max_width="58%" font_size="4vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" bottom_padding="10%" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" translate_y="-50%" translate_x="-50%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="50%" zindex="200" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="2" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" line_reveal_by_space_text_effect="letter-reveal-top" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" link_indicator="true" link_indicator_bg_color="#f4ece2" link_indicator_icon_color="#000000" text_content="BOOK NOW" font_size="13vw" link_href="https://google.com" font_line_height="0.9" font_size_tablet="14vw"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="34%" constrain_group_2="yes" right_padding_desktop="34%" left_padding_tablet="30%" constrain_group_4="yes" right_padding_tablet="30%" left_padding_phone="27%" constrain_group_6="yes" right_padding_phone="27%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1504941214544-9c1c44559ab4.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" video_mp4="" background_video_loading="lazy-load" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="75vh" custom_height_tablet="45vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Full Width Layered Parallax Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-split-parallax.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#7a95a8" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1583939003579-730e3918a45a.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" enable_gradient="true" color_overlay="rgba(0,0,0,0.62)" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Weddings" font_size="3vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column][vc_column column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1515168985652-8454bcc8fcaf.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" enable_gradient="true" color_overlay="rgba(0,0,0,0.72)" color_overlay_2="rgba(0,0,0,0.24)" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" delay="200"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Conferences" font_size="3vw"][/split_line_heading][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" button_border_thickness="0px" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Learn More" url="#"][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Featured Recent Posts List', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-news.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="5%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="15%" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" sticky_content="true" sticky_content_functionality="css" sticky_content_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="left" mobile_content_alignment="center" link_target="_self" text_content="Read the latest news" font_size="4vw" font_line_height="0.9" max_width="75%"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="20" right_padding_desktop="15%" top_padding_tablet="0" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Track events, lean about activities and get vacation tips for your stay with us." font_size="1.05vw" font_line_height="1.6" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" ignore_sticky_posts="yes" grid_item_spacing="40px" image_size="portfolio-thumb_large" image_loading="default" animation="fade-in-from-bottom" heading_tag="h4" grid_style="vertical_list" vertical_list_hover_effect="slight_move" vertical_list_border_color="rgba(0,0,0,0.35)" vertical_list_read_more="yes" vertical_list_counter="yes" text_color="dark" posts_per_page="4"][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" gradient_type="default" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="transform_x" column_parallax_intensity="3.5" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" text_color="#000000" style="text_outline" outline_thickness="ultra-thin" text_repeat_number="4" text_repeat_divider="space" overflow="visible" background_image_animation="None" custom_font_size="13vw" custom_font_size_mobile="20vw"]
<h1><em>PRIVATE EVENTS</em></h1>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Fancy Box Parallax Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-parallax-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="8%" right_padding_desktop="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" id="impact" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="top" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>ACTIVITIES</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="3%" right_padding_desktop="70%" bottom_padding_tablet="6%" right_padding_tablet="40%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="The adventure starts now" font_size="4vw" font_line_height="0.9"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_style="solid_bg" flickity_touch_total_indicator_bg_color="#f4ece2" flickity_touch_total_indicator_icon_color="#000000" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="10px" flickity_centered_cells="true" flickity_column_vertical_alignment="bottom" column_padding="0" flickity_element_spacing="0" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204207-0" title="Item" tab_id="1636816204207-0"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1605144156683-5ebde77feed5.webp" hover_color="accent-color" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Golf" min_height_tablet="550"]
<h4>Premier Golf Course</h4>
A true test of the champion; Test your skills at our full 18-hole immaculate course overlooking the ocean.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204244-9" title="Item" tab_id="1636816204245-9"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1567227278154-0b83bcf237e1.webp" hover_color="accent-color" hover_color_custom="#0a0202" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Leafs" min_height_tablet="550"]
<h4>Relaxing Wellness Spa</h4>
Another layer of relaxation awaits you on your vacation. Featuring massages, a hair salon, and nail studio.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204265-8" title="Item" tab_id="1636816204266-1"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1602199926649-2e5e447bab97.webp" hover_color="accent-color" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Snorkel" min_height_tablet="550"]
<h4>Scuba Diving &amp; Snorkeling</h4>
Explore the crystal clear waters from down under with our scuba excursion.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204294-1" title="Item" tab_id="1636816204295-5"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1600521605615-a8d3a23d8262.webp" hover_color="extra-color-1" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Jeep" min_height_tablet="550"]
<h4>Premium Wildlife Tours</h4>
Expertly guided scenic and tours of the land available in group UTV sessions.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204322-6" title="Item" tab_id="1636816204323-10"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1551524358-f34c0214781d.webp" hover_color="extra-color-1" hover_color_custom="#000000" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Wave" min_height_tablet="550"]
<h4>Professional Surf Lessons</h4>
Get another item off your bucket list and immerse yourself in the swell with our instructors.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" id="1636816204348-2" title="Item" tab_id="1636816204349-3"][fancy_box box_style="hover_desc" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1499510318569-1a3d67dc3976.webp" hover_color="accent-color" hover_color_custom="#0a0202" hover_desc_color_opacity="0.9" hover_desc_hover_overlay_opacity="0.4" disable_hover_movement="true" bg_parallax="true" icon_position="top" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="75vh" icon_iconsmind="iconsmind-Tennis" min_height_tablet="550"]
<h4>Clay Tennis Courts</h4>
Professional-quality tennis courts that are available to you all year round. Classes and lessons are also available.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Images and Parallax Text Column', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-parallax-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="14%" left_padding_desktop="8%" right_padding_desktop="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="radial-gradient(circle at top right, rgb(255,200,129) 0%, rgba(243,243,243,0) 41%)" advanced_gradient_radial_position="top right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" gradient_type="advanced" shape_type="" advanced_gradient_display_type="radial"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_y="-50%" translate_x="50%" text_align="left" min_width_desktop="175" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="0" right_position_desktop="0" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="https://themenectar.com/img/demo-media/spinners/ocean-views.png" image_size="full" animation_type="looped" loop_animation="rotate" hover_animation="none" alignment="" border_radius="none" image_loading="skip-lazy-load" max_width="custom" el_class="dark-filter" max_width_custom="175"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1516752093629-7d10b9d79a18.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="radial" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="450"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-14-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1.75" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10vh" bottom_padding="15" top_padding_tablet="0" top_padding_phone="0" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_column_text]
<h5>Excellence</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h3" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Where forest meets ocean" font_size="4vw" font_line_height="0.9" max_width="85%"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="p" line_reveal_by_space_text_effect="none" content_alignment="default" mobile_content_alignment="inherit" link_target="_self" text_content="Nestled right in the middle of a natural juxtaposition. Salient is more than a resort; it's an unforgettable experience for you and your whole family." font_size="1.05vw" font_line_height="1.6" font_size_tablet="16"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="4%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="100" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="Vertical Line" divider_color="black" custom_height="34"][split_line_heading animation_type="line-reveal-by-space" font_style="i" line_reveal_by_space_text_effect="none" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="The best of both worlds; Refreshing greenery with scenic ocean views." font_line_height="1.3" max_width="70%" font_size="1.45vw" font_size_tablet="22px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1615228100591-976c4e87b179.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="65vh" custom_height_tablet="350"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Image Slider with Static Text Overlaid', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-slider-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" constrain_group_9="yes" constrain_group_10="yes" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient="linear-gradient(125deg, rgb(122, 149, 168) 15%, rgb(122, 149, 168) 15%)" advanced_gradient_angle="125" shape_divider_color="#f0ece5" shape_divider_position="bottom" shape_divider_height="33%" bg_image_animation="none" shape_type="straight_section" gradient_type="advanced" advanced_gradient_display_type="linear"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="35%" constrain_group_2="yes" right_padding_desktop="35%" left_padding_tablet="25%" constrain_group_4="yes" right_padding_tablet="25%" left_padding_phone="12%" constrain_group_6="yes" right_padding_phone="12%" translate_y="-50%" translate_x="-50%" text_align="left" min_width_desktop="100%" row_position="absolute" row_position_tablet="inherit" row_position_phone="inherit" top_position_desktop="50%" left_position_desktop="50%" zindex="100" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_icon icon_family="linea" enable_animation="true" animation_speed="medium" icon_style="default" icon_color_type="custom" icon_color_custom="#f4ece2" icon_padding="15px" icon_linea="icon-basic-compass"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#f4ece2" line_reveal_by_space_text_effect="default" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="Stunning views, outstanding service, and michelin star dining." font_size="3vw" font_size_tablet="5vw" font_line_height="1.3" font_size_phone="38px"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="simple_slider" simple_slider_sizing="aspect_ratio" simple_slider_aspect_ratio="2-1" simple_slider_pagination_controls="true" simple_slider_pagination_coloring="light" simple_slider_pagination_alignment="default" simple_slider_touch_indicator="true" simple_slider_touch_indicator_bg_color="#f4ece2" simple_slider_touch_indicator_icon_color="#000000" simple_slider_transition_type="slide" simple_slider_parallax="true" simple_slider_wrap="true" simple_slider_min_height="450"][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1634304233286-8c7956a85b29.webp" simple_slider_bg_image_position="center-top" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(0,0,0,0.74)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480591-9" title="Item" tab_id="1636774480592-0"][vc_column_text][/vc_column_text][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1446038236174-69712e24d137.webp" simple_slider_bg_image_position="center-bottom" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(10,10,10,0.5)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480618-8" title="Item" tab_id="1636774480619-4"][vc_column_text][/vc_column_text][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/photo-1508238100279-3b16198926a4.webp" simple_slider_bg_image_position="center-bottom" simple_slider_font_color="#ffffff" simple_slider_color_overlay="rgba(0,0,0,0.78)" simple_slider_overlay_strength="0.3" simple_slider_bg_image_loading="default" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1636774480643-1" title="Item" tab_id="1636774480643-2"][vc_column_text][/vc_column_text][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Scrolling Tabbed Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-vertical-tabbed.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" left_padding_desktop="8%" right_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_func="active_link_only" vs_navigation_width="wide" vs_tab_spacing="20px" vs_tab_tag="h2" vs_enable_cta="true" vs_cta_style="text-reveal-wave" vs_cta_text_color="#0a0a0a" vs_cta_bg_color="accent-color" vs_cta_heading_tag="h5" constrain_group_1="yes" constrain_group_2="yes" vs_sticky_aspect="default" vs_cta_text="View All Accommodations" vs_cta_padding_top="15" vs_cta_padding_bottom="15" vs_cta_padding_left="25" vs_cta_padding_right="25" vs_font_size="4vw" vs_sub_desc_font_size="1.05vw"][tab icon_family="none" title="Single Suites" id="1636774480206-0" tab_id="1636774480207-0" sub_desc="Bohemian-inspired interiors with breathtaking views of the ocean from one side, and lushes greenery from the other. Ranges from 200 - 300 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1559414059-34fe0a59e57a.webp"  background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Private Cabins" id="1636774480315-8" tab_id="1636774480317-5" sub_desc="Leave all of your troubles behind and enjoy the ultimate escape in our deluxe cabins, perfect for the vacationing family. Ranges from 400 - 600 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1572970385182-97a64c98205b.webp" background_image_position="center bottom" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Ocean Villas" id="1636774480370-4" tab_id="1636774480370-3" sub_desc="A once in a lifetime experience awaits you. Stay on the water in one of our exclusive bungalows hundreds of feet out on the ocean. Ranges from 300 - 500 sqft."][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1590523277581-658f9545acd2.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="50vh"][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Text With Inline Images', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-text-with-images.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" constrain_group_1="yes" bottom_padding="6%" left_padding_desktop="16%" constrain_group_2="yes" right_padding_desktop="16%" left_padding_phone="8%" constrain_group_6="yes" right_padding_phone="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][nectar_text_inline_images images="" image_size="medium" image_effect="circle_reveal" image_effect_rm_mobile="yes" image_loading="skip-lazy-load" line_reveal_by_space_text_effect="default" content_alignment="default" font_size="3vw" font_size_desktop="6vw" font_line_height="1.3" font_size_tablet="6vw" font_size_phone="8vw"]
<h2>An * enchanting new resort nestled on the coast of  Queensland *</h2>
[/nectar_text_inline_images][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Landing Hero Video', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-11-Nov-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/resort-landing-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="80" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="hidden" advanced_gradient_angle="0" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" translate_y="26%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="200" overflow="visible" pointer_events="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="parallax" animation_movement_type="default" column_parallax_intensity="1" persist_movement_on_mobile="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" gradient_type="default"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_color="#0a0909" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="YOUR" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw"][/split_line_heading][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_color="#0a0808" line_reveal_by_space_text_effect="letter-reveal-bottom" mobile_disable_animation="true" content_alignment="center" mobile_content_alignment="inherit" link_target="_self" text_content="PARADISE" font_size="13vw" font_line_height="0.8" font_size_tablet="13vw" animation_delay="200"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" zindex="1" overflow="hidden" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" advanced_gradient_angle="0" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" mobile_disable_entrance_animation="true" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" delay="550" gradient_type="default"][nectar_video_player_self_hosted video_mp4="" video_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1633797755709-9eea6ff21df2.webp" el_aspect="235" el_aspect_tablet="169" rm_on_mobile="true" player_functionality="lightbox" play_button_style="follow_mouse" play_button_color="#f4ece2" play_button_icon_color="#122120" border_radius="none" box_shadow="none" advanced_gradient="linear-gradient(180deg, rgba(244,236,226,0.22) 5%, rgba(255,255,255,0) 85%)" advanced_gradient_angle="180" video_lightbox_url="https://vimeo.com/118023315" advanced_gradient_display_type="linear"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Soft Footer With CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']. ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-footer-3.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#c498d9" scene_position="center" top_padding="10%" bottom_padding="5%" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Don't wait any longer, take control of your skin today" font_size="8vh"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt" font_container="tag:p|font_size:18|text_align:left|line_height:1.8" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][nectar_cta btn_style="see-through" heading_tag="h6" text_color="#ffffff" button_color="black" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="left" constrain_group_1="yes" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Shop Now" padding_top="20" padding_bottom="20" padding_left="50" padding_right="50" url="https://themenectar.com/promo" margin_top="20" margin_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#c498d9" scene_position="center" top_padding="5%" bottom_padding="10%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#0a0a0a" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="+216 (0)40 3629 4753"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="hello@domain.com"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Instagram" margin_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="FaceBook" padding_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Twitter" padding_right="25" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="YouTube" padding_right="25" margin_bottom="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Footer With CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general']. ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'general cta date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-footer-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" bottom_padding="5%" top_padding_tablet="20%" bottom_padding_tablet="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" right_padding_desktop="20%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Don't wait any longer, take control of your skin today" font_size="8vh"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_custom_heading text="Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt" font_container="tag:p|font_size:18|text_align:left|line_height:1.8" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][nectar_cta btn_style="see-through" heading_tag="h6" button_color="accent-color" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="left" constrain_group_1="yes" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Shop Now" padding_top="20" padding_bottom="20" padding_left="50" padding_right="50" url="https://themenectar.com/promo" margin_top="20" margin_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="5%" bottom_padding="10%" top_padding_tablet="10%" bottom_padding_tablet="20%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#5b5b5b" shape_divider_position="top" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="top" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Contact Us</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="+216 (0)40 3629 4753"][nectar_cta btn_style="underline" heading_tag="h4" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="hello@domain.com"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-md-6"][vc_column_text]
<h5>Connect</h5>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Instagram" margin_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="FaceBook" padding_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Twitter" padding_right="25" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="h6" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="YouTube" padding_right="25" margin_bottom="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'WooCommerce Overflowing Product Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-product-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_woo_products product_type="all" category="all" columns="4" flickity_mobile_column_width="100%" orderby="date" order="DESC" carousel="1" script="flickity" flickity_wrap="no-wrap" flickity_overflow="visible" flickity_controls="touch_indicator" flickity_image_scale_on_drag="true" flickity_item_animation="fade-in-side" per_page="8"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Minimal Full Width Grid Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-three-col-text-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" border_bottom_desktop="1" column_border_color="#919ec6" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="advanced" border_bottom_desktop="1" column_border_color="#919ec6" column_border_style="solid" offset="vc_col-xs-7"][nectar_highlighted_text color_type="regular" highlight_color="#ff7530" text_color="#000000" style="full_text" highlight_expansion="default" custom_font_size="4vw"]
<h2>How your skin was <em>meant to be</em>.</h2>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="advanced" border_bottom_desktop="1" column_border_color="#919ec6" column_border_style="solid" offset="vc_col-xs-5"][vc_column_text max_width="300"]
<h5>A new way to replenish skin tone and texture.</h5>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text css=".vc_custom_1616207860454{margin-bottom: 30px !important;}"]
<h3>Glowing</h3>
Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore.[/vc_column_text][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-800-waterfall.webp" animation="None" hover_animation="zoom-crop" alignment="" img_link_large="yes" border_radius="none" box_shadow="x_large_depth" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="advanced" border_left_desktop="1" border_right_desktop="1" column_border_color="#919ec6" column_border_style="solid" delay="150"][vc_column_text css=".vc_custom_1616207874149{margin-bottom: 30px !important;}"]
<h3>Resilient</h3>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.[/vc_column_text][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-800-leaves.webp" animation="None" hover_animation="zoom-crop" alignment="" img_link_large="yes" border_radius="none" box_shadow="x_large_depth" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid" delay="300"][vc_column_text css=".vc_custom_1616207884304{margin-bottom: 30px !important;}"]
<h3>Smooth</h3>
nostrud exercitation ullamco laboris nisi ut sunt in culpa qui officia deserunt mollit anim id est laborum.[/vc_column_text][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-800-trees.webp" animation="None" hover_animation="zoom-crop" alignment="" img_link_large="yes" border_radius="none" box_shadow="x_large_depth" image_loading="default" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Rotating Text Hero Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-24-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#9fc5d0" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/photo-1611912902203-c4be99ca7126.webp" bg_position="center center" background_image_loading="skip-lazy-load" bg_repeat="no-repeat" scene_position="center" top_padding="15%" bottom_padding="15%" top_padding_tablet="30%" constrain_group_3="yes" bottom_padding_tablet="30%" top_padding_phone="40%" constrain_group_5="yes" bottom_padding_phone="40%" text_color="custom" text_align="left" row_border_radius="none" row_border_radius_applies="bg" color_overlay="#000000" overlay_strength="0.3" gradient_direction="radial" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="45%" bg_image_animation="zoom-out" parallax_bg="true" parallax_bg_speed="fast" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="center" bg_image_animation="zoom-out-reveal" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" zindex="20"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Skincare made" font_size="10vh" animation_delay="200"][/split_line_heading][nectar_rotating_words_title heading_tag="h1" dynamic_text="simple, pure, honest, custom" ending_text="for you." duration="2500" dynamic_heading_tag="default" element_animation="stagger_words" mobile_display="inline" text_flow="inline" element_animation_delay="550" font_size="10vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" zindex="20"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" delay="650"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" constrain_group_3="yes" display="block" link_text="Shop Now" margin_top="30" padding_top="18" padding_bottom="18" margin_bottom="20" url="https://themenectar.com/demo/salient-ecommerce-robust/product-category/skincare/"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fancy Box Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="8%" bottom_padding="8%" top_padding_tablet="16%" bottom_padding_tablet="16%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_color="#000000" shape_divider_position="top" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="bottom" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30" bottom_padding_tablet="20" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]</p>
<h2>Featured Products</h2>
<p>Quality ingredients. Real results.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_hidden-xs"][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="right" alignment_tablet="default" alignment_phone="default" display="block" link_text="View All Products" url=""][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="4" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_hide_indicator="true" flickity_touch_total_icon_color="dark" color="extra-color-2" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="15px" column_padding="0" flickity_element_spacing="0" flickity_image_scale_on_drag="true" border_radius="none"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228607-7" tab_id="1616288228608-5" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-camera.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="https://themenectar.com/promo" link_screen_reader="Daily anti-aging cream"]</p>
<h4>Daily anti-acne cream with Tretinoin</h4>
<p>A multi purpose cream that fights breakouts while keeping skin youthful.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228653-4" tab_id="1616288228653-6" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-explore.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="100" link_screen_reader="Magic eye cream"]</p>
<h4>Magic eye kit</h4>
<p>Super charged active retinol cream that fights off stubborn eye bags 24/7.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228676-8" tab_id="1616288228677-10" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-field.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="200" link_screen_reader="Multi-peptide soothing moisturizer"]</p>
<h4>Multi-peptide soothing moisturizer</h4>
<p>An excellent source of antioxidants to sooth your skin. Made from waterlily extracts.[/fancy_box][/item][item simple_slider_bg_image_url="670" simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228696-1" tab_id="1616288228696-10" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-girl-2.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="300" link_screen_reader="Refreshing complete vitamin C Nectar serum"]</p>
<h4>Refreshing complete vitamin C Nectar serum</h4>
<p>Protect and rejuvenate your skin with our most potent vitamin C serum yet.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228721-9" tab_id="1616288228722-10" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-girl.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="400" link_screen_reader="The All-In-One Anti Ace"]</p>
<h4>The All-In-One Anti Ace</h4>
<p>A simple daily supplement that combats acne before it starts.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228768-4" tab_id="1616288228769-4" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-explore.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="" delay="500" link_screen_reader="The Nectar Super Secret Serum"]</p>
<h4>The Nectar Super Secret Serum</h4>
<p>The best kept secret in the skincare world can finally be yours.[/fancy_box][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616288228793-7" tab_id="1616288228794-9" title="Item"][fancy_box box_style="image_above_text_underline" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-camera.webp" image_aspect_ratio="4-5" content_color="#000000" border_radius="default" image_loading="default" enable_animation="true" animation="fade-in-from-right" image_size="large" link_url="https://themenectar.com/" delay="600" link_screen_reader="Vegetable Vitamins"]</p>
<h4>Natural Face Wash</h4>
<p>Easily get the vitamins you've been missing for perfect skin.[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Overflowing Parallax Left With Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'about general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-cascading-left.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="4%" bottom_padding="2%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#ff7530" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="20%" image_1_rotate_sign="+" image_1_rotate="none" image_1_scale="1" image_1_padding="none" image_1_box_shadow="none" image_1_max_width_desktop="100%" image_1_max_width_mobile="100%" image_1_image_width_mobile="default" image_2_url="https://themenectar.com/img/demo-media/rack/bottle-mockup.png" image_2_offset_x_sign="+" image_2_offset_x="0%" image_2_offset_y_sign="+" image_2_offset_y="10%" image_2_rotate_sign="+" image_2_rotate="none" image_2_scale="1" image_2_padding="none" image_2_box_shadow="none" image_2_max_width_desktop="100%" image_2_max_width_mobile="100%" image_2_image_width_mobile="default" image_3_offset_x_sign="+" image_3_offset_x="0%" image_3_offset_y_sign="+" image_3_offset_y="0%" image_3_rotate_sign="+" image_3_rotate="none" image_3_scale="1" image_3_padding="auto" image_3_box_shadow="none" image_3_max_width_desktop="100%" image_3_max_width_mobile="100%" image_3_image_width_mobile="default" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_scale="1" image_4_padding="auto" image_4_box_shadow="none" image_4_max_width_desktop="100%" image_4_max_width_mobile="100%" image_4_image_width_mobile="default" element_sizing="forced" element_sizing_aspect="1-1" image_loading="default" border_radius="none" parallax_scrolling="yes" layer_1_parallax_scrolling="no" parallax_scrolling_intensity="subtle" overflow="hidden"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" top_margin="6%" top_margin_tablet="0" top_margin_phone="4%" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Anti-Acne solutions that yield fast results" max_width="550"][/split_line_heading][vc_column_text max_width="550"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Anti-Acne" url=""][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Overflowing Parallax Right With Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'about general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-cascading-right.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="2%" bottom_padding="4%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="90px" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" top_margin="6%" top_margin_tablet="0" top_margin_phone="4%" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Expertly crafted serums for all skin types" max_width="550"][/split_line_heading][vc_column_text max_width="550"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Serums" url=""][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cascading_images image_1_bg_color="#bcafd3" image_1_offset_x_sign="+" image_1_offset_x="0%" image_1_offset_y_sign="+" image_1_offset_y="20%" image_1_rotate_sign="+" image_1_rotate="none" image_1_scale="1" image_1_padding="none" image_1_box_shadow="none" image_1_max_width_desktop="100%" image_1_max_width_mobile="100%" image_1_image_width_mobile="default" image_2_url="https://themenectar.com/img/demo-media/rack/bottle-mockup.png" image_2_offset_x_sign="+" image_2_offset_x="0%" image_2_offset_y_sign="+" image_2_offset_y="10%" image_2_rotate_sign="+" image_2_rotate="none" image_2_scale="1" image_2_padding="none" image_2_box_shadow="none" image_2_max_width_desktop="100%" image_2_max_width_mobile="100%" image_2_image_width_mobile="default" image_3_offset_x_sign="+" image_3_offset_x="0%" image_3_offset_y_sign="+" image_3_offset_y="0%" image_3_rotate_sign="+" image_3_rotate="none" image_3_scale="1" image_3_padding="auto" image_3_box_shadow="none" image_3_max_width_desktop="100%" image_3_max_width_mobile="100%" image_3_image_width_mobile="default" image_4_offset_x_sign="+" image_4_offset_x="0%" image_4_offset_y_sign="+" image_4_offset_y="0%" image_4_rotate_sign="+" image_4_rotate="none" image_4_scale="1" image_4_padding="auto" image_4_box_shadow="none" image_4_max_width_desktop="100%" image_4_max_width_mobile="100%" image_4_image_width_mobile="default" element_sizing="forced" element_sizing_aspect="1-1" image_loading="default" border_radius="none" parallax_scrolling="yes" layer_1_parallax_scrolling="no" parallax_scrolling_intensity="subtle" overflow="hidden"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Interactive Shop Categories', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['shop'];
$data['custom_class'] = 'shop date-21-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-category-grid.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="8%" bottom_padding="8%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" top_padding_tablet="8%" bottom_padding_tablet="20%" top_padding_phone="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#e0e0e0" shape_divider_position="bottom" shape_divider_height="1" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" bottom_padding_tablet="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]</p>
<h6>All Categories</h6>
<p>[/vc_column_text][/vc_column_inner][/vc_row_inner][nectar_category_grid post_type="products" product_category="all" heading_tag="h2" subtext="none" image_loading="lazy-load" grid_style="mouse_follow_image" image_aspect_ratio="4-5" text_color="dark" text_color_hover="dark" subtext_visibility="always" item_divider_custom=""][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Show-stopper Slider Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-23-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-slider.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ff7747" scene_position="center" top_padding="12%" left_padding_desktop="15%" constrain_group_2="yes" right_padding_desktop="15%" top_padding_tablet="20%" left_padding_tablet="10%" constrain_group_4="yes" right_padding_tablet="10%" left_padding_phone="0" constrain_group_6="yes" right_padding_phone="0" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" bottom_padding_tablet="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]</p>
<h6>Real Results, Guaranteed</h6>
<p>[/vc_column_text][/vc_column_inner][/vc_row_inner][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Our products are FDA approved and backed by real science" font_size="9vh"][/split_line_heading][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ff7747" scene_position="center" top_padding="6%" bottom_padding="6%" top_padding_tablet="7%" bottom_padding_tablet="10%" text_color="custom" custom_text_color="#d4c0ff" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="impact" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][carousel script="simple_slider" simple_slider_sizing="aspect_ratio" simple_slider_aspect_ratio="2-1" simple_slider_arrow_controls="true" simple_slider_arrow_positioning="inside" simple_slider_pagination_controls="true" simple_slider_pagination_coloring="light" simple_slider_pagination_alignment="right" simple_slider_parallax="true" simple_slider_min_height="575" autorotation_speed="6000"][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-girl-2.webp" simple_slider_bg_image_position="center-center" simple_slider_font_color="#ffffff" simple_slider_overlay_strength="0.3" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1616288229240-2" tab_id="1616288229241-6" title="Item"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="425"]</p>
<h2>Clear up acne breakouts in as little as two days.</h2>
<p>[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Now" url="" margin_top="35"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-girl.webp" simple_slider_bg_image_position="center-center" simple_slider_font_color="#ffffff" simple_slider_overlay_strength="0.3" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1616288229294-4" tab_id="1616288229295-10" title="Item"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="450"]</p>
<h2>Finally, a face wash that delivers.</h2>
<p>[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="" margin_top="35"][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-field.webp" simple_slider_bg_image_position="center-center" simple_slider_font_color="#ffffff" simple_slider_overlay_strength="0.3" simple_slider_gradient_direction="left_to_right" bg_image_url="" bg_image_position="default" image_url="" id="1616288229350-5" tab_id="1616288229351-10" title="Item"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="450"]</p>
<h2>Developed to provide deep regeneration.</h2>
<p>[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="https://themenectar.com/" margin_top="35"][/vc_column_inner][/vc_row_inner][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Staggered Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-testimonials.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="2%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" top_padding_tablet="10%" bottom_padding_tablet="8%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="50%" shape_divider_height_tablet="75%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" top_margin_tablet="20" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/tall-testimonial.webp" background_image_position="left top" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#ff4600" gradient_direction="top_to_bottom" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="40vh" custom_height_phone="200"][vc_column_text]
<h4>Marley Cohen</h4>
[/vc_column_text][vc_column_text]Dry Skin[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h5" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="``Vivamus egestas tincidunt sapien at pulvinar. Nullam pretium lorem est. Mauris orci lectus, porttitor ac quam a, egestas.``" max_width="650"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-3-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="30" bottom_padding_tablet="15" right_padding_tablet="15%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Real people with life-changing results" max_width="575"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/tall-testimonial-2.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#ff4600" gradient_direction="top_to_bottom" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="40vh" custom_height_phone="200"][vc_column_text]
<h4>TJ Davis</h4>
[/vc_column_text][vc_column_text]Oily Skin[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star" icon_size="14" margin_right="5"][nectar_icon icon_family="fontawesome" icon_style="default" icon_color_type="color_scheme" icon_color="Accent-Color" icon_padding="0px" icon_fontawesome="fa fa-star-half-o" icon_size="14"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="10%" left_padding_desktop="10%" constrain_group_2="yes" right_padding_desktop="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h5" stagger_animation="true" mobile_disable_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="``Mauris orci lectus, porttitor ac quam a, egestas consequat lorem. Nullam tincidunt. Mauris orci lectus, porttitor ac quam.``" max_width="650"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Triple Info Columns', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['services'];
$data['custom_class'] = 'general services date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-three-col-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="6%" bottom_padding="12%" bottom_padding_tablet="30%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="350"]
<h4>Quality Ingredients</h4>
[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text max_width="350"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="" margin_top="15"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="50" constrain_group_3="yes" bottom_margin_tablet="50" top_margin_phone="30" constrain_group_5="yes" bottom_margin_phone="30" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" delay="100"][vc_column_text max_width="350"]
<h4>Lasting Results</h4>
[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text max_width="350"]Even the all-powerful Pointing has no control about the blind texts. One day a line of blind text by the name.[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Explore" url="" margin_top="15"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin_tablet="20" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" delay="200"][vc_column_text max_width="350"]
<h4>Fast Shipping</h4>
[/vc_column_text][divider line_type="No Line" custom_height="15"][vc_column_text max_width="350"]A small river named Duden flows by their place and supplies it with the necessary regelialia.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Fun Dual Column Footer', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-footer.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#111111" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" color_overlay="#111111" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" column_margin="70px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="25%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]
<h4>Come Visit</h4>
The Castle Unit 345 2500 Castle Dr
Manhattan, NY[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]
<h4>Contact Us</h4>
+216 (0)40 3629 4753
hello@themenectar.com[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" bottom_padding="25%" bottom_padding_tablet="15%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Instagram" margin_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="FaceBook" padding_right="30" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="Twitter" padding_right="25" margin_bottom="10"][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" alignment_tablet="default" alignment_phone="default" display="inline" link_text="YouTube" padding_right="25" margin_bottom="10"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-10-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" border_left_desktop="1" border_left_tablet="0" border_top_tablet="1" border_left_phone="0" border_top_phone="1" column_border_color="#5e5e5e" column_border_style="solid"][vc_row_inner column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="15%" constrain_group_1="yes" bottom_padding="15%" top_padding_tablet="15%" bottom_padding_tablet="10%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="500"]
<h2>Stay in the loop with our weekly newsletter</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_content" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#111111" scene_position="center" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" color_overlay="#111111" overlay_strength="0.8" gradient_direction="radial" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="advanced" border_top_desktop="1" border_top_tablet="0" border_top_phone="0" column_border_color="#5e5e5e" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="50" constrain_group_1="yes" bottom_padding="50" top_padding_tablet="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slowest" style="text_outline" outline_thickness="thin" text_repeat_number="5" text_repeat_divider="custom" text_repeat_divider_scale="half" overflow="hidden" background_image_animation="None" custom_font_size="11vh" text_repeat_divider_custom="·" custom_font_size_mobile="8vh"]
<h2><a href="#"><em>Salient WordPress Theme</em></a></h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Text right with parallax image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-left-parallax-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="2%" top_padding_tablet="8%" bottom_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/mountain.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="55vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][nectar_highlighted_text color_type="regular" highlight_color="#ff7530" text_color="#ff7530" style="regular_underline" highlight_expansion="default" underline_thickness="1px" delay="400"]
<h5><em>No Shortcuts</em></h5>
[/nectar_highlighted_text][vc_column_text css_animation="none" css=".vc_custom_1615162301211{margin-bottom: 20px !important;}"]
<h3>Glowing Skin</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lobortis, nunc quis pharetra volutpat, nulla tellus commodo quam, non rutrum purus leo laoreet risus. Praesent id ipsum in nibh interdum eleifend quis et tellus. Suspendisse eu facilisis eros. Cras egestas convallis sem, a rutrum nisl.

Quisque pulvinar, metus ac scelerisque scelerisque, arcu dui consectetur lorem, at tristique magna magna vel sapien. Vivamus commodo sodales sem faucibus tincidunt. Nunc ut mi id dui suscipit varius et vel mi.

Nunc vel nunc vitae risus ornare convallis. Vestibulum non sem at turpis dictum pulvinar at interdum urna. Ut nec iaculis urna.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Text left with parallax image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-22-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-right-parallax-img.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding_tablet="8%" bottom_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" column_element_spacing="10px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][nectar_highlighted_text color_type="regular" highlight_color="#ff7530" text_color="#ff7530" style="regular_underline" highlight_expansion="default" underline_thickness="1px" delay="400"]
<h5><em>The difference</em></h5>
[/nectar_highlighted_text][vc_column_text css_animation="none" css=".vc_custom_1615162291092{margin-bottom: 20px !important;}"]
<h3>Gentle Exfoliation</h3>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="5px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][vc_column_text]
<h6>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer lobortis, nunc quis pharetra volutpat, nulla tellus commodo quam, non rutrum purus leo laoreet risus. Praesent id ipsum in nibh interdum eleifend quis et tellus. Suspendisse eu facilisis eros.</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="30" top_padding_tablet="0" top_padding_phone="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="20" bottom_margin="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-lg-6 vc_col-md-12"][vc_column_text css_animation="none" css=".vc_custom_1615162320908{margin-bottom: 10px !important;}"]
<h4>Vegan</h4>
[/vc_column_text][vc_column_text]The Big Oxmox advised her not to do so, because there were thousands of bad Commas, wild Question Marks and devious Semikoli.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="20" bottom_margin="20" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-lg-6 vc_col-md-12"][vc_column_text css_animation="none" css=".vc_custom_1615162311994{margin-bottom: 10px !important;}"]
<h4>Non-abrasive</h4>
[/vc_column_text][vc_column_text]Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-12"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/large-urban.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="55vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Carousel FAQ', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-20-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-faq.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="4%" bottom_padding="9%" top_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="1" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="1.5%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_color="#000000" stagger_animation="true" content_alignment="center" mobile_content_alignment="inherit" text_content="Need more info? Check out our most frequently asked questions." max_width="700"][/split_line_heading][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="2" tablet_cols_flickity="2" flickity_controls="default" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" pagination_alignment_flickity="default" flickity_spacing="15px" column_padding="30px" flickity_element_spacing="30px" flickity_image_scale_on_drag="true" border_radius="none" enable_column_border="true"][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899173-8" tab_id="1616281899174-2" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>How soon will products ship outside the U.S.?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282728232{margin-top: 10px !important;}" max_width="375"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris facilisis lorem sed nisl vulputate varius. Integer quis fermentum enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899251-5" tab_id="1616281899252-9" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>What is your return policy for opened products?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282737786{margin-top: 10px !important;}" max_width="375"]In vulputate dolor eu fermentum pharetra. Sed finibus nunc sed hendrerit imperdiet. Nam nisi justo, maximus id elit vel, dictum lacinia turpis.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899312-6" tab_id="1616281899313-6" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>Are all of your products organic and cruely-free?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282746674{margin-top: 10px !important;}" max_width="375"]Nam nisi justo, maximus id elit vel, dictum lacinia turpis. Integer cursus lorem vitae urna pharetra, ac aliquet metus condimentum.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][item simple_slider_bg_image_position="default" simple_slider_overlay_strength="0.3" id="1616281899370-3" tab_id="1616281899371-10" title="Item"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="no-extra-padding" column_padding_position="all" column_element_spacing="10px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text max_width="375"]</p>
<h4>Do you offer any promotions for first-time buyers?</h4>
<p>[/vc_column_text][vc_column_text css=".vc_custom_1616282753059{margin-top: 10px !important;}" max_width="375"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris facilisis lorem sed nisl vulputate varius. Integer quis fermentum enim.[/vc_column_text][/vc_column_inner][/vc_row_inner][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Layered Parallax Blocks', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'] . ', ' . $cat_display_names['cta'];
$data['custom_class'] = 'services cta date-21-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-dual-parallax.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="4%" bottom_padding="4%" top_padding_tablet="8%" constrain_group_3="yes" bottom_padding_tablet="8%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/neutral-field.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay="#0a0a0a" gradient_direction="radial" overlay_strength="0.5" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="very_subtle" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_column_text max_width="350" css=".vc_custom_1607992185528{margin-bottom: 15px !important;}"]
<h2>Serums</h2>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Now" url="#"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column_inner][vc_column_inner column_padding="padding-5-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/neutral-girl.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][vc_column_text css=".vc_custom_1607992178595{margin-bottom: 15px !important;}" max_width="350"]
<h2>Anti-Acne</h2>
[/vc_column_text][nectar_cta btn_style="underline" heading_tag="span" text_color="#ffffff" button_color="default" link_type="regular" alignment="center" alignment_tablet="default" alignment_phone="default" display="block" link_text="Shop Now" url="#"][divider line_type="No Line" custom_height="35vh" custom_height_phone="150"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Rotating Words, Text Above Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-20-Feb-2018';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-header-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffeddc" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="custom" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="33%" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="radial" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="35" left_padding_desktop="6%" constrain_group_2="yes" right_padding_desktop="6%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h1" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Premium skincare" font_size="7vh"][/split_line_heading][nectar_rotating_words_title heading_tag="h1" beginning_text="made" dynamic_text="simple, affordable, honestly, suited" ending_text="for you." duration="2500" dynamic_heading_tag="default" element_animation="stagger_words" mobile_display="inline" text_flow="inline" element_animation_delay="300" font_size="7vh"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="0px" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/large-business.webp" background_image_position="center center" enable_bg_scale="true" background_image_loading="default" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="60vh" custom_height_tablet="50vh" custom_height_phone="40vh"][split_line_heading animation_type="line-reveal-by-space" font_style="h5" text_color="#ffffff" stagger_animation="true" content_alignment="right" mobile_content_alignment="left" text_content="Skin that glows, guaranteed." max_width="300"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Call To Action with Scrolling Text Button', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-19-Feb-2021';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/ecom-robust-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="5%" constrain_group_1="yes" bottom_padding="5%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-11-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" background_image_position="center center" background_image_loading="default" column_shadow="none" column_border_radius="15px" column_link_target="_self" enable_gradient="true" color_overlay="#3648d6" color_overlay_2="#ff7530" gradient_direction="left_b_to_right_t" overlay_strength="0.95" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" border_type="simple" column_border_width="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="20" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" stagger_animation="true" content_alignment="default" mobile_content_alignment="inherit" text_content="Take the leap today and start building your site" max_width="700" font_size="65px"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="25%" constrain_group_2="yes" right_padding_desktop="25%" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" left_padding_phone="15%" constrain_group_6="yes" right_padding_phone="15%" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" column_element_spacing="default" background_color="#ff7530" background_color_opacity="1" background_color_hover="#3648d6" background_hover_color_opacity="1" column_shadow="none" column_border_radius="10px" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid" column_link="#"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="medium" text_color="#ffffff" style="default" text_repeat_number="6" text_repeat_divider="space" overflow="hidden" background_image_animation="None" custom_font_size="30px"]
<h4> Learn More</h4>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="10" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][vc_column_text]⚬ Quality guarantee ⚬ Free 30-day trial ⚬ Trusted globally[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Post Grid, Content Under Featured Image', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-blog-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="3" grid_item_spacing="25px" grid_item_height="30vh" image_size="large" image_loading="default" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#000000" animation="none" display_categories="yes" display_date="yes" display_excerpt="yes" grid_style="content_under_image" text_color="dark" hover_effect="zoom" border_radius="5px" posts_per_page="6"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Post Grid, Content Under Featured Image Masonry', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-blog-1.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="in_container" full_screen_row_position="middle" column_margin="default" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="load-more" button_color="black" columns="4" grid_item_spacing="25px" grid_item_height="30vh" enable_masonry="yes" image_size="large" image_loading="default" heading_tag="default" enable_indicator="yes" mouse_indicator_style="default" mouse_indicator_text="view" mouse_indicator_color="#000000" animation="none" display_categories="yes" display_date="yes" display_excerpt="yes" grid_style="content_under_image" text_color="dark" hover_effect="zoom" border_radius="5px" posts_per_page="6"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Nonprofit Dual CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['cta'];
$data['custom_class'] = 'cta date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_b_to_right_t" overlay_strength="1" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="5%" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="It's time to make nature our priority. Let's change the world together." max_width="650"][/split_line_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#f4f4f4" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/neutral-field.webp" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#f4f4f4" gradient_direction="left_to_right" overlay_strength="1" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="padding-6-percent" column_padding_phone="padding-12-percent" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][divider line_type="No Line" custom_height="5vh" custom_height_tablet="0vh"][vc_column_text css=".vc_custom_1579541117059{margin-bottom: 50px !important;}"]Every little bit helps the greater good of the world.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Donate" url="#" padding_top="15" padding_right="30" padding_bottom="15" padding_left="25"][divider line_type="No Line" custom_height="5vh" custom_height_tablet="0vh"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/12" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/neutral-explore.webp" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" color_overlay="rgba(0,0,0,0.7)" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner centered_text="true" column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1579541110385{margin-bottom: 50px !important;}" max_width="280"]We have a long track record of wide-reaching effects.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="white" link_type="regular" alignment="center" display="block" link_text="See our Impact" url="#" padding_top="15" padding_right="30" padding_bottom="15" padding_left="25"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Nonprofit Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] . ', ' . $cat_display_names['general'];
$data['custom_class'] = 'about general date-19-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-scrolling2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#f7f7f7" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="100" id="beliefs" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="90px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="5%" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]
<h3>If we can find the right way to teach people about wildlife, they will be touched.</h3>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]Aliquam ligula lectus, efficitur non pretium quis, elementum quis sapien. Nunc dapibus mi vitae mi placerat eleifend. Cras ullamcorper. Aliquam ligula lectus, efficitur non pretium quis.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="regular" alignment="left" display="block" link_text="Make a Donation" url="#" margin_top="30"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" text_color="#b5b5b5" style="text_outline" outline_thickness="thin" text_repeat_number="3" text_repeat_divider="none" overflow="hidden" background_image_url="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" background_image_animation="ro-reveal-from-bottom" separate_text_coloring="true" text_color_front="#ffffff" scroll_functionality="automatic" custom_font_size="15vh" custom_font_size_mobile="11vw" background_image_height="55vh"]
<h2><i>You Can Make A Difference</i></h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Nonprofit Scrolling Text Dark', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['about'] . ', ' . $cat_display_names['general'];
$data['custom_class'] = 'about general date-19-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-scrolling.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" text_color="light" text_align="left" zindex="100" id="beliefs" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="90px" bottom_padding="5%" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]</p>
<h3>If we can find the right way to teach people about wildlife, they will be touched.</h3>
<p>[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]Aliquam ligula lectus, efficitur non pretium quis, elementum quis sapien. Nunc dapibus mi vitae mi placerat eleifend. Cras ullamcorper molestie massa, at suscipit quam rhoncus vel. Suspendisse accumsan id diam et laoreet. Etiam eu feugiat nulla.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" display="block" link_text="Make a Donation" url="#" margin_top="30"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="slow" text_color="#595959" style="text_outline" outline_thickness="thin" text_repeat_number="3" text_repeat_divider="none" overflow="hidden" background_image_url="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" background_image_animation="ro-reveal-from-bottom" separate_text_coloring="true" text_color_front="#ffffff" scroll_functionality="automatic" custom_font_size="15vh" custom_font_size_mobile="11vw" background_image_height="55vh"]</p>
<h2><i>You Can Make A Difference</i></h2>
<p>[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Nonprofit Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'services blog date-19-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-recent-posts.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Recent News Articles" max_width="600"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in"][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" image_size="large" image_loading="lazy-load" heading_tag="h3" animation="fade-in-from-bottom" display_date="yes" grid_style="mouse_follow_image" text_color="dark" post_title_overlay="yes" mouse_follow_image_alignment="middle" mouse_follow_post_spacing="45px" border_radius="none" meta_visibility="always" posts_per_page="6" custom_font_size="28px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Nonprofit Services and Testimonials', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'] . ', ' . $cat_display_names['testimonials'];
$data['custom_class'] = 'services testimonials date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-services.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" bg_color="#ffffff" full_screen_row_position="middle" column_margin="default" scene_position="center" top_padding="12%" text_color="dark" text_align="left" id="testimonials" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Measurable results are the name of the game" max_width="450"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="90px" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" bottom_margin_tablet="5%" bottom_margin_phone="5%" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://themenectar.com/img/demo-media/unsplash/webp/small-smile-guy.webp" add_image_shadow="true" quote="Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet elementum semper. Etiam ultricies nisi vel augue. Curabitur ullamcorper." name="Kara Lucas" subtitle="Animal Activist"][/vc_column_inner][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" top_margin="150px" top_margin_tablet="5%" top_margin_phone="5%" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic_left_image" image="https://themenectar.com/img/demo-media/unsplash/webp/small-smile.webp" add_image_shadow="true" quote="Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Fringilla mauris sit amet. Donec sodales sagittis. Aenean commodo ligula." name="Alexander Gerard" subtitle="Conversationalist"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" bottom_padding="12%" text_color="dark" text_align="left" id="impact" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="default" column_padding="0" flickity_image_scale_on_drag="true" border_radius="none"][item id="1583163501716-5" title="Item" tab_id="1583163501718-4"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/large-mountain.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum."]
<h3>Forests</h3>
[/fancy_box][/item][item id="1583163501860-1" title="Item" tab_id="1583163501861-9"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-bird.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula."]
<h3>Birds</h3>
[/fancy_box][/item][item id="1583163501970-2" title="Item" tab_id="1583163501971-2"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-dolphin.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Socis natoque penatibus et magnis dis parturient montes."]
<h3>Dolphin</h3>
[/fancy_box][/item][item id="1583163502066-1" title="Item" tab_id="1583163502067-3"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-panda.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum."]
<h3>Pandas</h3>
[/fancy_box][/item][item id="1583163502157-8" title="Item" tab_id="1583163502158-10"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-rhino.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Sed vulputate purus sed facilisis dignissim erat."]
<h3>Rhino</h3>
[/fancy_box][/item][item id="1583163502244-7" title="Item" tab_id="1583163502246-2"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-turtle.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Socis natoque penatibus et magnis dis parturient montes."]
<h3>Turtles</h3>
[/fancy_box][/item][item id="1583163502353-0" title="Item" tab_id="1583163502354-1"][fancy_box box_style="hover_desc" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-cow.webp" hover_color="accent-color" box_alignment="left" hover_desc_bg_animation="none" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="450" hover_content="Sed vulputate purus sed facilisis dignissim erat."]
<h3>Cattle</h3>
[/fancy_box][/item][/carousel][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Nonprofit Reveal Image and Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'general date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-image-overlap.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" scene_position="center" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-rhino.jpg" alignment="" animation="ro-reveal-from-left" hover_animation="none" border_radius="none" image_loading="default" max_width="125%" max_width_mobile="default" margin_top="25%" margin_bottom="25%" margin_top_tablet="0px" margin_bottom_tablet="0px" margin_top_phone="0px" margin_bottom_phone="0px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#f0f5f9" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_t_to_right_b" overlay_strength="1" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" translate_y="20px" translate_x="10%" translate_y_tablet="30px" translate_x_tablet="0px" translate_x_phone="nonw"][vc_row_inner column_margin="default" translate_x="15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css_animation="none" css=".vc_custom_1582826380836{margin-bottom: 40px !important;}" max_width="550"]
<h2>Nature can be fully saved through love from people</h2>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1579198858100{margin-bottom: 40px !important;}" max_width="550"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Nulla consequat massa quis enim. Sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus lorem mus.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="video_lightbox" alignment="left" display="block" link_text="Watch Our Video" url="https://www.youtube.com/watch?v=RDC1ZFFhZq8"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Nonprofit Reveal Image and Text Alt', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'general date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-image-overlap-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color="#f0f5f9" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_t_to_right_b" overlay_strength="1" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" column_border_width="none" column_border_style="solid" translate_y="20px" translate_x="10%" translate_y_tablet="30px" translate_x_tablet="0px" translate_x_phone="nonw"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" translate_x="-15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" column_border_width="none" column_border_style="solid"][vc_column_text css_animation="none" css=".vc_custom_1582826380836{margin-bottom: 40px !important;}" max_width="550"]
<h2>Nature can be fully saved through love from people</h2>
[/vc_column_text][vc_column_text css_animation="none" css=".vc_custom_1579198858100{margin-bottom: 40px !important;}" max_width="550"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Nulla consequat massa quis enim. Sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus lorem mus.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="video_lightbox" alignment="left" alignment_tablet="default" alignment_phone="default" display="block" link_text="Watch Our Video" url="https://www.youtube.com/watch?v=RDC1ZFFhZq8"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" bg_image_animation="none" column_border_width="none" column_border_style="solid"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_spacing="default" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" bg_image_animation="none" column_border_width="none" column_border_style="solid"][image_with_animation image_url="https://themenectar.com/img/demo-media/unsplash/webp/animal-turtle.webp" animation="ro-reveal-from-right" hover_animation="none" alignment="right" border_radius="none" image_loading="default" max_width="125%" max_width_mobile="default" margin_top="25%" margin_bottom="25%" margin_top_tablet="0px" margin_bottom_tablet="0px" margin_top_phone="0px" margin_bottom_phone="0px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );





$data = array();
$data['name'] = esc_html__( 'Nonprofit Intro Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'general date-20-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="dark" text_align="left" id="philosophy" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_highlighted_text color_type="regular" highlight_color="#00cae8" style="regular_underline" delay="200"]
<h3>We stand proudly <a href="#"><em>united as one</em></a>. Our goal is to protect the all lifeforms on our planet. Together, we're part of something larger and <em><a href="#">extraordinary</a></em>. The future of wildlife depends on all of us acting now. With our combined efforts, we can prevent species on the <a href="#"><em>verge of extinction</em></a> from disappearing forever.</h3>
[/nectar_highlighted_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="new_tab" alignment="left" display="block" link_text="Make a Donation" url="#" margin_top="60"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Ageless Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-21-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overflow="visible" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section" gradient_type="default"][vc_column column_padding="no-extra-padding" column_padding_tablet="padding-6-percent" column_padding_phone="inherit" column_padding_position="top" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" animation_type="default" enable_animation="true" animation="fade-in-from-bottom" animation_easing="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" delay="400" offset="vc_col-xs-6"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="40" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" min_width_desktop="60vh" min_width_tablet="50vw" min_width_phone="50vw" overflow="visible" pointer_events="all" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][nectar_highlighted_text style="text_outline" outline_thickness="regular" text_outline_color="#000000" text="9vh" custom_font_size="10vh"]
<h1>Protecting our Diverse <em>Wildlife</em></h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding_tablet="0px" top_padding_phone="0px" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" min_width_tablet="0px" min_width_phone="0px" overflow="visible" pointer_events="all" min_width="47vh"][vc_column_inner column_padding="padding-9-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" enable_border_animation="true"][vc_column_text]Through steady action, we will ensure a bright future for our beautiful planet.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" column_position="default" gradient_direction="left_to_right" overlay_strength="0.5" width="3/4" tablet_width_inherit="default" animation_type="default" bg_image_animation="none" border_type="simple" column_border_width="none" column_border_style="solid" offset="vc_col-xs-6"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" row_position="default" row_position_tablet="inherit" row_position_phone="inherit" min_width_desktop="75vw" min_width_tablet="50vw" min_width_phone="50vw" overflow="visible" pointer_events="all"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" column_element_direction_desktop="default" column_element_spacing="default" desktop_text_alignment="default" tablet_text_alignment="default" phone_text_alignment="default" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/monkey-tall.webp" background_image_position="center center" background_image_stacking="default" enable_bg_scale="true" background_image_loading="default" column_backdrop_filter="none" column_shadow="none" column_border_radius="none" column_link_target="_self" overflow="visible" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" animation_type="default" bg_image_animation="ro-reveal-from-bottom" border_type="simple" column_border_width="none" column_border_style="solid"][divider line_type="No Line" custom_height="100vh" custom_height_tablet="80vh"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Dark Wellness Gradient Highlight Intro', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-highlight-intro-text-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="#000000" style="regular_underline"]
<h3><em><a href="#">Achieve</a></em> your goals easier than ever before. We offer a wide range of rewarding amenities which are all <em><a href="#">personalized</a></em> to specific <a href="#"><em>your needs</em></a>.</h3>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Wellness Gradient Highlight Text Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/fitness-tall.webp" background_image_position="center top" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="-28%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]
<h2>Elevate Your Body and <em>Mind</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329676960{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#ffffff" button_color="default" link_type="regular" alignment="left" display="block" link_text="Explore amenities" url="#" margin_top="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colored-services-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/food.webp" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#0b473a" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Nutritional Plans</h4>
Catered to suit your lifestyle.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/800-500-bike.webp" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#ff6b30" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="" min_height="400"]
<h4>Fitness Center</h4>
Custom programs built for you.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/800-500-room.webp" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#36302c" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Full Day Spa</h4>
5,000 square feet of pure bliss.[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="4%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452718117{margin-bottom: 15px !important;}"]
<h4>Skin Care</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Vitamin C Cleanse</li>
 	<li>Organic Tea Facial</li>
 	<li>Ultra Hydration Facial</li>
 	<li>Vampire Facial</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452713162{margin-bottom: 15px !important;}"]
<h4>Psychology</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Mature life</li>
 	<li>Prenatal well-being</li>
 	<li>Relationship Counseling</li>
 	<li>General Stress</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452723639{margin-bottom: 15px !important;}"]
<h4>Grooming</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Blow-Outs</li>
 	<li>General Styling</li>
 	<li>Keratin Treatments</li>
 	<li>Scalp Treatments</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="150" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452728136{margin-bottom: 15px !important;}"]
<h4>Massage</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Therapeutic</li>
 	<li>Deep Tissue</li>
 	<li>Essential Oil</li>
 	<li>Couples</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Wellness Pricing Tiers', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/pricing-tiers-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Bronze" col_2_content="Access to facility 7 days out of the month, Basic group classes, Personal Coach." cta_1_text="Join Now" col_3_content="$25/mo" icon_iconsmind="iconsmind-Dry"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Silver" col_2_content="Bronze + Unlimited Access to facilties from every day from 9am - 10pm, Personal nutritionist, Personal trainer." cta_1_text="Join Now" col_3_content="$35/mo" icon_iconsmind="iconsmind-Plant"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Gold" col_2_content="Silver + Fully unlimited access to facility, Bi-monthly therapy, Monthly massage." cta_1_text="Join Now" col_3_content="$50/mo" icon_iconsmind="iconsmind-Flowerpot"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Platinum" col_2_content="Gold + Business Coaching, Bi-weekly therapy, Access to cryotherapy and thermotherapy rooms, Spa package discounts." cta_1_text="Join Now" col_3_content="$100/mo" icon_iconsmind="iconsmind-Palm-Tree"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Wellness Gradient Highlight Text Section 2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text2-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left" min_width_desktop="120%" min_width_tablet="0px"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]
<h2>Flourish with Optimism, Live <em>Deliberately</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329697124{padding-right: 10% !important;}"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" top_padding="40" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-light.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/fitness-pushup.webp" background_image_position="right center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Dark Wellness Interactive Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/featured-img-mouse-follow-post-grid-2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#000000" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text max_width="450"]
<h2>Recent blog articles we've written</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" image_size="large" image_loading="lazy-load" heading_tag="h3" animation="fade-in-from-bottom" display_date="yes" grid_style="mouse_follow_image" text_color="light" post_title_overlay="yes" mouse_follow_image_alignment="middle" mouse_follow_post_spacing="25px" border_radius="none" posts_per_page="3" custom_font_size="28px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Interactive Recent Posts', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['blog'];
$data['custom_class'] = 'blog date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/featured-img-mouse-follow-post-grid.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" bottom_padding="3%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text max_width="450"]
<h2>Recent blog articles we've written</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][nectar_post_grid post_type="post" blog_category="all" order="DESC" orderby="date" pagination="none" columns="3" image_size="large" image_loading="lazy-load" heading_tag="h3" animation="fade-in-from-bottom" display_date="yes" grid_style="mouse_follow_image" text_color="dark" post_title_overlay="yes" mouse_follow_image_alignment="middle" mouse_follow_post_spacing="25px" border_radius="none" posts_per_page="3" custom_font_size="28px"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Video Overlap', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/video-lightbox-split-bg.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" bottom_padding="8%" constrain_group_1="yes" top_padding="8%" text_color="light" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" enable_shape_divider="true" shape_divider_color="#0b473a" shape_divider_position="bottom" shape_divider_height="50%" bg_image_animation="none" shape_type="straight_section"][vc_column centered_text="true" column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height="25vh" custom_height_tablet="20vh"][vc_row_inner column_margin="20px" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_lightbox link_style="play_button" video_url="https://vimeo.com/118023315"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text]
<h2>Your Life, Rejuvenated</h2>
[/vc_column_text][/vc_column_inner][/vc_row_inner][divider line_type="No Line" custom_height="25vh" custom_height_tablet="20vh"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Pricing Tiers', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['pricing'];
$data['custom_class'] = 'pricing date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/pricing-tiers.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Bronze" col_2_content="Access to facility 7 days out of the month, Basic group classes, Personal Coach." cta_1_text="Join Now" col_3_content="$25/mo" icon_iconsmind="iconsmind-Dry"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Silver" col_2_content="Bronze + Unlimited Access to facilties from every day from 9am - 10pm, Personal nutritionist, Personal trainer." cta_1_text="Join Now" col_3_content="$35/mo" icon_iconsmind="iconsmind-Plant"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Gold" col_2_content="Silver + Fully unlimited access to facility, Bi-monthly therapy, Monthly massage." cta_1_text="Join Now" col_3_content="$50/mo" icon_iconsmind="iconsmind-Flowerpot"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_horizontal_list_item columns="4" column_layout_using_4_columns="large_first" col_1_text_align="left" col_2_text_align="left" col_3_text_align="right" col_4_text_align="right" col_1_text_element="h3" col_2_text_element="p" col_3_text_element="h4" col_4_text_element="p" font_family="p" hover_effect="full_border" hover_color="accent-color" border_radius="5px" icon_family="iconsmind" icon_size="large" col_1_content="Platinum" col_2_content="Gold + Business Coaching, Bi-weekly therapy, Access to cryotherapy and thermotherapy rooms, Spa package discounts." cta_1_text="Join Now" col_3_content="$100/mo" icon_iconsmind="iconsmind-Palm-Tree"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Testimonials with Scrolling Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['testimonials'];
$data['custom_class'] = 'testimonials date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/testimonials-scrolling-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" bg_color="#0b473a" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/neutral-field.webp" bg_position="center center" bg_repeat="no-repeat" scene_position="center" top_padding="12%" bottom_padding="1%" text_color="light" text_align="left" enable_gradient="true" color_overlay="#0b473a" color_overlay_2="rgba(11,71,58,0.7)" overlay_strength="1" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="90px" bottom_padding="14%" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic" text_color="#ffffff" quote="People take different roads seeking fulfillment and happiness. Just because they’re not on your road doesn’t mean they’ve gotten lost." name="Kara Lucas" subtitle="Yoga Instructor"][/vc_column_inner][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" top_margin="200px" top_margin_tablet="50px" top_margin_phone="50px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_single_testimonial testimonial_style="basic" text_color="#ffffff" quote="If we are to create a more peaceful world, made up of peaceful individuals, we need a greater concern for others. Altruism. That gives inner strength, self-confidence." name="Alex Cohen" subtitle="Life Coach"][/vc_column_inner][/vc_row_inner][nectar_scrolling_text scroll_direction="rtl" scroll_speed="medium" text_color="#ffffff" style="text_outline" outline_thickness="thin" text_repeat_number="5" text_repeat_divider="custom" text_repeat_divider_scale="half" overflow="visible" background_image_animation="None" custom_font_size="10vh" text_repeat_divider_custom="⚬"]
<h2>a better life</h2>
[/nectar_scrolling_text][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="1%" bottom_padding="12%" text_color="dark" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_scrolling_text scroll_direction="ltr" scroll_speed="medium" text_color="#0b473a" style="text_outline" outline_thickness="thin" text_repeat_number="5" text_repeat_divider="custom" text_repeat_divider_scale="half" overflow="visible" background_image_animation="None" custom_font_size="10vh" text_repeat_divider_custom="⚬"]
<h2>awaits you</h2>
[/nectar_scrolling_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Gradient Highlight Text Section 2', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text2.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="15%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left" min_width_desktop="120%" min_width_tablet="0px"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]</p>
<h2>Flourish with Optimism, Live <em>Deliberately</em></h2>
<p>[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329697124{padding-right: 10% !important;}"]A small river named Duden flows by their place and supplies it with the necessary regelialia. It is a paradisematic country, in which roasted parts of sentences fly into your mouth. Even the all-powerful Pointing has no control about the blind texts.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" top_padding="40" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][vc_row_inner equal_height="yes" content_placement="middle" column_margin="70px" text_align="left"][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-sm-offset-0 vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" alignment="" animation="None" hover_animation="none" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/neutral-camera.webp" background_image_position="right center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Services', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/colored-services.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/food.webp" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#0b473a" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Nutritional Plans</h4>
Catered to suit your lifestyle.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/fitness-pushup.webp" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#ff6b30" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="" min_height="400"]
<h4>Fitness Center</h4>
Custom programs built for you.[/fancy_box][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][fancy_box box_style="parallax_hover" icon_family="none" image_url="https://themenectar.com/img/demo-media/unsplash/webp/neutral-field.webp" parallax_hover_box_alignment="bottom" parallax_hover_box_overlay="#36302c" parallax_hover_box_overlay_opacity="0.9" parallax_hover_box_overlay_opacity_hover="0.3" border_radius="default" image_loading="default" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" min_height="400"]
<h4>Full Day Spa</h4>
5,000 square feet of pure bliss.[/fancy_box][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" top_padding="4%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452718117{margin-bottom: 15px !important;}"]
<h4>Skin Care</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Vitamin C Cleanse</li>
 	<li>Organic Tea Facial</li>
 	<li>Ultra Hydration Facial</li>
 	<li>Vampire Facial</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="50" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452713162{margin-bottom: 15px !important;}"]
<h4>Psychology</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Mature life</li>
 	<li>Prenatal well-being</li>
 	<li>Relationship Counseling</li>
 	<li>General Stress</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452723639{margin-bottom: 15px !important;}"]
<h4>Grooming</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Blow-Outs</li>
 	<li>General Styling</li>
 	<li>Keratin Treatments</li>
 	<li>Scalp Treatments</li>
</ul>
[/fancy-ul][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/4" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="150" offset="vc_col-xs-6"][vc_column_text css=".vc_custom_1581452728136{margin-bottom: 15px !important;}"]
<h4>Massage</h4>
[/vc_column_text][fancy-ul icon_type="none" alignment="left" spacing="15px"]
<ul>
 	<li>Therapeutic</li>
 	<li>Deep Tissue</li>
 	<li>Essential Oil</li>
 	<li>Couples</li>
</ul>
[/fancy-ul][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Wellness Gradient Highlight Intro', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-highlight-intro-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" bottom_padding="" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="#ffffff" style="regular_underline"]
<h3><em><a href="#">Achieve</a></em> your goals easier than ever before. We offer a wide range of rewarding amenities which are all <em><a href="#">personalized</a></em> to specific <a href="#"><em>your needs</em></a>.</h3>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Wellness Gradient Highlight Text Section', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/overlapping-highlight-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" top_padding="8%" constrain_group_1="yes" bottom_padding="8%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/flowers-light-bg.webp" background_image_position="center top" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="zoom-out"][divider line_type="No Line" custom_height_tablet="600" custom_height_phone="500"][/vc_column][vc_column column_padding="padding-7-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" translate_x="-28%" translate_x_tablet="0%" translate_x_phone="0%" text_align="left"][vc_column_inner column_padding="padding-10-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" style="half_text" custom_font_size="7vh"]
<h2>Elevate Your Body and <em>Mind</em></h2>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" top_margin="40" top_margin_tablet="0px" top_margin_phone="0px" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1580329676960{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="h5" text_color="#000000" button_color="default" link_type="regular" alignment="left" display="block" link_text="Explore amenities" url="#" margin_top="10"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Gradient Highlight Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-10-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/gradient-highlight-hero.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" bg_image="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" bg_color="#0b473a" video_bg="use_video" video_mp4="" scene_position="center" top_padding="13%" constrain_group_1="yes" bottom_padding="13%" top_padding_tablet="20%" bottom_padding_tablet="25%" text_color="light" text_align="left" color_overlay="rgba(11,71,58,0.9)" overlay_strength="0.95" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" parallax_bg="true" parallax_bg_speed="fast" shape_type="curve"][vc_column centered_text="true" column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" bottom_padding="60" bottom_padding_tablet="20" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_highlighted_text color_type="gradient" highlight_color="#ff6b30" secondary_color="rgba(255,107,48,0.01)" text_color="#f8eadc" style="half_text" custom_font_size="10vh" delay="200"]
<h1>Outside Health Starts <em>Inside</em></h1>
[/nectar_highlighted_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="600"][nectar_cta btn_style="next-section" btn_type="minimal-arrow" alignment="center" next_section_color="#f8eadc"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );






$data = array();
$data['name'] = esc_html__( 'Clean Image and Left Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-left-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="90px" equal_height="yes" content_placement="middle" bg_color="#ffffff" top_padding_tablet="8%" constrain_group_1="yes" bottom_padding_tablet="8%" scene_position="center" text_color="dark" text_align="left" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="3/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583244983471{margin-bottom: 20px !important;}"]
<h2>Why we're different</h2>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:20px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="70px" top_padding="25" bottom_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583243653891{margin-bottom: 10px !important;}"]
<h4>Attention to Detail</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583243657396{margin-bottom: 10px !important;}"]
<h4>Experience</h4>
[/vc_column_text][vc_custom_heading text="Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="0px" bottom_padding_tablet="40px" bottom_padding_phone="40px" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Contact Us" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="2/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left" min_width_desktop="43vw" min_width_tablet="50vw" min_width_phone="50vw"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="ro-reveal-from-right"][divider line_type="No Line" custom_height="80vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Clean Image and Right Text', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'] . ', ' . $cat_display_names['about'];
$data['custom_class'] = 'general about date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/basic-right-text.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" bg_color="#ffffff" scene_position="center" top_padding_tablet="8%" constrain_group_1="yes" bottom_padding_tablet="8%" text_color="dark" text_align="left" id="home" overlay_strength="0.5" gradient_direction="top_to_bottom" shape_divider_position="bottom" bg_image_animation="none" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" right_margin_tablet="auto" left_margin_tablet="auto" right_margin_phone="auto" left_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_tablet="600" max_width_phone="420px" gradient_direction="left_to_right" overlay_strength="0.5" width="2/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/mountain.webp" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.5" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="ro-reveal-from-left"][divider line_type="No Line" custom_height="90vh" custom_height_tablet="40vh" custom_height_phone="300px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-7-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" top_margin_tablet="40" right_margin_tablet="auto" left_margin_tablet="auto" right_margin_phone="auto" left_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_desktop="1000px" max_width_tablet="600px" max_width_phone="420px" zindex="100" gradient_direction="left_t_to_right_b" overlay_strength="0.3" width="3/5" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-12"][vc_row_inner column_margin="40px" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583270538634{margin-bottom: 20px !important;}"]
<h2>Our Philosophy</h2>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:20px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="70px" top_padding="25" bottom_padding="15" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583270560188{margin-bottom: 10px !important;}"]
<h4>Quality over Quantity</h4>
[/vc_column_text][vc_custom_heading text="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="small_desktop" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1583270575677{margin-bottom: 10px !important;}"]
<h4>Design Focused</h4>
[/vc_column_text][vc_custom_heading text="Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean." font_container="tag:p|font_size:16px|text_align:left|line_height:2em" use_theme_fonts="yes" css_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" bottom_padding="0px" bottom_padding_tablet="40px" bottom_padding_phone="40px" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="h6" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Contact Us" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean Self Hosted Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/npo-video-hero.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" scene_position="center" top_padding="12%" constrain_group_1="yes" bottom_padding="12%" top_padding_tablet="20%" bottom_padding_tablet="20%" top_padding_phone="20%" bottom_padding_phone="20%" text_color="dark" text_align="left" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css_animation="fadeInUp" css=".vc_custom_1579718474257{margin-bottom: 10px !important;}"]
<h5>Salient WordPress Theme</h5>
[/vc_column_text][split_line_heading animation_type="line-reveal-by-space" font_style="h1" text_content="Build a beautiful website, visually" max_width="475"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="h4" text_color="#ffffff" button_color="accent-color" link_type="regular" alignment="left" display="block" link_text="Get Started" margin_top="30" padding_top="20" padding_right="40" padding_bottom="20" padding_left="40"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-left"][nectar_video_player_self_hosted video_webm="" video_image="https://themenectar.com/img/demo-media/unsplash/webp/yellow-bg-plant.webp" loop="yes" border_radius="10px" box_shadow="none"][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Promo Video Hero', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['hero_section'];
$data['custom_class'] = 'hero_section date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/yellow-header.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffcf6d" scene_position="center" top_padding="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="20" overlay_strength="1" gradient_direction="top_to_bottom" enable_shape_divider="true" shape_divider_color="#ffffff" shape_divider_position="bottom" shape_divider_height="20%" bg_image_animation="none" video_mute="true" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][vc_column_text]
<h4>Salient WordPress Theme</h4>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="13%" constrain_group_2="yes" right_padding_desktop="13%" left_padding_tablet="0" right_padding_tablet="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][nectar_highlighted_text text_color="#000000" style="text_outline" outline_thickness="regular" custom_font_size="10vh"]
<h1>Beautiful &amp; unique
websites made easy</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" left_padding_desktop="0" constrain_group_2="yes" right_padding_desktop="0" text_align="left"][vc_column_inner column_padding="padding-6-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][nectar_cta btn_style="basic" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#fff5e2" link_type="regular" alignment="center" constrain_group_1="yes" constrain_group_2="yes" constrain_group_3="yes" constrain_group_4="yes" display="inline" margin_top="20" margin_bottom="20" margin_left="15" margin_right="15" link_text="Why Choose Salient" padding_top="20" padding_bottom="20" padding_left="45" padding_right="45"][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#ffffff" button_color="accent-color" button_color_hover="#2643ef" link_type="new_tab" alignment="left" constrain_group_1="yes" constrain_group_2="yes" constrain_group_3="yes" constrain_group_4="yes" display="inline" link_text="Purchase Salient" margin_top="20" margin_bottom="20" margin_left="15" margin_right="15" padding_top="20" padding_bottom="20" padding_left="45" padding_right="45"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" top_padding="5%" left_padding_desktop="8%" constrain_group_2="yes" right_padding_desktop="8%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="200"][nectar_video_player_self_hosted video_image="https://themenectar.com/img/demo-media/unsplash/webp/yellow-bg-plant.webp" hide_controls="yes" loop="yes" autoplay="yes" border_radius="15px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="8%" left_padding_desktop="12%" constrain_group_2="yes" right_padding_desktop="12%" left_padding_tablet="0" constrain_group_4="yes" right_padding_tablet="0" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.8" gradient_direction="left_t_to_right_b" shape_divider_color="#ff8b50" shape_divider_position="bottom" shape_divider_height="250" bg_image_animation="none" video_mute="true" shape_type="straight_section"][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="40px" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="70"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-xs-4"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="140"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="210"][/vc_column_inner][vc_column_inner column_padding="padding-1-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="left-right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/5" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_hidden-sm vc_hidden-xs"][image_with_animation image_url="https://themenectar.com/demo/dummy-data-imgs/tn-sample-logo-grey.png" animation="Grow In" hover_animation="none" alignment="" border_radius="none" box_shadow="none" image_loading="lazy-load" max_width="100%" max_width_mobile="default" delay="280"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]

CONTENT;

vc_add_default_templates( $data );




$data = array();
$data['name'] = esc_html__( 'Video Overflow Right', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-right-overflow-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="50px" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="column_reverse" column_direction_phone="column_reverse" bg_color="#ffffff" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" top_padding_tablet="15%" constrain_group_3="yes" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.8" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self"  gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-6"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Intuitive Interface"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec posuere mi eget felis placerat, quis condimentum quam mattis. Aenean id diam sit amet lacus.[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Discover More" url="#design" padding_top="20" padding_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-4-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-6"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left" min_width_desktop="58vw"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://themenectar.com/img/demo-media/unsplash/webp/yellow-bg-plant.webp" hide_controls="yes" loop="yes" autoplay="yes" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Video Overflow Left', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-left-overflow-video.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_content" full_screen_row_position="middle" column_margin="default" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="10%" bottom_padding="10%" top_padding_tablet="15%" bottom_padding_tablet="15%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" zindex="200" id="design" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" left_margin_tablet="auto" right_margin_tablet="auto" left_margin_phone="auto" right_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_tablet="600px" max_width_phone="420px" gradient_direction="left_to_right" overlay_strength="0.3" width="5/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="40" translate_x="-20%" translate_x_tablet="0" text_align="left" min_width_desktop="50vw" min_width_tablet="none"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://themenectar.com/img/demo-media/unsplash/webp/large-adventure.webp" hide_controls="yes" loop="yes" autoplay="yes" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="padding-10-percent" column_padding_tablet="no-extra-padding" column_padding_phone="no-extra-padding" column_padding_position="left" left_margin_tablet="auto" right_margin_tablet="auto" left_margin_phone="auto" right_margin_phone="auto" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" max_width_desktop="850" max_width_tablet="600px" max_width_phone="420px" gradient_direction="left_to_right" overlay_strength="0.3" width="7/12" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" right_padding_desktop="90" right_padding_tablet="0" text_align="left" min_width="47vh"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" enable_border_animation="true" bg_image_animation="none"][split_line_heading animation_type="line-reveal-by-space" font_style="h2" text_content="Award-Winning Design"][/split_line_heading][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="40" right_padding_desktop="90" right_padding_tablet="0" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text]
<div class="wpb_text_column wpb_content_element vc_custom_1490624298920">
<div class="wpb_wrapper">
<h6>For over 7 years, we've focused on creating trend-setting designs that make people stop and stare.  Details matter, and we rush nothing. Quality, not quantity, is what guides us.</h6>
</div>
</div>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-2-percent" column_padding_tablet="no-extra-padding" column_padding_phone="inherit" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" constrain_group_3="yes" constrain_group_4="yes" display="block" link_text="Great design for all" url="#" padding_top="20" padding_bottom="20"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Clean Dual CTA', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-cta.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="2%" bottom_padding="7%" top_padding_tablet="8%" bottom_padding_tablet="10%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_b_to_right_t" overlay_strength="1" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="10" bottom_padding_phone="5" left_padding_phone="25%" constrain_group_6="yes" right_padding_phone="25%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="slight-twist"][vc_column_text]
<h6>This site was built with Salient</h6>
[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_highlighted_text text_color="#000000" style="text_outline" outline_thickness="regular" custom_font_size="10vh"]
<h1>You Can Build a</h1>
<h1>Stunning Website</h1>
[/nectar_highlighted_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row type="full_width_background" full_screen_row_position="middle" column_margin="none" equal_height="yes" content_placement="middle" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" bottom_padding="8%" text_color="dark" text_align="left" row_border_radius="10px" row_border_radius_applies="inner" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color="#ffcf6d" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" tablet_text_alignment="center" phone_text_alignment="center" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner equal_height="yes" content_placement="middle" column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="10" left_padding_tablet="20%" constrain_group_4="yes" right_padding_tablet="20%" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/minimal-white-desk-open-middle.webp" background_image_position="left top" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" enable_gradient="true" color_overlay_2="#ffcf6d" gradient_direction="left_to_right" overlay_strength="1" width="5/6" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-6 vc_col-md-5 vc_hidden-sm vc_hidden-xs"][/vc_column_inner][vc_column_inner column_padding="padding-15-percent" column_padding_tablet="padding-8-percent" column_padding_phone="padding-8-percent" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" offset="vc_col-lg-5 vc_col-md-6"][vc_column_text css=".vc_custom_1586179428508{margin-bottom: 50px !important;}"]Start by checking out the premade demo websites to see what's possible.[/vc_column_text][nectar_cta btn_style="basic" heading_tag="span" text_color="#ffffff" button_color="accent-color" button_color_hover="#2643ef" link_type="video_lightbox" alignment="left" display="block" link_text="See The Magic" url="https://www.youtube.com/watch?v=RDC1ZFFhZq8" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" background_image="https://themenectar.com/img/demo-media/unsplash/webp/large-clouds.webp" background_image_position="center center" enable_bg_scale="true" column_shadow="none" column_border_radius="none" column_link_target="_self" color_overlay="#3452ff" gradient_direction="left_to_right" overlay_strength="0.8" width="1/2" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding_tablet="10" text_align="left"][vc_column_inner column_padding="padding-12-percent" column_padding_tablet="inherit" column_padding_phone="padding-8-percent" column_padding_position="all" centered_text="true" background_color_opacity="1" background_hover_color_opacity="1" font_color="#ffffff" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_column_text css=".vc_custom_1586179434669{margin-bottom: 50px !important;}" max_width="280"]Salient is the ultimate WordPress theme for building beautiful websites.[/vc_column_text][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="white" button_color_hover="#e8e8ff" link_type="regular" alignment="center" display="block" link_text="Purchase Salient" url="#" padding_top="15" padding_right="35" padding_bottom="15" padding_left="35"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Sticky Vertical Tabs', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-17-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/sticky-tabs.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#ffffff" scene_position="center" top_padding="6%" bottom_padding="6%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][tabbed_section style="vertical_scrolling" tab_color="Accent-Color" vs_navigation_width="regular" vs_navigation_spacing="45px" vs_tab_spacing="40%" vs_tab_tag="h3"][tab icon_family="none" title="The Best Features" id="1586441707425-5" sub_desc="Far far away, behind the word mountains, far from the countries Vokalia and Consonantia." tab_id="1586441707426-2"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://themenectar.com/img/demo-media/unsplash/webp/large-clouds.webp" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Intuitive User Interface" id="1586441707538-9" sub_desc="Separated they live in Bookmarksgrove right at the coast of the Semantics." tab_id="1586441707540-6"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_custom_heading text="Look deep into nature, and then you will understand everything better." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586380254133{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586380260249{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Scorching Hot Design" id="1586441707700-1" sub_desc="It is a paradisematic country, in which roasted parts of sentences fly into your mouth." tab_id="1586441707701-2"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_custom_heading text="Try not to become a man of success, but rather try to become a man of value." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586380277392{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586380281399{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );



$data = array();
$data['name'] = esc_html__( 'Dark Sticky Vertical Tabs', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['general'];
$data['custom_class'] = 'general date-8-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/sticky-tabs-dark.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bg_color="#000000" scene_position="center" top_padding="10%" constrain_group_1="yes" bottom_padding="10%" text_color="light" text_align="left" row_border_radius="none" row_border_radius_applies="bg" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][tabbed_section style="vertical_scrolling" tab_color="extra-color-gradient-1" vs_navigation_width="regular" vs_navigation_spacing="45px" vs_tab_spacing="40%" vs_tab_tag="h3"][tab icon_family="none" title="Best Features Provided" id="1586451527673-0" tab_id="1586451527675-4"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://themenectar.com/img/demo-media/unsplash/webp/large-city.webp" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586450820355{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586450820355{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Intuitive User Interface" id="1586451527867-5" tab_id="1586451527868-3"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][nectar_video_player_self_hosted video_image="https://themenectar.com/img/demo-media/unsplash/webp/large-fashion.webp" border_radius="10px" box_shadow="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586450830737{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586450830737{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. They live.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][tab icon_family="none" title="Scorching Hot Design" id="1586451528012-3" tab_id="1586451528013-6"][vc_row_inner column_margin="none" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="2/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_custom_heading text="Try not to become a man of success, but rather try to become a man of value." font_container="tag:h2|font_size:40|text_align:left|line_height:50px" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/3" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][/vc_column_inner][/vc_row_inner][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" text_align="left"][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css=".vc_custom_1586380277392{padding-right: 10% !important;}"]Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts. Separated they live in Bookmarksgrove right at the coast of the Semantics, a large language ocean.[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="padding-3-percent" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="top-bottom" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][vc_column_text css=".vc_custom_1586380281399{padding-right: 10% !important;}"]Even the all-powerful Pointing has no control about the blind texts it is an almost unorthographic life One day however a small line of blind text by the name of Lorem Ipsum decided to leave for the far World of Grammar.[/vc_column_text][/vc_column_inner][/vc_row_inner][/tab][/tabbed_section][/vc_column][/vc_row]
CONTENT;

vc_add_default_templates( $data );


$data = array();
$data['name'] = esc_html__( 'Services Carousel', 'js_composer' );
$data['cat_display_name'] = $cat_display_names['services'];
$data['custom_class'] = 'services date-18-Jan-2020';
$data['image_path'] = preg_replace( '/\s/', '%20', SALIENT_CORE_PLUGIN_PATH . '/includes/img/templates/promo-services-carousel.jpg' );
$data['content'] = <<<CONTENT
[vc_row type="full_width_background" full_screen_row_position="middle" column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" scene_position="center" top_padding="14%" constrain_group_1="yes" bottom_padding="14%" top_padding_tablet="20%" constrain_group_3="yes" bottom_padding_tablet="20%" text_color="dark" text_align="left" row_border_radius="none" row_border_radius_applies="bg" id="more-features" overlay_strength="0.3" gradient_direction="left_to_right" shape_divider_position="bottom" bg_image_animation="none" shape_type=""][vc_column column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/1" tablet_width_inherit="default" tablet_text_alignment="default" phone_text_alignment="default" column_border_width="none" column_border_style="solid" bg_image_animation="none"][vc_row_inner column_margin="default" column_direction="default" column_direction_tablet="default" column_direction_phone="default" bottom_padding="15" text_align="left"][vc_column_inner column_padding="padding-4-percent" column_padding_tablet="padding-13-percent" column_padding_phone="padding-4-percent" column_padding_position="right" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom"][vc_column_text css_animation="none" css=".vc_custom_1585945715457{margin-bottom: 20px !important;}" max_width="500"]
<h2>Salient is loaded with the features you need</h2>
[/vc_column_text][/vc_column_inner][vc_column_inner column_padding="no-extra-padding" column_padding_tablet="inherit" column_padding_phone="inherit" column_padding_position="all" background_color_opacity="1" background_hover_color_opacity="1" column_shadow="none" column_border_radius="none" column_link_target="_self" gradient_direction="left_to_right" overlay_strength="0.3" width="1/2" tablet_width_inherit="default" column_border_width="none" column_border_style="solid" bg_image_animation="none" enable_animation="true" animation="fade-in-from-bottom" delay="100"][nectar_single_testimonial testimonial_style="basic" quote="Salient is an overall amazing theme. It packs all the features one may need, it's snappy, fast, incredibly user-friendly, and is by far, one of the best I've used."][nectar_cta btn_style="arrow-animation" heading_tag="span" text_color="#000000" button_color="default" link_type="regular" alignment="left" constrain_group_3="yes" display="block" link_text="See what people are saying" url="#" padding_top="20" padding_bottom="20" margin_top="40"][/vc_column_inner][/vc_row_inner][carousel script="flickity" flickity_formatting="default" desktop_cols_flickity="3" desktop_small_cols_flickity="3" tablet_cols_flickity="2" flickity_controls="touch_total" flickity_touch_total_hide_indicator="true" color="default" flickity_overflow="visible" flickity_wrap_around="no-wrap" flickity_spacing="20px" column_padding="0" flickity_image_scale_on_drag="true" border_radius="none" touch_total_hide_indicator="true"][item id="1586088313912-3" tab_id="1586088313913-8" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/500-500-building.webp" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Edit" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Front-end Editor &amp; Back-end Editor</h3>
Edit your site visually or through a simplified interface. The choice is yours.[/fancy_box][/item][item id="1586088314180-7" tab_id="1586088314181-8" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/500-500-forest.webp" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" enable_animation="true" animation="none" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Duplicate-Layer" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Huge Collection of Elements</h3>
Over 55 unique page builder elements to create your masterpiece.[/fancy_box][/item][item id="1586088314414-2" tab_id="1586088314415-9" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/500-500-sky.webp" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" enable_animation="true" animation="none" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Flash" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Blazing Fast Performance</h3>
97% PageSpeed score &amp; 93% YSlow Score on GTMetrix.[/fancy_box][/item][item id="1586088314647-8" tab_id="1586088314648-4" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-600-flame.webp" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="here's some awesome text that would only be shown on hover" icon_iconsmind="iconsmind-Window-2" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Suitable for Any Website</h3>
Unlimited customization possibilities allow Salient to shine no matter the use case.[/fancy_box][/item][item id="1586088314855-1" tab_id="1586088314856-6" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-600-girl.webp" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" color_scheme="dark" secondary_content="" icon_iconsmind="iconsmind-Monitor-phone" min_height="300" min_height_tablet="275" min_height_phone="255"]
<h3>Ultra Responsive and Retina Ready</h3>
Built with mobile in mind rather than it being an afterthought.[/fancy_box][/item][item id="1586088315048-2" tab_id="1586088315049-6" title="Item"][fancy_box box_style="color_box_hover" icon_family="iconsmind" image_url="https://themenectar.com/img/demo-media/unsplash/webp/600-600-guy.webp" color="accent-color" color_custom="#000000" color_box_hover_overlay_opacity="0.5" box_alignment="left" enable_border="true" border_radius="default" image_loading="lazy-load" c