<?php 
/**
 * Icon Collections
 *
 * @package Salient Core
 * @subpackage helpers
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( !function_exists('salient_iconsmind_arr_p') ) {

  function salient_iconsmind_arr_p() {

    return array(
      'Pac-Man' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M18.232 32c-8.823 0-16-7.177-16-16s7.177-16 16-16c4.288 0 8.315 1.676 11.341 4.717 0.259 0.259 0.259 0.681-0.001 0.941l-10.341 10.341 10.341 10.341c0.26 0.26 0.26 0.681 0.001 0.941-3.027 3.041-7.053 4.717-11.341 4.717zM18.232 1.333c-8.085 0-14.667 6.581-14.667 14.667s6.581 14.667 14.667 14.667c3.708 0 7.204-1.367 9.917-3.861l-10.332-10.333c-0.26-0.257-0.26-0.683 0-0.943l10.332-10.331c-2.713-2.499-6.209-3.865-9.917-3.865zM14.899 12.001c-1.837 0-3.333-1.495-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.495 3.333 3.333-1.496 3.333-3.333 3.333zM14.899 6.668c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2z',
      ),
      'Paint-Brush' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26.667 22.667h-21.333c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h21.333c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.3 0.667-0.667 0.667zM6 21.333h20v-2.667h-20v2.667zM26.667 32h-21.333c-0.368 0-0.667-0.299-0.667-0.667v-9.333c0-0.368 0.299-0.667 0.667-0.667h21.333c0.367 0 0.667 0.299 0.667 0.667v9.333c0 0.368-0.3 0.667-0.667 0.667zM6 30.667h20v-8h-20v8zM8 30c-0.368 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM10.667 30c-0.368 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM13.333 30c-0.368 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM16 30c-0.368 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM18.667 30c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.3 0.667-0.667 0.667zM21.333 30c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.3 0.667-0.667 0.667zM24 30c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.3 0.667-0.667 0.667zM26.667 19.333c-0.367 0-0.667-0.299-0.667-0.667v-1.959c0-1.128-0.917-2.041-2.041-2.041h-0.959c-2.757 0-5-2.244-5-5v-6.333c0-1.103-0.897-2-2-2s-2 0.897-2 2v6.333c0 2.756-2.243 5-5 5h-0.959c-1.125 0-2.041 0.917-2.041 2.041v1.959c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.299-0.667-0.667v-1.959c0-1.861 1.515-3.375 3.375-3.375h0.959c2.023 0 3.667-1.644 3.667-3.667v-6.333c0-1.839 1.496-3.333 3.333-3.333s3.333 1.495 3.333 3.333v6.333c0 2.023 1.643 3.667 3.667 3.667h0.959c1.861 0 3.375 1.515 3.375 3.375v1.959c0 0.368-0.3 0.667-0.667 0.667z',
      ),
      'Paint-Bucket' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26 12.013c-0.367 0-0.667-0.299-0.667-0.667 0-5.132-4.175-9.305-9.307-9.305s-9.307 4.176-9.307 9.305c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.299-0.667-0.667c0-5.864 4.773-10.639 10.64-10.639s10.64 4.773 10.64 10.639c0 0.368-0.3 0.667-0.667 0.667zM16.172 13.959c-4.939 0-8.769-0.629-10.508-1.725-0.311-0.195-0.405-0.608-0.208-0.917 0.196-0.309 0.608-0.409 0.919-0.208 0.565 0.357 2.944 1.52 9.797 1.52 6.509 0 8.781-1.055 9.456-1.509 0.305-0.201 0.719-0.127 0.925 0.184 0.204 0.305 0.124 0.717-0.181 0.923-1.664 1.117-5.287 1.733-10.2 1.733zM16.161 31.292c-6.627 0-9.424-1.076-10.501-1.716-0.203-0.12-0.327-0.337-0.327-0.573l0.019-18.384c0.001-0.227 0.119-0.436 0.311-0.557 1.737-1.096 5.568-1.725 10.509-1.725 4.919 0 8.541 0.617 10.2 1.737 0.184 0.125 0.295 0.331 0.295 0.552v18.377c0 0.236-0.124 0.453-0.327 0.573-1.919 1.139-5.341 1.716-10.179 1.716zM6.667 28.604c1.055 0.511 3.68 1.355 9.495 1.355 5.243 0 7.864-0.695 9.172-1.352v-17.604c-0.947-0.504-3.384-1.333-9.161-1.333-5.988 0-8.559 0.887-9.491 1.349l-0.015 1.652v15.933zM16.172 25.959c-2.369 0-4.48-0.141-6.276-0.425-0.324-0.055-0.563-0.333-0.563-0.661v-8c0-0.195 0.085-0.38 0.233-0.507 0.148-0.129 0.345-0.181 0.537-0.152 1.727 0.273 3.768 0.413 6.068 0.413 1.605 0 3.053-0.069 4.427-0.208 0.189-0.025 0.375 0.039 0.515 0.168 0.139 0.125 0.22 0.304 0.22 0.495v8c0 0.341-0.257 0.628-0.599 0.66-1.42 0.145-2.912 0.217-4.563 0.217zM10.667 24.296c1.603 0.219 3.451 0.329 5.505 0.329 1.373 0 2.633-0.051 3.828-0.153v-6.66c-1.197 0.097-2.461 0.147-3.828 0.147-2.037 0-3.885-0.107-5.505-0.315v6.652z',
      ),
      'Paintbrush' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 7.333c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM16 4.667c-0.368 0-0.667 0.3-0.667 0.667s0.299 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667zM30 24h-28c-0.368 0-0.667-0.3-0.667-0.667v-4.5c0-2.508 1.788-2.795 3.365-3.049 2.659-0.427 5.968-0.959 5.968-10.784 0-2.757 2.243-5 5-5h0.667c2.757 0 5 2.243 5 5 0 9.825 3.307 10.357 5.969 10.784 1.576 0.253 3.364 0.541 3.364 3.049v4.5c0 0.367-0.3 0.667-0.667 0.667zM2.667 22.667h26.667v-3.833c0-1.307-0.539-1.459-2.245-1.732-2.821-0.455-7.088-1.14-7.088-12.101 0-2.023-1.643-3.667-3.667-3.667h-0.667c-2.023 0-3.667 1.644-3.667 3.667 0 10.961-4.267 11.647-7.089 12.101-1.705 0.273-2.244 0.423-2.244 1.732v3.833zM30 32h-28c-0.368 0-0.667-0.3-0.667-0.667v-8c0-0.367 0.299-0.667 0.667-0.667h28c0.367 0 0.667 0.3 0.667 0.667v8c0 0.367-0.3 0.667-0.667 0.667zM2.667 30.667h26.667v-6.667h-26.667v6.667zM6 31.333c-0.368 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.299 0.667-0.667 0.667zM10 31.333c-0.368 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.299 0.667-0.667 0.667zM14 31.333c-0.368 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.299 0.667-0.667 0.667zM18 31.333c-0.367 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.3 0.667-0.667 0.667zM22 31.333c-0.367 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.3 0.667-0.667 0.667zM26 31.333c-0.367 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.3 0.667-0.667 0.667zM29.333 21.333h-26.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h26.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Palette' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M13.339 30.060v0c-0.541 0-1.083-0.031-1.608-0.096-0.189-0.024-0.36-0.128-0.468-0.284-0.109-0.156-0.144-0.355-0.097-0.539 0.107-0.424 0.157-0.787 0.157-1.136 0-2.573-2.093-4.667-4.667-4.667-0.937 0-1.841 0.276-2.615 0.803-0.161 0.109-0.361 0.14-0.549 0.091-0.188-0.052-0.343-0.18-0.427-0.357-2.441-5.127-0.809-12.048 3.968-16.824 3.248-3.249 7.481-5.111 11.617-5.111 3.195 0 6.101 1.145 8.181 3.224 2.411 2.412 3.529 5.811 3.155 9.576-0.372 3.713-2.161 7.347-5.040 10.224-3.241 3.236-7.473 5.096-11.608 5.096zM12.607 28.705c3.995 0.243 8.211-1.5 11.396-4.691 2.661-2.659 4.315-6.003 4.656-9.413 0.336-3.359-0.648-6.377-2.771-8.5-1.828-1.827-4.399-2.833-7.24-2.833-3.783 0-7.675 1.721-10.673 4.721-4.177 4.177-5.759 10.091-3.995 14.643 0.828-0.416 1.739-0.632 2.675-0.632 3.308 0 6 2.695 6 6 0.001 0.232-0.015 0.467-0.048 0.705zM11.989 22.005c-1.837 0-3.333-1.497-3.333-3.333 0-1.839 1.496-3.333 3.333-3.333s3.333 1.496 3.333 3.333c0 1.836-1.496 3.333-3.333 3.333zM11.989 16.672c-1.103 0-2 0.896-2 2 0 1.101 0.897 2 2 2s2-0.899 2-2c0-1.104-0.897-2-2-2zM11.989 11.337c-1.103 0-2-0.897-2-2s0.897-2 2-2c1.103 0 2 0.897 2 2s-0.897 2-2 2zM11.989 8.671c-0.368 0-0.667 0.3-0.667 0.667s0.299 0.667 0.667 0.667c0.368 0 0.667-0.3 0.667-0.667s-0.299-0.667-0.667-0.667zM17.323 8.671c-1.103 0-2-0.897-2-2s0.897-2 2-2c1.101 0 2 0.897 2 2s-0.899 2-2 2zM17.323 6.004c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667zM22.656 10.004c-1.103 0-2-0.897-2-2s0.897-2 2-2c1.101 0 2 0.897 2 2s-0.899 2-2 2zM22.656 7.337c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667zM25.323 15.337c-1.103 0-2-0.897-2-2s0.897-2 2-2c1.101 0 2 0.897 2 2s-0.899 2-2 2zM25.323 12.671c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667zM23.989 20.672c-1.103 0-2-0.899-2-2 0-1.104 0.897-2 2-2 1.101 0 2 0.896 2 2 0 1.101-0.899 2-2 2zM23.989 18.005c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667z',
      ),
      'Palm-Tree' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M30.309 29.84h-29.333c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h29.333c0.368 0 0.667 0.299 0.667 0.667s-0.297 0.667-0.667 0.667zM14.589 29.84c-0.368 0-0.667-0.299-0.667-0.667 0-5.459 4.437-14.325 7.333-17.221 0.26-0.26 0.684-0.26 0.943 0 0.26 0.26 0.26 0.683 0 0.943-2.677 2.679-6.943 11.215-6.943 16.279 0 0.368-0.297 0.667-0.667 0.667zM21.727 12.785c-0.275 0-0.531-0.171-0.628-0.444-0.336-0.948-1.227-2.212-2.721-2.916-1.483-0.7-3.275-0.701-5.172-0.007-0.345 0.127-0.729-0.052-0.856-0.396-0.127-0.347 0.052-0.729 0.397-0.856 2.833-1.036 4.935-0.547 6.2 0.051 1.584 0.745 2.859 2.12 3.408 3.676 0.123 0.348-0.057 0.729-0.407 0.852-0.073 0.028-0.145 0.040-0.221 0.040zM21.728 12.785c-0.043 0-0.087-0.004-0.132-0.013-0.361-0.076-0.595-0.424-0.524-0.785 0.197-0.985 0.084-2.528-0.839-3.901-0.915-1.361-2.449-2.28-4.437-2.655-0.361-0.072-0.6-0.417-0.531-0.78 0.068-0.361 0.419-0.6 0.779-0.529 2.965 0.564 4.516 2.064 5.296 3.224 0.976 1.453 1.364 3.287 1.039 4.905-0.061 0.316-0.34 0.535-0.651 0.535zM21.727 12.785c-0.161 0-0.324-0.059-0.452-0.176-0.271-0.251-0.288-0.672-0.039-0.943 0.681-0.74 1.381-2.117 1.305-3.765-0.076-1.639-0.912-3.221-2.417-4.577-0.273-0.249-0.295-0.668-0.049-0.941 0.248-0.275 0.669-0.3 0.943-0.048 2.243 2.021 2.789 4.108 2.855 5.504 0.083 1.749-0.536 3.519-1.655 4.732-0.132 0.141-0.311 0.215-0.491 0.215zM24.119 22.377c-0.104 0-0.209-0.028-0.308-0.079-0.325-0.171-0.451-0.573-0.281-0.9 0.937-1.796 1.167-3.571 0.667-5.132-0.503-1.576-1.639-2.619-2.536-3.076-0.328-0.164-0.46-0.567-0.293-0.895 0.167-0.329 0.565-0.459 0.896-0.293 1.472 0.749 2.667 2.189 3.203 3.856 0.425 1.333 0.64 3.48-0.757 6.156-0.117 0.233-0.348 0.363-0.589 0.363zM28.487 19.98c-0.352 0-0.644-0.273-0.667-0.632-0.115-2.021-0.828-3.663-2.060-4.748-1.237-1.089-2.749-1.417-3.751-1.336-0.365 0.025-0.687-0.252-0.712-0.621-0.027-0.367 0.251-0.687 0.62-0.709 1.655-0.108 3.413 0.511 4.727 1.667 1.049 0.92 2.336 2.655 2.508 5.672 0.023 0.364-0.257 0.683-0.625 0.7-0.013 0.008-0.027 0.008-0.040 0.008zM31.024 15.624c-0.211 0-0.419-0.1-0.549-0.289-1.148-1.668-2.609-2.703-4.224-2.991-1.625-0.289-3.083 0.225-3.903 0.805-0.301 0.213-0.715 0.139-0.928-0.16-0.213-0.304-0.14-0.716 0.161-0.928 1.347-0.952 3.185-1.336 4.904-1.028 1.377 0.245 3.377 1.060 5.088 3.545 0.208 0.305 0.131 0.717-0.172 0.927-0.116 0.080-0.248 0.119-0.377 0.119z',
      ),
      'Panda' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M4.417 18.177v0c-1.129 0-1.637-0.472-1.865-0.867-0.489-0.86-0.203-2.14 0.909-4.055 1.643-2.823 3.503-4.251 5.528-4.251 3.388 0 5.805 4.080 5.905 4.251 0.088 0.151 0.115 0.335 0.071 0.507-0.047 0.173-0.159 0.316-0.313 0.409-0.292 0.157-7.047 4.005-10.235 4.005zM8.987 10.333c-1.515 0-2.985 1.207-4.373 3.589-1.18 2.028-0.96 2.621-0.904 2.716 0.076 0.133 0.333 0.203 0.709 0.203 2.128 0 6.709-2.265 8.944-3.489-0.724-1.005-2.408-3.019-4.376-3.019zM16.4 23.861v0c-2.891-0.003-4.917-3.781-5-3.943-0.139-0.26-0.087-0.584 0.123-0.789 0.861-0.853 3.691-0.94 4.864-0.94 1.827 0 4.117 0.183 4.669 1.060 0.135 0.199 0.139 0.456 0.028 0.669-1.376 2.609-2.953 3.943-4.684 3.943zM12.928 19.872c0.695 1.061 2.044 2.651 3.472 2.651v0c1.092 0 2.167-0.908 3.209-2.695-0.533-0.144-1.656-0.311-3.223-0.311-1.637 0.007-2.831 0.177-3.459 0.355zM16.4 26.272v0c-2.803 0-4.836-2.389-4.92-2.489-0.239-0.281-0.199-0.699 0.083-0.937 0.281-0.235 0.699-0.199 0.94 0.083 0.016 0.021 1.729 2.016 3.899 2.016 0.003 0 0.005 0 0.008 0 1.253-0.001 2.46-0.68 3.58-2.013 0.24-0.284 0.659-0.32 0.94-0.084s0.317 0.656 0.084 0.937c-1.393 1.651-2.943 2.488-4.613 2.488zM16.424 25.937c-0.367 0-0.667-0.3-0.667-0.667v-1.333c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v1.333c0 0.368-0.299 0.667-0.667 0.667zM16.283 31.361c-8.656 0-15.697-6.857-15.697-15.28 0-2.695 0.724-5.313 2.103-7.637-1.139-0.421-2.061-1.344-2.467-2.528-0.357-1.035-0.287-2.139 0.196-3.112 0.472-0.943 1.291-1.644 2.297-1.969 2.024-0.649 4.279 0.471 5.048 2.431 2.549-1.616 5.475-2.468 8.523-2.468 2.853 0 5.611 0.745 8.036 2.152 0.451-1 1.297-1.777 2.349-2.119 0.399-0.132 0.808-0.195 1.227-0.195 1.751 0 3.305 1.123 3.88 2.789 0.361 1.039 0.287 2.143-0.195 3.112-0.391 0.776-1.016 1.391-1.784 1.765 1.429 2.353 2.189 5.025 2.189 7.776-0.007 8.432-7.048 15.283-15.705 15.283zM3.941 1.972c-0.276 0-0.552 0.044-0.815 0.131-0.665 0.215-1.2 0.679-1.515 1.304-0.324 0.645-0.369 1.385-0.132 2.083 0.353 1.024 1.269 1.751 2.34 1.865 0.235 0.027 0.436 0.169 0.535 0.383 0.097 0.216 0.079 0.463-0.053 0.659-1.561 2.287-2.384 4.945-2.384 7.691 0 7.695 6.444 13.949 14.364 13.949 7.921 0 14.364-6.255 14.364-13.949 0-2.775-0.839-5.457-2.423-7.753-0.129-0.185-0.153-0.417-0.075-0.623 0.083-0.207 0.257-0.361 0.472-0.412l0.241-0.053c0.664-0.216 1.2-0.676 1.517-1.303 0.321-0.644 0.368-1.383 0.131-2.084-0.472-1.393-2.037-2.204-3.428-1.756-0.908 0.293-1.547 1.035-1.739 1.993-0.037 0.216-0.195 0.403-0.396 0.487-0.199 0.085-0.443 0.063-0.625-0.057-2.377-1.565-5.159-2.391-8.044-2.391-3.087 0-6.044 0.953-8.547 2.753-0.191 0.139-0.44 0.164-0.653 0.072-0.216-0.093-0.365-0.296-0.397-0.527-0.021-0.191-0.064-0.384-0.124-0.573-0.385-1.125-1.437-1.888-2.615-1.888zM8.892 15.271c-1.101 0-2-0.899-2-2 0-1.103 0.899-2 2-2 1.104 0 2 0.897 2 2 0 1.101-0.893 2-2 2zM8.892 12.604c-0.364 0-0.667 0.3-0.667 0.667 0 0.368 0.303 0.667 0.667 0.667 0.367 0 0.667-0.299 0.667-0.667 0-0.367-0.299-0.667-0.667-0.667zM27.973 18.177c-3.192 0-9.943-3.848-10.227-4.011-0.156-0.085-0.268-0.235-0.315-0.408-0.044-0.171-0.021-0.355 0.071-0.507 0.099-0.176 2.516-4.252 5.904-4.252 2.028 0 3.88 1.428 5.528 4.252 1.112 1.909 1.401 3.196 0.912 4.053-0.237 0.395-0.745 0.872-1.873 0.872zM19.028 13.355c2.235 1.221 6.811 3.489 8.945 3.489 0.371 0 0.636-0.075 0.704-0.203 0.055-0.096 0.276-0.688-0.907-2.717-1.385-2.383-2.861-3.588-4.372-3.588-1.972-0.003-3.651 2.008-4.371 3.019zM23.497 15.271c-1.101 0-2-0.899-2-2 0-1.103 0.899-2 2-2 1.104 0 2 0.897 2 2 0 1.101-0.896 2-2 2zM23.497 12.604c-0.367 0-0.667 0.3-0.667 0.667 0 0.368 0.3 0.667 0.667 0.667s0.667-0.299 0.667-0.667c0-0.367-0.3-0.667-0.667-0.667z',
      ),
      'Panorama' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M31.333 23.333h-30.667c-0.368 0-0.667-0.3-0.667-0.667v-13.333c0-0.367 0.299-0.667 0.667-0.667h30.667c0.367 0 0.667 0.3 0.667 0.667v13.333c0 0.367-0.3 0.667-0.667 0.667zM1.333 22h29.333v-12h-29.333v12zM29.36 20.667c-0.008-0.001-0.017-0.001-0.027 0h-25.333c-0.265 0-0.504-0.156-0.611-0.4-0.107-0.245-0.059-0.528 0.121-0.719l4-4.333c0.171-0.191 0.432-0.256 0.676-0.192l3.616 1.056 3.72-3.799c0.233-0.243 0.607-0.269 0.873-0.071l4.711 3.495 2.305-4.336c0.109-0.207 0.323-0.344 0.56-0.355 0.245 0.024 0.461 0.108 0.588 0.307l5.251 8.18c0.133 0.123 0.216 0.297 0.216 0.492 0 0.375-0.299 0.675-0.667 0.675zM5.523 19.333h22.591l-4.059-6.327-2.133 4.015c-0.089 0.172-0.251 0.297-0.44 0.337-0.192 0.043-0.391 0-0.544-0.115l-4.867-3.612-3.593 3.668c-0.173 0.177-0.427 0.243-0.664 0.175l-3.604-1.052-2.687 2.911zM5.333 14.667c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM5.333 12c-0.368 0-0.667 0.3-0.667 0.667s0.299 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667z',
      ),
      'Pantheon' => 
      array (
        'height' => '32',
        'width' => '35',
        'path' => 'M2.667 11.625h1.333v13.333h-1.333v-13.333zM6.667 11.625h1.333v13.333h-1.333v-13.333zM10.667 11.625h1.333v13.333h-1.333v-13.333zM14.667 11.625h1.333v13.333h-1.333v-13.333zM18.667 11.625h1.333v13.333h-1.333v-13.333zM22.667 11.625h1.333v13.333h-1.333v-13.333zM26.667 11.625h1.333v13.333h-1.333v-13.333zM30.667 11.625h1.333v13.333h-1.333v-13.333zM33.333 28.959h-32v-4h32v4zM2.667 27.625h29.333v-1.333h-29.333v1.333zM34.667 31.625h-34.667v-4h34.667v4zM1.333 30.292h32v-1.333h-32v1.333zM32.645 11.625c-0.008 0-0.016 0-0.028 0h-30.572c-0.296 0-0.556-0.195-0.639-0.477-0.084-0.283 0.028-0.587 0.277-0.747l15.287-9.917c0.22-0.144 0.505-0.144 0.725 0l15.189 9.852c0.251 0.096 0.427 0.339 0.427 0.623 0 0.368-0.297 0.667-0.667 0.667zM4.299 10.292h26.068l-13.033-8.455-13.035 8.455z',
      ),
      'Pantone' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M13.061 32h-4c-2.573 0-4.667-2.091-4.667-4.667v-22.667c0-2.573 2.093-4.667 4.667-4.667h4c2.573 0 4.667 2.093 4.667 4.667v22.667c0.001 2.576-2.093 4.667-4.667 4.667zM9.061 1.333c-1.839 0-3.333 1.496-3.333 3.333v22.667c0 1.837 1.495 3.333 3.333 3.333h4c1.839 0 3.333-1.496 3.333-3.333v-22.667c0-1.837-1.495-3.333-3.333-3.333h-4zM14.049 31.872c-0.312 0-0.592-0.224-0.653-0.54-0.069-0.361 0.168-0.711 0.528-0.78l4.737-0.909c1.781-0.385 2.929-2.164 2.541-3.959l-4.792-21.581c-0.083-0.36 0.144-0.716 0.505-0.796 0.361-0.084 0.713 0.148 0.797 0.507l4.792 21.585c0.544 2.519-1.063 5.008-3.579 5.549l-4.752 0.912c-0.040 0.007-0.084 0.012-0.125 0.012zM20.063 30.444c-0.257 0-0.505-0.149-0.612-0.405-0.145-0.336 0.011-0.729 0.349-0.875l4.601-1.976c1.636-0.781 2.339-2.776 1.547-4.435l-9.816-19.381c-0.167-0.329-0.033-0.729 0.295-0.896 0.329-0.165 0.732-0.035 0.896 0.293l9.823 19.393c1.115 2.333 0.131 5.125-2.195 6.235l-4.628 1.989c-0.083 0.040-0.172 0.057-0.26 0.057zM14.395 28h-6.667c-0.367 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.3-0.667 0.667-0.667h6.667c0.367 0 0.667 0.3 0.667 0.667v4c0 0.367-0.299 0.667-0.667 0.667zM8.395 26.667h5.333v-2.667h-5.333v2.667zM14.395 20h-6.667c-0.367 0-0.667-0.3-0.667-0.667v-4c0-0.368 0.3-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v4c0 0.367-0.299 0.667-0.667 0.667zM8.395 18.667h5.333v-2.667h-5.333v2.667zM14.395 12h-6.667c-0.367 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.3-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.299 0.667-0.667 0.667zM8.395 10.667h5.333v-2.667h-5.333v2.667zM11.061 5.959c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2c0 1.103-0.896 2-2 2zM11.061 3.292c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667c0-0.367-0.299-0.667-0.667-0.667z',
      ),
      'Pants' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M23.341 14.667h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM22.008 21.333c-0.309 0-0.588-0.219-0.653-0.536l-1.333-6.667c-0.071-0.361 0.164-0.712 0.524-0.784 0.367-0.072 0.712 0.164 0.784 0.524l1.333 6.667c0.073 0.361-0.161 0.711-0.523 0.784-0.045 0.009-0.088 0.012-0.132 0.012zM24.675 21.333h-2.667c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM23.341 17.333h-1.333c-0.367 0-0.667-0.3-0.667-0.667 0-0.368 0.3-0.667 0.667-0.667h1.333c0.368 0 0.667 0.299 0.667 0.667 0 0.367-0.299 0.667-0.667 0.667zM11.341 14.667h-2.667c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM10.008 21.333c-0.043 0-0.087-0.003-0.132-0.012-0.361-0.075-0.595-0.423-0.523-0.784l1.333-6.667c0.072-0.361 0.417-0.595 0.784-0.524 0.361 0.072 0.595 0.423 0.523 0.784l-1.333 6.667c-0.061 0.317-0.34 0.536-0.652 0.536zM10.008 21.333h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM10.008 17.333h-1.333c-0.368 0-0.667-0.3-0.667-0.667 0-0.368 0.299-0.667 0.667-0.667h1.333c0.368 0 0.667 0.299 0.667 0.667 0 0.367-0.299 0.667-0.667 0.667zM25.995 32c-0.009 0-0.019 0-0.028 0h-6.667c-0.328 0-0.608-0.24-0.659-0.564l-2.653-16.984-2.655 16.984c-0.051 0.324-0.329 0.564-0.659 0.564h-6.667c-0.191 0-0.373-0.084-0.5-0.224-0.127-0.143-0.185-0.333-0.163-0.524l3.777-30.667c0.043-0.333 0.325-0.585 0.661-0.585h12.403c0.337 0 0.621 0.251 0.661 0.585l3.755 30.485c0.035 0.081 0.055 0.169 0.055 0.263 0.004 0.367-0.296 0.667-0.663 0.667zM19.869 30.667h5.343l-3.613-29.333h-11.224l-3.613 29.333h5.343l3.208-20.533-0.005-0.031c-0.029-0.192 0.025-0.388 0.152-0.536 0.253-0.296 0.78-0.296 1.033 0 0.127 0.148 0.203 0.344 0.173 0.536l-0.004 0.031 3.208 20.533zM16.008 11.333c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v4c0 0.368-0.299 0.667-0.667 0.667zM22.008 7.333c-1.836 0-3.333-1.496-3.333-3.333 0-0.368 0.3-0.667 0.667-0.667 0.368 0 0.667 0.299 0.667 0.667 0 1.103 0.899 2 2 2 0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM10.008 7.333c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667c1.103 0 2-0.897 2-2 0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667c0 1.837-1.496 3.333-3.333 3.333z',
      ),
      'Paper-Plane' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.724 27.461c-0.167 0-0.329-0.065-0.453-0.18l-6.196-5.708c-0.271-0.251-0.288-0.673-0.036-0.943 0.249-0.267 0.672-0.289 0.94-0.036l5.615 5.173 12.505-19.365-26.375 8.357 4.355 3.473c0.291 0.229 0.337 0.648 0.105 0.936-0.228 0.291-0.648 0.335-0.935 0.105l-5.331-4.255c-0.195-0.151-0.287-0.401-0.241-0.639 0.044-0.243 0.219-0.44 0.453-0.515l29.333-9.297c0.271-0.083 0.56 0.011 0.735 0.232 0.172 0.224 0.183 0.528 0.028 0.765l-13.94 21.589c-0.107 0.165-0.281 0.275-0.473 0.3-0.035 0.003-0.061 0.005-0.089 0.005zM6.621 26.009c-0.079 0-0.156-0.013-0.233-0.039-0.26-0.097-0.433-0.349-0.433-0.628v-6.635c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v4.844l2.7-3.125c0.243-0.28 0.664-0.307 0.94-0.068 0.279 0.241 0.307 0.661 0.069 0.94l-3.872 4.476c-0.128 0.153-0.313 0.235-0.504 0.235zM10.495 21.529c-0.197 0-0.396-0.088-0.528-0.257-0.227-0.291-0.173-0.709 0.12-0.935l12.985-10.084-16.091 9.080c-0.32 0.18-0.727 0.068-0.911-0.251-0.181-0.321-0.068-0.728 0.251-0.912l24.012-13.545c0.305-0.172 0.688-0.080 0.88 0.211 0.195 0.292 0.133 0.683-0.143 0.896l-20.171 15.657c-0.119 0.095-0.263 0.14-0.405 0.14z',
      ),
      'Paper' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M27.333 32h-22.667c-0.368 0-0.667-0.3-0.667-0.667v-24.695c0-0.164 0.060-0.321 0.169-0.444l5.333-5.972c0.127-0.141 0.307-0.223 0.497-0.223h17.333c0.367 0 0.667 0.299 0.667 0.667v30.667c0 0.367-0.3 0.667-0.667 0.667zM5.333 30.667h21.333v-29.333h-16.368l-4.965 5.559v23.775zM10 8h-4.667c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h4v-5.333c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6c0 0.368-0.299 0.667-0.667 0.667z',
      ),
      'Parasailing' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M25.708 23.995c-0.131 0-0.259-0.036-0.373-0.115-0.248-0.169-0.353-0.479-0.257-0.765 0.731-2.183 0.187-4.533-1.421-6.141-1.133-1.137-2.639-1.756-4.243-1.756s-3.109 0.625-4.244 1.756c-0.259 0.259-0.683 0.259-0.941 0-0.132-0.132-0.195-0.304-0.195-0.472 0-0.172 0.065-0.341 0.195-0.472 2.339-2.34 2.339-6.143 0-8.484-1.587-1.585-4.007-2.14-6.145-1.42-0.283 0.091-0.596-0.012-0.765-0.259-0.167-0.248-0.149-0.577 0.044-0.804 0.236-0.279 0.479-0.555 0.74-0.815 2.472-2.472 5.771-3.833 9.287-3.833 3.571 0 6.932 1.396 9.471 3.932 2.517 2.519 3.915 5.856 3.933 9.396 0.020 3.544-1.343 6.867-3.833 9.361-0.261 0.261-0.539 0.504-0.817 0.741-0.125 0.095-0.28 0.149-0.433 0.149zM19.413 13.88c1.959 0 3.8 0.761 5.185 2.147 1.441 1.44 2.187 3.368 2.131 5.347 1.784-2.132 2.747-4.804 2.731-7.632-0.020-3.189-1.277-6.195-3.545-8.461-2.284-2.285-5.312-3.543-8.528-3.543-2.805 0-5.457 0.967-7.571 2.735 2.028-0.079 3.932 0.703 5.352 2.128 2.088 2.084 2.651 5.132 1.692 7.735 0.805-0.3 1.668-0.455 2.553-0.455zM10.541 26.919h-4c-0.367 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.3-0.667 0.667-0.667h4c0.368 0 0.667 0.3 0.667 0.667v4c0 0.368-0.297 0.667-0.667 0.667zM7.208 25.585h2.667v-2.667h-2.667v2.667zM6.541 22.919c-0.017 0-0.033-0.001-0.053-0.003-0.365-0.028-0.639-0.352-0.612-0.716l1.328-16.764c0.029-0.368 0.349-0.641 0.717-0.612 0.368 0.028 0.641 0.351 0.612 0.716l-1.328 16.765c-0.025 0.349-0.319 0.613-0.664 0.613zM10.541 26.919c-0.312 0-0.591-0.221-0.653-0.539-0.071-0.361 0.167-0.711 0.528-0.781l15.167-2.924c0.361-0.065 0.711 0.165 0.78 0.528 0.071 0.361-0.167 0.711-0.528 0.781l-15.167 2.925c-0.043 0.007-0.084 0.009-0.127 0.009zM1.875 31.585c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.257-0.26-0.683 0-0.943l4.667-4.667c0.259-0.257 0.683-0.257 0.943 0 0.259 0.26 0.259 0.685 0 0.943l-4.667 4.667c-0.129 0.131-0.3 0.195-0.471 0.195zM10.541 22.919c-0.136 0-0.272-0.039-0.389-0.128-0.299-0.216-0.364-0.635-0.148-0.929l4.155-5.752c0.215-0.3 0.632-0.368 0.931-0.149 0.299 0.216 0.365 0.635 0.149 0.932l-4.156 5.751c-0.129 0.18-0.333 0.276-0.541 0.276z',
      ),
      'Parrot' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M17.992 4.417c-0.175 0-0.349-0.068-0.481-0.189-0.12-0.135-0.185-0.293-0.185-0.477 0-0.175 0.065-0.349 0.185-0.469 0.255-0.252 0.708-0.252 0.948 0 0.12 0.12 0.2 0.295 0.2 0.469 0 0.188-0.084 0.361-0.2 0.477-0.12 0.119-0.295 0.189-0.467 0.189zM22.527 31.281c-0.039 0-0.081-0.003-0.12-0.011-0.328-0.060-0.563-0.355-0.547-0.688l0.547-12.792-2.487-0.268c-0.305-0.031-0.547-0.265-0.588-0.568l-1.44-10.069c-0.049 0-0.104 0-0.159 0-1.215 0-2.132-0.377-2.651-1.095-0.549-0.756-0.608-1.824-0.168-3.165 0.128-0.615 0.807-1.907 2.337-1.907 1.528 0 3.435 1.279 5.833 3.915 6.295 6.909 0.333 25.4 0.079 26.187-0.096 0.279-0.355 0.461-0.637 0.461zM20.576 16.253l2.596 0.279c0.349 0.035 0.609 0.337 0.593 0.692l-0.305 7.107c1.26-5.984 2.281-14.793-1.361-18.799-2.757-3.028-4.224-3.477-4.852-3.477-0.847 0-1.043 0.881-1.051 0.917-0.225 0.695-0.395 1.549-0.039 2.036 0.344 0.473 1.133 0.545 1.571 0.545 0.344 0 0.596-0.037 0.617-0.045 0.172-0.028 0.36 0.012 0.505 0.119 0.145 0.105 0.243 0.265 0.268 0.444l1.457 10.183zM14.323 8.696c-0.181 0-0.36-0.077-0.488-0.213-0.196-0.211-1.916-2.112-1.791-3.967 0.048-0.725 0.383-1.36 0.965-1.837 1.355-1.107 2.345-1.336 2.453-1.36 0.361-0.077 0.713 0.156 0.791 0.517 0.075 0.361-0.155 0.709-0.512 0.787-0.024 0.005-0.8 0.196-1.888 1.087-0.303 0.249-0.455 0.532-0.479 0.896-0.032 0.481 0.16 1.028 0.421 1.528 0.136-0.608 0.38-1.144 0.819-1.389 0.229-0.128 0.7-0.279 1.3 0.119 0.305 0.201 0.389 0.619 0.185 0.923-0.195 0.289-0.575 0.38-0.875 0.216-0.151 0.341-0.26 1.224-0.236 2.003 0.008 0.279-0.156 0.531-0.415 0.639-0.080 0.037-0.167 0.053-0.252 0.053zM1.379 24.615c-0.233 0-0.463-0.125-0.584-0.344-0.179-0.323-0.063-0.727 0.259-0.909 0.131-0.073 13.313-7.275 29.697-4.185 0.361 0.068 0.599 0.417 0.528 0.779-0.068 0.361-0.417 0.599-0.779 0.531-15.887-3-28.675 3.972-28.804 4.036-0.096 0.064-0.207 0.093-0.317 0.093zM22.656 14.972c-0.309 0-0.588-0.213-0.653-0.528l-1.109-5.333c-0.079-0.361 0.156-0.713 0.516-0.789 0.361-0.076 0.713 0.157 0.789 0.519l1.109 5.333c0.079 0.361-0.153 0.713-0.516 0.789-0.047 0.009-0.092 0.009-0.136 0.009z',
      ),
      'Password-2shopping' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28 31.417h-24c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h24c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM4 31.417c-2.205 0-4-1.795-4-4 0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667c0 1.472 1.196 2.667 2.667 2.667 0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM28 31.417c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667c1.472 0 2.667-1.195 2.667-2.667 0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667c0 2.205-1.795 4-4 4zM31.333 28.084c-0.367 0-0.667-0.3-0.667-0.667v-9.333c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v9.333c0 0.367-0.3 0.667-0.667 0.667zM31.333 18.751c-0.367 0-0.667-0.3-0.667-0.667 0-1.472-1.195-2.667-2.667-2.667-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667c2.205 0 4 1.795 4 4 0 0.367-0.3 0.667-0.667 0.667zM28 15.417h-26.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h26.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM1.333 15.417c-0.368 0-0.667-0.3-0.667-0.667 0-7.547 7.243-14.167 15.5-14.167 0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667c-7.415 0-14.167 6.116-14.167 12.833 0 0.367-0.299 0.667-0.667 0.667zM30.569 12.021c-0.296 0-0.567-0.199-0.644-0.5-1.368-5.297-7.54-9.604-13.757-9.604-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667c6.901 0 13.511 4.657 15.049 10.604 0.091 0.357-0.123 0.72-0.479 0.809-0.057 0.017-0.113 0.024-0.169 0.024zM0.667 28.084c-0.368 0-0.667-0.3-0.667-0.667v-9.333c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v9.333c0 0.367-0.299 0.667-0.667 0.667zM14.667 27.417c-2.573 0-4.667-2.093-4.667-4.667s2.093-4.667 4.667-4.667c2.573 0 4.667 2.093 4.667 4.667s-2.093 4.667-4.667 4.667zM14.667 19.417c-1.837 0-3.333 1.495-3.333 3.333s1.496 3.333 3.333 3.333 3.333-1.495 3.333-3.333-1.496-3.333-3.333-3.333z',
      ),
      'Password-Field' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M9.333 20.667h-5.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM4.781 17.219c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.257-0.26-0.683 0-0.943l3.771-3.769c0.26-0.26 0.683-0.26 0.943 0 0.26 0.257 0.26 0.683 0 0.943l-3.771 3.768c-0.129 0.131-0.3 0.196-0.471 0.196zM8.552 17.219c-0.171 0-0.341-0.065-0.472-0.195l-3.771-3.769c-0.26-0.26-0.26-0.685 0-0.943 0.26-0.26 0.683-0.26 0.943 0l3.771 3.768c0.26 0.26 0.26 0.685 0 0.943-0.129 0.131-0.3 0.196-0.471 0.196zM17.333 20.667h-5.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM12.781 17.219c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.257-0.26-0.683 0-0.943l3.771-3.768c0.26-0.26 0.683-0.26 0.944 0 0.259 0.257 0.259 0.683 0 0.943l-3.772 3.768c-0.129 0.129-0.3 0.195-0.471 0.195zM16.552 17.219c-0.171 0-0.341-0.065-0.472-0.195l-3.771-3.769c-0.26-0.26-0.26-0.685 0-0.943 0.26-0.26 0.683-0.26 0.943 0l3.772 3.768c0.259 0.26 0.259 0.685 0 0.943-0.131 0.131-0.301 0.196-0.472 0.196zM25.333 20.667h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM31.333 23.333h-30.667c-0.368 0-0.667-0.3-0.667-0.667v-13.333c0-0.367 0.299-0.667 0.667-0.667h30.667c0.367 0 0.667 0.3 0.667 0.667v13.333c0 0.367-0.3 0.667-0.667 0.667zM1.333 22h29.333v-12h-29.333v12z',
      ),
      'Password-shopping' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M7.333 22.667c-3.676 0-6.667-2.991-6.667-6.667s2.991-6.667 6.667-6.667 6.667 2.991 6.667 6.667-2.991 6.667-6.667 6.667zM7.333 10.667c-2.941 0-5.333 2.392-5.333 5.333s2.392 5.333 5.333 5.333 5.333-2.392 5.333-5.333-2.392-5.333-5.333-5.333zM30.667 16.667h-17.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h17.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM28.667 21.333c-0.367 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v4c0 0.367-0.3 0.667-0.667 0.667zM24.667 20c-0.367 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.667c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Password' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M10.333 16.667c-1.837 0-3.333-1.495-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.495 3.333 3.333-1.496 3.333-3.333 3.333zM10.333 11.333c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM5 19.333c-1.837 0-3.333-1.495-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.495 3.333 3.333-1.496 3.333-3.333 3.333zM5 14c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM10.333 22c-1.837 0-3.333-1.495-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.495 3.333 3.333-1.496 3.333-3.333 3.333zM10.333 16.667c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM29.667 16.667h-17.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h17.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM27.667 20c-0.367 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.667c0 0.367-0.3 0.667-0.667 0.667zM25 18.667c-0.367 0-0.667-0.3-0.667-0.667v-1.333c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v1.333c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Pause-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M11.333 31.333c-0.368 0-0.667-0.3-0.667-0.667v-29.333c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v29.333c0 0.367-0.299 0.667-0.667 0.667zM20.667 31.333c-0.367 0-0.667-0.3-0.667-0.667v-29.333c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v29.333c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Pause' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M11.333 30.667h-9.333c-0.368 0-0.667-0.3-0.667-0.667v-28c0-0.367 0.299-0.667 0.667-0.667h9.333c0.368 0 0.667 0.3 0.667 0.667v28c0 0.367-0.299 0.667-0.667 0.667zM2.667 29.333h8v-26.667h-8v26.667zM30 30.667h-9.333c-0.367 0-0.667-0.3-0.667-0.667v-28c0-0.367 0.3-0.667 0.667-0.667h9.333c0.367 0 0.667 0.3 0.667 0.667v28c0 0.367-0.3 0.667-0.667 0.667zM21.333 29.333h8v-26.667h-8v26.667z',
      ),
      'Paw' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M22.18 30.331c-0.835 0-1.747-0.065-2.711-0.133-2.221-0.153-4.716-0.153-6.937 0-0.965 0.068-1.873 0.133-2.708 0.133-1.16 0-2.631-0.107-3.68-0.945-0.992-0.792-1.473-2.104-1.473-4.011 0-5.979 4.849-12.667 11.333-12.667 6.487 0 11.333 6.688 11.333 12.667-0.004 4.368-2.609 4.956-5.157 4.956zM16 28.708c1.255 0 2.479 0.084 3.563 0.161 0.94 0.065 1.829 0.128 2.617 0.128 2.533 0 3.82-0.56 3.82-3.623 0-5.352-4.276-11.333-10-11.333s-10 5.983-10 11.333c0 1.472 0.317 2.445 0.973 2.969 0.565 0.453 1.445 0.653 2.847 0.653 0.788 0 1.677-0.063 2.617-0.128 1.084-0.075 2.308-0.161 3.563-0.161zM5.524 16.637c-1.577 0-3.219-1.095-4.084-2.733-0.633-1.193-0.771-2.496-0.38-3.575 0.3-0.819 0.884-1.444 1.655-1.76 1.761-0.725 4.18 0.435 5.276 2.505 0.632 1.195 0.769 2.496 0.379 3.575-0.297 0.819-0.881 1.445-1.651 1.76-0.373 0.152-0.776 0.228-1.195 0.228zM3.907 9.673c-0.245 0-0.473 0.043-0.687 0.131-0.535 0.221-0.789 0.653-0.908 0.979-0.259 0.717-0.144 1.651 0.305 2.497 0.776 1.467 2.459 2.364 3.593 1.895 0.533-0.219 0.788-0.653 0.905-0.977 0.259-0.713 0.144-1.647-0.305-2.497-0.631-1.195-1.827-2.027-2.904-2.027zM12.964 12.496c-1.857 0-3.505-1.984-3.919-4.719-0.46-2.993 0.739-5.653 2.724-6.057 1.98-0.399 3.972 1.684 4.428 4.667 0.459 2.991-0.743 5.652-2.727 6.059-0.168 0.033-0.337 0.051-0.507 0.051zM12.276 3.001c-0.081 0-0.163 0.008-0.245 0.027-1.245 0.251-2.009 2.336-1.671 4.549 0.367 2.423 1.755 3.796 2.843 3.56 1.247-0.251 2.013-2.339 1.676-4.549-0.343-2.245-1.592-3.587-2.603-3.587zM26.479 16.637v0c-0.421 0-0.824-0.079-1.196-0.232-0.767-0.315-1.356-0.939-1.652-1.753-0.391-1.081-0.251-2.381 0.379-3.577 1.099-2.071 3.509-3.232 5.279-2.505 0.769 0.315 1.359 0.94 1.653 1.759 0.389 1.083 0.251 2.383-0.381 3.579-0.865 1.633-2.505 2.731-4.081 2.731zM28.093 9.673c-1.083 0-2.273 0.832-2.907 2.028-0.448 0.848-0.565 1.781-0.305 2.496 0.119 0.324 0.368 0.756 0.905 0.975 0.212 0.087 0.444 0.135 0.693 0.135v0c1.079 0 2.271-0.832 2.903-2.028 0.451-0.848 0.564-1.781 0.305-2.497-0.121-0.325-0.372-0.757-0.909-0.976-0.208-0.088-0.44-0.132-0.685-0.132zM20.369 12.496v0c-0.169 0-0.339-0.017-0.508-0.051-1.984-0.407-3.185-3.068-2.727-6.059 0.456-2.984 2.451-5.068 4.428-4.667 1.984 0.405 3.184 3.065 2.727 6.057-0.415 2.733-2.064 4.719-3.92 4.719zM21.057 3.001c-1.011 0-2.26 1.341-2.603 3.584-0.337 2.212 0.429 4.3 1.676 4.552 1.093 0.235 2.473-1.139 2.847-3.563 0.336-2.211-0.428-4.297-1.675-4.549-0.083-0.016-0.164-0.024-0.245-0.024z',
      ),
      'Pawn' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M27.333 32h-22.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h22.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM24.667 29.333h-17.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h17.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM16 12c-3.308 0-6-2.691-6-6 0-3.308 2.692-6 6-6 3.307 0 6 2.692 6 6 0 3.309-2.693 6-6 6zM16 1.333c-2.573 0-4.667 2.093-4.667 4.667s2.093 4.667 4.667 4.667c2.573 0 4.667-2.093 4.667-4.667s-2.093-4.667-4.667-4.667zM22.667 16h-13.333c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h13.333c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.3 0.667-0.667 0.667zM10 14.667h12v-2.667h-12v2.667zM21.36 29.333c-0.008 0-0.017 0-0.027 0h-10.667c-0.2 0-0.389-0.088-0.516-0.245-0.127-0.153-0.177-0.357-0.139-0.552l2.667-13.333c0.063-0.312 0.336-0.536 0.653-0.536h5.333c0.316 0 0.589 0.224 0.653 0.536l2.632 13.157c0.048 0.091 0.076 0.195 0.076 0.305 0 0.368-0.299 0.668-0.667 0.668zM11.48 28h9.041l-2.401-12h-4.241l-2.399 12z',
      ),
      'Paypal' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M9.865 26.481h-4.824c-0.499 0-1.211-0.060-1.641-0.577-0.496-0.593-0.344-1.427-0.196-2.232 0.245-1.349 2.773-17.145 3.22-20.28 0.443-3.12 2.673-3.12 3.513-3.12v0c0.14 0 5.052-0.088 8.981-0.088 2.7 0 4.868 0.885 6.104 2.493 1.373 1.787 1.621 4.381 0.735 7.712-1.303 4.889-5.073 7.368-11.207 7.368l-1.051-0.008c-1.507 0-1.595 0.605-1.696 1.305l-0.031 0.196c-0.119 0.716-1.252 6.691-1.252 6.691-0.061 0.312-0.336 0.54-0.656 0.54zM4.423 25.051c0 0 0.112 0.097 0.617 0.097h4.272c0.281-1.484 1.047-5.536 1.143-6.119l0.027-0.167c0.107-0.732 0.353-2.448 3.016-2.448l1.051 0.008c2.032 0 8.221 0 9.917-6.379 0.775-2.909 0.607-5.115-0.501-6.556-1.317-1.716-3.728-1.972-5.047-1.972-3.924 0-8.831 0.088-8.831 0.088-0.007 0-0.148 0-0.152 0-0.807 0-1.915 0-2.195 1.973-0.448 3.144-2.983 18.981-3.228 20.333-0.049 0.275-0.181 1.004-0.089 1.14v0zM12.532 31.815h-4.824c-0.499 0-1.211-0.060-1.641-0.577-0.496-0.593-0.344-1.427-0.196-2.232 0.059-0.329 0.263-1.572 0.543-3.299 0.059-0.363 0.4-0.612 0.765-0.552 0.363 0.059 0.611 0.403 0.552 0.765-0.283 1.739-0.489 2.991-0.549 3.321-0.051 0.275-0.183 1.003-0.089 1.139v0c0 0 0.112 0.097 0.617 0.097h4.272c0.281-1.484 1.047-5.536 1.143-6.119l0.027-0.167c0.107-0.732 0.353-2.448 3.016-2.448l0.429 0.003c2.644 0.035 8.815 0.101 10.536-6.373 1.028-3.856 0.405-6.447-1.851-7.701-0.321-0.18-0.437-0.585-0.259-0.908 0.18-0.319 0.584-0.439 0.908-0.257 1.964 1.092 3.991 3.579 2.491 9.209-1.989 7.475-9.14 7.389-11.843 7.364l-0.415-0.003c-1.507 0-1.595 0.605-1.696 1.305l-0.028 0.195c-0.119 0.716-1.252 6.691-1.252 6.691-0.061 0.319-0.336 0.547-0.656 0.547z',
      ),
      'Pen-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M2.489 30.176c-0.173 0-0.344-0.067-0.472-0.195-0.205-0.204-0.252-0.521-0.12-0.779l4.107-7.876c0.028-0.061 0.072-0.116 0.12-0.164l15.584-15.585c0.26-0.26 0.683-0.26 0.943 0l3.771 3.771c0.26 0.26 0.26 0.683 0 0.943l-15.583 15.583c-0.048 0.048-0.103 0.088-0.164 0.121l-7.876 4.107c-0.099 0.049-0.204 0.075-0.309 0.075zM7.14 22.029l-3.081 5.911 5.909-3.081 15.039-15.040-2.828-2.828-15.039 15.039zM26.421 10.291l-0.943-0.943 2.399-2.396c1.063-1.064 1.292-2.561 0.511-3.343-0.781-0.78-2.279-0.551-3.341 0.513l-2.396 2.397-0.943-0.943 2.396-2.397c1.583-1.584 3.925-1.813 5.227-0.513 1.303 1.303 1.073 3.644-0.511 5.227l-2.399 2.397zM8.266 19.961l3.772 3.772-0.944 0.944-3.772-3.772 0.944-0.944z',
      ),
      'Pen-3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M2.492 30.175c-0.172 0-0.343-0.067-0.472-0.195-0.205-0.204-0.255-0.521-0.12-0.779l4.107-7.876c0.031-0.061 0.072-0.116 0.12-0.164l15.669-15.671c0.251-0.251 0.695-0.251 0.943 0l3.771 3.769c0.259 0.26 0.259 0.684 0 0.943l-15.669 15.669c-0.048 0.048-0.103 0.088-0.164 0.121l-7.877 4.107c-0.095 0.049-0.201 0.075-0.307 0.075zM7.143 22.028l-3.080 5.908 5.908-3.080 15.125-15.125-2.828-2.828-15.125 15.125zM26.511 10.203l-0.943-0.943 2.309-2.307c1.063-1.063 1.292-2.563 0.513-3.341-0.78-0.78-2.279-0.551-3.341 0.512l-2.309 2.308-0.943-0.943 2.309-2.308c1.58-1.584 3.924-1.813 5.227-0.512 1.3 1.3 1.069 3.643-0.513 5.227l-2.309 2.307zM8.597 19.633l3.771 3.771-0.943 0.943-3.771-3.771 0.943-0.943zM20.234 8.589l3.772 3.771-0.943 0.943-3.772-3.771 0.943-0.943z',
      ),
      'Pen-4' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M1.54 31.107c-0.175 0-0.345-0.071-0.472-0.195-0.163-0.161-0.229-0.396-0.179-0.62l2.221-9.763c0.028-0.121 0.088-0.235 0.179-0.323l17.979-17.983c1.535-1.531 3.987-1.787 5.244-0.528l3.772 3.772c0.543 0.543 0.843 1.303 0.843 2.139 0 1.101-0.5 2.232-1.372 3.103l-17.98 17.98c-0.088 0.089-0.201 0.149-0.324 0.179l-9.763 2.221c-0.048 0.012-0.097 0.017-0.148 0.017zM4.369 21.013l-1.944 8.54 8.543-1.943 17.844-17.844c0.615-0.613 0.981-1.419 0.981-2.16 0-0.34-0.080-0.823-0.452-1.195l-3.772-3.773c-0.373-0.373-0.859-0.452-1.196-0.452-0.739 0-1.547 0.367-2.161 0.98l-17.843 17.847zM20.354 4.965l6.658 6.658-0.944 0.944-6.658-6.658 0.944-0.944zM11.888 28.303c-4.067 0-8.208-4.143-8.208-8.208h1.333c0 3.341 3.532 6.875 6.875 6.875v1.333z',
      ),
      'Pen-5' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M1.54 31.107c-0.175 0-0.345-0.071-0.472-0.195-0.163-0.161-0.229-0.396-0.179-0.62l2.221-9.763c0.028-0.121 0.089-0.235 0.179-0.323l17.979-17.983c1.533-1.531 3.985-1.787 5.244-0.528l3.771 3.772c0.652 0.651 0.941 1.575 0.815 2.596-0.119 0.96-0.595 1.899-1.341 2.645l-17.98 17.98c-0.088 0.089-0.201 0.149-0.324 0.179l-9.764 2.221c-0.048 0.012-0.097 0.017-0.148 0.017zM4.369 21.013l-1.944 8.541 8.543-1.944 17.845-17.844c0.536-0.537 0.877-1.197 0.961-1.864 0.075-0.607-0.079-1.139-0.435-1.489l-3.771-3.773c-0.372-0.373-0.857-0.452-1.196-0.452-0.74 0-1.547 0.364-2.161 0.98l-17.843 17.845zM20.188 4.803l6.991 6.989-0.943 0.943-6.991-6.989 0.943-0.943zM17.361 7.629l6.991 6.989-0.943 0.944-6.991-6.989 0.943-0.944zM11.888 28.303c-4.067 0-8.209-4.143-8.209-8.208h1.333c0 3.341 3.535 6.875 6.876 6.875v1.333z',
      ),
      'Pen-6' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M10.936 15.61l5.493 5.495-0.943 0.943-5.493-5.495 0.943-0.943zM25.468 12.895c-0.171 0-0.341-0.065-0.472-0.195l-8.013-8.013-7.071 7.069c-0.26 0.26-0.683 0.26-0.943 0-0.26-0.259-0.26-0.683 0-0.943l7.541-7.54c0.26-0.26 0.683-0.26 0.943 0l8.484 8.483c0.26 0.26 0.26 0.684 0 0.943-0.128 0.131-0.299 0.196-0.469 0.196zM3.785 28.921c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.26-0.26-0.683 0-0.943l1.885-1.885c0.26-0.26 0.683-0.26 0.943 0s0.26 0.683 0 0.943l-1.885 1.885c-0.129 0.132-0.3 0.195-0.471 0.195zM8.499 27.979c-0.171 0-0.341-0.065-0.472-0.195l-3.771-3.771c-0.26-0.26-0.26-0.683 0-0.943l3.495-3.495c0.26-0.26 0.683-0.26 0.943 0s0.26 0.683 0 0.943l-3.024 3.027 2.828 2.828 3.025-3.027c0.26-0.26 0.683-0.26 0.943 0s0.26 0.683 0 0.943l-3.496 3.495c-0.129 0.132-0.301 0.195-0.471 0.195zM13.213 25.152c-0.177 0-0.347-0.072-0.472-0.195l-5.657-5.657c-0.26-0.259-0.26-0.683 0-0.943l14.613-14.613c0.228-0.228 0.515-0.348 0.827-0.348 0.728 0 1.367 0.647 1.879 1.168l4.015 4.013c0.24 0.236 0.467 0.459 0.467 0.823 0 0.367-0.227 0.588-0.467 0.824l-14.733 14.733c-0.125 0.125-0.295 0.195-0.471 0.195zM8.499 18.828l4.715 4.715 14.141-14.143-3.901-3.9c-0.217-0.221-0.727-0.739-0.94-0.771l-2.7 2.785-11.315 11.313z',
      ),
      'Pen' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M2.492 30.16c-0.172 0-0.344-0.067-0.472-0.195-0.205-0.208-0.253-0.525-0.12-0.781l4.107-7.88c0.029-0.060 0.073-0.115 0.121-0.164l17.979-17.979c1.528-1.529 3.967-1.772 5.225-0.512 1.301 1.3 1.071 3.644-0.512 5.227l-17.98 17.979c-0.047 0.047-0.101 0.087-0.161 0.12l-7.879 4.109c-0.099 0.052-0.203 0.076-0.308 0.076zM7.143 22.013l-3.083 5.912 5.911-3.084 17.909-17.907c1.061-1.061 1.291-2.56 0.512-3.34-0.377-0.38-0.863-0.459-1.204-0.459-0.741 0-1.52 0.353-2.136 0.971l-17.909 17.907zM11.003 23.811l-2.827-2.829 0.943-0.943 2.827 2.829-0.943 0.943zM12.417 12.692c-0.171 0-0.341-0.065-0.472-0.195-0.259-0.26-0.259-0.683 0-0.943l8.016-8.015c0.125-0.125 0.295-0.195 0.472-0.195v0c0.177 0 0.347 0.071 0.472 0.195l6.128 6.131c0.26 0.26 0.26 0.683 0 0.943-0.259 0.26-0.683 0.26-0.943 0l-5.656-5.659-7.548 7.543c-0.131 0.131-0.301 0.195-0.469 0.195z',
      ),
      'Pencil-Ruler' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24 32h-6.667c-0.367 0-0.667-0.3-0.667-0.667v-30.667c0-0.368 0.3-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v30.667c0 0.367-0.3 0.667-0.667 0.667zM18 30.667h5.333v-29.333h-5.333v29.333zM20.667 5.333h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM19.333 8h-1.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM20.667 10.667h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM19.333 13.333h-1.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM20.667 16h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM19.333 18.667h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM20.667 21.333h-2.667c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM19.333 24h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM20.667 26.667h-2.667c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM19.333 29.333h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM12.667 31.133c-0.297 0-0.555-0.195-0.639-0.473l-2-6.725c-0.020-0.065-0.028-0.129-0.028-0.195v-20.183c0-1.913 1.145-3.357 2.667-3.357s2.667 1.444 2.667 3.357v20.183c0 0.065-0.009 0.131-0.028 0.195l-2 6.725c-0.084 0.279-0.341 0.473-0.639 0.473zM11.333 23.643l1.333 4.481 1.333-4.481v-20.085c0-1.135-0.585-2.024-1.333-2.024s-1.333 0.889-1.333 2.024v20.085zM11.333 22.667h2.667v1.333h-2.667v-1.333zM8 16.667c-0.367 0-0.667-0.299-0.667-0.667v-8.667c0-0.368 0.3-0.667 0.667-0.667h7.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667h-6.667v8c0 0.368-0.3 0.667-0.667 0.667z',
      ),
      'Pencil' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M1.54 31.105c-0.175 0-0.345-0.069-0.472-0.195-0.163-0.161-0.229-0.397-0.179-0.621l2.223-9.761c0.028-0.123 0.089-0.235 0.179-0.323l17.98-17.98c1.531-1.532 3.984-1.787 5.243-0.528l3.771 3.773c0.651 0.649 0.94 1.573 0.815 2.595-0.12 0.96-0.596 1.899-1.344 2.644l-17.979 17.981c-0.088 0.088-0.201 0.149-0.324 0.177l-9.765 2.221c-0.048 0.009-0.097 0.016-0.147 0.016zM4.371 21.011l-1.944 8.543 8.543-1.944 17.845-17.844c0.536-0.537 0.877-1.2 0.961-1.867 0.076-0.607-0.079-1.135-0.432-1.488l-3.771-3.773c-0.372-0.375-0.857-0.452-1.195-0.452-0.74 0-1.547 0.365-2.161 0.979l-17.847 17.847zM26.029 12.575l-7.333-7.331 0.943-0.943 7.333 7.331-0.943 0.943zM23.391 15.567l-7.333-7.329 0.943-0.943 7.333 7.329-0.943 0.943zM11.889 28.303c-4.067 0-8.209-4.141-8.209-8.211h1.333c0 3.343 3.535 6.877 6.876 6.877v1.333zM7.658 25.266l-0.943-0.943 13.082-13.082 0.943 0.943-13.082 13.082z',
      ),
      'Penguin' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M11.037 6.037c-0.16 0-0.333-0.080-0.468-0.197-0.119-0.136-0.199-0.296-0.199-0.481 0-0.172 0.080-0.333 0.199-0.471 0.267-0.251 0.695-0.24 0.947 0 0.136 0.137 0.203 0.3 0.203 0.471 0 0.173-0.067 0.347-0.2 0.477-0.133 0.123-0.307 0.201-0.481 0.201zM21.652 31.983h-11.324c-0.259 0-0.495-0.148-0.604-0.385-0.109-0.232-0.073-0.511 0.093-0.711l2.765-3.3 1.023 0.857-1.848 2.203h9.896l-0.001 1.336zM21.239 32.020c-1.317 0-3.883-0.193-6.244-1.492-6.029-3.32-8.151-12.159-6.672-27.813 0.013-0.14 0.071-0.276 0.164-0.381 0.084-0.092 2.084-2.316 4.747-2.352 1.173 0 2.513 0.617 3.62 1.647 2.164 2.020 4.211 10.132 6.472 19.733 0.764 3.251 1.555 6.609 1.917 7.32 1.045 0.453 3.251 1.711 3.748 2 0.265 0.085 0.456 0.336 0.456 0.631 0 0.375-0.32 0.675-0.68 0.667-0.005 0-0.008 0-0.016 0h-6.583c-0.005 0.007-0.367 0.041-0.929 0.041zM9.628 3.071c-1.36 14.713 0.607 23.311 6.011 26.288 3.005 1.653 6.389 1.303 6.451 1.295l4.101-0.003c-0.633-0.339-1.243-0.651-1.599-0.795-0.633-0.252-0.896-1.093-2.565-8.188-1.609-6.833-4.040-17.157-6.084-19.067-0.851-0.797-1.876-1.289-2.673-1.289-1.736 0.024-3.191 1.316-3.641 1.759zM8.437 9.523c-0.043 0-0.085-0.003-0.129-0.011l-5.216-1.029c-0.264-0.052-0.472-0.259-0.525-0.524-0.053-0.263 0.059-0.533 0.284-0.687l5.661-3.768c0.305-0.201 0.72-0.121 0.924 0.189 0.204 0.303 0.121 0.719-0.185 0.92l-4.313 2.871 3.628 0.716c0.36 0.073 0.596 0.423 0.525 0.784-0.064 0.32-0.341 0.539-0.653 0.539zM18.043 27.707c-0.041 0-0.084-0.003-0.125-0.011-3.109-0.591-4.872-11.168-5.337-14.396-0.053-0.363 0.2-0.701 0.564-0.753 0.367-0.055 0.701 0.199 0.753 0.563 0.761 5.259 2.247 11.004 3.591 12.751 0.243-2.503 0.787-8.527 0.579-10.389-0.039-0.364 0.221-0.695 0.588-0.737 0.364-0.039 0.695 0.221 0.737 0.585 0.279 2.507-0.645 11.412-0.688 11.788-0.021 0.187-0.115 0.356-0.265 0.465-0.115 0.088-0.252 0.135-0.396 0.135z',
      ),
      'Pentagon' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M25.476 31.959h-18.951c-0.292 0-0.549-0.191-0.637-0.471l-5.857-18.856c-0.084-0.267 0.011-0.557 0.232-0.728l15.333-11.724c0.24-0.183 0.568-0.184 0.805-0.003l15.333 11.583c0.224 0.169 0.317 0.46 0.237 0.728l-5.86 18.997c-0.084 0.283-0.341 0.473-0.636 0.473zM7.017 30.625h17.969l5.576-18.083-14.556-10.996-14.561 11.135 5.572 17.944zM23.208 28.296h-14.412c-0.292 0-0.549-0.192-0.637-0.471l-4.453-14.336c-0.085-0.268 0.009-0.557 0.232-0.728l11.659-8.916c0.24-0.183 0.568-0.183 0.805-0.003l11.661 8.808c0.224 0.168 0.317 0.459 0.237 0.728l-4.459 14.444c-0.084 0.281-0.341 0.473-0.633 0.473zM9.287 26.963h13.429l4.172-13.529-10.884-8.221-10.888 8.327 4.171 13.424zM21.107 24.907h-10.211c-0.292 0-0.549-0.191-0.637-0.469l-3.156-10.159c-0.084-0.267 0.009-0.557 0.232-0.728l8.26-6.317c0.24-0.181 0.568-0.181 0.805-0.001l8.263 6.239c0.224 0.169 0.315 0.46 0.235 0.728l-3.153 10.235c-0.085 0.283-0.343 0.473-0.637 0.473zM11.388 23.573h9.227l2.875-9.319-7.485-5.652-7.489 5.727 2.873 9.244zM18.888 21.172h-5.772c-0.291 0-0.547-0.188-0.636-0.465l-1.781-5.573c-0.087-0.273 0.011-0.569 0.241-0.74l4.667-3.435c0.235-0.172 0.557-0.173 0.792 0.003l4.667 3.461c0.232 0.169 0.325 0.468 0.24 0.739l-1.781 5.545c-0.092 0.277-0.347 0.465-0.636 0.465zM13.604 19.839h4.797l1.487-4.628-3.888-2.885-3.884 2.859 1.488 4.655z',
      ),
      'People-onCloud' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M3.344 29.661c-0.367 0-0.667-0.3-0.667-0.667v-0.995c0-2.312 2.195-4.339 4.695-4.339 0.364 0 0.667 0.3 0.667 0.667s-0.303 0.667-0.667 0.667c-1.759 0-3.361 1.433-3.361 3.005v0.995c0 0.367-0.3 0.667-0.667 0.667zM18.011 29.661c-0.367 0-0.667-0.3-0.667-0.667v-1.016c0-1.756-1.096-2.984-2.667-2.984-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667c2.317 0 4 1.815 4 4.317v1.016c0 0.367-0.3 0.667-0.667 0.667zM10.867 26.328c-2.167 0-4.153-1.899-4.44-4.111-0.557-0.204-1.084-0.66-1.084-1.275v-1.461c0-0.524 0.448-0.937 1.333-1.232v-0.96c0-1.628 0.976-2.78 2.393-2.853 0.367-0.153 1.443-0.553 2.543-0.553 1.948 0 3.064 1.241 3.064 3.407v0.829c0.751 0.091 1.333 0.407 1.333 1.361v1.461c0 0.539-0.333 1.016-0.805 1.251-0.257 2.256-2.173 4.136-4.337 4.136zM6.705 20.931c0.073 0 0.249 0.077 0.352 0.077 0.367 0 0.667 0.299 0.667 0.667 0 1.707 1.528 3.32 3.143 3.32 1.584 0 3.029-1.584 3.029-3.32 0-0.368 0.301-0.667 0.667-0.667l0.109-1.527c0-0.004 0-0.009 0-0.012-0.104-0.025-0.305-0.051-0.667-0.051-0.365 0-0.667-0.3-0.667-0.667v-1.464c0-1.836-0.92-2.073-1.731-2.073-1.032 0-2.109 0.483-2.125 0.488-0.084 0.039-0.18 0.060-0.276 0.060-0.888 0-1.201 0.788-1.201 1.525v1.464c0 0.307-0.209 0.576-0.508 0.645-0.305 0.077-0.648 0.2-0.825 0.297v1.248c0.009-0.009 0.021-0.012 0.033-0.012zM19.661 24.995c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667c2.588 0 4.281-1.297 5.077-2.611-0.397-0.68-1.177-2.065-1.341-2.765-0.275-1.16-1.187-3.86-3.736-3.86-0.505 0-0.98 0.112-1.417 0.333-0.319 0.167-0.728 0.039-0.896-0.292-0.168-0.328-0.035-0.729 0.293-0.895 0.625-0.319 1.305-0.48 2.025-0.48 2.425 0 4.308 1.827 5.029 4.888 0.12 0.503 0.913 1.932 1.38 2.713 0.12 0.196 0.131 0.44 0.028 0.643-0.885 1.769-3.041 3.659-6.443 3.659zM26.011 29.661c-0.367 0-0.667-0.3-0.667-0.667v-1.016c0-1.756-1.096-2.984-2.667-2.984h-2.667c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c2.317 0 4 1.815 4 4.317v1.016c0 0.367-0.3 0.667-0.667 0.667zM28.044 24.593c-0.261 0-0.511-0.156-0.617-0.415-0.139-0.339 0.023-0.729 0.361-0.869 1.751-0.723 2.883-2.417 2.883-4.307 0-1.677-0.885-3.187-2.365-4.031-0.221-0.127-0.355-0.371-0.333-0.627 0.021-0.281 0.032-0.473 0.032-0.671 0-5.513-4.484-10-9.997-10-4.575 0-8.553 3.096-9.684 7.532-0.080 0.305-0.364 0.508-0.677 0.5-0.075-0.004-0.141-0.012-0.213-0.024-0.008 0-0.016 0-0.024 0-3.393 0-6.075 2.685-6.075 5.983 0 1.687 0.64 3.239 1.805 4.371 0.263 0.256 0.268 0.68 0.013 0.943-0.253 0.265-0.677 0.271-0.943 0.013-1.424-1.385-2.209-3.276-2.209-5.328 0-3.987 3.203-7.241 7.179-7.325 1.453-4.739 5.827-8.001 10.824-8.001 6.251 0 11.331 5.084 11.331 11.333 0 0.121-0.004 0.243-0.013 0.363 1.661 1.111 2.68 2.977 2.68 4.967 0 2.435-1.456 4.609-3.705 5.54-0.079 0.039-0.165 0.053-0.251 0.053z',
      ),
      'Pepper-withFire' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M4.423 21.153c-0.336 0-0.625-0.253-0.661-0.596-0.328-3.072 0.427-7.377 2.864-9.568 0.213-0.193 0.527-0.224 0.771-0.087 0.251 0.139 0.381 0.421 0.331 0.701-0.452 2.472-0.057 3.771 0.464 4.161 0.3 0.225 0.639 0.137 0.867 0.023 0.636-0.313 1.275-1.232 1.279-2.569 0.003-1.008-0.164-2.057-0.343-3.169-0.511-3.203-1.089-6.832 2.831-9.688 0.232-0.168 0.544-0.172 0.78-0.005 0.235 0.167 0.335 0.465 0.251 0.74-1.323 4.319-0.521 6.457 0.087 6.984 0.195 0.173 0.305 0.124 0.339 0.107 0.224-0.105 0.639-0.687 0.605-2.131-0.005-0.261 0.139-0.501 0.373-0.616 0.239-0.112 0.517-0.080 0.716 0.085 2.119 1.76 2.968 4.388 2.867 6.212-0.052 0.957-0.484 2.008-0.901 3.027-0.401 0.972-0.945 2.303-0.571 2.516 0.14 0.081 0.276 0.104 0.484-0.033 0.795-0.513 1.617-2.667 1.445-4.447-0.024-0.24 0.085-0.473 0.287-0.611 0.197-0.139 0.456-0.155 0.672-0.051 1.987 0.977 3.513 4.336 3.401 7.269-0.016 0.361-0.309 0.82-0.667 0.82-0.008 0-0.019 0-0.027 0-0.367 0-0.656-0.503-0.64-0.871 0.079-2.005-0.735-4.065-1.716-5.175-0.188 1.701-0.917 3.507-2.028 4.229-0.604 0.389-1.265 0.392-1.867 0.051-1.397-0.793-0.659-2.604-0.008-4.193 0.375-0.916 0.763-1.865 0.805-2.597 0.063-1.14-0.372-2.772-1.424-4.123-0.203 0.912-0.632 1.557-1.243 1.845-0.584 0.271-1.245 0.159-1.781-0.305-0.917-0.795-1.619-2.815-1.043-6.096-1.476 2.049-1.104 4.393-0.711 6.847 0.177 1.115 0.361 2.268 0.359 3.383-0.004 1.676-0.799 3.152-2.020 3.76-0.789 0.391-1.612 0.337-2.263-0.151-0.476-0.361-1.14-1.196-1.191-3.072-0.995 1.951-1.336 4.568-1.112 6.655 0.036 0.365-0.227 0.695-0.591 0.735-0.021 0.003-0.045 0.004-0.071 0.004zM18.057 31.767v0c-0.396 0-0.805-0.007-1.216-0.023-7.32-0.255-11.817-3.372-15.252-6.388-1.385-1.216-1.925-2.695-1.453-3.957 0.639-1.699 2.987-2.264 5.084-1.068 3.425 1.956 7.764 2.153 11.649 0.468 5.973-2.592 10.339-1.677 11.415 2.269 0.623 2.284 0.377 4.175-0.727 5.619-1.56 2.044-4.757 3.080-9.5 3.080zM2.889 20.993c-0.724 0-1.303 0.336-1.504 0.877-0.272 0.721 0.135 1.648 1.084 2.484 3.255 2.861 7.516 5.816 14.416 6.057 0.399 0.015 0.789 0.023 1.169 0.023 0.003 0 0.003 0 0.003 0 4.245 0 7.161-0.884 8.44-2.555 0.836-1.097 1.005-2.597 0.497-4.459-0.503-1.851-1.864-2.788-4.052-2.788-1.552 0-3.419 0.469-5.541 1.391-4.263 1.855-9.056 1.632-12.843-0.532-0.571-0.327-1.147-0.499-1.669-0.499zM25.305 23.803c-0.325 0-0.609-0.24-0.659-0.572-0.052-0.363 0.2-0.701 0.568-0.753 1.713-0.251 2.085-1.212 2.56-2.432 0.487-1.271 1.096-2.853 3.591-2.853 0.367 0 0.667 0.299 0.667 0.667 0 0.367-0.3 0.667-0.667 0.667-1.581 0-1.888 0.795-2.352 1.999-0.5 1.297-1.123 2.912-3.612 3.271-0.035 0.005-0.063 0.008-0.096 0.008zM25.041 30.412c-0.145 0-0.297-0.048-0.419-0.148-0.284-0.232-0.328-0.652-0.096-0.937 0.251-0.305 0.473-0.757 0.136-1.179-0.459-0.559-1.639-0.799-2.94-0.139-0.303 0.149-0.664 0.057-0.855-0.22-0.188-0.276-0.14-0.649 0.107-0.872 0.945-0.845 1.019-1.673 0.789-2.125-0.24-0.479-0.817-0.68-1.541-0.528-0.333 0.061-0.636-0.108-0.752-0.408-0.12-0.3-0.008-0.64 0.265-0.811 0.849-0.531 0.899-1.203 0.685-1.619-0.084-0.165-0.297-0.417-0.547-0.312-0.341 0.141-0.729-0.023-0.869-0.361s0.021-0.731 0.361-0.869c0.839-0.348 1.784 0.043 2.243 0.932 0.317 0.619 0.367 1.444-0.039 2.207 0.612 0.197 1.107 0.601 1.393 1.172 0.323 0.64 0.331 1.376 0.063 2.093 1.18-0.073 2.148 0.367 2.68 1.024 0.669 0.832 0.623 1.927-0.136 2.857-0.144 0.159-0.333 0.243-0.529 0.243z',
      ),
      'Pepper' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M18.057 23.288c-0.405-0.029-0.804-0.007-1.216-0.023-7.32-0.255-11.817-3.372-15.251-6.388-1.385-1.216-1.929-2.695-1.453-3.957 0.64-1.699 2.989-2.263 5.084-1.068 3.428 1.957 7.767 2.156 11.651 0.468 5.975-2.592 10.337-1.677 11.413 2.269 0.623 2.284 0.377 4.175-0.727 5.619-1.561 2.043-4.759 3.080-9.501 3.080zM2.889 12.515c-0.724 0-1.301 0.336-1.505 0.877-0.272 0.721 0.135 1.648 1.087 2.484 3.256 2.861 7.515 5.816 14.417 6.057 0.399 0.015 0.789 0.023 1.169 0.023v0c4.245 0 7.164-0.884 8.44-2.555 0.839-1.097 1.005-2.597 0.5-4.459-0.503-1.851-1.867-2.788-4.055-2.788-1.549 0-3.415 0.469-5.539 1.391-4.269 1.853-9.056 1.631-12.844-0.532-0.571-0.327-1.148-0.499-1.671-0.499zM25.305 15.323c-0.325 0-0.609-0.24-0.659-0.572-0.052-0.363 0.2-0.701 0.568-0.753 1.713-0.251 2.085-1.212 2.56-2.432 0.487-1.271 1.096-2.853 3.591-2.853 0.367 0 0.667 0.299 0.667 0.667 0 0.367-0.3 0.667-0.667 0.667-1.581 0-1.888 0.795-2.352 1.999-0.5 1.297-1.123 2.912-3.612 3.271-0.035 0.005-0.063 0.008-0.096 0.008zM25.041 21.932c-0.145 0-0.297-0.048-0.419-0.148-0.284-0.232-0.328-0.652-0.096-0.937 0.251-0.305 0.473-0.757 0.136-1.179-0.456-0.559-1.64-0.799-2.94-0.139-0.301 0.152-0.661 0.056-0.852-0.22-0.188-0.276-0.143-0.649 0.107-0.872 0.945-0.845 1.016-1.673 0.789-2.125-0.241-0.479-0.82-0.68-1.547-0.528-0.315 0.061-0.632-0.108-0.751-0.408-0.12-0.3-0.008-0.64 0.265-0.811 0.848-0.531 0.899-1.203 0.685-1.619-0.085-0.165-0.3-0.416-0.547-0.312-0.337 0.14-0.731-0.021-0.869-0.361-0.14-0.341 0.021-0.731 0.361-0.869 0.841-0.348 1.784 0.045 2.244 0.932 0.317 0.619 0.367 1.444-0.041 2.207 0.612 0.197 1.109 0.601 1.393 1.172 0.323 0.64 0.331 1.376 0.063 2.093 1.175-0.084 2.148 0.367 2.68 1.024 0.672 0.832 0.62 1.927-0.136 2.857-0.141 0.16-0.331 0.243-0.527 0.243z',
      ),
      'Petrol' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24.667 14.667h-22.667c-0.367 0-0.667-0.299-0.667-0.667v-13.333c0-0.368 0.3-0.667 0.667-0.667h22.667c0.368 0 0.667 0.299 0.667 0.667v13.333c0 0.368-0.299 0.667-0.667 0.667zM2.667 13.333h21.333v-12h-21.333v12zM22 10.667h-17.333c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.3-0.667 0.667-0.667h17.333c0.368 0 0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM5.333 9.333h16v-5.333h-16v5.333zM22 32h-17.333c-0.367 0-0.667-0.3-0.667-0.667v-17.333c0-0.368 0.3-0.667 0.667-0.667h17.333c0.368 0 0.667 0.299 0.667 0.667v17.333c0 0.367-0.299 0.667-0.667 0.667zM5.333 30.667h16v-16h-16v16zM10 10c-0.367 0-0.667-0.299-0.667-0.667v-1.333c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v1.333c0 0.368-0.299 0.667-0.667 0.667zM27.417 30.667h-0.167c-1.792 0-3.251-1.457-3.251-3.249v-7.417c0-0.735-0.599-1.333-1.333-1.333-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667c1.471 0 2.667 1.195 2.667 2.667v7.417c0 1.057 0.86 1.917 1.917 1.917h0.167c1.056 0 1.917-0.861 1.917-1.917v-17.807l-2.083-2.083c-0.259-0.26-0.259-0.683 0-0.943s0.684-0.26 0.943 0l2.277 2.277c0.124 0.125 0.195 0.295 0.195 0.472v18.084c0 1.791-1.456 3.248-3.249 3.248z',
      ),
      'Petronas-Tower' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M13.333 32h-8c-0.368 0-0.667-0.3-0.667-0.667v-16c0-0.368 0.299-0.667 0.667-0.667h8c0.368 0 0.667 0.299 0.667 0.667v16c0 0.367-0.299 0.667-0.667 0.667zM6 30.667h6.667v-14.667h-6.667v14.667zM12 16h-5.333c-0.368 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.299 0.667 0.667v5.333c0 0.368-0.299 0.667-0.667 0.667zM7.333 14.667h4v-4h-4v4zM7.333 8h4v2.667h-4v-2.667zM20.667 8h4v2.667h-4v-2.667zM8.667 0h1.333v8h-1.333v-8zM26.667 32h-8c-0.367 0-0.667-0.3-0.667-0.667v-16c0-0.368 0.3-0.667 0.667-0.667h8c0.367 0 0.667 0.299 0.667 0.667v16c0 0.367-0.3 0.667-0.667 0.667zM19.333 30.667h6.667v-14.667h-6.667v14.667zM25.333 16h-5.333c-0.367 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.299 0.667 0.667v5.333c0 0.368-0.3 0.667-0.667 0.667zM20.667 14.667h4v-4h-4v4zM22 0h1.333v8h-1.333v-8zM18 21.333h-4c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h4c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM10.667 31.333c-0.368 0-0.667-0.3-0.667-0.667v-10.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v10.667c0 0.367-0.299 0.667-0.667 0.667zM21.333 31.333c-0.367 0-0.667-0.3-0.667-0.667v-10.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v10.667c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Philipines' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M0.667 31.333c-0.367 0-0.667-0.3-0.667-0.667v-29.333c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v29.333c0 0.367-0.299 0.667-0.667 0.667zM31.333 24h-30.667c-0.367 0-0.667-0.3-0.667-0.667v-21.333c0-0.368 0.3-0.667 0.667-0.667h30.667c0.367 0 0.667 0.299 0.667 0.667v21.333c0 0.367-0.3 0.667-0.667 0.667zM1.333 22.667h29.333v-20h-29.333v20zM30.667 13.333h-18.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h18.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM12 13.333c-0.164 0-0.328-0.060-0.457-0.181l-11.333-10.667c-0.268-0.252-0.283-0.675-0.028-0.943 0.253-0.268 0.676-0.28 0.943-0.028l11.333 10.667c0.268 0.252 0.283 0.675 0.028 0.943-0.131 0.139-0.308 0.209-0.485 0.209zM0.667 22.667c-0.193 0-0.383-0.084-0.516-0.243-0.235-0.287-0.195-0.705 0.091-0.939l11.333-9.333c0.281-0.233 0.701-0.195 0.936 0.091 0.237 0.284 0.196 0.704-0.088 0.939l-11.333 9.333c-0.123 0.101-0.273 0.152-0.423 0.152zM4.667 14.667c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.896 2-2 2zM4.667 12c-0.367 0-0.667 0.299-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.299 0.667-0.667-0.299-0.667-0.667-0.667z',
      ),
      'Phone-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M14.776 26.461c-0.396 0-0.783-0.084-1.148-0.244l-1.992-0.881c-2.948-1.305-3.205-6.969-0.587-12.896 2.216-5.013 5.763-8.515 8.628-8.515 0.461 0 0.901 0.087 1.303 0.265l1.992 0.881c0.695 0.307 1.229 0.867 1.503 1.575 0.276 0.709 0.256 1.481-0.049 2.179l-0.585 1.329c-0.616 1.393-2.349 2.069-3.751 1.453l-1.992-0.88c-0.508-0.227-2.035 0.861-3.167 3.425-0.505 1.143-0.803 2.34-0.812 3.283-0.009 0.816 0.199 1.275 0.409 1.365l1.992 0.879c1.435 0.639 2.085 2.319 1.452 3.752l-0.585 1.327c-0.463 1.036-1.484 1.703-2.611 1.703zM19.676 5.259c-2.277 0-5.463 3.317-7.408 7.72-2.472 5.592-2.044 10.275-0.095 11.137l1.992 0.881c0.748 0.331 1.667-0.031 1.993-0.772l0.585-1.328c0.336-0.761-0.009-1.655-0.773-1.995l-1.991-0.879c-0.792-0.349-1.22-1.273-1.204-2.601 0.013-1.135 0.341-2.484 0.925-3.805 0.935-2.115 2.611-4.249 4.247-4.249 0.241 0 0.471 0.048 0.681 0.141l1.991 0.88c0.749 0.333 1.667-0.031 1.993-0.772l0.587-1.331c0.164-0.369 0.175-0.78 0.028-1.156-0.143-0.377-0.427-0.673-0.799-0.836l-1.992-0.88c-0.229-0.105-0.487-0.156-0.761-0.156zM15.999 32c-2.556 0-4.127-0.559-4.801-1.705-0.936-1.596 0.212-3.648 1.049-5.148l0.121-0.216c0.179-0.321 0.584-0.44 0.907-0.257 0.323 0.18 0.439 0.584 0.259 0.907l-0.123 0.221c-0.641 1.148-1.612 2.885-1.063 3.821 0.403 0.683 1.665 1.044 3.651 1.044 8.087 0 14.667-6.581 14.667-14.667s-6.58-14.667-14.667-14.667c-8.087 0-14.667 6.581-14.667 14.667 0 4.223 1.821 8.245 4.999 11.028 0.277 0.245 0.304 0.664 0.061 0.943-0.244 0.276-0.665 0.304-0.941 0.060-3.464-3.040-5.451-7.425-5.451-12.031 0-8.821 7.177-16 16-16s16 7.179 16 16c-0.001 8.823-7.179 16-16.001 16z',
      ),
      'Phone-3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M8 32h-5.333c-1.471 0-2.667-1.195-2.667-2.667v-26.667c0-1.472 1.196-2.667 2.667-2.667h5.333c1.471 0 2.667 1.195 2.667 2.667v26.667c0 1.472-1.196 2.667-2.667 2.667zM2.667 1.333c-0.735 0-1.333 0.599-1.333 1.333v26.667c0 0.735 0.599 1.333 1.333 1.333h5.333c0.735 0 1.333-0.599 1.333-1.333v-26.667c0-0.735-0.599-1.333-1.333-1.333h-5.333zM31.333 30.667h-21.333c-0.368 0-0.667-0.3-0.667-0.667v-28c0-0.368 0.299-0.667 0.667-0.667h21.333c0.367 0 0.667 0.299 0.667 0.667v28c0 0.367-0.3 0.667-0.667 0.667zM10.667 29.333h20v-26.667h-20v26.667zM27.333 12h-12c-0.368 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.299-0.667 0.667-0.667h12c0.367 0 0.667 0.299 0.667 0.667v5.333c0 0.368-0.3 0.667-0.667 0.667zM16 10.667h10.667v-4h-10.667v4zM19.333 26c-0.367 0-0.667-0.3-0.667-0.667v-10.667c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v10.667c0 0.367-0.3 0.667-0.667 0.667zM23.333 26c-0.367 0-0.667-0.3-0.667-0.667v-10.667c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v10.667c0 0.367-0.3 0.667-0.667 0.667zM26.667 18.667h-10.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h10.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM26.667 22.667h-10.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h10.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM27.333 26.667h-12c-0.368 0-0.667-0.3-0.667-0.667v-12c0-0.368 0.299-0.667 0.667-0.667h12c0.367 0 0.667 0.299 0.667 0.667v12c0 0.367-0.3 0.667-0.667 0.667zM16 25.333h10.667v-10.667h-10.667v10.667z',
      ),
      'Phone-3G' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.667 32h-13.333c-1.471 0-2.667-1.195-2.667-2.667v-26.667c0-1.472 1.196-2.667 2.667-2.667h13.333c1.472 0 2.667 1.195 2.667 2.667v26.667c0 1.472-1.195 2.667-2.667 2.667zM3.333 1.333c-0.735 0-1.333 0.599-1.333 1.333v26.667c0 0.735 0.599 1.333 1.333 1.333h13.333c0.735 0 1.333-0.599 1.333-1.333v-26.667c0-0.735-0.599-1.333-1.333-1.333h-13.333zM18 6.667h-16c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM10 4c-0.173 0-0.347-0.067-0.467-0.2-0.133-0.133-0.2-0.293-0.2-0.467s0.067-0.333 0.187-0.467c0.253-0.253 0.707-0.253 0.947 0 0.133 0.119 0.2 0.293 0.2 0.467s-0.067 0.347-0.2 0.467c-0.12 0.133-0.293 0.2-0.467 0.2zM18 26.667h-16c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM23.333 5.333h-1.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM24 8h-2c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h1.333v-4h-1.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2c0.367 0 0.667 0.299 0.667 0.667v5.333c0 0.368-0.3 0.667-0.667 0.667zM30.667 8h-4c-0.367 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.3-0.667 0.667-0.667h3.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667h-2.667v4h2.667v-1.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h0.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM11.333 29.333h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Phone-4G' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.667 32h-13.333c-1.471 0-2.667-1.195-2.667-2.667v-26.667c0-1.472 1.196-2.667 2.667-2.667h13.333c1.472 0 2.667 1.195 2.667 2.667v26.667c0 1.472-1.195 2.667-2.667 2.667zM3.333 1.333c-0.735 0-1.333 0.599-1.333 1.333v26.667c0 0.735 0.599 1.333 1.333 1.333h13.333c0.735 0 1.333-0.599 1.333-1.333v-26.667c0-0.735-0.599-1.333-1.333-1.333h-13.333zM18 6.667h-16c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM18 26.667h-16c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM30.667 8h-4c-0.367 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.3-0.667 0.667-0.667h3.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667h-2.667v4h2.667v-1.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h0.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM24 8.667c-0.367 0-0.667-0.299-0.667-0.667v-1.333h-2c-0.251 0-0.479-0.14-0.593-0.363-0.115-0.224-0.093-0.492 0.055-0.695l2.667-3.667c0.216-0.299 0.633-0.363 0.931-0.147 0.299 0.216 0.363 0.636 0.147 0.931l-1.896 2.608h1.357c0.367 0 0.667 0.299 0.667 0.667v2c0 0.367-0.3 0.665-0.667 0.665zM10 4c-0.173 0-0.347-0.067-0.467-0.2-0.12-0.12-0.2-0.293-0.2-0.467 0-0.187 0.080-0.36 0.2-0.48 0.24-0.24 0.693-0.24 0.933 0.013 0.133 0.119 0.2 0.293 0.2 0.467s-0.067 0.347-0.2 0.467c-0.12 0.133-0.293 0.2-0.467 0.2zM11.333 29.333h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Phone-SMS' => 
      array (
        'height' => '32',
        'width' => '37',
        'path' => 'M16 32h-13.333c-1.471 0-2.667-1.195-2.667-2.667v-26.667c0-1.472 1.196-2.667 2.667-2.667h13.333c1.471 0 2.667 1.195 2.667 2.667v26.667c0 1.472-1.195 2.667-2.667 2.667zM2.667 1.333c-0.733 0-1.333 0.6-1.333 1.333v26.667c0 0.735 0.599 1.333 1.333 1.333h13.333c0.735 0 1.333-0.599 1.333-1.333v-26.667c0-0.735-0.599-1.333-1.333-1.333h-13.333zM17.333 6.667h-16c-0.368 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h16c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM9.333 4c-0.173 0-0.347-0.067-0.467-0.2-0.133-0.12-0.2-0.293-0.2-0.467s0.067-0.347 0.2-0.467c0.227-0.253 0.693-0.253 0.947 0 0.121 0.12 0.187 0.295 0.187 0.467s-0.067 0.347-0.2 0.467c-0.12 0.135-0.293 0.2-0.467 0.2zM10.667 29.333h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM17.333 26.667h-16c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h16c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM19.277 17.445c-0.291 0-0.548-0.191-0.636-0.467-0.087-0.279 0.016-0.583 0.253-0.749 1.348-0.943 2.423-2.329 3.196-4.127-1.353-1.325-2.091-3.005-2.091-4.769 0-4.045 3.888-7.333 8.667-7.333s8.667 3.288 8.667 7.333c0 4.545-4.979 8.165-10.472 7.168-1.203 1.415-3.46 2.944-7.584 2.944zM28.667 1.333c-4.044 0-7.333 2.693-7.333 6 0 1.524 0.708 2.977 1.992 4.096 0.211 0.185 0.284 0.484 0.183 0.747-0.588 1.503-1.361 2.775-2.307 3.804 2.145-0.321 3.809-1.208 4.867-2.611 0.156-0.208 0.421-0.305 0.677-0.251 4.809 1.073 9.257-1.959 9.255-5.784 0-3.308-3.289-6.001-7.333-6.001z',
      ),
      'Phone-Simcard' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26.667 32h-21.333c-0.368 0-0.667-0.3-0.667-0.667v-30.667c0-0.368 0.299-0.667 0.667-0.667h15.444c0.165 0 0.325 0.061 0.447 0.172l5.889 5.333c0.139 0.127 0.22 0.305 0.22 0.495v25.333c0 0.367-0.3 0.667-0.667 0.667zM6 30.667h20v-24.371l-5.479-4.963h-14.521v29.333zM20 28h-8c-1.837 0-3.333-1.496-3.333-3.333v-12c0-1.837 1.496-3.333 3.333-3.333h8c1.837 0 3.333 1.496 3.333 3.333v12c0 1.837-1.496 3.333-3.333 3.333zM12 10.667c-1.103 0-2 0.897-2 2v12c0 1.103 0.897 2 2 2h8c1.103 0 2-0.897 2-2v-12c0-1.103-0.897-2-2-2h-8zM22 17.333h-12c-0.368 0-0.667-0.3-0.667-0.667 0-0.368 0.299-0.667 0.667-0.667h12c0.367 0 0.667 0.299 0.667 0.667 0 0.367-0.3 0.667-0.667 0.667zM22 21.333h-12c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h12c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM13.333 16.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM16 16.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM18.667 16.667c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM13.333 24.667c-0.368 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.667c0 0.367-0.299 0.667-0.667 0.667zM16 24.667c-0.368 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.667c0 0.367-0.299 0.667-0.667 0.667zM18.667 24.667c-0.367 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.667c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Phone-Wifi' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 32h-13.333c-1.471 0-2.667-1.195-2.667-2.667v-26.667c0-1.472 1.196-2.667 2.667-2.667h13.333c1.472 0 2.667 1.195 2.667 2.667v26.667c0 1.472-1.195 2.667-2.667 2.667zM2.667 1.333c-0.735 0-1.333 0.599-1.333 1.333v26.667c0 0.735 0.599 1.333 1.333 1.333h13.333c0.735 0 1.333-0.599 1.333-1.333v-26.667c0-0.735-0.599-1.333-1.333-1.333h-13.333zM17.333 6.667h-16c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM9.333 4c-0.173 0-0.347-0.067-0.467-0.2-0.133-0.12-0.2-0.293-0.2-0.467s0.067-0.347 0.2-0.467c0.24-0.253 0.693-0.253 0.933 0 0.133 0.119 0.2 0.28 0.2 0.467 0 0.173-0.067 0.347-0.2 0.48-0.12 0.12-0.293 0.187-0.467 0.187zM17.333 26.667h-16c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM31.333 12c-0.367 0-0.667-0.299-0.667-0.667 0-5.515-4.485-10-10-10-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667c6.251 0 11.333 5.084 11.333 11.333 0 0.368-0.3 0.667-0.667 0.667zM23.333 12c-0.367 0-0.667-0.299-0.667-0.667 0-1.103-0.897-2-2-2-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667c1.837 0 3.333 1.496 3.333 3.333 0 0.368-0.3 0.667-0.667 0.667zM27.333 12c-0.367 0-0.667-0.299-0.667-0.667 0-3.308-2.693-6-6-6-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667c4.044 0 7.333 3.289 7.333 7.333 0 0.368-0.3 0.667-0.667 0.667zM10.667 29.333h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Phone' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 18.448c-3.488 0-6.325-2.036-6.325-4.539s2.837-4.54 6.325-4.54 6.325 2.036 6.325 4.539-2.837 4.54-6.325 4.54zM16 10.703c-2.705 0-4.992 1.472-4.992 3.205 0 1.739 2.285 3.205 4.992 3.205 2.705 0 4.992-1.471 4.992-3.205s-2.287-3.205-4.992-3.205zM26.576 28.691h-21.151c-1.125 0-2.759-0.871-2.759-2.235v-5.752c0-0.136 0.043-0.268 0.121-0.381l3.716-5.292c0.147-0.208 0.399-0.315 0.652-0.275 0.252 0.040 0.459 0.223 0.532 0.468 0.821 2.747 4.448 4.813 8.439 4.813 3.944 0 7.415-2.027 8.249-4.815 0.073-0.247 0.281-0.427 0.535-0.468 0.251-0.043 0.505 0.069 0.651 0.279l3.652 5.295c0.081 0.107 0.12 0.24 0.12 0.375v5.751c0 1.367-1.633 2.237-2.757 2.237zM4 20.917v5.539c0 0.388 0.812 0.901 1.425 0.901h21.151c0.612 0 1.424-0.513 1.424-0.901v-5.544l-2.845-4.123c-1.492 2.716-5.061 4.581-9.028 4.581-3.999 0-7.704-1.909-9.216-4.599l-2.911 4.145zM30.276 14.023h-4.229c-0.855 0-2.047-0.639-2.047-1.683v-1.045c0-2.101-4.139-3.515-8-3.515-3.863 0-8 1.413-8 3.515v1.045c0 1.043-1.192 1.683-2.047 1.683h-4.229c-0.951 0-1.724-0.755-1.724-1.683v-1.829c0-4.447 8.305-7.2 16-7.2s16 2.753 16 7.2v1.829c0 0.928-0.773 1.683-1.724 1.683zM16 6.447c4.527 0 9.333 1.695 9.333 4.848v1.045c0.028 0.104 0.393 0.349 0.713 0.349h4.229c0.223 0 0.391-0.151 0.391-0.349v-1.829c0-3.361-7.745-5.867-14.667-5.867-6.923 0-14.667 2.511-14.667 5.867v1.829c0 0.195 0.168 0.349 0.391 0.349h4.229c0.32 0 0.684-0.245 0.713-0.357v-1.037c0-3.149 4.808-4.848 9.333-4.848z',
      ),
      'Photo-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M22.956 17.333h-13.925c-0.232 0-0.448-0.121-0.571-0.319-0.123-0.195-0.132-0.444-0.027-0.649l3.109-6.083c0.088-0.172 0.247-0.297 0.431-0.344 0.187-0.047 0.387-0.012 0.543 0.1l2.959 2.055 2.972-5.164c0.129-0.219 0.371-0.349 0.62-0.333 0.253 0.017 0.475 0.176 0.575 0.411l3.925 9.404c0.084 0.205 0.064 0.44-0.060 0.627-0.12 0.184-0.328 0.296-0.551 0.296zM10.121 16h11.833l-3.021-7.235-2.66 4.624c-0.093 0.163-0.251 0.277-0.432 0.319-0.184 0.039-0.372 0.004-0.527-0.104l-2.928-2.035-2.265 4.431zM11.223 8.651c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM11.223 5.984c-0.365 0-0.667 0.3-0.667 0.667 0 0.364 0.301 0.667 0.667 0.667s0.667-0.303 0.667-0.667c0-0.367-0.301-0.667-0.667-0.667zM28.667 32h-25.333c-0.367 0-0.667-0.299-0.667-0.667v-30.667c0-0.368 0.3-0.667 0.667-0.667h25.333c0.367 0 0.667 0.299 0.667 0.667v30.667c0 0.368-0.3 0.667-0.667 0.667zM4 30.667h24v-29.333h-24v29.333zM26 21.333h-20c-0.367 0-0.667-0.299-0.667-0.667v-17.333c0-0.368 0.3-0.667 0.667-0.667h20c0.367 0 0.667 0.299 0.667 0.667v17.333c0 0.368-0.3 0.667-0.667 0.667zM6.667 20h18.667v-16h-18.667v16zM12 25.333h-5.333c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM21.333 28h-14.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h14.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Photo-3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M25.895 32h-19.789c-3.365 0-6.105-2.739-6.105-6.104v-19.792c0-3.365 2.74-6.104 6.105-6.104h19.789c3.365 0 6.105 2.739 6.105 6.104v19.792c0 3.365-2.74 6.104-6.105 6.104zM6.105 1.333c-2.632 0-4.772 2.14-4.772 4.771v19.792c0 2.631 2.14 4.771 4.772 4.771h19.789c2.632 0 4.772-2.14 4.772-4.771v-19.792c0-2.631-2.14-4.771-4.772-4.771h-19.789zM23.228 22.667h-14.456c-3.365 0-6.105-2.739-6.105-6.104v-7.792c0-3.365 2.74-6.104 6.105-6.104h14.456c3.365 0 6.105 2.739 6.105 6.104v7.792c0 3.365-2.74 6.104-6.105 6.104zM8.772 4c-2.632 0-4.772 2.14-4.772 4.771v7.792c0 2.631 2.14 4.771 4.772 4.771h14.456c2.632 0 4.772-2.14 4.772-4.771v-7.792c0-2.631-2.14-4.771-4.772-4.771h-14.456zM14.667 14.667h1.333v6.667h-1.333v-6.667zM14.245 21.567c-0.98-0.001-1.82-0.352-2.419-1.015-0.625-0.687-0.923-1.64-0.828-2.617 0.033-0.355 0.355-0.656 0.695-0.6 1.195 0.061 2.195 0.497 2.825 1.228 0.549 0.639 0.795 1.467 0.704 2.387-0.029 0.32-0.287 0.576-0.607 0.6-0.128 0.012-0.252 0.017-0.371 0.017zM12.364 18.776c0.077 0.335 0.229 0.64 0.445 0.88 0.273 0.301 0.629 0.484 1.063 0.549-0.055-0.295-0.177-0.553-0.364-0.773-0.265-0.305-0.659-0.529-1.144-0.656zM15.317 15.721c-1.749 0-3.167-1.419-3.167-3.167s1.417-3.167 3.167-3.167c1.747 0 3.167 1.419 3.167 3.167s-1.42 3.167-3.167 3.167zM15.317 10.721c-1.011 0-1.833 0.823-1.833 1.833s0.823 1.833 1.833 1.833 1.833-0.823 1.833-1.833-0.823-1.833-1.833-1.833zM18.909 9.060c-0.101 0-0.203-0.023-0.3-0.071-0.328-0.165-0.461-0.567-0.297-0.896s0.031-0.732-0.295-0.897c-0.328-0.165-0.735-0.033-0.9 0.297-0.167 0.328-0.571 0.456-0.896 0.295-0.328-0.165-0.46-0.567-0.296-0.896 0.497-0.984 1.7-1.38 2.688-0.885s1.383 1.699 0.888 2.689c-0.113 0.229-0.351 0.364-0.592 0.364zM20.791 13.719c-0.321 0-0.605-0.236-0.657-0.564-0.055-0.364 0.195-0.705 0.557-0.761 0.177-0.028 0.331-0.121 0.437-0.265 0.103-0.14 0.145-0.317 0.12-0.495-0.057-0.361-0.388-0.608-0.76-0.557-0.357 0.059-0.704-0.193-0.76-0.557-0.056-0.361 0.195-0.701 0.557-0.757 1.088-0.16 2.113 0.581 2.283 1.669 0.084 0.528-0.045 1.057-0.361 1.487-0.313 0.429-0.779 0.712-1.305 0.797-0.041 0.001-0.076 0.004-0.111 0.004zM18.755 18.636c-0.057 0-0.115-0.003-0.175-0.008-0.531-0.043-1.017-0.297-1.361-0.703-0.239-0.283-0.199-0.701 0.084-0.939 0.281-0.237 0.7-0.201 0.937 0.083 0.115 0.139 0.276 0.219 0.453 0.237 0.175 0.016 0.351-0.040 0.487-0.155 0.281-0.239 0.315-0.659 0.081-0.939-0.237-0.281-0.2-0.701 0.081-0.94 0.284-0.233 0.701-0.2 0.94 0.083 0.708 0.844 0.6 2.105-0.243 2.816-0.361 0.3-0.813 0.464-1.285 0.464zM9.989 14.785c-1.065 0-1.953-0.841-2-1.913-0.023-0.535 0.164-1.045 0.527-1.44 0.361-0.393 0.853-0.623 1.388-0.645 0.404-0.005 0.68 0.271 0.695 0.639 0.016 0.365-0.271 0.68-0.639 0.695-0.181 0.007-0.347 0.084-0.467 0.215-0.121 0.132-0.184 0.301-0.173 0.479 0.016 0.364 0.372 0.697 0.695 0.637 0.393-0.013 0.68 0.269 0.695 0.639 0.016 0.365-0.271 0.68-0.639 0.695-0.024 0-0.052 0.001-0.081 0.001zM11.248 9.527c-0.213 0-0.423-0.101-0.555-0.297-0.297-0.444-0.403-0.977-0.297-1.501s0.409-0.972 0.852-1.272c0.443-0.296 0.976-0.408 1.503-0.297 0.525 0.104 0.973 0.407 1.271 0.852 0.204 0.305 0.123 0.72-0.185 0.924-0.305 0.2-0.72 0.121-0.924-0.185-0.1-0.148-0.251-0.251-0.423-0.285-0.18-0.032-0.355 0-0.5 0.099-0.147 0.099-0.249 0.251-0.287 0.424-0.032 0.173 0 0.352 0.099 0.5 0.204 0.305 0.123 0.72-0.185 0.921-0.112 0.081-0.241 0.119-0.368 0.119z',
      ),
      'Photo-Album' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M31.312 25.335h-4.645v-1.333h4.645c1.787 0 3.355-1.684 3.355-3.604v-8.417c0-1.805-1.496-3.977-3.355-3.977h-4.645v-1.333h4.645c2.683 0 4.688 2.805 4.688 5.311v8.417c0 2.676-2.145 4.937-4.688 4.937zM5.333 25.335h-3.979c-2.701 0-5.355-2.445-5.355-4.937v-8.417c0-2.584 2.752-5.311 5.355-5.311h3.979v1.333h-3.979c-1.879 0-4.021 2.119-4.021 3.977v8.417c0 1.751 2.067 3.604 4.021 3.604h3.979v1.333zM23.312 28.001h-14.624c-2.584 0-4.688-2.103-4.688-4.687v-14.628c0-2.584 2.103-4.688 4.688-4.688h14.624c2.584 0 4.689 2.103 4.689 4.688v14.629c-0.001 2.583-2.104 4.685-4.689 4.685zM8.688 5.335c-1.849 0-3.355 1.504-3.355 3.353v14.629c0 1.851 1.504 3.355 3.355 3.355h14.624c1.851 0 3.356-1.504 3.356-3.355v-14.629c0-1.849-1.505-3.353-3.356-3.353h-14.624zM20.645 22.668h-9.291c-2.584 0-4.688-2.101-4.688-4.685v-6.629c0-2.584 2.103-4.688 4.688-4.688h9.291c2.584 0 4.689 2.101 4.689 4.688v6.631c-0.001 2.583-2.104 4.684-4.689 4.684zM11.355 8.001c-1.849 0-3.355 1.504-3.355 3.352v6.631c0 1.851 1.504 3.355 3.355 3.355h9.291c1.851 0 3.356-1.504 3.356-3.355v-6.631c0-1.848-1.504-3.352-3.356-3.352h-9.291zM22.028 20.001h-11.383c-0.237 0-0.457-0.127-0.577-0.332s-0.12-0.46-0.001-0.667l2.688-4.692c0.18-0.316 0.584-0.428 0.904-0.251l2.428 1.361 3.029-3.719c0.153-0.192 0.395-0.269 0.637-0.237 0.24 0.044 0.437 0.215 0.513 0.447l2.396 7.211c0.068 0.203 0.031 0.425-0.092 0.6-0.127 0.176-0.328 0.279-0.543 0.279zM11.796 18.668h9.308l-1.723-5.183-2.616 3.211c-0.204 0.251-0.559 0.32-0.843 0.161l-2.341-1.309-1.785 3.12z',
      ),
      'Photo-Album2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M23.743 26.667h-12.152c-2.164 0-3.921-1.76-3.921-3.921v-12.153c0-2.163 1.757-3.923 3.921-3.923h12.151c2.164 0 3.924 1.76 3.924 3.923v12.152c0.001 2.163-1.759 3.923-3.923 3.923zM11.591 8c-1.428 0-2.591 1.161-2.591 2.588v12.152c0 1.428 1.163 2.589 2.591 2.589h12.151c1.425 0 2.588-1.161 2.588-2.589v-12.152c0-1.427-1.163-2.588-2.588-2.588h-12.151zM21.076 22.667h-6.817c-2.164 0-3.921-1.76-3.921-3.921v-5.487c0-2.163 1.757-3.923 3.921-3.923h6.817c2.164 0 3.924 1.76 3.924 3.923v5.485c0 2.163-1.76 3.923-3.924 3.923zM14.257 10.667c-1.428 0-2.591 1.161-2.591 2.588v5.485c0 1.428 1.163 2.589 2.591 2.589h6.817c1.425 0 2.588-1.161 2.588-2.589v-5.485c0-1.427-1.163-2.588-2.588-2.588h-6.817zM21.964 20h-8.601c-0.235 0-0.453-0.125-0.575-0.328-0.12-0.203-0.124-0.455-0.009-0.661l2.125-3.844c0.087-0.157 0.237-0.273 0.412-0.32 0.18-0.045 0.361-0.020 0.519 0.072l1.556 0.935 1.653-2.763c0.131-0.217 0.376-0.331 0.625-0.321 0.251 0.023 0.472 0.185 0.567 0.417l2.355 5.901c0.081 0.205 0.055 0.439-0.068 0.621-0.131 0.181-0.337 0.291-0.559 0.291zM14.492 18.667h6.487l-1.487-3.736-1.305 2.18c-0.089 0.152-0.241 0.261-0.413 0.305-0.172 0.036-0.356 0.016-0.505-0.079l-1.535-0.92-1.241 2.249zM27 32h-20.625c-1.493 0-2.708-1.215-2.708-2.708v-26.584c0-1.493 1.215-2.708 2.708-2.708h20.625c2.573 0 4.667 2.093 4.667 4.667v22.667c0 2.573-2.093 4.667-4.667 4.667zM6.375 1.333c-0.757 0-1.375 0.617-1.375 1.375v26.584c0 0.757 0.617 1.375 1.375 1.375h20.625c1.839 0 3.333-1.495 3.333-3.333v-22.667c0-1.839-1.495-3.333-3.333-3.333h-20.625zM6.333 9.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM6.333 13.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM6.333 17.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM6.333 21.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM6.333 25.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Photo-Album3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M29.667 32h-25.959c-1.493 0-2.708-1.215-2.708-2.708v-26.584c0-1.493 1.215-2.708 2.708-2.708h25.959c2.573 0 4.667 2.093 4.667 4.667v22.667c0 2.573-2.093 4.667-4.667 4.667zM3.708 1.333c-0.757 0-1.375 0.617-1.375 1.375v26.584c0 0.757 0.617 1.375 1.375 1.375h25.959c1.839 0 3.333-1.495 3.333-3.333v-22.667c0-1.839-1.495-3.333-3.333-3.333h-25.959zM3.667 9.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM3.667 13.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM3.667 17.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM3.667 21.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM3.667 25.333h-5.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM25.94 25.333h-15.213c-1.917 0-3.060-1.823-3.060-3.585v-7.156c0-1.895 1.229-3.921 3.060-3.921h6.461l0.657-1.027c0.124-0.195 0.335-0.307 0.561-0.307h4.473c0.221 0 0.429 0.111 0.553 0.297l0.7 1.035h1.805c1.831 0 3.060 2.028 3.060 3.921v7.156c0.001 1.764-1.141 3.587-3.059 3.587zM10.727 12c-0.987 0-1.727 1.367-1.727 2.588v7.156c0 1.107 0.645 2.252 1.727 2.252h15.213c1.081 0 1.727-1.145 1.727-2.252v-7.156c0-1.221-0.74-2.588-1.727-2.588h-2.163c-0.221 0-0.428-0.111-0.553-0.295l-0.697-1.039h-3.753l-0.659 1.027c-0.123 0.193-0.335 0.307-0.561 0.307h-6.827zM21.019 22.861c-2.833 0-5.139-2.307-5.139-5.141s2.305-5.141 5.139-5.141c2.836 0 5.14 2.307 5.14 5.141s-2.304 5.141-5.14 5.141zM21.019 13.912c-2.099 0-3.805 1.708-3.805 3.808s1.707 3.808 3.805 3.808 3.807-1.708 3.807-3.808-1.708-3.808-3.807-3.808zM14.333 12h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM12.333 22c-0.367 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Photo' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M25.895 32h-19.789c-3.367 0-6.105-2.739-6.105-6.104v-19.792c0-3.365 2.739-6.104 6.105-6.104h19.789c3.365 0 6.105 2.739 6.105 6.104v19.792c0 3.365-2.74 6.104-6.105 6.104zM6.105 1.333c-2.632 0-4.772 2.14-4.772 4.771v19.792c0 2.631 2.14 4.771 4.772 4.771h19.789c2.632 0 4.772-2.14 4.772-4.771v-19.792c0-2.631-2.14-4.771-4.772-4.771h-19.789zM1.333 25.333h29.333v1.333h-29.333v-1.333zM28.289 22.667h-24.904c-0.251 0-0.48-0.14-0.595-0.364s-0.092-0.489 0.056-0.695l7.252-9.924c0.193-0.264 0.549-0.351 0.843-0.199l3.124 1.597 5.104-6.827c0.136-0.184 0.349-0.285 0.579-0.267 0.224 0.016 0.427 0.14 0.537 0.34l8.584 15.349c0.117 0.207 0.115 0.46-0.005 0.663-0.119 0.204-0.337 0.325-0.575 0.325zM4.699 21.333h22.453l-7.529-13.461-4.825 6.459c-0.195 0.261-0.547 0.344-0.837 0.195l-3.119-1.597-6.143 8.405zM7.013 9.672c-1.368 0-2.48-1.113-2.48-2.479s1.112-2.477 2.48-2.477c1.367 0 2.479 1.112 2.479 2.477s-1.112 2.479-2.479 2.479zM7.013 6.045c-0.633 0-1.147 0.515-1.147 1.144 0 0.635 0.515 1.145 1.147 1.145s1.145-0.515 1.145-1.145c0-0.629-0.515-1.144-1.145-1.144z',
      ),
      'Photos' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M23.112 31.997h-16.889c-3.064 0-5.556-2.492-5.556-5.555v-18.223c0-3.063 2.492-5.555 5.556-5.555h16.889c3.063 0 5.555 2.492 5.555 5.555v18.223c0 3.063-2.492 5.555-5.555 5.555zM6.223 3.999c-2.328 0-4.223 1.893-4.223 4.221v18.223c0 2.328 1.895 4.221 4.223 4.221h16.889c2.328 0 4.221-1.893 4.221-4.221v-18.223c0-2.328-1.893-4.221-4.221-4.221h-16.889zM27.635 28.713l-0.448-1.255c1.684-0.599 2.813-2.195 2.813-3.976v-17.927c0-2.329-1.893-4.223-4.221-4.223h-16.297c-1.588 0-3.028 0.884-3.759 2.305l-1.187-0.609c0.96-1.867 2.855-3.028 4.944-3.028h16.299c3.063 0 5.555 2.492 5.555 5.555v17.928c0 2.339-1.487 4.443-3.699 5.229zM2 25.331h25.333v1.333h-25.333v-1.333zM24.965 21.331h-21.187c-0.251 0-0.479-0.139-0.592-0.361-0.115-0.221-0.095-0.484 0.051-0.691l6.519-9.131c0.185-0.26 0.527-0.352 0.817-0.221l2.776 1.248 4.569-5.988c0.141-0.185 0.371-0.283 0.603-0.255 0.232 0.027 0.435 0.171 0.531 0.383l6.519 14.075c0.096 0.205 0.081 0.445-0.041 0.639-0.125 0.188-0.337 0.303-0.564 0.303zM5.075 19.997h18.845l-5.615-12.124-4.22 5.528c-0.189 0.249-0.521 0.328-0.804 0.203l-2.757-1.241-5.449 7.635zM7.036 10.295c-1.265 0-2.296-1.028-2.296-2.297s1.029-2.297 2.296-2.297c1.268 0.001 2.297 1.028 2.297 2.299s-1.029 2.296-2.297 2.296zM7.036 7.035c-0.531 0-0.963 0.429-0.963 0.964s0.432 0.964 0.963 0.964 0.964-0.431 0.964-0.964-0.432-0.964-0.964-0.964z',
      ),
      'Physics' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M20.333 31.333h-9.333c-0.265 0-0.505-0.157-0.611-0.401-0.107-0.247-0.057-0.528 0.124-0.72l4.667-5c0.252-0.271 0.723-0.271 0.975 0l4.667 5c0.181 0.195 0.229 0.473 0.124 0.72-0.107 0.244-0.347 0.401-0.612 0.401zM12.532 30h6.265l-3.133-3.357-3.132 3.357zM1.667 29.333c-0.272 0-0.528-0.168-0.628-0.439-0.127-0.347 0.053-0.729 0.4-0.856l29.333-10.667c0.348-0.125 0.728 0.052 0.855 0.4 0.127 0.347-0.053 0.729-0.399 0.855l-29.333 10.667c-0.076 0.027-0.152 0.040-0.228 0.040zM5.667 18c2.209 0 4 1.792 4 4s-1.791 4-4 4-4-1.792-4-4 1.791-4 4-4zM5.667 16.667c-2.941 0-5.333 2.393-5.333 5.333s2.392 5.333 5.333 5.333 5.333-2.393 5.333-5.333-2.392-5.333-5.333-5.333v0zM25 2c1.837 0 3.333 1.495 3.333 3.333s-1.496 3.333-3.333 3.333-3.333-1.495-3.333-3.333 1.496-3.333 3.333-3.333zM25 0.667c-2.579 0-4.667 2.088-4.667 4.667s2.088 4.667 4.667 4.667c2.577 0 4.667-2.088 4.667-4.667s-2.089-4.667-4.667-4.667v0z',
      ),
      'Pi' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M0.396 10.217c-0.368 0-0.667-0.299-0.667-0.667 0-5.284 4.299-9.584 9.584-9.584h22.291c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667h-22.292c-4.549 0-8.251 3.701-8.251 8.251 0.001 0.369-0.297 0.667-0.665 0.667zM25.891 32.033c-3.467 0-6.287-2.792-6.287-6.221v-24.511c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v24.511c0 2.695 2.223 4.888 4.953 4.888 2.732 0 4.953-2.209 4.953-4.925 0-0.368 0.3-0.667 0.667-0.667 0.368 0 0.667 0.299 0.667 0.667 0 3.452-2.82 6.259-6.287 6.259zM4.808 31.355c-0.277 0-0.537-0.175-0.632-0.451-0.119-0.351 0.068-0.727 0.417-0.848 8.161-2.775 9.997-22.671 9.997-29.421 0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667c0 0.269-0.297 27.080-10.901 30.685-0.072 0.024-0.144 0.035-0.215 0.035z',
      ),
      'Piano' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M31.013 25c-0.009-0.001-0.017-0.001-0.027 0h-30c-0.368 0-0.667-0.299-0.667-0.667v-15.333c0-4.779 3.963-8.667 8.833-8.667 4.959 0 8.003 4.46 8.823 8.879 0.7 3.789 3.423 4.791 6.305 5.852 3.421 1.259 7.295 2.684 7.369 9.081 0.019 0.061 0.028 0.125 0.028 0.192 0.001 0.364-0.297 0.663-0.665 0.663zM1.653 23.667h28.652c-0.233-5.051-3.139-6.121-6.483-7.352-2.961-1.089-6.319-2.325-7.159-6.861-0.719-3.876-3.319-7.788-7.511-7.788-4.065 0-7.5 3.359-7.5 7.333v14.668zM28.987 31.667h-26.667c-0.368 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667h26.667c0.367 0 0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM2.987 30.333h25.333v-5.333h-25.333v5.333zM7.653 28.333c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667 0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM11.653 28.333c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667 0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM15.653 28.333c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667 0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM19.653 28.333c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667 0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM23.653 28.333c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667 0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667z',
      ),
      'Picasa' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M23.333 14.66c-0.175 0-0.344-0.068-0.472-0.195l-12.444-12.441c-0.163-0.163-0.228-0.396-0.177-0.619 0.049-0.224 0.211-0.407 0.427-0.483 4.332-1.531 9.081-1.115 12.987 1.021 0.211 0.116 0.347 0.341 0.347 0.584v11.471c0 0.269-0.164 0.513-0.415 0.616-0.080 0.028-0.168 0.045-0.252 0.045zM12.139 1.857l10.528 10.525v-9.456c-3.2-1.632-6.979-2.052-10.528-1.069zM30.112 22.66h-6.779c-0.367 0-0.667-0.301-0.667-0.667v-19.467c0-0.239 0.123-0.455 0.325-0.576 0.2-0.123 0.453-0.127 0.661-0.012 5.149 2.809 8.347 8.197 8.347 14.052 0 2.169-0.427 4.275-1.273 6.259-0.107 0.251-0.347 0.411-0.615 0.411zM24 21.327h5.664c0.667-1.699 1.003-3.492 1.003-5.333 0-4.985-2.528-9.597-6.667-12.293v17.627zM23.333 22.66h-14.667c-0.368 0-0.667-0.301-0.667-0.667v-7.103l-6.32 5.691c-0.171 0.152-0.411 0.209-0.633 0.14-0.221-0.064-0.393-0.24-0.456-0.461-0.393-1.42-0.591-2.857-0.591-4.267 0-6.752 4.285-12.808 10.667-15.072 0.245-0.081 0.513-0.024 0.695 0.16l12.444 12.443c0.124 0.123 0.195 0.292 0.195 0.469v8c0 0.368-0.3 0.667-0.667 0.667zM9.333 21.327h13.333v-7.057l-6.621-6.621-6.712 6.043v7.636zM10.721 2.324c-5.633 2.176-9.388 7.616-9.388 13.669 0 0.939 0.097 1.891 0.289 2.843l6.521-5.864c0.056-0.080 0.128-0.14 0.208-0.192l6.751-6.076-4.381-4.38zM8.667 30.131c-0.111 0-0.22-0.028-0.32-0.084-3.779-2.061-6.605-5.629-7.755-9.788-0.067-0.247 0.009-0.503 0.196-0.672l7.432-6.693c0.196-0.173 0.476-0.215 0.717-0.112 0.24 0.108 0.395 0.349 0.395 0.609v16.071c0 0.237-0.124 0.453-0.327 0.573-0.104 0.061-0.223 0.096-0.339 0.096zM1.992 20.3c1.005 3.276 3.153 6.121 6.008 7.985v-13.395l-6.008 5.409zM16 31.993c-2.672 0-5.319-0.673-7.653-1.948-0.213-0.116-0.347-0.343-0.347-0.581v-7.472c0-0.364 0.299-0.667 0.667-0.667h21.445c0.224 0 0.435 0.112 0.557 0.303 0.123 0.188 0.143 0.419 0.057 0.631-2.519 5.912-8.303 9.735-14.727 9.735zM9.333 29.059c2.053 1.049 4.349 1.601 6.667 1.601 5.548 0 10.571-3.108 13.065-8h-19.732v6.399z',
      ),
      'Pie-Chart' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 1.333c8.085 0 14.667 6.58 14.667 14.667 0 8.088-6.581 14.667-14.667 14.667-8.087 0-14.667-6.579-14.667-14.667 0-8.087 6.58-14.667 14.667-14.667zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0zM16 16.667c-0.1 0-0.201-0.023-0.297-0.071l-13.333-6.667c-0.329-0.165-0.463-0.565-0.299-0.895s0.565-0.463 0.895-0.299l13.333 6.667c0.329 0.165 0.461 0.567 0.299 0.895-0.119 0.235-0.353 0.369-0.597 0.369zM9.333 30c-0.1 0-0.201-0.024-0.297-0.071-0.329-0.167-0.463-0.565-0.299-0.896l6.667-13.333c0.064-0.129 0.169-0.233 0.299-0.299l13.333-6.667c0.328-0.165 0.729-0.031 0.895 0.299s0.029 0.729-0.299 0.895l-13.136 6.567-6.567 13.135c-0.117 0.235-0.352 0.371-0.596 0.371z',
      ),
      'Pie-Chart2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.011 31.317c-8.463 0-15.347-6.879-15.347-15.333 0-8.248 6.443-14.969 14.667-15.301 0.165-0.004 0.357 0.059 0.488 0.185 0.131 0.125 0.205 0.299 0.205 0.48v13.028l9.553-9.527c0.253-0.255 0.667-0.26 0.928-0.013 3.116 2.937 4.831 6.895 4.831 11.145 0 8.459-6.875 15.336-15.325 15.336zM14.691 2.060c-7.284 0.633-12.695 6.503-12.695 13.924 0 7.72 6.287 14 14.013 14 7.715 0 13.993-6.28 13.993-14 0-3.665-1.399-7.092-3.953-9.723l-10.223 10.195c-0.191 0.191-0.476 0.247-0.727 0.144-0.249-0.104-0.411-0.347-0.411-0.616v-13.924zM18.024 10.751c-0.085 0-0.172-0.016-0.255-0.051-0.249-0.105-0.412-0.347-0.412-0.616v-8.639c0-0.189 0.081-0.369 0.221-0.496s0.328-0.188 0.519-0.167c2.488 0.269 4.401 0.979 6.599 2.447 0.167 0.112 0.273 0.291 0.295 0.489 0.020 0.197-0.052 0.396-0.193 0.536l-6.303 6.3c-0.128 0.128-0.299 0.196-0.471 0.196zM18.691 2.205v6.269l4.579-4.576c-1.312-0.801-2.688-1.397-4.579-1.693z',
      ),
      'Pie-Chart3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.169 13.56c-0.012 0-0.024 0-0.036-0.001-0.196-0.011-0.379-0.108-0.497-0.265l-7.284-9.712c-0.117-0.156-0.159-0.352-0.12-0.54 0.040-0.188 0.16-0.351 0.328-0.444 2.271-1.264 4.841-1.931 7.44-1.931 3.185 0 6.248 0.979 8.857 2.831 0.157 0.112 0.256 0.285 0.277 0.477 0.019 0.192-0.045 0.383-0.177 0.524l-8.3 8.852c-0.128 0.133-0.303 0.209-0.488 0.209zM9.889 3.408l6.337 8.451 7.223-7.699c-4.024-2.544-9.283-2.832-13.56-0.752zM24.284 28.767c-0.055 0-0.112-0.007-0.167-0.023-0.185-0.047-0.344-0.175-0.428-0.347l-5.873-11.748c-0.125-0.249-0.081-0.551 0.111-0.753l8.981-9.581c0.132-0.14 0.293-0.216 0.511-0.211 0.192 0.008 0.371 0.097 0.493 0.247 2.205 2.721 3.421 6.147 3.421 9.649 0 5.055-2.495 9.784-6.669 12.649-0.115 0.077-0.247 0.117-0.38 0.117zM19.216 16.469l5.312 10.629c3.439-2.645 5.472-6.74 5.472-11.097 0-2.94-0.94-5.823-2.659-8.2l-8.125 8.668zM16 31.333c-8.455 0-15.333-6.879-15.333-15.333 0-4.123 1.615-7.992 4.549-10.896 0.137-0.136 0.327-0.208 0.517-0.191 0.192 0.013 0.369 0.111 0.484 0.265l8.608 11.475 6.476 12.929c0.084 0.172 0.092 0.373 0.020 0.552-0.073 0.177-0.219 0.315-0.403 0.377-1.608 0.545-3.26 0.821-4.919 0.821zM5.621 6.607c-2.341 2.58-3.621 5.887-3.621 9.393 0 7.72 6.28 14 14 14 1.261 0 2.523-0.176 3.757-0.524l-6.061-12.125-8.075-10.744z',
      ),
      'Pilates-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M4.725 14.665c-1.101 0-2-0.897-2-2s0.899-2 2-2c1.103 0 2 0.897 2 2s-0.897 2-2 2zM4.725 11.999c-0.367 0-0.667 0.3-0.667 0.667s0.301 0.667 0.667 0.667c0.367 0 0.667-0.3 0.667-0.667s-0.299-0.667-0.667-0.667zM14.717 31.999c-5.145 0-9.333-4.188-9.333-9.333s4.188-9.333 9.333-9.333c5.147 0 9.333 4.188 9.333 9.333s-4.187 9.333-9.333 9.333zM14.717 14.665c-4.412 0-8 3.588-8 8s3.588 8 8 8c4.413 0 8-3.588 8-8s-3.587-8-8-8zM25.107 13.937c-0.099 0-0.196-0.023-0.292-0.068-0.331-0.161-0.468-0.561-0.305-0.892l6.165-12.603c0.163-0.331 0.564-0.463 0.893-0.305 0.329 0.161 0.468 0.563 0.305 0.893l-6.165 12.601c-0.117 0.237-0.352 0.373-0.601 0.373zM11.373 22.749c-0.321 0-0.604-0.232-0.657-0.56l-1.967-12.155-8.505-8.907c-0.253-0.267-0.245-0.691 0.023-0.943 0.265-0.255 0.688-0.245 0.943 0.021l8.648 9.055c0.092 0.099 0.155 0.221 0.176 0.357l2 12.361c0.059 0.361-0.188 0.703-0.552 0.761-0.037 0.005-0.072 0.008-0.108 0.008zM24.051 31.999c-0.295 0-0.564-0.197-0.643-0.496-0.095-0.356 0.117-0.721 0.472-0.813 2.553-0.677 4.204-3.825 4.204-8.025 0-7.353-5.996-13.332-13.367-13.332-1.761 0-3.476 0.337-5.092 1.003-0.341 0.145-0.731-0.021-0.872-0.363s0.023-0.729 0.361-0.867c1.779-0.733 3.664-1.104 5.601-1.104 8.105 0 14.7 6.581 14.7 14.665 0 4.821-2.040 8.475-5.196 9.311-0.056 0.015-0.113 0.021-0.169 0.021z',
      ),
      'Pilates-3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M18.643 13.605c-1.103 0-2-0.897-2-2s0.897-2 2-2c1.101 0 2 0.897 2 2s-0.897 2-2 2zM18.643 10.939c-0.368 0-0.667 0.3-0.667 0.667s0.299 0.667 0.667 0.667c0.367 0 0.667-0.3 0.667-0.667s-0.299-0.667-0.667-0.667zM8.635 13.485c-3.676 0-6.667-2.937-6.667-6.547 0-3.608 2.991-6.543 6.667-6.543s6.667 2.935 6.667 6.543c0 3.609-2.991 6.547-6.667 6.547zM8.635 1.728c-2.941 0-5.333 2.337-5.333 5.209 0 2.875 2.392 5.213 5.333 5.213s5.333-2.339 5.333-5.213c0-2.872-2.392-5.209-5.333-5.209zM18.633 8.313c-0.293 0-0.56-0.195-0.641-0.492-0.747-2.735-1.943-3.716-4.579-3.753-0.369-0.007-0.664-0.309-0.659-0.677 0.005-0.364 0.303-0.657 0.667-0.657 0.003 0 0.007 0 0.009 0 3.249 0.047 4.943 1.417 5.845 4.739 0.097 0.357-0.112 0.721-0.469 0.817-0.056 0.016-0.116 0.024-0.173 0.024zM11.959 17.648c-1.016 0-2.015-0.195-2.851-0.727-1.257-0.801-1.896-2.197-1.896-4.151 0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667c0 1.489 0.417 2.477 1.277 3.028 1.847 1.169 5.351 0.083 7.128-0.751 0.335-0.156 0.732-0.013 0.887 0.32 0.156 0.333 0.015 0.732-0.319 0.888-0.641 0.295-3.148 1.392-5.56 1.392zM21.303 31.604c-0.368 0-0.667-0.3-0.667-0.667v-9.959c0-0.257 0.148-0.495 0.383-0.604 0.232-0.112 0.511-0.079 0.709 0.088l8.064 6.691c0.284 0.235 0.323 0.653 0.085 0.937s-0.653 0.323-0.937 0.085l-6.972-5.779v8.539c0.001 0.369-0.299 0.668-0.665 0.668zM21.303 21.645c-0.305 0-0.583-0.213-0.651-0.527l-1.333-6.039c-0.081-0.361 0.148-0.716 0.507-0.797 0.363-0.084 0.715 0.145 0.795 0.508l1.333 6.039c0.080 0.361-0.147 0.716-0.507 0.797-0.051 0.013-0.097 0.019-0.144 0.019z',
      ),
      'Pilates' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.049 30.055c-7.749 0-14.056-6.304-14.056-14.055s6.305-14.055 14.056-14.055 14.055 6.304 14.055 14.055c0 7.751-6.304 14.055-14.055 14.055zM16.049 3.277c-7.015 0-12.723 5.705-12.723 12.721s5.708 12.723 12.723 12.723c7.016 0 12.721-5.705 12.721-12.723 0-7.015-5.705-12.721-12.721-12.721zM3.771 9.889c-0.157 0-0.312-0.055-0.441-0.167l-1.388-1.223c-0.257-0.228-0.301-0.616-0.096-0.893l3.943-5.388c0.123-0.168 0.316-0.269 0.525-0.273 0.24 0.011 0.407 0.088 0.536 0.252l1.959 2.48c0.228 0.289 0.179 0.707-0.111 0.936s-0.708 0.18-0.937-0.111l-1.413-1.795-3.067 4.192 0.931 0.82c0.276 0.247 0.304 0.664 0.059 0.94-0.131 0.152-0.313 0.229-0.499 0.229zM28.228 9.889c-0.185 0-0.368-0.077-0.5-0.227-0.244-0.276-0.217-0.696 0.061-0.94l0.929-0.82-3.067-4.189-1.413 1.793c-0.229 0.291-0.647 0.339-0.937 0.111-0.289-0.228-0.339-0.645-0.109-0.936l1.956-2.48c0.129-0.164 0.323-0.203 0.533-0.252 0.207 0.004 0.404 0.104 0.528 0.273l3.945 5.388c0.204 0.277 0.161 0.665-0.097 0.893l-1.389 1.223c-0.127 0.107-0.284 0.163-0.44 0.163z',
      ),
      'Pilot' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28.5 31.667c-0.367 0-0.667-0.299-0.667-0.667 0-2.695-2.193-4.888-4.889-4.888-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667c3.431 0 6.223 2.791 6.223 6.221 0 0.368-0.3 0.667-0.667 0.667zM3.5 31.667c-0.368 0-0.667-0.299-0.667-0.667 0-3.431 2.791-6.221 6.223-6.221 0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667c-2.695 0-4.889 2.193-4.889 4.888 0 0.368-0.299 0.667-0.667 0.667zM16.035 26.112c-3.709 0-7.476-4.829-7.789-8.565-1.067-0.509-2.412-2.004-2.412-2.867v-1.563c0-0.529 0-1.836 1.333-2.156v-3.961c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v4.555c0 0.368-0.299 0.667-0.667 0.667-0.647 0-0.667 0.14-0.667 0.896v1.563c0.077 0.401 1.321 1.639 1.749 1.712 0.368 0 0.643 0.299 0.643 0.665 0 3.119 3.412 7.721 6.476 7.721 3.021 0 6.26-4.528 6.26-7.721 0-0.367 0.297-0.667 0.667-0.667 0.384-0.084 1.483-1.295 1.54-1.725v-1.548c0-0.751-0.020-0.896-0.667-0.896-0.368 0-0.667-0.299-0.667-0.667v-4.555c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v3.961c1.333 0.32 1.333 1.625 1.333 2.156v1.563c0 0.815-1.192 2.337-2.225 2.861-0.292 3.804-3.895 8.571-7.575 8.571zM24.5 7h-17.333c-0.307 0-0.575-0.209-0.648-0.508l-0.911-3.721c-0.071-0.289 0.057-0.588 0.315-0.737l2.8-1.612c0.101-0.057 0.216-0.088 0.333-0.088h13.889c0.116 0 0.232 0.031 0.333 0.088l2.8 1.612c0.276 0.159 0.401 0.485 0.301 0.789l-1.244 3.721c-0.095 0.272-0.349 0.456-0.636 0.456zM7.691 5.667h16.331l0.919-2.751-2.173-1.251h-13.533l-2.212 1.275 0.669 2.727zM16 30.279c-0.119 0-0.237-0.031-0.343-0.095l-6.944-4.167c-0.316-0.189-0.417-0.597-0.228-0.915 0.189-0.316 0.597-0.42 0.915-0.229l6.601 3.961 6.601-3.961c0.316-0.195 0.725-0.087 0.916 0.229 0.188 0.312 0.085 0.725-0.229 0.915l-6.944 4.167c-0.108 0.064-0.227 0.095-0.345 0.095zM15.833 10.333c-3.199 0-8.611-0.561-8.611-2.667 0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667c0.225 0.449 2.86 1.333 7.277 1.333s7.053-0.884 7.285-1.379c0-0.368 0.296-0.644 0.663-0.644s0.663 0.321 0.663 0.693c0 2.101-5.413 2.663-8.611 2.663z',
      ),
      'Pinch' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M19.24 11.333c-0.367 0-0.667-0.3-0.667-0.667v-5.4c0-0.687-0.611-1.267-1.333-1.267s-1.333 0.568-1.333 1.24v5.427c0 0.367-0.299 0.667-0.667 0.667s-0.667-0.3-0.667-0.667v-5.427c0-1.417 1.196-2.573 2.667-2.573 1.445 0 2.667 1.193 2.667 2.6v5.4c0 0.367-0.3 0.667-0.667 0.667zM15.24 11.333c-0.368 0-0.667-0.3-0.667-0.667v-5.4c0-0.687-0.611-1.267-1.333-1.267-0.292 0-0.584 0.093-0.82 0.267-0.299 0.219-0.713 0.152-0.931-0.144-0.217-0.295-0.155-0.713 0.144-0.928 0.463-0.339 1.032-0.528 1.607-0.528 1.445 0 2.667 1.195 2.667 2.601v5.399c0 0.367-0.299 0.667-0.667 0.667zM23.24 11.333c-0.367 0-0.667-0.3-0.667-0.667v-5.4c0-0.687-0.611-1.267-1.333-1.267s-1.333 0.568-1.333 1.24v5.427c0 0.367-0.3 0.667-0.667 0.667s-0.667-0.3-0.667-0.667v-5.427c0-1.417 1.195-2.573 2.667-2.573 1.445 0 2.667 1.193 2.667 2.6v5.4c0 0.367-0.3 0.667-0.667 0.667zM21.823 29.333h-7.533c-3.164 0-5.409-4.885-7.389-9.195-0.749-1.631-1.456-3.169-2.045-4-0.864-1.213-0.813-2.719 0.123-3.656 1.040-1.037 2.705-1.068 3.711-0.063l3.029 3.117c0.256 0.263 0.251 0.688-0.013 0.943-0.264 0.256-0.687 0.251-0.943-0.013l-3.023-3.109c-0.472-0.472-1.308-0.445-1.82 0.067-0.545 0.547-0.372 1.391 0.021 1.943 0.661 0.932 1.36 2.453 2.169 4.213 1.635 3.556 3.869 8.42 6.179 8.42h7.397c0.76-0.336 4.887-2.361 4.887-6.697v-16.033c0-0.689-0.611-1.267-1.333-1.267s-1.333 0.568-1.333 1.24v5.425c0 0.365-0.299 0.667-0.667 0.667s-0.667-0.301-0.667-0.667v-5.425c0-1.417 1.196-2.575 2.667-2.575 1.445 0 2.667 1.195 2.667 2.6v16.033c0 5.587-5.597 7.888-5.836 7.981-0.077 0.035-0.161 0.051-0.247 0.051zM11.907 16h-1.333v-4.912l-2.649 1.36c-1.255 0.639-2.873 0.093-3.531-1.193-0.327-0.639-0.388-1.395-0.168-2.080 0.211-0.651 0.652-1.179 1.244-1.479l6.167-4.503 0.785 1.080-6.256 4.556c-0.363 0.195-0.569 0.444-0.671 0.756-0.112 0.351-0.083 0.737 0.085 1.063 0.331 0.641 1.121 0.921 1.736 0.609l3.619-1.855c0.207-0.105 0.453-0.097 0.652 0.027 0.199 0.123 0.319 0.339 0.319 0.571l0.001 6z',
      ),
      'Ping-Pong' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M5.455 28.384c-0.171 0-0.341-0.065-0.472-0.195l-3.772-3.771c-0.127-0.125-0.195-0.295-0.195-0.472s0.071-0.347 0.195-0.472l5.397-5.399c-1.907-3.816-1.171-8.492 1.868-11.532 1.891-1.888 4.401-2.928 7.073-2.928 2.671 0 5.183 1.040 7.071 2.928 3.899 3.899 3.899 10.244 0 14.141-1.888 1.888-4.397 2.924-7.067 2.924v0c-1.431 0-2.857-0.307-4.152-0.899l-5.475 5.472c-0.131 0.136-0.301 0.201-0.472 0.201zM2.627 23.947l2.829 2.828 5.34-5.339c0.205-0.203 0.521-0.251 0.777-0.121 1.221 0.632 2.599 0.965 3.981 0.965v0c2.313 0 4.488-0.901 6.124-2.533 3.379-3.38 3.379-8.877 0-12.255-1.637-1.639-3.813-2.536-6.128-2.536s-4.492 0.901-6.129 2.536c-2.74 2.741-3.32 7.011-1.413 10.385 0.148 0.259 0.103 0.585-0.109 0.801l-5.272 5.268zM7.352 17.361l4.715 4.717-0.943 0.943-4.715-4.717 0.943-0.943zM28.317 19.54c-0.712 0-1.383-0.276-1.885-0.779-0.503-0.505-0.78-1.175-0.78-1.885 0-0.713 0.277-1.383 0.78-1.885 1.007-1.008 2.763-1.008 3.772 0 1.039 1.036 1.039 2.729 0 3.771-0.504 0.504-1.176 0.779-1.887 0.779zM28.317 15.543c-0.357 0-0.692 0.139-0.943 0.391-0.252 0.251-0.389 0.584-0.389 0.943 0 0.356 0.139 0.692 0.389 0.943 0.503 0.5 1.383 0.5 1.887 0 0.519-0.523 0.519-1.365 0-1.885-0.252-0.249-0.588-0.391-0.944-0.391z',
      ),
      'Pinterest' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 1.277c8.117 0 14.723 6.604 14.723 14.723s-6.604 14.723-14.723 14.723-14.723-6.604-14.723-14.723 6.605-14.723 14.723-14.723zM16-0.056c-8.868 0-16.056 7.188-16.056 16.056 0 8.864 7.188 16.056 16.056 16.056 8.867 0 16.056-7.192 16.056-16.056-0.001-8.868-7.189-16.056-16.056-16.056v0zM10.737 30.86c-0.063 0-0.128-0.012-0.192-0.028-0.353-0.105-0.553-0.473-0.447-0.829l2.521-8.405c-0.693-1.221-1.075-2.868-1.075-4.641 0-2.392 0.719-4.967 2.295-4.967 0.847 0 1.315 0.413 1.557 0.757 0.979 1.391 0.039 4.207-0.16 4.757l-1.161 3.873c0.556 0.753 1.376 1.316 2.58 1.316 3.375 0 7.315-1.92 7.315-7.333 0-4.328-2.516-8.708-7.319-8.708-3.5 0-8.708 1.964-8.708 7.375 0 2.34 0.809 4.053 2.223 4.697 0.335 0.152 0.481 0.548 0.328 0.883-0.152 0.335-0.544 0.485-0.884 0.328-1.907-0.869-3-3.028-3-5.912 0-6.389 6.005-8.708 10.041-8.708 5.681 0 8.652 5.052 8.652 10.041 0 5.984-4.344 8.667-8.648 8.667-1.185 0-2.211-0.391-3.031-1.145l-2.249 7.501c-0.087 0.292-0.352 0.481-0.639 0.481zM13.84 13.319c-0.368 0.061-1.139 1.924-0.925 4.508 0.031 0.373 0.111 1.028 0.315 1.739l0.744-2.476c0.407-1.137 0.768-2.961 0.333-3.577-0.067-0.096-0.175-0.193-0.467-0.193z',
      ),
      'Pipe' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26.144 19.043h-4c-0.368 0-0.667-0.3-0.667-0.667v-14.667c0-0.368 0.299-0.667 0.667-0.667h4c0.368 0 0.667 0.299 0.667 0.667v14.667c0 0.368-0.297 0.667-0.667 0.667zM22.811 17.709h2.667v-13.333h-2.667v13.333zM22.144 17.709h-20.667c-0.368 0-0.667-0.3-0.667-0.667 0-0.368 0.299-0.667 0.667-0.667h20v-10.667h-20c-0.368 0-0.667-0.3-0.667-0.667 0-0.368 0.299-0.667 0.667-0.667h20.667c0.368 0 0.667 0.299 0.667 0.667v12c0 0.368-0.297 0.667-0.667 0.667zM27.189 28.957c-2.205 0-4-1.795-4-4 0-2.124 1.816-3.816 3.592-5.193 0.24-0.188 0.577-0.188 0.815 0 1.776 1.376 3.592 3.069 3.592 5.193 0.001 2.205-1.795 4-3.999 4zM27.189 21.14c-1.379 1.111-2.667 2.408-2.667 3.816 0 1.472 1.196 2.667 2.667 2.667s2.667-1.195 2.667-2.667c0-1.408-1.291-2.705-2.667-3.816z',
      ),
      'Pipette' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 24.917c-0.112 0-0.225-0.028-0.331-0.088l-4.667-2.667c-0.208-0.12-0.336-0.341-0.336-0.579v-10.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v10.28l4.331 2.475c0.32 0.181 0.429 0.588 0.248 0.909-0.123 0.216-0.348 0.336-0.579 0.336zM16 24.917c-0.232 0-0.456-0.12-0.58-0.336-0.183-0.319-0.072-0.727 0.248-0.909l4.332-2.476v-10.28c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v10.667c0 0.239-0.128 0.46-0.336 0.579l-4.667 2.667c-0.104 0.060-0.219 0.089-0.331 0.089zM22.667 10.917h-13.333c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h13.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM20.667 11.584c-0.367 0-0.667-0.299-0.667-0.667v-5c0-2.257-1.832-4.167-4-4.167-2.243 0-4 1.684-4 3.833v5.333c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.3-0.667-0.667v-5.333c0-2.897 2.343-5.167 5.333-5.167 2.891 0 5.333 2.52 5.333 5.5v5c0 0.367-0.3 0.667-0.667 0.667zM16 31.584c-1.103 0-2-0.897-2-2 0-0.776 0.624-3.333 2-3.333s2 2.557 2 3.333c0 1.103-0.897 2-2 2zM16 27.639c-0.285 0.32-0.667 1.393-0.667 1.944 0 0.367 0.299 0.667 0.667 0.667s0.667-0.3 0.667-0.667c0-0.551-0.381-1.623-0.667-1.944z',
      ),
      'Piramids' => 
      array (
        'height' => '32',
        'width' => '33',
        'path' => 'M24.113 26.797c-0.009 0-0.017 0-0.028 0h-23.419c-0.239 0-0.459-0.128-0.577-0.333s-0.119-0.461 0-0.667l11.711-20.284c0.239-0.413 0.917-0.413 1.155 0l11.629 20.143c0.123 0.121 0.195 0.288 0.195 0.472 0.001 0.369-0.297 0.669-0.665 0.669zM1.821 25.464h21.111l-10.556-18.284-10.555 18.284zM32.784 22.797h-10.019c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h8.869l-7.631-13.373-4.92 8.576c-0.185 0.319-0.589 0.427-0.912 0.248-0.317-0.185-0.429-0.589-0.248-0.912l5.503-9.585c0.119-0.208 0.339-0.335 0.579-0.335v0c0.24 0 0.461 0.129 0.581 0.336l8.773 15.384c0.12 0.205 0.12 0.459-0.003 0.664-0.117 0.203-0.336 0.331-0.573 0.331z',
      ),
      'Pisces-2' => 
      array (
        'height' => '32',
        'width' => '40',
        'path' => 'M22.572 27.691c-4.437 0-8.108-1.899-9.777-3.779-3.049-3.435-3.559-6.849-3.577-9.528-1.139-0.221-2.459 0.972-3.719 2.107-1.276 1.151-2.595 2.343-4.036 2.343v0c-0.367 0-0.727-0.080-1.068-0.232-0.293-0.132-0.451-0.455-0.373-0.765 0.079-0.308 0.379-0.532 0.687-0.508v0c0.979 0 1.989-1.82 3.063-3.749 1.863-3.361 4.187-7.543 8.667-7.543 0.745 0 1.528 0.121 2.336 0.361 2.145-1.328 4.844-2.084 7.449-2.084 4.177 0 8.908 2.060 9.645 7.841 0.028 0.227-0.060 0.453-0.237 0.599l-0.333 0.28c-1.328 1.132-4.437 3.768-7.557 3.768-0.181 0-0.36-0.005-0.533-0.028 0.063 0.252 0.251 0.541 0.575 0.989 0.587 0.82 1.395 1.945 1.095 3.752-0.044 0.268-0.251 0.479-0.516 0.536-0.268 0.055-0.541-0.052-0.695-0.276-1.16-1.7-2.408-1.599-3.42-1.533-0.135 0.005-0.265 0.011-0.391 0.019 0.087 0.752 0.473 1.573 1.097 2.276 0.975 1.104 2.36 1.743 3.789 1.743 1.133 0 2.279-0.377 3.409-1.128-0.292-4.153 1.632-7.791 5.721-10.815 0.251-0.191 0.604-0.175 0.845 0.040 0.232 0.211 0.284 0.56 0.125 0.832-1.175 1.991-1.068 3.833-0.983 5.313 0.028 0.497 0.055 0.943 0.028 1.336 0.312 0.052 0.64 0.14 0.981 0.245 0.588 0.167 1.195 0.339 1.809 0.339 0.847 0 1.528-0.349 2.139-1.091 0.2-0.248 0.549-0.309 0.833-0.159 0.28 0.148 0.413 0.479 0.315 0.787-0.667 2.107-3.472 5.752-9.659 5.312-2.204 1.567-4.873 2.4-7.735 2.4zM8.941 13.021c0.417 0 0.825 0.088 1.217 0.264 0.243 0.108 0.397 0.353 0.395 0.617-0.052 3.779 0.917 6.509 3.24 9.124 1.424 1.604 4.779 3.331 8.78 3.331 2.66 0 5.133-0.799 7.141-2.301 0.133-0.099 0.297-0.141 0.459-0.135 3.563 0.305 5.861-0.863 7.181-2.224-0.972 0.167-2.020-0.097-2.851-0.333-0.555-0.155-1.149-0.247-1.221-0.212-0.261 0.1-0.557 0.027-0.745-0.187-0.185-0.211-0.216-0.515-0.084-0.753 0.148-0.273 0.109-0.932 0.071-1.635-0.055-0.972-0.125-2.172 0.161-3.503-3.659 3.659-3.305 7.085-3.177 8.317 0.027 0.239-0.083 0.471-0.273 0.609-1.464 1.055-2.976 1.584-4.497 1.584-1.812 0-3.557-0.801-4.788-2.192-1.049-1.192-1.584-2.661-1.423-3.948 0.025-0.189 0.123-0.359 0.275-0.465 0.153-0.109 0.344-0.141 0.528-0.109 0.176 0.036 0.503 0.028 0.843 0.009 0.843-0.044 1.948-0.139 3.168 0.669-0.171-0.363-0.407-0.695-0.647-1.029-0.544-0.751-1.159-1.615-0.667-2.8 0.128-0.304 0.451-0.467 0.776-0.391 0.3 0.079 0.609 0.112 0.933 0.112 2.632 0 5.48-2.417 6.696-3.451l0.057-0.049c-0.664-3.967-3.733-6.32-8.275-6.32-2.465 0-5.012 0.747-6.988 2.039-0.169 0.116-0.384 0.139-0.579 0.079-0.777-0.253-1.525-0.389-2.221-0.389-3.695 0-5.715 3.643-7.5 6.861-0.4 0.72-0.783 1.413-1.171 2.028 0.28-0.244 0.565-0.495 0.845-0.751 1.351-1.208 2.745-2.467 4.34-2.467zM22.949 16.664c-0.033 0-0.071-0.003-0.108-0.009-1.139-0.185-2.861-1.725-3.605-3.725-0.683-1.827-0.385-3.641 0.84-5.113 0.237-0.281 0.656-0.321 0.939-0.084 0.284 0.235 0.321 0.653 0.085 0.937-0.932 1.12-1.139 2.396-0.619 3.793 0.608 1.624 2.012 2.785 2.573 2.876 0.361 0.060 0.611 0.401 0.552 0.764-0.052 0.328-0.335 0.561-0.657 0.561zM26.416 10.565h-1.333c-0.365 0-0.667-0.3-0.667-0.667s0.301-0.667 0.667-0.667h1.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Pisces' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M0.667 29.679c-0.368 0-0.667-0.303-0.667-0.667 0-0.367 0.299-0.667 0.667-0.667 6.835 0 12.395-5.539 12.395-12.347 0-6.805-5.56-12.344-12.395-12.344-0.368 0-0.667-0.303-0.667-0.667 0-0.368 0.299-0.667 0.667-0.667 7.569 0 13.728 6.136 13.728 13.677 0.001 7.543-6.159 13.68-13.728 13.68zM31.333 29.679c-7.571 0-13.728-6.139-13.728-13.68s6.157-13.677 13.728-13.677c0.367 0 0.667 0.299 0.667 0.667 0 0.364-0.3 0.667-0.667 0.667-6.835 0-12.395 5.533-12.395 12.344 0 6.805 5.56 12.347 12.395 12.347 0.367 0 0.667 0.3 0.667 0.667 0 0.368-0.3 0.667-0.667 0.667zM22.785 16.644h-13.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h13.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Pizza-Slice' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M31.573 22.677c-0.367 0-0.667-0.3-0.667-0.667 0-11.419-9.289-20.708-20.708-20.708-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667c12.153 0 22.041 9.888 22.041 22.041 0 0.368-0.297 0.667-0.667 0.667zM0.428 32.031c-0.175 0-0.344-0.068-0.472-0.195-0.173-0.172-0.237-0.428-0.167-0.664l8.667-28.667c0.107-0.352 0.483-0.552 0.831-0.445 0.353 0.107 0.552 0.479 0.445 0.831l-8.307 27.476 27.476-8.307c0.352-0.105 0.724 0.093 0.831 0.445 0.107 0.353-0.091 0.724-0.445 0.831l-28.667 8.667c-0.063 0.020-0.128 0.028-0.192 0.028zM14.428 10.031c-1.837 0-3.333-1.496-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.496 3.333 3.333-1.496 3.333-3.333 3.333zM14.428 4.697c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM10.428 24.697c-1.837 0-3.333-1.496-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.496 3.333 3.333-1.496 3.333-3.333 3.333zM10.428 19.364c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM25.093 20.697c-1.836 0-3.333-1.496-3.333-3.333s1.497-3.333 3.333-3.333c1.839 0 3.333 1.496 3.333 3.333s-1.495 3.333-3.333 3.333zM25.093 15.364c-1.101 0-2 0.897-2 2s0.899 2 2 2c1.104 0 2-0.897 2-2s-0.896-2-2-2zM15.761 16.697c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.26-0.26-0.683 0-0.943l2.667-2.667c0.26-0.26 0.683-0.26 0.943 0s0.26 0.683 0 0.943l-2.667 2.667c-0.129 0.131-0.3 0.195-0.471 0.195zM3.761 28.697c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.259-0.26-0.683 0-0.943l2.667-2.667c0.26-0.259 0.683-0.259 0.943 0 0.26 0.26 0.26 0.684 0 0.943l-2.667 2.667c-0.129 0.131-0.3 0.195-0.471 0.195zM11.761 15.364c-0.171 0-0.341-0.065-0.472-0.195l-2.667-2.667c-0.26-0.26-0.26-0.683 0-0.943s0.683-0.26 0.943 0l2.667 2.667c0.26 0.26 0.26 0.683 0 0.943-0.129 0.131-0.3 0.195-0.471 0.195zM19.76 23.364c-0.169 0-0.341-0.065-0.472-0.195l-2.667-2.667c-0.26-0.259-0.26-0.683 0-0.943 0.26-0.259 0.683-0.259 0.943 0l2.667 2.667c0.26 0.26 0.26 0.684 0 0.943-0.129 0.131-0.299 0.195-0.471 0.195zM23.76 11.364c-0.169 0-0.341-0.065-0.472-0.195l-2.667-2.667c-0.26-0.26-0.26-0.683 0-0.943s0.683-0.26 0.943 0l2.667 2.667c0.26 0.26 0.26 0.683 0 0.943-0.129 0.131-0.299 0.195-0.471 0.195z',
      ),
      'Pizza' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 1.333c8.085 0 14.667 6.58 14.667 14.667 0 8.085-6.581 14.667-14.667 14.667-8.087 0-14.667-6.581-14.667-14.667 0-8.087 6.58-14.667 14.667-14.667zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0zM16 4c6.616 0 12 5.383 12 12s-5.384 12-12 12-12-5.383-12-12 5.384-12 12-12zM16 2.667c-7.364 0-13.333 5.969-13.333 13.333s5.969 13.333 13.333 13.333c7.361 0 13.333-5.969 13.333-13.333s-5.972-13.333-13.333-13.333v0zM16 8.667c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM16 6c-0.368 0-0.667 0.299-0.667 0.667s0.299 0.667 0.667 0.667 0.667-0.299 0.667-0.667-0.299-0.667-0.667-0.667zM16 27.333c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM16 24.667c-0.368 0-0.667 0.3-0.667 0.667s0.299 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.299-0.667-0.667-0.667zM6.667 18c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM6.667 15.333c-0.368 0-0.667 0.299-0.667 0.667s0.299 0.667 0.667 0.667 0.667-0.299 0.667-0.667-0.299-0.667-0.667-0.667zM25.333 18c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM25.333 15.333c-0.367 0-0.667 0.299-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.299 0.667-0.667-0.3-0.667-0.667-0.667zM9.401 11.401c-0.533 0-1.036-0.208-1.415-0.584-0.379-0.379-0.587-0.881-0.587-1.417 0-0.533 0.209-1.036 0.587-1.413 0.753-0.753 2.072-0.755 2.828 0 0.78 0.78 0.78 2.048 0 2.828-0.377 0.379-0.88 0.587-1.413 0.587zM9.401 8.735c-0.177 0-0.345 0.069-0.472 0.195-0.127 0.127-0.196 0.293-0.196 0.471 0 0.179 0.069 0.347 0.196 0.472 0.252 0.251 0.691 0.251 0.943 0 0.26-0.26 0.26-0.683 0-0.943-0.125-0.125-0.293-0.195-0.471-0.195zM22.6 24.6c-0.533 0-1.036-0.208-1.416-0.587-0.779-0.777-0.779-2.047 0-2.828 0.759-0.756 2.076-0.755 2.831 0 0.781 0.781 0.781 2.048 0 2.828-0.376 0.377-0.879 0.587-1.415 0.587zM22.6 21.932c-0.179 0-0.348 0.069-0.472 0.195-0.26 0.26-0.26 0.684 0 0.941 0.252 0.253 0.693 0.253 0.943 0 0.26-0.26 0.26-0.683 0-0.943-0.125-0.124-0.292-0.193-0.471-0.193v0zM9.4 24.6c-0.535 0-1.036-0.208-1.415-0.587-0.377-0.375-0.585-0.877-0.585-1.412s0.208-1.037 0.587-1.417c0.755-0.753 2.073-0.753 2.828 0 0.78 0.781 0.779 2.051 0 2.829-0.377 0.377-0.88 0.587-1.415 0.587zM9.401 21.932c-0.177 0-0.345 0.069-0.472 0.195-0.127 0.127-0.196 0.296-0.196 0.472s0.069 0.344 0.195 0.469c0.253 0.253 0.691 0.253 0.944 0 0.26-0.26 0.26-0.683 0-0.944-0.125-0.123-0.293-0.192-0.471-0.192zM22.6 11.4c-0.533 0-1.036-0.208-1.416-0.584-0.779-0.78-0.779-2.049 0-2.829 0.759-0.756 2.071-0.756 2.829 0 0.78 0.78 0.78 2.049 0 2.829-0.377 0.377-0.88 0.584-1.413 0.584zM22.6 8.735c-0.179 0-0.345 0.069-0.472 0.196-0.257 0.259-0.257 0.683 0 0.943 0.252 0.251 0.695 0.251 0.945 0 0.259-0.259 0.259-0.683 0-0.943-0.128-0.127-0.296-0.196-0.473-0.196zM16 18c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM16 15.333c-0.368 0-0.667 0.299-0.667 0.667s0.299 0.667 0.667 0.667 0.667-0.299 0.667-0.667-0.299-0.667-0.667-0.667zM14.667 11.333c-0.171 0-0.341-0.065-0.472-0.195l-1.333-1.333c-0.26-0.26-0.26-0.683 0-0.943s0.683-0.26 0.943 0l1.333 1.333c0.26 0.26 0.26 0.683 0 0.943-0.129 0.129-0.3 0.195-0.471 0.195zM17.333 11.333c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.26-0.26-0.683 0-0.943l1.333-1.333c0.259-0.26 0.683-0.26 0.943 0 0.259 0.26 0.259 0.683 0 0.943l-1.333 1.333c-0.129 0.129-0.3 0.195-0.471 0.195zM10.667 15.333c-0.171 0-0.341-0.065-0.472-0.195l-1.333-1.333c-0.26-0.26-0.26-0.683 0-0.943s0.683-0.26 0.943 0l1.333 1.333c0.26 0.26 0.26 0.683 0 0.943-0.129 0.129-0.3 0.195-0.471 0.195zM10.667 20h-1.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h1.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM15.333 22c-0.368 0-0.667-0.3-0.667-0.667v-1.333c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v1.333c0 0.367-0.299 0.667-0.667 0.667zM21.333 20h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM20 16.667c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.26-0.26-0.683 0-0.943l1.333-1.333c0.259-0.26 0.683-0.26 0.943 0 0.259 0.26 0.259 0.683 0 0.943l-1.333 1.333c-0.129 0.129-0.3 0.195-0.471 0.195z',
      ),
      'Plane-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 25.577c-3.944 0-7.153-3.208-7.153-7.153 0-3.943 3.209-7.153 7.153-7.153s7.153 3.211 7.153 7.153c0 3.944-3.209 7.153-7.153 7.153zM16 12.603c-3.209 0-5.82 2.611-5.82 5.82s2.611 5.821 5.82 5.821 5.82-2.611 5.82-5.82-2.611-5.821-5.82-5.821zM19.344 18.423c-0.005 0.003-0.016 0.003-0.027 0h-6.635c-0.369 0-0.667-0.3-0.667-0.667 0-2.643 1.341-3.984 3.981-3.984 2.581 0 3.917 1.276 3.979 3.789 0.023 0.063 0.028 0.131 0.028 0.195 0.007 0.368-0.292 0.667-0.66 0.667zM13.385 17.089h5.229c-0.169-1.417-0.948-1.984-2.615-1.984s-2.445 0.568-2.615 1.984zM22.484 20.423c-0.341 0-0.633-0.264-0.661-0.612-0.028-0.367 0.244-0.691 0.609-0.719l8.18-0.667c0.384-0.021 0.691 0.245 0.719 0.609 0.028 0.367-0.245 0.691-0.609 0.719l-8.18 0.667c-0.017 0.003-0.037 0.003-0.057 0.003zM9.651 20.423c-0.019 0-0.035 0-0.053-0.003l-8.317-0.667c-0.365-0.028-0.639-0.352-0.611-0.717s0.361-0.641 0.717-0.611l8.316 0.667c0.365 0.028 0.639 0.352 0.612 0.717-0.027 0.349-0.319 0.613-0.664 0.613zM20 7.756h-8c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h8c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM4 24.144c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM4 21.477c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.3-0.667-0.667-0.667zM28 24.144c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM28 21.477c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.3-0.667-0.667-0.667zM16 22.811c-1.103 0-2-0.897-2-2s0.897-2 2-2 2 0.897 2 2-0.897 2-2 2zM16 20.144c-0.367 0-0.667 0.3-0.667 0.667s0.3 0.667 0.667 0.667 0.667-0.3 0.667-0.667-0.3-0.667-0.667-0.667zM15.312 12.595l-1.289-0.344 1.333-4.984c0.080-0.292 0.344-0.495 0.643-0.495v0c0.305 0 0.567 0.203 0.643 0.495l1.331 4.984-1.289 0.344-0.683-2.575-0.688 2.575z',
      ),
      'Plane' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24 32.333c-0.071 0-0.14-0.012-0.211-0.033l-7.789-2.595-7.789 2.593c-0.203 0.063-0.427 0.033-0.601-0.089-0.173-0.125-0.276-0.328-0.276-0.543v-1.271c0-0.176 0.069-0.344 0.193-0.469l5.14-5.2v-6.896l-11.189 2.487c-0.195 0.044-0.403-0.004-0.561-0.133-0.157-0.124-0.249-0.317-0.249-0.517v-2.667c0-0.245 0.132-0.467 0.345-0.584l11.655-6.421v-6.995c0-1.839 1.496-3.333 3.333-3.333s3.333 1.495 3.333 3.333v6.995l11.655 6.421c0.212 0.117 0.345 0.339 0.345 0.584v2.667c0 0.2-0.091 0.393-0.251 0.521-0.156 0.128-0.364 0.172-0.563 0.133l-11.187-2.491v6.896l5.14 5.2c0.124 0.125 0.193 0.293 0.193 0.469v1.271c0 0.215-0.103 0.417-0.277 0.539-0.115 0.085-0.251 0.128-0.389 0.128zM16 28.333c0.071 0 0.143 0.012 0.211 0.033l7.123 2.372v-0.076l-5.14-5.196c-0.124-0.123-0.193-0.291-0.193-0.467v-8c0-0.2 0.091-0.393 0.251-0.521 0.156-0.129 0.364-0.172 0.56-0.133l11.191 2.487v-1.443l-11.655-6.419c-0.213-0.116-0.347-0.34-0.347-0.584v-7.388c0-1.103-0.897-2-2-2s-2 0.897-2 2v7.388c0 0.244-0.132 0.468-0.345 0.584l-11.655 6.423v1.443l11.189-2.487c0.195-0.044 0.404 0.004 0.561 0.133 0.157 0.124 0.249 0.317 0.249 0.517v8c0 0.176-0.069 0.344-0.193 0.469l-5.14 5.273 7.123-2.372c0.068-0.025 0.14-0.037 0.211-0.037z',
      ),
      'Plant' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M23.5 31.461h-15c-0.316 0-0.588-0.221-0.652-0.531l-2.5-12c-0.041-0.195 0.008-0.401 0.135-0.557 0.127-0.153 0.317-0.245 0.517-0.245h20c0.2 0 0.391 0.088 0.519 0.245 0.125 0.156 0.175 0.361 0.135 0.557l-2.5 12c-0.065 0.309-0.339 0.531-0.653 0.531zM9.043 30.128h13.916l2.223-10.667h-18.361l2.223 10.667zM24.667 22.128h-17.333c-0.368 0-0.667-0.3-0.667-0.667 0-0.369 0.299-0.667 0.667-0.667h17.333c0.367 0 0.667 0.297 0.667 0.667 0 0.367-0.3 0.667-0.667 0.667zM16 18.795c-0.368 0-0.667-0.3-0.667-0.667v-14.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v14.667c0 0.367-0.299 0.667-0.667 0.667zM15.283 16.46v0c-1.988 0-3.672-0.699-4.871-2.023-1.235-1.361-1.856-3.341-1.664-5.295 0.035-0.355 0.347-0.649 0.697-0.6 2.472 0.131 4.537 1.016 5.813 2.495 1.096 1.271 1.58 2.925 1.399 4.788-0.031 0.319-0.285 0.575-0.607 0.599-0.263 0.025-0.519 0.036-0.768 0.036zM10.048 9.932c0.019 1.361 0.503 2.676 1.352 3.609 0.94 1.036 2.281 1.584 3.883 1.584v0c0.027 0 0.053 0 0.080 0 0.008-1.253-0.371-2.359-1.112-3.217-0.925-1.072-2.401-1.761-4.203-1.976zM16.776 12.46c-0.249 0-0.505-0.011-0.771-0.033-0.32-0.028-0.576-0.28-0.607-0.597-0.18-1.861 0.304-3.519 1.399-4.789 1.279-1.479 3.341-2.364 5.813-2.492 0.356-0.045 0.663 0.248 0.696 0.597 0.193 1.953-0.428 3.932-1.664 5.296-1.196 1.32-2.879 2.019-4.867 2.019zM16.695 11.127c1.667-0.028 3.008-0.531 3.964-1.584 0.849-0.936 1.333-2.251 1.352-3.609-1.801 0.211-3.277 0.904-4.203 1.973-0.74 0.864-1.12 1.967-1.113 3.22zM15.283 8.46v0c-1.988 0-3.672-0.699-4.871-2.023-1.235-1.361-1.856-3.341-1.664-5.295 0.035-0.355 0.347-0.637 0.697-0.6 2.472 0.131 4.537 1.016 5.813 2.495 1.096 1.271 1.58 2.925 1.399 4.788-0.031 0.319-0.285 0.575-0.607 0.599-0.263 0.025-0.519 0.036-0.768 0.036zM10.048 1.932c0.019 1.361 0.503 2.676 1.352 3.609 0.94 1.036 2.281 1.584 3.883 1.584v0c0.027 0 0.053 0 0.080 0 0.008-1.253-0.371-2.359-1.112-3.217-0.925-1.072-2.401-1.761-4.203-1.976z',
      ),
      'Plasmid' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M7.58 13.7c-0.171 0-0.341-0.065-0.472-0.195l-2.935-2.932c-0.125-0.125-0.196-0.295-0.196-0.471 0-0.179 0.072-0.348 0.195-0.472l7.336-7.337c0.125-0.125 0.295-0.195 0.472-0.195v0c0.179 0 0.348 0.071 0.472 0.195l2.933 2.935c0.259 0.26 0.259 0.683 0 0.943l-7.333 7.333c-0.132 0.131-0.301 0.196-0.472 0.196zM5.587 10.101l1.992 1.987 6.391-6.391-1.991-1.989-6.392 6.393zM17.78 3.233c-1.592 0-3.111 0.293-4.528 0.805l1.047 1.047c1.103-0.335 2.271-0.519 3.48-0.519 6.616 0 12 5.383 12 12s-5.384 12-12 12-12-5.383-12-12c0-0.367 0.023-0.731 0.056-1.091l-1.323-0.224c-0.043 0.432-0.067 0.871-0.067 1.315 0 7.365 5.969 13.333 13.333 13.333 7.363 0 13.333-5.969 13.333-13.333 0.001-7.364-5.969-13.333-13.332-13.333zM7.433 16.415c-0.037 0-0.076-0.003-0.112-0.009l-5.879-0.999c-0.256-0.044-0.465-0.233-0.532-0.484-0.068-0.251 0.017-0.52 0.217-0.687l4.225-3.516c0.167-0.139 0.389-0.189 0.6-0.131 0.211 0.055 0.379 0.208 0.453 0.415l1.653 4.515c0.081 0.223 0.039 0.472-0.113 0.655-0.131 0.155-0.317 0.241-0.513 0.241zM3.093 14.335l3.317 0.563-0.933-2.547-2.384 1.984z',
      ),
      'Plaster' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24.413 16.080c-0.169 0-0.341-0.065-0.472-0.195-0.26-0.26-0.26-0.683 0-0.943l4.309-4.308c0.265-0.264 0.415-0.621 0.415-0.995 0-0.375-0.145-0.732-0.415-0.997l-4.893-4.896c-0.549-0.547-1.445-0.549-1.995 0l-4.153 4.152c-0.26 0.26-0.683 0.26-0.943 0-0.26-0.259-0.26-0.683 0-0.943l4.153-4.152c1.072-1.071 2.811-1.069 3.88 0l4.893 4.896c0.519 0.52 0.805 1.205 0.805 1.94 0 0.733-0.287 1.419-0.805 1.937l-4.309 4.308c-0.131 0.129-0.301 0.195-0.471 0.195zM9.637 29.997c-0.7 0-1.407-0.267-1.94-0.804l-4.893-4.893c-0.52-0.521-0.805-1.208-0.805-1.94 0-0.735 0.287-1.42 0.805-1.94l4.249-4.249c0.259-0.26 0.683-0.26 0.943 0 0.259 0.26 0.259 0.683 0 0.943l-4.249 4.249c-0.265 0.265-0.415 0.623-0.415 0.997 0 0.373 0.145 0.731 0.415 0.997l4.893 4.893c0.549 0.547 1.445 0.552 1.995 0l4.417-4.415c0.257-0.26 0.683-0.26 0.943 0 0.257 0.26 0.257 0.683 0 0.943l-4.417 4.415c-0.536 0.537-1.239 0.804-1.94 0.804zM9.637 2.665c0.531 0 1.063 0.203 1.472 0.608l17.616 17.62c0.809 0.811 0.809 2.124 0 2.936l-4.893 4.895c-0.409 0.405-0.937 0.608-1.472 0.608-0.529 0-1.063-0.203-1.469-0.608l-17.616-17.62c-0.812-0.811-0.812-2.127 0-2.936l4.893-4.895c0.407-0.405 0.937-0.608 1.469-0.608zM9.637 1.332c-0.912 0-1.765 0.355-2.412 0.999l-4.893 4.895c-0.643 0.643-1 1.5-1 2.412 0 0.913 0.357 1.767 1 2.415l17.617 17.619c0.645 0.644 1.501 0.999 2.412 0.999 0.915 0 1.768-0.355 2.415-0.999l4.893-4.895c0.643-0.641 1-1.501 1-2.412 0-0.913-0.357-1.767-1-2.415l-17.619-17.619c-0.648-0.644-1.504-0.999-2.413-0.999v0zM11.592 13.145c-0.355 0-0.707 0.136-0.976 0.405-0.541 0.541-0.539 1.417 0 1.959 0.269 0.271 0.625 0.407 0.976 0.407 0.355 0 0.711-0.136 0.979-0.407 0.539-0.541 0.539-1.417 0-1.959-0.267-0.269-0.623-0.405-0.979-0.405v0zM14.529 10.209c-0.357 0-0.708 0.136-0.977 0.407-0.54 0.539-0.54 1.417 0 1.957 0.269 0.269 0.624 0.405 0.977 0.405s0.708-0.136 0.976-0.405c0.54-0.54 0.54-1.417 0-1.957-0.267-0.271-0.621-0.407-0.976-0.407v0zM14.529 16.083c-0.357 0-0.708 0.139-0.977 0.409-0.54 0.539-0.54 1.417 0 1.957 0.271 0.271 0.625 0.407 0.977 0.407 0.355 0 0.708-0.136 0.976-0.407 0.54-0.54 0.54-1.417 0-1.957-0.267-0.275-0.621-0.409-0.976-0.409v0zM17.468 13.145c-0.356 0-0.708 0.136-0.976 0.405-0.54 0.541-0.54 1.417 0 1.959 0.268 0.271 0.625 0.407 0.976 0.407 0.356 0 0.708-0.136 0.977-0.407 0.54-0.541 0.54-1.417 0-1.959-0.271-0.269-0.625-0.405-0.977-0.405v0zM17.468 19.020c-0.355 0-0.708 0.139-0.976 0.408-0.54 0.537-0.54 1.417 0 1.957 0.268 0.271 0.625 0.407 0.976 0.407 0.356 0 0.708-0.136 0.977-0.407 0.54-0.54 0.54-1.417 0-1.957-0.269-0.273-0.624-0.408-0.977-0.408v0zM20.405 16.083c-0.356 0-0.711 0.139-0.979 0.409-0.539 0.539-0.539 1.417 0 1.957 0.271 0.271 0.627 0.407 0.979 0.407s0.707-0.136 0.976-0.407c0.541-0.54 0.539-1.417 0-1.957-0.269-0.275-0.625-0.409-0.976-0.409v0z',
      ),
      'Plastic-CupPhone' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M6 12c-0.165 0-0.324-0.061-0.447-0.172-0.14-0.127-0.22-0.305-0.22-0.495v-10.667c0-0.189 0.080-0.368 0.22-0.495 0.14-0.125 0.329-0.188 0.513-0.168l13.333 1.333c0.34 0.035 0.6 0.321 0.6 0.664v8c0 0.343-0.26 0.629-0.6 0.664l-13.333 1.333c-0.023 0-0.044 0.001-0.067 0.001zM6.667 1.404v9.193l12-1.199v-6.795l-12-1.2zM3.333 8.667c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v4c0 0.368-0.299 0.667-0.667 0.667zM0.667 10c-0.368 0-0.667-0.299-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM26 32c-0.024 0-0.044-0.001-0.067-0.003l-13.333-1.333c-0.34-0.033-0.6-0.321-0.6-0.664v-8c0-0.343 0.26-0.631 0.6-0.664l13.333-1.333c0.188-0.019 0.373 0.043 0.513 0.168 0.139 0.127 0.22 0.305 0.22 0.495v10.667c0 0.189-0.081 0.368-0.22 0.495-0.123 0.112-0.281 0.173-0.447 0.173zM13.333 29.397l12 1.199v-9.195l-12 1.199v6.797zM28.667 28.667c-0.367 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v4c0 0.367-0.3 0.667-0.667 0.667zM31.333 30c-0.367 0-0.667-0.3-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.367-0.3 0.667-0.667 0.667zM12 26.667h-6.667c-1.632 0-3.020-1.051-3.375-2.553-0.327-1.383 0.341-2.676 1.743-3.376l24.028-10.68c0.816-0.409 1.195-1.092 1.016-1.863-0.175-0.736-0.899-1.528-2.079-1.528h-6.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h6.667c1.633 0 3.021 1.051 3.375 2.553 0.325 1.383-0.341 2.676-1.743 3.377l-24.028 10.68c-0.816 0.411-1.196 1.092-1.015 1.863 0.173 0.735 0.897 1.528 2.077 1.528h6.667c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.665-0.667 0.665zM8.667 11.333c-0.368 0-0.667-0.299-0.667-0.667v-9.333c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v9.333c0 0.368-0.299 0.667-0.667 0.667zM23.333 31.333c-0.367 0-0.667-0.3-0.667-0.667v-9.333c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v9.333c0 0.367-0.3 0.667-0.667 0.667z',
      ),
      'Plastic-CupPhone2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M11.333 17.333h-8c-0.327 0-0.604-0.236-0.657-0.557l-2.667-16c-0.032-0.193 0.023-0.389 0.149-0.54 0.127-0.149 0.312-0.236 0.508-0.236h13.333c0.196 0 0.383 0.085 0.508 0.236 0.127 0.151 0.181 0.348 0.149 0.54l-2.667 16c-0.053 0.321-0.331 0.557-0.657 0.557zM3.897 16h6.871l2.444-14.667h-11.759l2.444 14.667zM13.333 5.333h-12c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h12c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM1.333 6.667h12v1.333h-12v-1.333zM28.667 22.667h-8c-0.327 0-0.604-0.236-0.657-0.557l-2.667-16c-0.032-0.193 0.023-0.389 0.149-0.54 0.127-0.149 0.313-0.236 0.508-0.236h13.333c0.195 0 0.383 0.085 0.508 0.236 0.128 0.151 0.183 0.348 0.149 0.54l-2.667 16c-0.053 0.321-0.331 0.557-0.657 0.557zM21.231 21.333h6.871l2.444-14.667h-11.759l2.444 14.667zM30.667 10.667h-12c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h12c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM18.667 12h12v1.333h-12v-1.333zM16 32c-5.169 0-9.333-4.376-9.333-8v-6.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 3.001 3.692 6.667 8 6.667 4.307 0 8-3.665 8-6.667v-1.333c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v1.333c0 3.624-4.164 8-9.333 8z',
      ),
      'Plate' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26.668 25.873h-21.333c-0.177 0-0.347-0.071-0.472-0.195-0.6-0.6-1.139-1.573-1.712-2.601-0.457-0.824-1.409-2.537-1.817-2.537-0.368 0-0.667-0.299-0.667-0.667 0-0.367 0.299-0.667 0.667-0.667h29.333c0.367 0 0.667 0.3 0.667 0.667 0 0.368-0.3 0.667-0.667 0.667-0.409 0-1.36 1.713-1.817 2.537-0.572 1.028-1.112 2.001-1.711 2.601-0.124 0.125-0.293 0.195-0.471 0.195zM5.629 24.54h20.743c0.42-0.504 0.872-1.319 1.312-2.111 0.387-0.695 0.751-1.352 1.128-1.889h-25.621c0.376 0.537 0.741 1.195 1.128 1.889 0.439 0.792 0.891 1.607 1.311 2.111zM27.335 19.873c-0.368 0-0.667-0.299-0.667-0.667 0-2.205-1.796-4-4-4h-0.667c-0.368 0-0.667-0.299-0.667-0.667v-0.667c0-2.205-1.796-4-4-4-0.368 0-0.667-0.299-0.667-0.667 0-0.367 0.299-0.667 0.667-0.667 2.941 0 5.333 2.392 5.333 5.333 2.941 0 5.333 2.392 5.333 5.333 0 0.369-0.299 0.667-0.667 0.667zM10.779 19.873c-0.368 0-0.667-0.299-0.667-0.667 0-1.783 1.641-3.343 3.225-3.7 0.084-1.984 1.855-3.633 3.941-3.633 0.367 0 0.667 0.3 0.667 0.667 0 0.368-0.3 0.667-0.667 0.667-1.391 0-2.611 1.143-2.611 2.445v0.443c0 0.368-0.299 0.667-0.667 0.667-0.987 0-2.556 1.119-2.556 2.445 0 0.369-0.299 0.667-0.667 0.667zM4.105 19.873c-0.368 0-0.667-0.299-0.667-0.667 0-3.7 2.291-6.167 5.896-6.435v-0.185c0-3.501 3.124-6.461 6.821-6.461 0.368 0 0.667 0.299 0.667 0.667 0 0.367-0.299 0.667-0.667 0.667-2.924 0-5.488 2.396-5.488 5.128v0.827c0 0.367-0.299 0.667-0.667 0.667-3.275 0-5.229 1.917-5.229 5.127 0 0.369-0.299 0.667-0.667 0.667z',
      ),
      'Plates' => 
      array (
        'height' => '32',
        'width' => '45',
        'path' => 'M21.292 2.667c7.352 0 13.333 5.981 13.333 13.333s-5.981 13.333-13.333 13.333c-7.352 0-13.333-5.981-13.333-13.333s5.981-13.333 13.333-13.333zM21.292 1.333c-8.1 0-14.667 6.567-14.667 14.667s6.567 14.667 14.667 14.667 14.667-6.567 14.667-14.667-6.567-14.667-14.667-14.667v0zM21.292 7.555c4.656 0 8.444 3.788 8.444 8.445s-3.788 8.445-8.444 8.445-8.444-3.788-8.444-8.445 3.788-8.445 8.444-8.445zM21.292 6.221c-5.4 0-9.777 4.377-9.777 9.779s4.377 9.779 9.777 9.779 9.777-4.377 9.777-9.779-4.377-9.779-9.777-9.779v0zM4.625 31.333c-0.368 0-0.667-0.3-0.667-0.667v-26.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v26.667c0 0.367-0.299 0.667-0.667 0.667zM0.625 15.333c-0.368 0-0.667-0.299-0.667-0.667v-11.195c0-1.323 1.271-2.528 2.667-2.528 1.288 0 2.667 0.972 2.667 2.417v3.305c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.299-0.667-0.667v-3.305c0-0.62-0.704-1.084-1.333-1.084-0.66 0-1.333 0.603-1.333 1.195v11.195c0 0.368-0.299 0.667-0.667 0.667zM2.625 18c-1.396 0-2.667-1.203-2.667-2.528v-2.139c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v2.139c0 0.591 0.673 1.195 1.333 1.195 0.629 0 1.333-0.464 1.333-1.084 0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667c0 1.445-1.379 2.417-2.667 2.417zM40.625 31.333c-0.367 0-0.667-0.3-0.667-0.667v-29.333c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v29.333c0 0.367-0.3 0.667-0.667 0.667zM40.625 11.763c-2.748 0-4.667-2.152-4.667-5.232v-5.197c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v5.197c0 1.941 1.031 3.899 3.333 3.899s3.333-1.957 3.333-3.899v-5.197c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v5.197c0 3.080-1.919 5.232-4.667 5.232z',
      ),
      'Plaxo' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 1.333c8.085 0 14.667 6.581 14.667 14.667s-6.581 14.667-14.667 14.667c-8.087 0-14.667-6.581-14.667-14.667s6.58-14.667 14.667-14.667zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0zM10 30.708c-0.368 0-0.667-0.303-0.667-0.667v-14.041c0-3.657 2.928-6.524 6.667-6.524 3.613 0 6.667 3.117 6.667 6.805 0 3.581-2.927 6.383-6.667 6.383-1.115 0-2.021 0.897-2.021 2s0.907 2 2.021 2c6.12 0 10.719-4.521 10.719-10.515 0-5.947-4.797-10.788-10.693-10.788s-10.693 4.769-10.693 10.636v10.125c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.299-0.667-0.667v-10.123c0-6.597 5.395-11.967 12.027-11.967s12.027 5.433 12.027 12.119c0 6.751-5.172 11.848-12.031 11.848-1.871 0-3.375-1.495-3.375-3.333s1.504-3.333 3.355-3.333c3.040 0 5.333-2.171 5.333-5.049 0-2.969-2.443-5.473-5.333-5.473-2.991 0-5.333 2.281-5.333 5.193v14.041c-0.001 0.367-0.3 0.663-0.668 0.663z',
      ),
      'Play-Music' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 1.333c8.085 0 14.667 6.58 14.667 14.667s-6.581 14.667-14.667 14.667-14.667-6.58-14.667-14.667 6.581-14.667 14.667-14.667zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0zM11.333 23.595c-0.115 0-0.231-0.029-0.333-0.089-0.205-0.119-0.333-0.339-0.333-0.577v-13.859c0-0.239 0.128-0.459 0.333-0.577 0.205-0.12 0.461-0.12 0.667 0l12 6.928c0.205 0.119 0.333 0.339 0.333 0.577s-0.128 0.459-0.333 0.577l-12 6.928c-0.103 0.063-0.219 0.092-0.333 0.092zM12 10.227v11.547l10-5.773-10-5.773z',
      ),
      'Plug-In' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M13.333 7.68c-0.368 0-0.667-0.299-0.667-0.667v-4.639c0-0.368-0.299-0.667-0.667-0.667s-0.667 0.299-0.667 0.667v4.639c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.299-0.667-0.667v-4.639c0-1.103 0.897-2 2-2s2 0.897 2 2v4.639c0 0.368-0.299 0.667-0.667 0.667zM21.333 7.68c-0.367 0-0.667-0.299-0.667-0.667v-4.639c0-0.368-0.3-0.667-0.667-0.667s-0.667 0.299-0.667 0.667v4.639c0 0.368-0.3 0.667-0.667 0.667s-0.667-0.299-0.667-0.667v-4.639c0-1.103 0.897-2 2-2s2 0.897 2 2v4.639c0 0.368-0.3 0.667-0.667 0.667zM24 11.013h-16c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667h16c0.367 0 0.667 0.3 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM8.667 9.68h14.667v-1.333h-14.667v1.333zM17.305 21.68h-2.612c-3.324 0-6.028-2.703-6.028-6.028v-5.305c0-0.367 0.299-0.667 0.667-0.667h13.333c0.368 0 0.667 0.3 0.667 0.667v5.305c0.001 3.324-2.701 6.028-6.027 6.028zM10 11.013v4.639c0 2.587 2.105 4.695 4.695 4.695h2.612c2.587 0 4.695-2.105 4.695-4.695v-4.639h-12.001zM9.944 31.625c-0.368 0-0.667-0.299-0.667-0.667 0-3.74 2.016-5.191 3.637-6.357 1.351-0.972 2.419-1.743 2.419-3.588 0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667c0 2.531-1.512 3.619-2.973 4.671-1.584 1.14-3.083 2.219-3.083 5.275 0 0.368-0.297 0.667-0.667 0.667z',
      ),
      'Plug-In2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24.685 21.667h-2.667c-0.368 0-0.667-0.3-0.667-0.667v-13.333c0-0.368 0.299-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667v13.333c0 0.367-0.3 0.667-0.667 0.667zM22.685 20.333h1.333v-12h-1.333v12zM22.019 20.333h-4.085c-2.528 0-4.584-2.056-4.584-4.584v-2.833c0-2.528 2.056-4.584 4.584-4.584h4.084c0.367 0 0.667 0.299 0.667 0.667v10.667c0.001 0.368-0.299 0.668-0.665 0.668zM17.933 9.667c-1.792 0-3.251 1.457-3.251 3.251v2.833c0 1.792 1.457 3.251 3.251 3.251h3.417v-9.333l-3.417-0.001zM30.052 16.333h-4.7c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h4.7c0.365 0 0.653-0.293 0.653-0.667 0-0.368-0.305-0.667-0.68-0.667h-4.675c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h4.673c1.111 0 2.013 0.897 2.013 2s-0.891 2-1.985 2zM0.629 25c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667c4.172 0 5.313-2.343 6.525-4.821 1.185-2.427 2.527-5.179 6.864-5.179 0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667c-3.505 0-4.507 2.053-5.667 4.429-1.273 2.611-2.716 5.571-7.723 5.571z',
      ),
      'Plurk' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M6.855 27.479c-1.005 0-2.040-0.157-2.504-0.339-0.256-0.101-0.424-0.347-0.424-0.623 0-1.361 0.545-2.728 0.984-3.825 0.241-0.607 0.492-1.239 0.492-1.52 0-1.029-0.288-1.592-0.62-2.251-0.372-0.727-0.793-1.555-0.793-3 0-0.652 0.039-1.417 0.080-2.191-2.328-0.756-4.024-2.453-4.024-4.089 0-3.073 0.971-4.040 3.145-5.057 0.232-0.109 0.509-0.077 0.707 0.091 0.199 0.167 0.284 0.429 0.219 0.683-0.571 2.189 0 3.564 1.793 4.296 2.035-2.104 4.897-2.833 6.92-3.2 2.124-0.385 5.629-0.636 8.932-0.636 0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667c-3.921 0-7.135 0.331-8.693 0.615-1.929 0.351-4.696 1.052-6.46 3.097-0.177 0.203-0.456 0.281-0.713 0.199-2.345-0.763-3.472-2.359-3.308-4.639-0.876 0.6-1.209 1.365-1.209 3.219 0 0.985 1.357 2.397 3.548 2.955 0.308 0.079 0.517 0.361 0.501 0.68l-0.027 0.5c-0.040 0.753-0.080 1.507-0.080 2.147 0 1.127 0.3 1.712 0.647 2.396 0.36 0.704 0.767 1.503 0.767 2.859 0 0.536-0.259 1.188-0.587 2.011-0.337 0.847-0.745 1.867-0.859 2.836 0.824 0.159 2.1 0.167 2.676 0.031 0.065-2.784 1.364-5.055 1.423-5.153 0.147-0.251 0.44-0.393 0.729-0.312 0.027 0.005 2.597 0.593 5.073 0.028 0.199-0.051 0.407 0.003 0.564 0.129 0.159 0.128 0.251 0.317 0.251 0.524v4.609h2.667v-4.667c0-0.367 0.3-0.667 0.667-0.667h3.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667h-2.667v4.667c0 0.367-0.3 0.667-0.667 0.667h-4c-0.368 0-0.667-0.3-0.667-0.667v-4.476c-1.817 0.271-3.519 0.068-4.343-0.079-0.368 0.775-1.079 2.536-1.031 4.476 0.004 0.183-0.067 0.359-0.195 0.483-0.385 0.391-1.304 0.528-2.248 0.528zM22.065 21.855c-3.347 0-6.069-3.596-6.069-8.020 0-4.417 2.723-8.017 6.069-8.017s6.068 3.599 6.068 8.017c0 4.423-2.721 8.020-6.068 8.020zM22.065 7.153c-2.612 0-4.737 2.999-4.737 6.684 0 3.687 2.125 6.684 4.737 6.684 2.609 0 4.735-2.997 4.735-6.684 0-3.685-2.125-6.684-4.735-6.684zM22.065 17.937c-1.849 0-3.355-1.808-3.355-4.041 0-2.229 1.505-4.037 3.355-4.037s3.352 1.808 3.352 4.037-1.505 4.041-3.352 4.041zM22.065 11.189c-1.115 0-2.021 1.211-2.021 2.704s0.907 2.708 2.021 2.708c1.112 0 2.019-1.215 2.019-2.708s-0.907-2.704-2.019-2.704zM29.899 13.917c-0.175 0-0.352-0.072-0.481-0.204-0.255-0.267-0.248-0.689 0.021-0.943l1.388-1.333c0.265-0.256 0.688-0.247 0.943 0.019 0.255 0.267 0.251 0.693-0.019 0.943l-1.391 1.333c-0.131 0.125-0.297 0.185-0.461 0.185zM31.287 15.208c-0.164 0-0.325-0.059-0.453-0.179l-1.391-1.295c-0.268-0.251-0.287-0.672-0.033-0.941 0.251-0.267 0.675-0.285 0.943-0.032l1.388 1.292c0.271 0.251 0.287 0.673 0.036 0.943-0.133 0.143-0.312 0.212-0.489 0.212zM22.008 25.959c-0.175 0-0.344-0.069-0.469-0.193-0.128-0.125-0.197-0.297-0.197-0.473v-4.101c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v3.427l2.211-0.027-0.929-4.12c-0.084-0.361 0.143-0.716 0.503-0.8 0.357-0.081 0.716 0.143 0.8 0.503l1.109 4.924c0.044 0.195-0.003 0.404-0.128 0.56-0.125 0.159-0.312 0.251-0.516 0.252l-3.708 0.039c-0.003 0.011-0.005 0.011-0.008 0.011zM11.34 25.959c-0.171 0-0.335-0.065-0.46-0.184-0.132-0.127-0.207-0.301-0.207-0.483v-3.417c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.716l3.277-0.16c0.364-0.075 0.68 0.264 0.699 0.635 0.019 0.365-0.265 0.683-0.633 0.695l-3.976 0.195c-0.012 0.004-0.021 0.004-0.033 0.004zM30.675 13.875h-8c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h8c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Pointer' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M22.708 26.667h-9.375c-1.471 0-2.667-1.195-2.667-2.667v-1.333c-1.471 0-2.667-1.195-2.667-2.667v-1.333c-1.471 0-2.667-1.195-2.667-2.667v-1.333h-2.667c-1.471 0-2.667-1.196-2.667-2.667s1.196-2.667 2.667-2.667h8v-1.333c0-1.471 1.196-2.667 2.667-2.667h7.333c6.251 0 11.333 5.084 11.333 11.333v0.708c0 5.124-4.168 9.292-9.292 9.292zM2.667 10.667c-0.735 0-1.333 0.599-1.333 1.333s0.599 1.333 1.333 1.333h3.333c0.368 0 0.667 0.299 0.667 0.667v2c0 0.735 0.599 1.333 1.333 1.333h0.667c0.368 0 0.667 0.3 0.667 0.667v2c0 0.735 0.599 1.333 1.333 1.333h0.667c0.368 0 0.667 0.3 0.667 0.667v2c0 0.735 0.599 1.333 1.333 1.333h9.375c4.388 0 7.959-3.571 7.959-7.959v-0.708c0-5.515-4.485-10-10-10h-7.333c-0.735 0-1.333 0.599-1.333 1.333v2c0 0.368-0.299 0.667-0.667 0.667h-8.667zM18.667 10.667h-8c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h8c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM10.667 14.667h-5.333c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM13.333 18.667h-5.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM16 22.667h-5.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Poland' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M0.667 31.333c-0.368 0-0.667-0.3-0.667-0.667v-29.333c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v29.333c0 0.367-0.299 0.667-0.667 0.667zM31.333 24h-30.667c-0.368 0-0.667-0.3-0.667-0.667v-21.333c0-0.368 0.299-0.667 0.667-0.667h30.667c0.367 0 0.667 0.299 0.667 0.667v21.333c0 0.367-0.3 0.667-0.667 0.667zM1.333 22.667h29.333v-20h-29.333v20zM30.667 13.333h-29.333c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h29.333c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM16 10.771c-1.695 0-2.667-0.992-2.667-2.721v-3.383c0-0.368 0.299-0.667 0.667-0.667h4c0.367 0 0.667 0.299 0.667 0.667v3.383c0 1.729-0.972 2.721-2.667 2.721zM14.667 5.333v2.716c0 0.985 0.387 1.388 1.333 1.388s1.333-0.403 1.333-1.388v-2.716h-2.667z',
      ),
      'Police-Man' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24.667 11.333c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.177 0.071-0.347 0.195-0.472 0.68-0.683 0.839-1.86 0.56-2.528-0.091-0.221-0.205-0.333-0.339-0.333-1.697 0-3.96-0.957-5.776-1.725-1.043-0.441-2.223-0.941-2.64-0.941s-1.599 0.5-2.64 0.941c-1.817 0.768-4.079 1.725-5.776 1.725-0.133 0-0.248 0.112-0.339 0.333-0.279 0.672-0.12 1.849 0.56 2.528 0.125 0.125 0.195 0.295 0.195 0.472v2.667c0 0.368-0.299 0.667-0.667 0.667s-0.667-0.299-0.667-0.667v-2.409c-0.932-1.112-1.077-2.749-0.655-3.768 0.304-0.735 0.877-1.156 1.571-1.156 1.427 0 3.551-0.899 5.256-1.62 1.58-0.669 2.504-1.047 3.16-1.047s1.583 0.377 3.16 1.047c1.705 0.721 3.829 1.62 5.256 1.62 0.695 0 1.267 0.421 1.571 1.156 0.424 1.021 0.279 2.656-0.653 3.768v2.409c0.001 0.368-0.299 0.667-0.665 0.667zM15.909 15.333c-0.003 0-0.004 0-0.007 0-4.563-0.001-9.188-1.441-9.236-4.656-0.005-0.367 0.288-0.672 0.657-0.677 0.384-0.015 0.671 0.288 0.676 0.656 0.032 2.195 4 3.343 7.903 3.344 0.001 0 0.004 0 0.007 0 3.897 0 8.056-1.171 8.091-3.344 0.005-0.364 0.303-0.656 0.667-0.656 0.003 0 0.007 0 0.011 0 0.368 0.005 0.663 0.307 0.656 0.677-0.049 3.199-4.919 4.656-9.424 4.656zM16 27.333c-5.719 0-9.333-6.932-9.333-8.667v-8c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v8c0 0.983 3.029 7.333 8 7.333 4.972 0 8-6.351 8-7.333v-8c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v8c0 1.735-3.615 8.667-9.333 8.667zM30.667 31.333c-0.367 0-0.667-0.299-0.667-0.667 0-3.307-2.693-6-6-6-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667c4.044 0 7.333 3.291 7.333 7.333 0 0.368-0.3 0.667-0.667 0.667zM1.333 31.333c-0.368 0-0.667-0.299-0.667-0.667 0-4.043 3.289-7.333 7.333-7.333 0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667c-3.308 0-6 2.693-6 6 0 0.368-0.299 0.667-0.667 0.667zM16.013 4.597l0.672 2.069h2.176l-1.761 1.469 0.673 2.164-1.76-1.232-1.761 1.301 0.672-2.245-1.76-1.457h2.176z',
      ),
      'Police-Station' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M31.347 8c-0.008 0-0.017 0-0.027 0h-30.667c-0.316 0-0.588-0.221-0.653-0.531-0.064-0.308 0.097-0.621 0.388-0.747l15.333-6.667c0.169-0.073 0.361-0.073 0.531 0l15.247 6.629c0.296 0.068 0.515 0.333 0.515 0.649 0 0.367-0.299 0.665-0.667 0.665zM3.859 6.667h24.256l-12.128-5.273-12.128 5.273zM31.32 32h-30.667c-0.368 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667h30.667c0.367 0 0.667 0.3 0.667 0.667v2.667c0 0.367-0.299 0.667-0.667 0.667zM1.32 30.667h29.333v-1.333h-29.333v1.333zM29.987 29.333h-28c-0.368 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667h28c0.367 0 0.667 0.3 0.667 0.667v2.667c0 0.367-0.299 0.667-0.667 0.667zM2.653 28h26.667v-1.333h-26.667v1.333zM7.32 24h-4c-0.368 0-0.667-0.3-0.667-0.667v-13.333c0-0.368 0.299-0.667 0.667-0.667h4c0.368 0 0.667 0.299 0.667 0.667v13.333c0 0.367-0.299 0.667-0.667 0.667zM3.987 22.667h2.667v-12h-2.667v12zM28.653 24h-4c-0.367 0-0.667-0.3-0.667-0.667v-13.333c0-0.368 0.3-0.667 0.667-0.667h4c0.367 0 0.667 0.299 0.667 0.667v13.333c0 0.367-0.299 0.667-0.667 0.667zM25.32 22.667h2.667v-12h-2.667v12zM15.987 22.667c-3.040 0-5.333-2.417-5.333-5.623v-5.479c0-0.184 0.076-0.359 0.209-0.485 0.135-0.125 0.32-0.192 0.497-0.18 2.363 0.137 3.139-0.405 4.168-1.383 0.257-0.245 0.661-0.245 0.917 0 1.056 1.004 1.751 1.519 4.169 1.383 0.18-0.012 0.363 0.056 0.496 0.181 0.135 0.125 0.209 0.301 0.209 0.484v5.477c0 3.208-2.292 5.624-5.333 5.624zM11.987 12.255v4.789c0 2.445 1.72 4.289 4 4.289s4-1.844 4-4.289v-4.789c-2.091 0.016-3.040-0.508-4.001-1.349-0.924 0.799-2.003 1.355-3.999 1.349z',
      ),
      'Police-Woman' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M9.341 23.12c-0.081 0-0.163-0.016-0.243-0.047-2.741-1.068-4.817-2.685-5.695-4.443-0.101-0.2-0.092-0.445 0.024-0.639 0.632-1.055 2.329-4.037 2.589-5.144l0.649-2.599v-3.652c-1.008-1.141-1.76-3.049-1.316-4.124 0.212-0.515 0.661-0.807 1.232-0.807 1.501 0 4.009-0.459 6.024-0.825 1.553-0.284 2.78-0.508 3.392-0.508s1.839 0.224 3.392 0.508c2.016 0.367 4.524 0.825 6.024 0.825 0.573 0 1.024 0.295 1.235 0.805 0.441 1.076-0.308 2.981-1.316 4.125v3.736c0 0.399 0.367 1.675 0.633 2.455 0.279 1.165 1.973 4.148 2.607 5.203 0.117 0.195 0.128 0.437 0.027 0.639-0.876 1.755-2.951 3.372-5.688 4.44-0.344 0.139-0.732-0.033-0.863-0.377-0.135-0.344 0.035-0.729 0.379-0.861 2.227-0.867 3.989-2.151 4.805-3.484-0.596-1.021-2.24-3.889-2.544-5.191-0.105-0.292-0.689-2.065-0.689-2.823v-4c0-0.177 0.071-0.347 0.195-0.472 1.024-1.027 1.396-2.612 1.216-2.891-1.632 0.064-4.193-0.44-6.259-0.819-1.368-0.251-2.661-0.485-3.153-0.485s-1.784 0.236-3.153 0.485c-2.068 0.376-4.641 0.848-6.264 0.848-0.175 0.249 0.199 1.837 1.221 2.861 0.127 0.125 0.197 0.295 0.197 0.472v4c0 0.055-0.007 0.109-0.020 0.161l-0.667 2.667c-0.305 1.295-1.945 4.163-2.545 5.183 0.819 1.333 2.585 2.62 4.815 3.487 0.343 0.133 0.512 0.521 0.379 0.861-0.101 0.267-0.353 0.428-0.62 0.428zM31.333 31.667h-1.333c0-3.344-4.004-8.667-7.333-8.667v-1.333c4.101 0 8.667 5.961 8.667 10zM2 31.667h-1.333c0-4.039 4.565-10 8.667-10v1.333c-3.329 0-7.333 5.323-7.333 8.667zM16 1.607l0.669 2.060h2.167l-1.752 1.479 0.668 2.164-1.752-1.224-1.752 1.3 0.669-2.253-1.753-1.465h2.167zM16 12.333c-5.233 0-9.333-2.049-9.333-4.667 0-0.368 0.299-0.667 0.667-0.667s0.667 0.297 0.667 0.667c0 1.577 3.285 3.333 8 3.333s8-1.756 8-3.333c0-0.368 0.3-0.667 0.667-0.667s0.667 0.297 0.667 0.667c0 2.616-4.1 4.667-9.333 4.667zM16 25.667c-3.863 0-6.667-3.084-6.667-7.333v-8h1.333v8c0 3.531 2.193 6 5.333 6s5.333-2.469 5.333-6v-8h1.333v8c0 4.251-2.805 7.333-6.667 7.333z',
      ),
      'Police' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 32c-0.044 0-0.089-0.004-0.133-0.013-5.324-1.084-13.2-6.068-13.2-13.32v-14c0-0.184 0.076-0.36 0.209-0.484 0.135-0.127 0.323-0.195 0.497-0.181 6.444 0.384 9.361-1.151 12.168-3.817 0.257-0.245 0.661-0.245 0.917 0 2.805 2.668 5.735 4.2 12.169 3.817 0.183-0.016 0.361 0.055 0.496 0.181 0.133 0.124 0.209 0.303 0.209 0.484v14c0 7.252-7.877 12.236-13.2 13.32-0.044 0.009-0.089 0.013-0.133 0.013zM4 5.367v13.3c0 6.451 7.111 10.935 12 11.985 4.889-1.051 12-5.535 12-11.985v-13.3c-6.133 0.236-9.181-1.245-12-3.795-2.817 2.553-5.853 4.036-12 3.795zM21.036 23.76c-0.14 0-0.279-0.044-0.399-0.135l-4.644-3.449-4.641 3.335c-0.236 0.169-0.553 0.165-0.787-0.007-0.232-0.173-0.327-0.473-0.233-0.751l1.757-5.133-4.609-3.069c-0.244-0.163-0.353-0.468-0.268-0.749s0.344-0.472 0.639-0.472h5.741l1.775-5.461c0.179-0.549 1.089-0.549 1.268 0l1.775 5.461h5.743c0.295 0 0.552 0.195 0.639 0.472 0.084 0.284-0.025 0.584-0.271 0.751l-4.609 3.053 1.76 5.273c0.091 0.276-0.005 0.583-0.243 0.751-0.119 0.089-0.255 0.131-0.392 0.131zM16 18.688c0.14 0 0.279 0.044 0.397 0.135l3.335 2.475-1.252-3.751c-0.095-0.285 0.013-0.6 0.265-0.767l3.189-2.113h-4.013c-0.289 0-0.544-0.187-0.635-0.461l-1.289-3.972-1.289 3.972c-0.088 0.275-0.344 0.461-0.633 0.461h-4.023l3.204 2.139c0.252 0.168 0.359 0.481 0.261 0.768l-1.247 3.639 3.34-2.4c0.116-0.083 0.253-0.124 0.389-0.124z',
      ),
      'Polo-Shirt' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24.776 30.667h-17.333c-0.368 0-0.667-0.299-0.667-0.667v-15.333h-3.875c-0.295 0-0.555-0.192-0.639-0.475l-2.235-7.449c-0.095-0.315 0.056-0.652 0.352-0.795l9.571-4.549c0.089-0.041 0.188-0.064 0.287-0.064h11.527c0.099 0 0.196 0.023 0.287 0.064l9.571 4.549c0.297 0.141 0.448 0.479 0.352 0.793l-2.235 7.451c-0.085 0.283-0.345 0.475-0.64 0.475h-3.656v15.333c0 0.368-0.3 0.667-0.667 0.667zM8.111 29.333h16v-15.333c0-0.368 0.3-0.667 0.667-0.667h3.825l1.927-6.427-8.917-4.24h-11.224l-8.917 4.24 1.928 6.427h4.044c0.368 0 0.667 0.299 0.667 0.667v15.333zM13.321 11.444c-0.031 0-0.063-0.003-0.093-0.007-0.248-0.033-0.452-0.203-0.535-0.439l-3.084-8.777c-0.1-0.281 0.001-0.596 0.247-0.768s0.573-0.159 0.805 0.029l5.899 4.833c0.272 0.223 0.324 0.616 0.12 0.901l-2.815 3.945c-0.128 0.18-0.332 0.281-0.544 0.281zM11.655 4.025l1.869 5.321 1.707-2.391-3.576-2.931zM18.948 11.444c-0.213 0-0.417-0.103-0.541-0.28l-2.813-3.945c-0.204-0.284-0.151-0.679 0.12-0.901l5.899-4.833c0.229-0.189 0.56-0.201 0.805-0.029 0.245 0.171 0.347 0.484 0.248 0.767l-3.085 8.779c-0.083 0.236-0.291 0.405-0.535 0.44-0.035 0.004-0.067 0.004-0.097 0.004zM17.039 6.953l1.705 2.391 1.869-5.321-3.575 2.931zM21.443 14.667h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667z',
      ),
      'Portrait' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M25.895 32h-19.789c-3.367 0-6.105-2.739-6.105-6.104v-19.792c0-3.364 2.739-6.104 6.105-6.104h19.789c3.365 0 6.105 2.74 6.105 6.104v19.792c0 3.365-2.739 6.104-6.105 6.104zM6.105 1.333c-2.632 0-4.772 2.14-4.772 4.771v19.792c0 2.631 2.14 4.771 4.772 4.771h19.789c2.632 0 4.772-2.14 4.772-4.771v-19.792c0-2.631-2.14-4.771-4.772-4.771h-19.789zM23.228 25.333h-14.456c-3.367 0-6.105-2.739-6.105-6.104v-10.459c0-3.364 2.739-6.104 6.105-6.104h14.456c3.365 0 6.105 2.74 6.105 6.104v10.459c0 3.365-2.739 6.104-6.105 6.104zM8.772 4c-2.632 0-4.772 2.14-4.772 4.771v10.459c0 2.631 2.14 4.771 4.772 4.771h14.456c2.632 0 4.772-2.14 4.772-4.771v-10.459c0-2.631-2.14-4.771-4.772-4.771h-14.456zM5.333 23.333c-0.368 0-0.667-0.3-0.667-0.667 0-2.573 2.093-4.667 4.667-4.667 0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667c-1.837 0-3.333 1.495-3.333 3.333 0 0.367-0.299 0.667-0.667 0.667zM26.667 23.333c-0.367 0-0.667-0.3-0.667-0.667 0-1.839-1.496-3.333-3.333-3.333-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667c2.573 0 4.667 2.093 4.667 4.667 0 0.367-0.3 0.667-0.667 0.667zM16 22c-3.088 0-5.432-3.509-5.651-6.832-0.621-0.335-1.016-1.116-1.016-1.835v-1.333c0-0.476 0-1.647 1.333-1.935v-1.529c0-1.688 0.204-3.2 2.667-3.2h5.333c2.464 0 2.667 1.516 2.667 3.2v1.528c1.333 0.291 1.333 1.46 1.333 1.936v1.333c0 0.719-0.395 1.5-1.016 1.835-0.219 3.323-2.563 6.832-5.651 6.832zM13.333 6.667c-1.132 0-1.333 0.139-1.333 1.867v2.133c0 0.367-0.299 0.667-0.667 0.667-0.667 0-0.667 0.076-0.667 0.667v1.333c0 0.343 0.243 0.667 0.333 0.667 0.368 0 0.667 0.3 0.667 0.667 0 2.775 1.892 6 4.333 6s4.333-3.225 4.333-6c0-0.367 0.3-0.667 0.667-0.667 0.091 0 0.333-0.324 0.333-0.667v-1.333c0-0.591 0-0.667-0.667-0.667-0.367 0-0.667-0.3-0.667-0.667v-2.133c0-1.731-0.2-1.867-1.333-1.867h-5.333z',
      ),
      'Portugal' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M0.667 31.333c-0.368 0-0.667-0.3-0.667-0.667v-29.333c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v29.333c0 0.367-0.299 0.667-0.667 0.667zM31.333 24h-30.667c-0.368 0-0.667-0.3-0.667-0.667v-21.333c0-0.368 0.299-0.667 0.667-0.667h30.667c0.367 0 0.667 0.299 0.667 0.667v21.333c0 0.367-0.3 0.667-0.667 0.667zM1.333 22.667h29.333v-20h-29.333v20zM11.333 6c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM11.333 23.333c-0.368 0-0.667-0.3-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v2.667c0 0.367-0.299 0.667-0.667 0.667zM11.333 17.541c-1.9 0-3.333-1.519-3.333-3.531v-4.011c0-0.368 0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.299 0.667 0.667v4.011c0 2.013-1.433 3.531-3.333 3.531zM9.333 10.667v3.344c0 1.273 0.841 2.197 2 2.197s2-0.924 2-2.197v-3.344h-4zM11.333 20c-4.044 0-7.333-3.289-7.333-7.333s3.289-7.333 7.333-7.333 7.333 3.289 7.333 7.333-3.289 7.333-7.333 7.333zM11.333 6.667c-3.308 0-6 2.692-6 6s2.692 6 6 6 6-2.692 6-6-2.692-6-6-6z',
      ),
      'Post-Mail' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M23.332 26.667h-14.667c-0.368 0-0.667-0.3-0.667-0.667v-18.667c0-0.368 0.299-0.667 0.667-0.667h14.667c0.368 0 0.667 0.299 0.667 0.667v18.667c0 0.367-0.299 0.667-0.667 0.667zM9.332 25.333h13.333v-17.333h-13.333v17.333zM24.665 32h-17.333c-0.368 0-0.667-0.3-0.667-0.667v-5.333c0-0.367 0.299-0.667 0.667-0.667h17.333c0.368 0 0.667 0.3 0.667 0.667v5.333c0 0.367-0.299 0.667-0.667 0.667zM7.999 30.667h16v-4h-16v4zM26.303 5.333h-20.605c-0.276 0-0.523-0.169-0.621-0.427-0.1-0.253-0.031-0.549 0.173-0.733 2.96-2.691 6.777-4.173 10.751-4.173s7.791 1.483 10.751 4.173c0.204 0.185 0.273 0.477 0.175 0.733-0.101 0.257-0.349 0.427-0.623 0.427zM7.592 4h16.812c-2.459-1.729-5.383-2.667-8.407-2.667-3.023 0-5.945 0.937-8.405 2.667zM24.665 8h-17.333c-0.252 0-0.483-0.141-0.596-0.368l-1.333-2.667c-0.104-0.207-0.092-0.452 0.029-0.648s0.336-0.316 0.567-0.316h20c0.231 0 0.445 0.12 0.567 0.316 0.123 0.195 0.133 0.443 0.029 0.648l-1.333 2.667c-0.113 0.227-0.344 0.368-0.596 0.368zM7.744 6.667h16.508l0.667-1.333h-17.841l0.667 1.333zM20.665 13.333h-9.333c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h9.333c0.368 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM11.999 12h8v-1.333h-8v1.333zM20.665 24h-9.333c-0.368 0-0.667-0.3-0.667-0.667v-6.667c0-0.368 0.299-0.667 0.667-0.667h9.333c0.368 0 0.667 0.299 0.667 0.667v6.667c0 0.367-0.299 0.667-0.667 0.667zM11.999 22.667h8v-5.333h-8v5.333zM15.999 21.333c-0.155 0-0.309-0.053-0.433-0.161l-4.667-4c-0.28-0.24-0.312-0.66-0.072-0.94s0.661-0.312 0.94-0.072l4.233 3.628 4.233-3.628c0.28-0.24 0.701-0.208 0.94 0.072 0.241 0.28 0.208 0.7-0.072 0.94l-4.667 4c-0.127 0.108-0.281 0.161-0.436 0.161z',
      ),
      'Post-Mail2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M27.333 9.667h-8c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h8c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM1.333 31.667c-0.368 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v4c0 0.367-0.299 0.667-0.667 0.667zM16 31.667c-0.368 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.299-0.667 0.667-0.667s0.667 0.3 0.667 0.667v4c0 0.367-0.299 0.667-0.667 0.667zM30.667 31.667c-0.367 0-0.667-0.3-0.667-0.667v-4c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v4c0 0.367-0.3 0.667-0.667 0.667zM28 21.667h-9.333c-0.367 0-0.667-0.3-0.667-0.667v-8c0-0.368 0.3-0.667 0.667-0.667h9.333c0.367 0 0.667 0.299 0.667 0.667v8c0 0.367-0.3 0.667-0.667 0.667zM19.333 20.333h8v-6.667h-8v6.667zM16 28.333h-14.667c-0.368 0-0.667-0.3-0.667-0.667v-19.333c0-4.412 3.588-8 8-8s8 3.588 8 8v19.333c0 0.367-0.299 0.667-0.667 0.667zM2 27h13.333v-18.667c0-3.676-2.991-6.667-6.667-6.667s-6.667 2.991-6.667 6.667v18.667zM30.667 28.333h-15.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h14.667v-18.667c0-3.613-3.205-6.667-7-6.667h-14.333c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h14.333c4.519 0 8.333 3.664 8.333 8v19.333c0 0.367-0.3 0.667-0.667 0.667zM13.333 17.667h-9.333c-0.368 0-0.667-0.3-0.667-0.667v-8c0-0.368 0.299-0.667 0.667-0.667h9.333c0.368 0 0.667 0.299 0.667 0.667v8c0 0.367-0.299 0.667-0.667 0.667zM4.667 16.333h8v-6.667h-8v6.667zM8.667 13.667c-0.155 0-0.309-0.053-0.433-0.161l-4.667-4c-0.28-0.24-0.312-0.66-0.072-0.94s0.663-0.312 0.94-0.072l4.233 3.628 4.233-3.628c0.279-0.24 0.701-0.208 0.94 0.072 0.24 0.28 0.208 0.7-0.072 0.94l-4.667 4c-0.127 0.108-0.281 0.161-0.436 0.161z',
      ),
      'Post-Office' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M27.333 28h-22.667c-0.368 0-0.667-0.3-0.667-0.667v-14.667c0-0.368 0.299-0.667 0.667-0.667h22.667c0.367 0 0.667 0.299 0.667 0.667v14.667c0 0.367-0.3 0.667-0.667 0.667zM5.333 26.667h21.333v-13.333h-21.333v13.333zM11.333 21.333h-4c-0.368 0-0.667-0.3-0.667-0.667v-5.333c0-0.368 0.299-0.667 0.667-0.667h4c0.368 0 0.667 0.299 0.667 0.667v5.333c0 0.367-0.299 0.667-0.667 0.667zM8 20h2.667v-4h-2.667v4zM24.667 21.333h-4c-0.367 0-0.667-0.3-0.667-0.667v-5.333c0-0.368 0.3-0.667 0.667-0.667h4c0.367 0 0.667 0.299 0.667 0.667v5.333c0 0.367-0.3 0.667-0.667 0.667zM21.333 20h2.667v-4h-2.667v4zM18 28h-4c-0.368 0-0.667-0.3-0.667-0.667v-9.333c0-0.367 0.299-0.667 0.667-0.667h4c0.367 0 0.667 0.3 0.667 0.667v9.333c0 0.367-0.3 0.667-0.667 0.667zM14.667 26.667h2.667v-8h-2.667v8zM31.333 13.333h-30.667c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h30.667c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.3 0.667-0.667 0.667zM1.333 12h29.333v-2.667h-29.333v2.667zM26 9.333h-20c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h20c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.3 0.667-0.667 0.667zM6.667 8h18.667v-2.667h-18.667v2.667z',
      ),
      'Post-Sign' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28.667 16h-20c-0.177 0-0.347-0.071-0.472-0.195l-5.333-5.333c-0.26-0.257-0.26-0.683 0-0.943l5.333-5.333c0.125-0.125 0.295-0.195 0.472-0.195h20c0.268 0 0.513 0.163 0.615 0.412 0.104 0.251 0.047 0.536-0.143 0.728l-4.861 4.861 4.861 4.861c0.193 0.192 0.251 0.476 0.143 0.728-0.104 0.247-0.347 0.408-0.615 0.408zM8.943 14.667h18.115l-4.195-4.195c-0.257-0.257-0.257-0.683 0-0.943l4.195-4.195h-18.115l-4.667 4.667 4.667 4.665zM20.667 32h-6.667c-0.367 0-0.667-0.299-0.667-0.667v-16c0-0.368 0.3-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v16c0 0.368-0.3 0.667-0.667 0.667zM14.667 30.667h5.333v-14.667h-5.333v14.667zM20.667 5.333h-6.667c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.3 0.667-0.667 0.667zM14.667 4h5.333v-2.667h-5.333v2.667z',
      ),
      'Post-Sign2ways' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M27.333 10.667h-20c-0.177 0-0.347-0.071-0.472-0.195l-2.667-2.667c-0.26-0.257-0.26-0.683 0-0.943l2.667-2.667c0.125-0.125 0.295-0.195 0.472-0.195h20c0.269 0 0.513 0.163 0.616 0.412 0.104 0.251 0.047 0.536-0.144 0.728l-2.195 2.195 2.195 2.195c0.192 0.192 0.249 0.476 0.144 0.728-0.103 0.245-0.347 0.408-0.616 0.408zM7.609 9.333h18.115l-1.528-1.528c-0.259-0.257-0.259-0.683 0-0.943l1.528-1.528h-18.115l-2 2 2 1.999zM24.667 18.667h-20c-0.269 0-0.513-0.163-0.616-0.412-0.104-0.251-0.047-0.536 0.144-0.727l2.195-2.195-2.195-2.195c-0.191-0.191-0.248-0.476-0.144-0.727 0.103-0.249 0.347-0.412 0.616-0.412h20c0.177 0 0.347 0.071 0.472 0.195l2.667 2.667c0.26 0.257 0.26 0.683 0 0.943l-2.667 2.667c-0.125 0.125-0.295 0.196-0.472 0.196zM6.276 17.333h18.115l2-2-2-2h-18.115l1.528 1.528c0.26 0.257 0.26 0.683 0 0.943l-1.528 1.529zM19.333 32h-6.667c-0.368 0-0.667-0.299-0.667-0.667v-13.333c0-0.368 0.299-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v13.333c0 0.368-0.3 0.667-0.667 0.667zM13.333 30.667h5.333v-12h-5.333v12zM19.333 13.333h-6.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM13.333 12h5.333v-1.333h-5.333v1.333zM19.333 5.333h-6.667c-0.368 0-0.667-0.299-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h6.667c0.367 0 0.667 0.299 0.667 0.667v4c0 0.368-0.3 0.667-0.667 0.667zM13.333 4h5.333v-2.667h-5.333v2.667z',
      ),
      'Posterous' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M12.604 14.667h-10.541c-1.137 0-2.063-0.925-2.063-2.063v-10.541c0-1.139 0.925-2.063 2.063-2.063h10.54c1.139 0 2.064 0.924 2.064 2.063v10.541c0 1.137-0.925 2.063-2.063 2.063zM2.061 1.333c-0.401 0-0.728 0.327-0.728 0.729v10.541c0 0.403 0.328 0.729 0.728 0.729h10.54c0.403 0 0.729-0.327 0.729-0.729v-10.541c0.001-0.403-0.328-0.729-0.728-0.729h-10.541zM29.937 14.667h-10.541c-1.139 0-2.063-0.925-2.063-2.063v-10.541c0-1.139 0.924-2.063 2.063-2.063h10.541c1.139 0 2.063 0.924 2.063 2.063v10.541c0 1.137-0.924 2.063-2.063 2.063zM19.396 1.333c-0.404 0-0.729 0.327-0.729 0.729v10.541c0 0.403 0.328 0.729 0.729 0.729h10.539c0.404 0 0.729-0.327 0.729-0.729v-10.541c0-0.403-0.328-0.729-0.729-0.729h-10.539zM12.604 32h-10.541c-1.137 0-2.063-0.924-2.063-2.063v-10.541c0-1.139 0.925-2.063 2.063-2.063h10.54c1.139 0 2.064 0.924 2.064 2.063v10.541c0 1.139-0.925 2.063-2.063 2.063zM2.061 18.667c-0.401 0-0.728 0.327-0.728 0.729v10.541c0 0.403 0.328 0.729 0.728 0.729h10.54c0.403 0 0.729-0.327 0.729-0.729v-10.541c0.001-0.403-0.328-0.729-0.728-0.729h-10.541zM29.937 32h-10.541c-1.139 0-2.063-0.924-2.063-2.063v-10.541c0-1.139 0.924-2.063 2.063-2.063h10.541c1.139 0 2.063 0.924 2.063 2.063v10.541c0 1.139-0.924 2.063-2.063 2.063zM19.396 18.667c-0.404 0-0.729 0.327-0.729 0.729v10.541c0 0.403 0.328 0.729 0.729 0.729h10.539c0.404 0 0.729-0.327 0.729-0.729v-10.541c0-0.403-0.328-0.729-0.729-0.729h-10.539zM7.648 4.093c1.96 0 3.555 1.593 3.555 3.555 0 1.96-1.595 3.555-3.555 3.555s-3.555-1.595-3.555-3.555c0-1.96 1.596-3.555 3.555-3.555zM7.648 2.76c-2.7 0-4.888 2.189-4.888 4.888 0 2.697 2.188 4.888 4.888 4.888 2.699 0 4.888-2.191 4.888-4.888-0.001-2.699-2.189-4.888-4.888-4.888v0zM24.407 4.093c1.961 0 3.555 1.593 3.555 3.555 0 1.96-1.593 3.555-3.555 3.555s-3.555-1.595-3.555-3.555c0-1.96 1.593-3.555 3.555-3.555zM24.407 2.76c-2.696 0-4.888 2.189-4.888 4.888 0 2.697 2.188 4.888 4.888 4.888s4.888-2.191 4.888-4.888c0-2.699-2.188-4.888-4.888-4.888v0zM7.648 20.852c1.96 0 3.555 1.593 3.555 3.555s-1.595 3.555-3.555 3.555c-1.96 0-3.555-1.593-3.555-3.555s1.596-3.555 3.555-3.555zM7.648 19.519c-2.7 0-4.888 2.193-4.888 4.888 0 2.7 2.188 4.888 4.888 4.888 2.699 0 4.888-2.188 4.888-4.888-0.001-2.701-2.189-4.888-4.888-4.888v0zM24.407 20.852c1.961 0 3.555 1.593 3.555 3.555s-1.593 3.555-3.555 3.555-3.555-1.593-3.555-3.555 1.593-3.555 3.555-3.555zM24.407 19.519c-2.696 0-4.888 2.193-4.888 4.888 0 2.7 2.188 4.888 4.888 4.888s4.888-2.188 4.888-4.888-2.188-4.888-4.888-4.888v0z',
      ),
      'Pound-Sign' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 1.333c8.085 0 14.667 6.58 14.667 14.667 0 8.088-6.581 14.667-14.667 14.667-8.087 0-14.667-6.579-14.667-14.667 0-8.087 6.58-14.667 14.667-14.667zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0zM21.333 26.667h-9.644c-0.244 0-0.469-0.133-0.585-0.349-0.117-0.213-0.108-0.473 0.025-0.681 0.931-1.441 1.212-2.379 1.535-3.644 0.309-1.24 0.2-2.768 0.095-4.244-0.027-0.175-0.743-5.355-0.743-6.975 0-3.221 1.683-4.995 4.736-4.995 1.236 0 2.557 0.385 3.932 1.145 0.321 0.179 0.437 0.584 0.259 0.905-0.179 0.324-0.584 0.441-0.907 0.261-1.173-0.649-2.28-0.979-3.285-0.979-2.321 0-3.403 1.163-3.403 3.661 0 1.528 0.727 6.78 0.733 6.835 0.112 1.552 0.236 3.259-0.127 4.711-0.265 1.044-0.52 1.925-1.099 3.013h8.477c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.668-0.667 0.668zM18.667 18.667h-8c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h8c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Pound-Sign2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24 31.777h-14.905c-0.244 0-0.469-0.135-0.585-0.348-0.117-0.216-0.108-0.476 0.025-0.683 1.468-2.269 1.911-3.748 2.419-5.74 0.492-1.972 0.321-4.364 0.156-6.677-0.043-0.293-1.147-8.273-1.147-10.752 0-4.743 2.471-7.355 6.956-7.355 1.848 0 3.833 0.58 5.9 1.724 0.321 0.179 0.439 0.584 0.259 0.908-0.179 0.321-0.584 0.437-0.907 0.259-1.867-1.033-3.636-1.557-5.252-1.557-3.783 0-5.623 1.969-5.623 6.021 0 2.389 1.127 10.531 1.139 10.613 0.169 2.351 0.356 4.96-0.188 7.141-0.448 1.755-0.872 3.208-1.963 5.109h13.716c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.669-0.667 0.669zM20 19.777h-12c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h12c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Pound' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M17.335 20.817h-4.443c-0.253 0-0.487-0.143-0.599-0.372-0.112-0.227-0.084-0.5 0.071-0.7 1.119-1.448 1.253-3.312 0.412-5.699-0.241-0.685-0.136-1.447 0.281-2.035 0.436-0.616 1.136-0.969 1.92-0.969 1.087 0 2.356 0.585 2.356 2.235 0 0.368-0.3 0.667-0.667 0.667-0.368 0-0.667-0.299-0.667-0.667 0-0.247 0-0.903-1.023-0.903-0.347 0-0.649 0.148-0.832 0.405-0.171 0.241-0.212 0.541-0.112 0.824 0.816 2.315 0.836 4.251 0.052 5.883h3.249c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.664-0.667 0.664zM16.001 16.817h-4c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h4c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM7.411 25.183c-2.289 0-4.521-0.14-6.827-0.429-0.333-0.045-0.584-0.329-0.584-0.665v-16.001c0-0.191 0.083-0.373 0.225-0.5s0.336-0.187 0.524-0.161c2.252 0.284 4.433 0.421 6.669 0.421 3.048 0 5.831-0.26 8.521-0.511 2.721-0.256 5.533-0.519 8.645-0.519 2.292 0 4.525 0.141 6.831 0.431 0.335 0.041 0.584 0.325 0.584 0.661v16.001c0 0.192-0.084 0.373-0.225 0.5-0.144 0.127-0.336 0.185-0.525 0.161-2.251-0.284-4.432-0.421-6.667-0.421-3.052 0-5.833 0.26-8.525 0.513-2.72 0.255-5.535 0.519-8.647 0.519zM1.335 23.5c2.044 0.235 4.037 0.351 6.076 0.351 3.049 0 5.833-0.261 8.524-0.513 2.723-0.253 5.536-0.52 8.648-0.52 2.041 0 4.040 0.112 6.084 0.344v-14.66c-2.044-0.236-4.037-0.351-6.080-0.351-3.049 0-5.833 0.26-8.524 0.513-2.721 0.253-5.533 0.517-8.644 0.517-2.044 0-4.041-0.112-6.087-0.343v14.661zM7.411 22.516c-1.385 0-2.736-0.055-4.129-0.167-0.367-0.028-0.64-0.351-0.611-0.716 0.029-0.367 0.353-0.644 0.719-0.612 1.359 0.109 2.675 0.164 4.023 0.164 0.368 0 0.667 0.299 0.667 0.667-0.001 0.365-0.3 0.664-0.668 0.664zM28.668 10.981c-0.017 0-0.035 0-0.055-0.001-1.349-0.109-2.665-0.163-4.028-0.163-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667c1.396 0 2.749 0.055 4.135 0.165 0.365 0.031 0.639 0.352 0.611 0.719-0.025 0.348-0.319 0.613-0.663 0.613z',
      ),
      'Power-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.001 30.684c-7.996 0-14.5-6.505-14.5-14.5 0-4.532 2.168-8.869 5.799-11.603 0.296-0.219 0.712-0.163 0.933 0.132s0.163 0.712-0.132 0.933c-3.299 2.483-5.268 6.421-5.268 10.537 0 7.257 5.907 13.167 13.167 13.167s13.167-5.909 13.167-13.167c0-4.164-1.919-7.996-5.268-10.517-0.295-0.221-0.353-0.639-0.132-0.931 0.221-0.297 0.639-0.359 0.933-0.135 3.685 2.772 5.799 6.993 5.799 11.583 0.003 7.995-6.501 14.5-14.497 14.5zM16.168 13.316c-0.368 0-0.667-0.299-0.667-0.667v-10.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v10.667c0 0.369-0.299 0.667-0.667 0.667z',
      ),
      'Power-3' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 17.333c-1.471 0-2.667-1.196-2.667-2.667v-12c0-1.471 1.196-2.667 2.667-2.667 1.472 0 2.667 1.196 2.667 2.667v12c0 1.471-1.195 2.667-2.667 2.667zM16 1.333c-0.735 0-1.333 0.597-1.333 1.333v12c0 0.736 0.599 1.333 1.333 1.333s1.333-0.597 1.333-1.333v-12c0-0.736-0.599-1.333-1.333-1.333zM16 32c-8.087 0-14.667-6.58-14.667-14.667 0-5.619 3.289-10.813 8.38-13.236 0.208-0.1 0.449-0.084 0.643 0.036 0.193 0.124 0.311 0.335 0.311 0.565v4.645c0 0.209-0.099 0.409-0.265 0.532-2.373 1.787-3.735 4.504-3.735 7.455 0 5.145 4.187 9.333 9.333 9.333 5.145 0 9.333-4.188 9.333-9.333 0-2.951-1.361-5.668-3.735-7.453-0.167-0.127-0.265-0.323-0.265-0.532v-4.647c0-0.232 0.117-0.441 0.309-0.567 0.195-0.12 0.437-0.139 0.643-0.035 5.092 2.42 8.381 7.617 8.381 13.236 0 8.087-6.581 14.667-14.667 14.667zM9.333 5.804c-4.083 2.367-6.667 6.784-6.667 11.529 0 7.352 5.981 13.333 13.333 13.333s13.333-5.981 13.333-13.333c0-4.748-2.584-9.163-6.667-11.529v3.217c2.547 2.040 4 5.051 4 8.312 0 5.881-4.785 10.667-10.667 10.667s-10.667-4.785-10.667-10.667c0-3.261 1.453-6.272 4-8.312v-3.217z',
      ),
      'Power-Cable' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28.667 31.333c-0.044 0-0.085-0.004-0.131-0.013l-6.667-1.333c-0.311-0.063-0.536-0.336-0.536-0.653v-5.333c0-0.317 0.224-0.591 0.536-0.653l6.667-1.333c0.197-0.036 0.4 0.013 0.552 0.139 0.157 0.127 0.245 0.317 0.245 0.516v8c0 0.199-0.088 0.389-0.245 0.516-0.119 0.096-0.268 0.149-0.421 0.149zM22.667 28.787l5.333 1.068v-6.375l-5.333 1.068v4.239zM30.667 26h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM30.667 28.667h-1.333c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h1.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM21.333 27.333h-16c-1.627-0.045-4.667-1.079-4.667-4.667 0-2.153 0.819-4.721 4.723-4.721 0.172 0 0.541 0.011 1.059 0.028 10.524 0.325 13.688-0.308 14.489-0.899 1.829-1.347 1.945-3.556 1.127-4.955-0.751-1.284-2.507-2.224-5.177-1.013-4.039 1.832-8.328 1.932-10.928 0.256-1.443-0.929-2.236-2.361-2.236-4.029 0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667c0 1.235 0.547 2.213 1.625 2.909 2.195 1.416 6.076 1.276 9.655-0.349 3.479-1.58 5.88-0.151 6.879 1.553 1.113 1.899 0.971 4.893-1.487 6.703-1.887 1.387-9.177 1.348-15.321 1.155-0.497-0.016-0.852-0.027-1.017-0.027-1.676 0.001-3.389 0.405-3.389 3.389 0 3.203 3.215 3.331 3.352 3.333h15.981c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM7.333 7.333h-5.333c-0.368 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.299-0.667 0.667-0.667h5.333c0.368 0 0.667 0.299 0.667 0.667v5.333c0 0.368-0.299 0.667-0.667 0.667zM2.667 6h4v-4h-4v4z',
      ),
      'Power-Station' => 
      array (
        'height' => '32',
        'width' => '39',
        'path' => 'M31.568 29.833h-24.608c-0.256 0-0.489-0.145-0.601-0.377-0.112-0.231-0.083-0.505 0.081-0.705 7.2-9.008 5.975-19.395 5.963-19.5-0.024-0.191 0.035-0.383 0.161-0.525 0.128-0.144 0.307-0.225 0.5-0.225h12.403c0.193 0 0.372 0.083 0.5 0.225 0.128 0.141 0.188 0.335 0.161 0.524-0.013 0.104-1.224 10.511 5.967 19.5 0.159 0.199 0.195 0.472 0.083 0.704-0.117 0.235-0.352 0.38-0.609 0.38zM8.303 28.5h21.921c-5.672-7.825-5.648-16.147-5.487-18.667h-10.947c0.161 2.52 0.181 10.841-5.488 18.667zM17.931 29.833h-17.264c-0.256 0-0.488-0.145-0.6-0.377-0.112-0.231-0.081-0.505 0.083-0.705 5.083-6.355 4.227-14.091 4.217-14.169-0.027-0.189 0.033-0.38 0.163-0.521 0.127-0.143 0.305-0.224 0.496-0.224h7.573c0.367 0 0.667 0.299 0.667 0.667 0 0.367-0.3 0.665-0.667 0.665h-6.856c0.101 2.052 0.005 7.921-3.751 13.333h15.939c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.665-0.667 0.665zM37.931 29.833h-17.333c-0.365 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h16.005c-3.753-5.412-3.852-11.281-3.751-13.333h-6.917c-0.367 0-0.667-0.3-0.667-0.667 0-0.368 0.3-0.667 0.667-0.667h7.639c0.192 0 0.368 0.083 0.497 0.224 0.128 0.14 0.189 0.332 0.164 0.521-0.012 0.079-0.861 7.817 4.216 14.171 0.157 0.199 0.193 0.472 0.081 0.704-0.112 0.235-0.347 0.38-0.601 0.38zM20.597 7.833c-0.169 0-0.341-0.065-0.472-0.195-0.26-0.259-0.26-0.683 0-0.943 0.193-0.192 0.117-0.504-0.188-1.287-0.339-0.868-0.804-2.059 0.188-3.047 0.257-0.259 0.683-0.259 0.943 0 0.257 0.26 0.257 0.684 0 0.943-0.336 0.336-0.224 0.752 0.112 1.621 0.307 0.789 0.729 1.871-0.112 2.712-0.131 0.129-0.299 0.195-0.471 0.195zM17.931 7.833c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.259-0.26-0.683 0-0.943 0.192-0.192 0.117-0.504-0.189-1.287-0.339-0.868-0.804-2.059 0.189-3.047 0.257-0.259 0.683-0.259 0.943 0 0.257 0.26 0.257 0.684 0 0.943-0.336 0.336-0.224 0.752 0.112 1.621 0.305 0.789 0.729 1.871-0.112 2.712-0.129 0.129-0.3 0.195-0.471 0.195z',
      ),
      'Power' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 31.236c-7.908 0-14.341-6.432-14.341-14.341 0-6.751 4.6-12.501 11.187-13.983 0.36-0.084 0.716 0.145 0.797 0.505 0.081 0.359-0.145 0.715-0.504 0.797-5.973 1.344-10.147 6.559-10.147 12.681 0 7.172 5.835 13.008 13.008 13.008s13.008-5.835 13.008-13.008c0-6.057-4.292-11.397-10.205-12.695-0.36-0.080-0.585-0.435-0.508-0.796 0.079-0.36 0.437-0.587 0.795-0.508 6.521 1.432 11.252 7.32 11.252 13.999 0 7.908-6.432 14.34-14.341 14.34zM15.972 12.764c-0.368 0-0.667-0.3-0.667-0.667v-10.667c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v10.667c0 0.368-0.299 0.667-0.667 0.667z',
      ),
      'Prater' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.068 27.664c-6.616 0-12-5.383-12-11.999 0-6.617 5.384-12.001 12-12.001 6.617 0 12 5.385 12 12.001s-5.383 11.999-12 11.999zM16.068 4.997c-5.881 0-10.667 4.787-10.667 10.668s4.785 10.665 10.667 10.665c5.881 0 10.667-4.784 10.667-10.665 0-5.883-4.785-10.668-10.667-10.668zM16.068 23.664c-4.412 0-8-3.588-8-8 0-4.411 3.588-8 8-8s8 3.589 8 8c0 4.412-3.589 8-8 8zM16.068 8.997c-3.676 0-6.667 2.991-6.667 6.667s2.991 6.667 6.667 6.667c3.677 0 6.667-2.991 6.667-6.667s-2.989-6.667-6.667-6.667zM24.136 31.001c-0.235 0-0.464-0.127-0.584-0.345l-7.484-13.609-7.483 13.609-1.168-0.643 8.068-14.669c0.117-0.213 0.341-0.345 0.584-0.345v0c0.243 0 0.467 0.132 0.584 0.345l8.067 14.669c0.177 0.323 0.060 0.729-0.263 0.907-0.103 0.053-0.212 0.081-0.321 0.081zM7.333 26.332h-2.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM5.333 24.999h1.333v-1.333h-1.333v1.333zM4.667 19.665h-2.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM2.667 18.332h1.333v-1.333h-1.333v1.333zM4.667 12.999h-2.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM2.667 11.665h1.333v-1.333h-1.333v1.333zM10 6.332h-2.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM8 4.999h1.333v-1.333h-1.333v1.333zM18 4.999h-2.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM16 3.665h1.333v-1.333h-1.333v1.333zM26 7.665h-2.667c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM24 6.332h1.333v-1.333h-1.333v1.333zM30 14.332h-2.667c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM28 12.999h1.333v-1.333h-1.333v1.333zM30 20.999h-2.667c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM28 19.665h1.333v-1.333h-1.333v1.333zM26 27.665h-2.667c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM24 26.332h1.333v-1.333h-1.333v1.333z',
      ),
      'Present' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28 31.584h-24c-0.368 0-0.667-0.299-0.667-0.667v-17.333c0-0.368 0.299-0.667 0.667-0.667h24c0.367 0 0.667 0.299 0.667 0.667v17.333c0 0.368-0.3 0.667-0.667 0.667zM4.667 30.251h22.667v-16h-22.667v16zM29.333 14.251h-26.667c-0.368 0-0.667-0.299-0.667-0.667v-5.333c0-0.368 0.299-0.667 0.667-0.667h26.667c0.367 0 0.667 0.299 0.667 0.667v5.333c0 0.368-0.3 0.667-0.667 0.667zM3.333 12.917h25.333v-4h-25.333v4zM16 30.917c-0.368 0-0.667-0.299-0.667-0.667v-21.333c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v21.333c0 0.368-0.299 0.667-0.667 0.667zM7.667 8.917c-2.645 0-4.333-2.369-4.333-4 0-1.511 1.208-3.277 4.611-3.277 3.068 0 6.721 2.836 8.6 5.505 0.211 0.301 0.14 0.716-0.161 0.928-0.303 0.212-0.717 0.141-0.929-0.161-1.711-2.428-4.987-4.94-7.511-4.94-2.053 0-3.277 0.727-3.277 1.944 0 0.941 1.139 2.667 3 2.667 0.368 0 0.667 0.299 0.667 0.667s-0.297 0.668-0.665 0.668zM24.333 8.917c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667c1.861 0 3-1.725 3-2.667 0-1.217-1.225-1.944-3.277-1.944-2.525 0-5.801 2.512-7.511 4.94-0.212 0.301-0.627 0.373-0.929 0.161-0.301-0.213-0.373-0.628-0.161-0.928 1.88-2.669 5.532-5.505 8.6-5.505 3.404 0 4.611 1.767 4.611 3.277 0.001 1.629-1.687 3.999-4.332 3.999zM16 7.528c-0.368 0-0.667-0.299-0.667-0.667 0-1.212-1.712-3.771-3.249-5.308-0.26-0.26-0.26-0.683 0-0.943s0.683-0.26 0.943 0c1.511 1.512 3.639 4.449 3.639 6.251 0.001 0.368-0.297 0.667-0.665 0.667zM16 7.528c-0.368 0-0.667-0.299-0.667-0.667 0-1.8 2.128-4.739 3.639-6.251 0.26-0.26 0.684-0.26 0.943 0 0.26 0.26 0.26 0.683 0 0.943-1.535 1.537-3.249 4.096-3.249 5.308 0.001 0.368-0.297 0.667-0.665 0.667z',
      ),
      'Presents' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28.667 32h-26.667c-0.368 0-0.667-0.3-0.667-0.667v-13.333c0-0.367 0.299-0.667 0.667-0.667h26.667c0.368 0 0.667 0.3 0.667 0.667v13.333c0 0.367-0.299 0.667-0.667 0.667zM2.667 30.667h25.333v-12h-25.333v12zM30 18.667h-29.333c-0.368 0-0.667-0.3-0.667-0.667v-4c0-0.368 0.299-0.667 0.667-0.667h29.333c0.368 0 0.667 0.299 0.667 0.667v4c0 0.367-0.299 0.667-0.667 0.667zM1.333 17.333h28v-2.667h-28v2.667zM15.333 31.333c-0.368 0-0.667-0.3-0.667-0.667v-16c0-0.368 0.299-0.667 0.667-0.667s0.667 0.299 0.667 0.667v16c0 0.367-0.299 0.667-0.667 0.667zM26 14.667h-16c-0.368 0-0.667-0.299-0.667-0.667v-10.667c0-0.368 0.299-0.667 0.667-0.667h16c0.368 0 0.667 0.299 0.667 0.667v10.667c0 0.368-0.299 0.667-0.667 0.667zM10.667 13.333h14.667v-9.333h-14.667v9.333zM27.333 4h-18.667c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h18.667c0.368 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM9.333 2.667h17.333v-1.333h-17.333v1.333zM18 14c-0.368 0-0.667-0.299-0.667-0.667v-12c0-0.368 0.299-0.667 0.667-0.667 0.367 0 0.667 0.299 0.667 0.667v12c0 0.368-0.3 0.667-0.667 0.667z',
      ),
      'Press' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M8.491 3.269h-3.917c-0.36 0-0.653-0.293-0.653-0.653 0-0.359 0.293-0.653 0.653-0.653h3.917c0.36 0 0.653 0.295 0.653 0.653 0 0.36-0.293 0.653-0.653 0.653zM8.491 5.257c-0.124 0-0.249-0.035-0.36-0.109-0.3-0.199-0.383-0.605-0.184-0.904l1.096-1.655-1.088-1.557c-0.205-0.297-0.133-0.703 0.163-0.909 0.297-0.203 0.704-0.133 0.909 0.163l1.34 1.925c0.153 0.22 0.157 0.515 0.008 0.736l-1.341 2.023c-0.125 0.185-0.331 0.288-0.543 0.288zM22.857 3.269h-3.917c-0.361 0-0.653-0.293-0.653-0.653 0-0.359 0.293-0.653 0.653-0.653h3.917c0.36 0 0.652 0.295 0.652 0.653 0 0.36-0.293 0.653-0.652 0.653zM18.973 5.257c-0.211 0-0.417-0.103-0.543-0.295l-1.343-2.021c-0.147-0.223-0.144-0.517 0.008-0.736l1.343-1.925c0.203-0.297 0.611-0.368 0.908-0.161 0.296 0.207 0.369 0.615 0.163 0.908l-1.088 1.556 1.096 1.655c0.199 0.299 0.117 0.707-0.185 0.904-0.108 0.081-0.233 0.116-0.359 0.116zM22.205 32h-7.379c-3.080 0-5.268-4.932-7.199-9.284-0.752-1.699-1.464-3.297-2.052-4.131-0.761-1.065-0.879-3.079 0.108-4.069 0.975-0.969 2.671-1.003 3.615-0.061l1.803 1.877v-10.689c0-1.384 1.196-2.548 2.612-2.548 1.44 0 2.611 1.129 2.611 2.52v5.655c0.385-0.215 0.831-0.337 1.307-0.337 1.125 0 2.111 0.736 2.469 1.731 0.415-0.268 0.913-0.424 1.449-0.424 1.124 0 2.111 0.736 2.469 1.729 0.415-0.267 0.913-0.424 1.448-0.424 1.417 0 2.612 1.168 2.612 2.547v7.065c0 5.407-5.312 8.623-5.539 8.753-0.1 0.061-0.217 0.091-0.335 0.091zM7.551 15.044c-0.347 0-0.689 0.141-0.941 0.396-0.492 0.493-0.397 1.788 0.032 2.392 0.664 0.937 1.365 2.523 2.18 4.356 1.593 3.591 3.775 8.509 6.005 8.509h7.188c0.811-0.531 4.757-3.345 4.757-7.535v-7.065c0-0.673-0.597-1.243-1.305-1.243s-1.305 0.559-1.305 1.215c0 0.359-0.293 0.652-0.653 0.652s-0.652-0.292-0.652-0.652v-1.279c0-0.673-0.599-1.243-1.305-1.243-0.708 0-1.305 0.559-1.305 1.215 0 0.359-0.293 0.653-0.653 0.653s-0.652-0.295-0.652-0.653v-1.279c0-0.673-0.599-1.243-1.305-1.243-0.708 0-1.305 0.559-1.305 1.215 0 0.359-0.293 0.653-0.653 0.653-0.361 0-0.653-0.295-0.653-0.653v-7.835c0-0.656-0.599-1.215-1.305-1.215-0.708 0-1.305 0.572-1.305 1.243v12.313c0 0.268-0.163 0.512-0.409 0.608-0.245 0.099-0.528 0.037-0.715-0.155l-2.92-3.043c-0.205-0.212-0.501-0.329-0.817-0.329z',
      ),
      'Preview' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 23.237c-5.036 0-9.631-2.576-12.281-6.888-0.133-0.213-0.133-0.481 0-0.695 2.651-4.311 7.245-6.889 12.281-6.889s9.631 2.579 12.281 6.888c0.133 0.213 0.133 0.481 0 0.695-2.651 4.313-7.245 6.889-12.281 6.889zM5.079 16c2.435 3.703 6.488 5.904 10.921 5.904s8.487-2.197 10.921-5.904c-2.435-3.703-6.488-5.904-10.921-5.904s-8.487 2.201-10.921 5.904zM16 20.263c-2.352 0-4.263-1.916-4.263-4.263s1.913-4.263 4.263-4.263 4.263 1.916 4.263 4.263-1.911 4.263-4.263 4.263zM16 13.071c-1.616 0-2.929 1.313-2.929 2.929s1.313 2.929 2.929 2.929 2.929-1.313 2.929-2.929-1.313-2.929-2.929-2.929zM21.124 22.248c-0.18 0-0.36-0.073-0.491-0.216-0.249-0.271-0.232-0.693 0.040-0.94 1.417-1.305 2.236-3.161 2.236-5.088s-0.817-3.787-2.241-5.091c-0.272-0.251-0.289-0.672-0.040-0.943 0.251-0.271 0.675-0.287 0.941-0.039 1.697 1.559 2.673 3.773 2.673 6.076 0 2.305-0.972 4.517-2.667 6.075-0.129 0.108-0.291 0.165-0.452 0.165zM10.881 22.251c-0.161 0-0.323-0.057-0.451-0.175-1.697-1.56-2.673-3.773-2.673-6.077s0.972-4.517 2.669-6.075c0.271-0.248 0.695-0.229 0.943 0.039 0.248 0.269 0.232 0.695-0.040 0.941-1.42 1.305-2.239 3.161-2.239 5.089s0.817 3.787 2.241 5.092c0.272 0.249 0.289 0.671 0.040 0.941-0.129 0.152-0.311 0.224-0.491 0.224zM31.333 32h-30.667c-0.367 0-0.667-0.3-0.667-0.667v-30.667c0-0.367 0.3-0.667 0.667-0.667h30.667c0.367 0 0.667 0.3 0.667 0.667v30.667c0 0.367-0.3 0.667-0.667 0.667zM1.333 30.667h29.333v-29.333h-29.333v29.333z',
      ),
      'Previous' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.145 23.584c-0.183 0-0.364-0.076-0.496-0.221l-5.625-6.251c-0.228-0.253-0.228-0.639 0-0.892l5.625-6.251c0.247-0.273 0.668-0.295 0.941-0.049 0.275 0.247 0.296 0.668 0.049 0.941l-5.223 5.804 5.223 5.805c0.247 0.273 0.224 0.695-0.049 0.94-0.127 0.116-0.285 0.173-0.445 0.173zM21.479 23.584c-0.183 0-0.364-0.076-0.497-0.221l-5.624-6.251c-0.228-0.253-0.228-0.639 0-0.892l5.624-6.251c0.249-0.273 0.667-0.295 0.943-0.049 0.273 0.247 0.296 0.668 0.049 0.941l-5.224 5.804 5.224 5.805c0.247 0.273 0.224 0.695-0.049 0.94-0.127 0.116-0.285 0.173-0.445 0.173zM16 1.333c8.085 0 14.667 6.58 14.667 14.667 0 8.085-6.581 14.667-14.667 14.667-8.087 0-14.667-6.581-14.667-14.667 0-8.087 6.58-14.667 14.667-14.667zM16 0c-8.836 0-16 7.164-16 16s7.164 16 16 16 16-7.164 16-16-7.164-16-16-16v0z',
      ),
      'Pricing' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M24.668 31.859h-17.333c-0.367 0-0.667-0.3-0.667-0.667v-23.087c0-0.177 0.071-0.347 0.195-0.472l6.251-6.251c1.653-1.656 4.331-1.656 5.984 0l6.044 6.257c0.123 0.128 0.191 0.291 0.191 0.467v23.084c0.003 0.368-0.297 0.668-0.664 0.668zM8.001 30.525h16v-22.152l-5.852-6.057c-1.139-1.139-2.94-1.143-4.091 0.008l-6.057 6.057v22.144zM16.004 25.92c-1.864 0-3.12-1.088-3.12-2.709 0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667c0 1.277 1.367 1.376 1.787 1.376s1.787-0.099 1.787-1.376c0-0.772-0.235-0.944-1.692-1.663l-0.775-0.383c-1.417-0.695-2.44-1.2-2.44-2.86 0-1.636 1.252-2.729 3.12-2.729 1.845 0 3.084 1.093 3.084 2.729 0 0.365-0.299 0.667-0.667 0.667-0.365 0-0.667-0.301-0.667-0.667 0-1.299-1.339-1.396-1.751-1.396-0.419 0-1.787 0.099-1.787 1.396 0 0.773 0.235 0.943 1.695 1.664l0.773 0.383c1.416 0.695 2.435 1.197 2.435 2.859 0.004 1.621-1.252 2.709-3.116 2.709zM15.92 14.991c-0.189 0-0.347-0.065-0.479-0.197-0.12-0.12-0.188-0.295-0.188-0.469 0-0.187 0.068-0.36 0.197-0.477 0.243-0.241 0.683-0.241 0.933 0 0.12 0.137 0.189 0.305 0.189 0.477 0 0.175-0.069 0.333-0.189 0.469-0.116 0.119-0.292 0.197-0.464 0.197zM15.249 14.321h1.333v1.536h-1.333v-1.536zM15.92 27.859c-0.189 0-0.372-0.068-0.495-0.2-0.104-0.12-0.185-0.293-0.185-0.467s0.081-0.349 0.197-0.469c0.213-0.241 0.695-0.251 0.947 0 0.12 0.12 0.196 0.296 0.196 0.469s-0.080 0.347-0.196 0.479c-0.131 0.12-0.292 0.188-0.464 0.188zM15.249 25.192h1.333v2.004h-1.333v-2.004zM16.215 9.733c-1.347 0-2.443-1.096-2.443-2.443 0-1.349 1.096-2.443 2.443-2.443s2.443 1.093 2.443 2.443c0 1.347-1.096 2.443-2.443 2.443zM16.215 6.181c-0.612 0-1.109 0.497-1.109 1.109s0.497 1.109 1.109 1.109 1.109-0.497 1.109-1.109-0.497-1.109-1.109-1.109z',
      ),
      'Printer' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26 14.667h-20c-0.368 0-0.667-0.299-0.667-0.667v-2.667c0-0.368 0.299-0.667 0.667-0.667h20c0.367 0 0.667 0.299 0.667 0.667v2.667c0 0.368-0.3 0.667-0.667 0.667zM6.667 13.333h18.667v-1.333h-18.667v1.333zM23.333 32h-9.875c-0.156 0-0.305-0.055-0.427-0.155l-4.792-4c-0.152-0.127-0.24-0.315-0.24-0.512v-13.333c0-0.368 0.299-0.667 0.667-0.667h14.667c0.367 0 0.667 0.299 0.667 0.667v17.333c0 0.367-0.3 0.667-0.667 0.667zM13.7 30.667h8.967v-16h-13.333v12.355l4.367 3.645zM30 21.333h-6c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h5.333v-10.667h-26.667v10.667h5.333c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667h-6c-0.368 0-0.667-0.3-0.667-0.667v-12c0-0.368 0.299-0.667 0.667-0.667h28c0.367 0 0.667 0.299 0.667 0.667v12c0 0.367-0.3 0.667-0.667 0.667zM24.667 9.333h-17.333c-0.368 0-0.667-0.299-0.667-0.667v-8c0-0.368 0.299-0.667 0.667-0.667h17.333c0.367 0 0.667 0.299 0.667 0.667v8c0 0.368-0.3 0.667-0.667 0.667zM8 8h16v-6.667h-16v6.667zM14 31.333c-0.368 0-0.667-0.3-0.667-0.667v-2.667h-4c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h4.667c0.368 0 0.667 0.3 0.667 0.667v3.333c0 0.367-0.299 0.667-0.667 0.667zM20 18.667h-8c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h8c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM20 21.333h-8c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h8c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM20 24h-8c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h8c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Professor' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M31.333 25.333h-15.333v-1.333h14.667v-20h-22.667v5.333h-1.333v-6c0-0.368 0.299-0.667 0.667-0.667h24c0.367 0 0.667 0.299 0.667 0.667v21.333c0 0.368-0.3 0.667-0.667 0.667zM8.667 20c-3.308 0-6-2.693-6-6s2.692-6 6-6 6 2.693 6 6-2.692 6-6 6zM8.667 9.333c-2.573 0-4.667 2.093-4.667 4.667s2.093 4.667 4.667 4.667 4.667-2.093 4.667-4.667-2.093-4.667-4.667-4.667zM16.667 29.333h-16c-0.368 0-0.667-0.299-0.667-0.667v-2.445c0-3.665 2.348-6.959 5.844-8.195 0.293-0.103 0.619 0.012 0.784 0.271l2.040 3.211 2.063-3.228c0.165-0.257 0.485-0.369 0.776-0.272 3.485 1.179 5.828 4.389 5.828 7.991v2.667c-0.001 0.369-0.301 0.668-0.668 0.668zM1.333 28h14.667v-2c0-2.86-1.763-5.429-4.437-6.545l-2.335 3.655c-0.123 0.192-0.335 0.305-0.561 0.305v0c-0.228 0-0.44-0.117-0.561-0.305l-2.307-3.632c-2.691 1.169-4.464 3.815-4.464 6.745l-0.001 1.777zM25.333 8h-8c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h8c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM28 12h-10.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h10.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM28 16h-10.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h10.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM15.448 21.885c-0.171 0-0.341-0.065-0.472-0.195-0.26-0.257-0.26-0.683 0-0.943l3.772-3.771c0.259-0.257 0.683-0.257 0.943 0 0.259 0.26 0.259 0.685 0 0.943l-3.772 3.771c-0.129 0.129-0.3 0.195-0.471 0.195z',
      ),
      'Profile' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M28.667 32h-25.333c-0.368 0-0.667-0.3-0.667-0.667v-30.667c0-0.367 0.299-0.667 0.667-0.667h25.333c0.367 0 0.667 0.3 0.667 0.667v30.667c0 0.367-0.3 0.667-0.667 0.667zM4 30.667h24v-29.333h-24v29.333zM16.273 13.057c-2.396 0-4.2-3.536-4.2-5.829 0-2.316 1.884-4.199 4.2-4.199 2.315 0 4.2 1.883 4.2 4.199 0 2.293-1.804 5.829-4.2 5.829zM16.273 4.361c-1.581 0-2.867 1.287-2.867 2.864 0 1.693 1.389 4.496 2.867 4.496 1.451 0 2.867-2.845 2.867-4.496 0-1.58-1.285-2.864-2.867-2.864zM16.273 20.361c-3.875 0-7.028-2.235-7.028-4.98 0-1.789 1.379-4.623 3.685-6.265l0.773 1.084c-1.869 1.333-3.125 3.752-3.125 5.18 0 1.975 2.608 3.645 5.695 3.645 3.085 0 5.695-1.671 5.695-3.645 0-1.425-1.256-3.849-3.128-5.18l0.773-1.084c2.307 1.641 3.688 4.475 3.688 6.265 0.001 2.747-3.153 4.98-7.028 4.98zM24 24h-14.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h14.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM24 28h-14.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h14.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Project' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M26.667 32h-21.333c-0.368 0-0.667-0.3-0.667-0.667v-30.667c0-0.367 0.299-0.667 0.667-0.667h21.333c0.367 0 0.667 0.3 0.667 0.667v30.667c0 0.367-0.3 0.667-0.667 0.667zM6 30.667h20v-29.333h-20v29.333zM21.333 17.333h-10.667c-0.368 0-0.667-0.3-0.667-0.667v-10.667c0-0.367 0.299-0.667 0.667-0.667h10.667c0.367 0 0.667 0.3 0.667 0.667v10.667c0 0.367-0.3 0.667-0.667 0.667zM11.333 16h9.333v-9.333h-9.333v9.333zM20.667 21.333h-9.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h9.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM20.667 24h-9.333c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h9.333c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Projector-2' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M29.208 23h-9.875c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h9.875c0.804 0 1.459-0.655 1.459-1.459v-9.084c0-0.804-0.655-1.459-1.459-1.459h-9.875c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h9.875c1.54 0 2.792 1.252 2.792 2.792v9.084c0 1.54-1.252 2.792-2.792 2.792zM12.943 23h-10.151c-1.539 0-2.792-1.252-2.792-2.792v-9.084c0-1.539 1.252-2.792 2.792-2.792h10.152c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667h-10.152c-0.804 0-1.459 0.655-1.459 1.459v9.084c0 0.804 0.655 1.459 1.459 1.459h10.151c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM16 23.667c-4.412 0-8-3.588-8-8s3.588-8 8-8c4.412 0 8 3.588 8 8s-3.588 8-8 8zM16 9c-3.676 0-6.667 2.991-6.667 6.667s2.991 6.667 6.667 6.667 6.667-2.991 6.667-6.667-2.991-6.667-6.667-6.667zM16 19.667c-2.205 0-4-1.795-4-4s1.795-4 4-4c2.205 0 4 1.795 4 4s-1.795 4-4 4zM16 13c-1.471 0-2.667 1.196-2.667 2.667 0 1.472 1.196 2.667 2.667 2.667 1.472 0 2.667-1.195 2.667-2.667 0-1.471-1.195-2.667-2.667-2.667zM6.667 24.333h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM28 24.333h-2.667c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667zM4 13.667h-2.667c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM4 16.333h-2.667c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667zM4 19h-2.667c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h2.667c0.368 0 0.667 0.3 0.667 0.667s-0.299 0.667-0.667 0.667zM30.667 13.667h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM30.667 16.333h-2.667c-0.367 0-0.667-0.299-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.299 0.667 0.667s-0.3 0.667-0.667 0.667zM30.667 19h-2.667c-0.367 0-0.667-0.3-0.667-0.667s0.3-0.667 0.667-0.667h2.667c0.367 0 0.667 0.3 0.667 0.667s-0.3 0.667-0.667 0.667z',
      ),
      'Projector' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M29.208 22h-26.417c-1.539 0-2.791-1.251-2.791-2.792v-9.084c0-1.539 1.251-2.791 2.791-2.791h26.417c1.54 0 2.792 1.251 2.792 2.791v9.084c0 1.541-1.251 2.792-2.792 2.792zM2.792 8.667c-0.803 0-1.459 0.656-1.459 1.459v9.085c0 0.803 0.655 1.459 1.459 1.459h26.419c0.803 0 1.459-0.656 1.459-1.459v-9.085c0-0.804-0.656-1.459-1.459-1.459h-26.419zM24.724 19.333c-2.575 0-4.667-2.092-4.667-4.667s2.092-4.667 4.667-4.667c2.573 0 4.667 2.093 4.667 4.667s-2.095 4.667-4.667 4.667zM24.724 11.333c-1.839 0-3.333 1.496-3.333 3.333s1.495 3.333 3.333 3.333c1.836 0 3.333-1.496 3.333-3.333s-1.497-3.333-3.333-3.333zM26.057 15.333c-0.368 0-0.667-0.299-0.667-0.667s-0.3-0.667-0.667-0.667c-0.368 0-0.667-0.299-0.667-0.667s0.299-0.667 0.667-0.667c1.101 0 2 0.897 2 2 0 0.368-0.3 0.667-0.667 0.667zM4.667 18.667c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM7.333 18.667c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM10 18.667c-0.367 0-0.667-0.299-0.667-0.667v-6.667c0-0.367 0.3-0.667 0.667-0.667s0.667 0.3 0.667 0.667v6.667c0 0.368-0.299 0.667-0.667 0.667zM7.333 24.667h-4c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.367 0.299-0.667 0.667-0.667h4c0.368 0 0.667 0.3 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM4 23.333h2.667v-1.333h-2.667v1.333zM28.667 24.667h-4c-0.367 0-0.667-0.299-0.667-0.667v-2.667c0-0.367 0.3-0.667 0.667-0.667h4c0.368 0 0.667 0.3 0.667 0.667v2.667c0 0.368-0.299 0.667-0.667 0.667zM25.333 23.333h2.667v-1.333h-2.667v1.333z',
      ),
      'Pulse' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M18.112 26.643c-0.013 0-0.027 0-0.039-0.003-0.333-0.019-0.601-0.284-0.627-0.617l-1.079-14.883-1.713 8.961c-0.060 0.312-0.335 0.541-0.655 0.541h-1.275c-0.296 0-0.556-0.195-0.639-0.479l-0.739-2.511-0.705 2.503c-0.083 0.289-0.344 0.487-0.643 0.487h-8c-0.368 0-0.667-0.3-0.667-0.667s0.299-0.667 0.667-0.667h7.496l1.196-4.248c0.081-0.288 0.341-0.483 0.639-0.484 0.259-0.028 0.559 0.195 0.643 0.476l1.251 4.253h0.224l2.563-13.407c0.063-0.331 0.341-0.584 0.695-0.537 0.333 0.020 0.601 0.284 0.625 0.617l1.076 14.845 1.605-8.475c0.059-0.313 0.335-0.541 0.655-0.541 0.001 0 0.003 0 0.004 0 0.321 0.001 0.596 0.233 0.652 0.549l1.236 6.951h7.441c0.367 0 0.667 0.297 0.667 0.667 0 0.364-0.3 0.667-0.667 0.667h-8c-0.323 0-0.6-0.232-0.656-0.549l-0.697-3.925-1.879 9.931c-0.063 0.319-0.339 0.544-0.656 0.544z',
      ),
      'Pumpkin' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 28.667c-1.796 0-3.517-0.651-4.999-1.885-0.696 0.177-1.399 0.267-2.092 0.267-4.912 0-8.909-4.167-8.909-9.291 0-5.119 3.997-9.284 8.909-9.284 0.696 0 1.397 0.088 2.091 0.264 2.964-2.472 7.035-2.472 10 0 0.693-0.176 1.393-0.264 2.089-0.264 4.913 0 8.911 4.165 8.911 9.284 0 5.123-3.997 9.291-8.911 9.291-0.695 0-1.395-0.089-2.092-0.267-1.479 1.235-3.2 1.885-4.997 1.885zM11.336 25.297l0.277 0.251c2.588 2.335 6.183 2.335 8.772 0l0.276-0.251 0.36 0.109c0.691 0.204 1.385 0.308 2.068 0.308 4.177 0 7.576-3.569 7.576-7.956 0-4.385-3.399-7.952-7.576-7.952-0.688 0-1.383 0.104-2.068 0.307l-0.36 0.107-0.276-0.251c-2.587-2.336-6.185-2.336-8.772 0l-0.277 0.251-0.359-0.107c-0.685-0.204-1.381-0.307-2.068-0.307-4.177 0-7.576 3.568-7.576 7.952 0 4.387 3.399 7.956 7.576 7.956 0.683 0 1.379-0.104 2.068-0.308l0.359-0.109zM16.195 7.547c-0.368 0-0.667-0.299-0.667-0.667 0-1.371 1.283-3.547 4.727-3.547h1.079c0.368 0 0.667 0.299 0.667 0.667s-0.299 0.667-0.667 0.667h-1.079c-2.564 0-3.393 1.492-3.393 2.213 0 0.369-0.299 0.667-0.667 0.667zM18.687 20.667c-0.009 0-0.020 0-0.028 0h-4.964c-0.24 0-0.46-0.128-0.579-0.336s-0.116-0.464 0.004-0.669l2.481-4.208c0.24-0.407 0.909-0.407 1.148 0l2.4 4.071c0.124 0.123 0.199 0.291 0.199 0.476 0.005 0.367-0.293 0.667-0.661 0.667zM14.863 19.333h2.629l-1.315-2.229-1.315 2.229zM10.504 18.208v0c-0.236 0-0.455-0.125-0.575-0.328l-2.481-4.208c-0.121-0.207-0.123-0.461-0.004-0.669s0.339-0.336 0.58-0.336h4.963c0.24 0 0.46 0.128 0.579 0.336s0.117 0.464-0.004 0.669l-2.481 4.208c-0.121 0.204-0.339 0.328-0.576 0.328zM9.192 14l1.315 2.229 1.315-2.229h-2.629zM21.849 18.208c-0.235 0-0.453-0.125-0.573-0.328l-2.481-4.208c-0.123-0.205-0.123-0.461-0.005-0.669 0.12-0.208 0.34-0.336 0.58-0.336h4.965c0.24 0 0.459 0.128 0.579 0.336 0.119 0.208 0.117 0.464-0.004 0.669l-2.481 4.208c-0.123 0.204-0.343 0.328-0.579 0.328zM20.535 14l1.313 2.229 1.315-2.229h-2.628zM16 24.328c-2.199 0-4.28-0.459-6.021-1.323-0.329-0.164-0.464-0.564-0.3-0.893 0.164-0.331 0.563-0.467 0.893-0.3 1.556 0.773 3.433 1.184 5.427 1.184 2.020 0 3.991-0.441 5.545-1.241 0.327-0.172 0.729-0.041 0.899 0.287 0.167 0.328 0.039 0.729-0.287 0.897-1.765 0.908-3.893 1.389-6.156 1.389z',
      ),
      'Punk' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16 27.996c-3.504 0-6.824-1.527-9.109-4.187-0.24-0.28-0.208-0.701 0.072-0.941 0.279-0.239 0.699-0.208 0.94 0.072 2.031 2.365 4.981 3.723 8.097 3.723 1.581 0 3.099-0.336 4.517-1 0.333-0.155 0.731-0.012 0.887 0.321s0.013 0.731-0.32 0.887c-1.599 0.747-3.308 1.125-5.084 1.125zM11.333 18.663c-1.837 0-3.333-1.496-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.496 3.333 3.333-1.496 3.333-3.333 3.333zM11.333 13.329c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM20.667 18.663c-1.837 0-3.333-1.496-3.333-3.333s1.496-3.333 3.333-3.333 3.333 1.496 3.333 3.333-1.496 3.333-3.333 3.333zM20.667 13.329c-1.103 0-2 0.897-2 2s0.897 2 2 2 2-0.897 2-2-0.897-2-2-2zM10.667 23.996h-4c-0.368 0-0.667-0.299-0.667-0.667 0-0.367 0.299-0.667 0.667-0.667h4c0.368 0 0.667 0.3 0.667 0.667 0 0.368-0.299 0.667-0.667 0.667zM19.333 9.329h-6.667c-0.267 0-0.508-0.159-0.612-0.404l-2.864-6.683c-0.144-0.336 0.009-0.725 0.343-0.875 4.119-1.82 8.816-1.82 12.936 0 0.333 0.148 0.485 0.537 0.341 0.873l-2.864 6.684c-0.105 0.245-0.347 0.404-0.613 0.404zM13.107 7.996h5.788l2.425-5.663c-3.415-1.333-7.227-1.333-10.639 0l2.425 5.663zM16 31.996c-8.087 0-14.667-6.58-14.667-14.667 0-6.036 3.621-11.384 9.227-13.624 0.341-0.139 0.729 0.028 0.867 0.373 0.137 0.341-0.029 0.731-0.372 0.865-5.096 2.036-8.388 6.899-8.388 12.387 0 7.352 5.981 13.333 13.333 13.333s13.333-5.981 13.333-13.333c0-5.488-3.292-10.351-8.388-12.387-0.341-0.136-0.508-0.525-0.372-0.865 0.139-0.344 0.525-0.509 0.867-0.372 5.605 2.239 9.227 7.585 9.227 13.623 0 8.088-6.581 14.667-14.667 14.667z',
      ),
      'Punker' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M16.167 29.611c-3.676 0-6.667-2.991-6.667-6.667v-1.448c-0.776-0.275-1.333-1.016-1.333-1.885v-2.667c0-0.869 0.557-1.611 1.333-1.885v-1.448c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v2c0 0.368-0.3 0.667-0.667 0.667s-0.667 0.3-0.667 0.667v2.667c0 0.367 0.3 0.667 0.667 0.667s0.667 0.299 0.667 0.667v2c0 2.941 2.392 5.333 5.333 5.333s5.333-2.392 5.333-5.333v-2c0-0.368 0.3-0.667 0.667-0.667s0.667-0.3 0.667-0.667v-2.667c0-0.367-0.3-0.667-0.667-0.667s-0.667-0.299-0.667-0.667v-2c0-0.368 0.3-0.667 0.667-0.667s0.667 0.299 0.667 0.667v1.448c0.776 0.275 1.333 1.016 1.333 1.885v2.667c0 0.869-0.557 1.611-1.333 1.885v1.448c0 3.676-2.991 6.667-6.667 6.667zM10.164 14.317c-0.367 0-0.667-0.301-0.667-0.667 0-2.823 1.788-5.351 4.448-6.291 0.34-0.124 0.728 0.057 0.852 0.409 0.123 0.347-0.061 0.728-0.409 0.851-2.128 0.751-3.557 2.772-3.557 5.031 0 0.369-0.3 0.667-0.667 0.667zM22.165 14.317c-0.368 0-0.667-0.301-0.667-0.667 0-2.256-1.428-4.279-3.553-5.029-0.347-0.124-0.528-0.504-0.407-0.852 0.124-0.348 0.505-0.528 0.852-0.407 2.656 0.937 4.441 3.468 4.441 6.288 0 0.369-0.299 0.667-0.667 0.667zM18.167 13.611h-4c-0.367 0-0.667-0.299-0.667-0.667v-12c0-0.368 0.3-0.667 0.667-0.667h4c0.367 0 0.667 0.299 0.667 0.667v12c0 0.368-0.3 0.667-0.667 0.667zM14.833 12.277h2.667v-10.667h-2.667v10.667zM5.611 31.723c-0.153 0-0.308-0.053-0.435-0.161-0.279-0.24-0.311-0.66-0.071-0.94l4.777-5.555c0.24-0.279 0.66-0.307 0.94-0.071 0.279 0.24 0.309 0.66 0.071 0.94l-4.777 5.555c-0.132 0.153-0.316 0.232-0.505 0.232zM26.389 31.723c-0.189 0-0.373-0.079-0.505-0.232l-4.777-5.555c-0.243-0.28-0.208-0.7 0.071-0.94 0.281-0.24 0.7-0.208 0.94 0.071l4.777 5.555c0.241 0.28 0.208 0.7-0.071 0.94-0.127 0.108-0.281 0.161-0.435 0.161z',
      ),
      'Puzzle' => 
      array (
        'height' => '32',
        'width' => '32',
        'path' => 'M27.251 25.332h-9.159c-0.216 0-0.419-0.104-0.544-0.281-0.125-0.176-0.156-0.401-0.084-0.605 0.156-0.452 0.296-0.805 0.411-1.097 0.22-0.561 0.308-0.799 0.308-1.045 0-0.827-0.991-1.788-2.268-1.788-1.3 0-2.269 0.908-2.269 1.713 0 0.281 0.127 0.611 0.351 1.208 0.107 0.28 0.232 0.609 0.369 1.009 0.073 0.204 0.040 0.429-0.084 0.605-0.125 0.177-0.328 0.281-0.544 0.281h-9.153c-0.367 0-0.667-0.299-0.667-0.667v-5.252c-0.631 0.169-1.248 0.191-1.26 0.191-1.584 0-2.779-1.548-2.779-3.601 0-2.021 1.24-3.603 2.817-3.603 0.012 0 0.608 0.020 1.221 0.184v-5.249c0-0.368 0.3-0.667 0.667-0.667h9.169c0.217 0 0.419 0.105 0.545 0.283 0.125 0.179 0.155 0.405 0.083 0.609-0.156 0.433-0.293 0.78-0.407 1.068-0.229 0.581-0.331 0.845-0.331 1.1 0 0.827 0.991 1.789 2.269 1.789 1.299 0 2.268-0.905 2.268-1.713 0-0.296-0.135-0.641-0.376-1.279-0.104-0.271-0.224-0.585-0.36-0.967-0.076-0.203-0.041-0.431 0.083-0.608 0.125-0.177 0.328-0.283 0.545-0.283h9.177c0.367 0 0.667 0.299 0.667 0.667v5.467c0.103-0.047 0.191-0.085 0.267-0.127 0.305-0.148 0.569-0.276 1.012-0.276 1.615 0 2.927 1.616 2.927 3.603 0 1.985-1.32 3.601-2.943 3.601-0.443 0-0.701-0.131-1.003-0.275-0.076-0.037-0.159-0.083-0.26-0.127v5.467c0 0.365-0.3 0.664-0.667 0.664zM19.049 23.999h7.533v-5.767c0-0.213 0.101-0.415 0.275-0.536 0.173-0.129 0.393-0.161 0.597-0.095 0.681 0.221 1.061 0.408 1.312 0.528 0.248 0.124 0.284 0.139 0.412 0.139 0.872 0 1.609-1.039 1.609-2.268 0-1.231-0.732-2.269-1.593-2.269-0.131 0-0.169 0.016-0.429 0.14-0.251 0.125-0.636 0.307-1.309 0.528-0.201 0.068-0.421 0.032-0.595-0.095-0.173-0.125-0.275-0.325-0.275-0.536v-5.769h-7.551c0.007 0.016 0.015 0.031 0.020 0.048 0.277 0.729 0.464 1.212 0.464 1.752 0 1.651-1.649 3.047-3.601 3.047-1.917 0-3.603-1.46-3.603-3.123 0-0.523 0.169-0.947 0.424-1.591 0.016-0.043 0.033-0.087 0.052-0.136h-7.541v5.765c0 0.365-0.3 0.667-0.667 0.667-0.283 0-0.527-0.177-0.621-0.424-0.241-0.129-0.897-0.277-1.267-0.277-0.817 0-1.484 1.019-1.484 2.269 0 1.272 0.639 2.268 1.445 2.268 0.381 0 1.063-0.151 1.307-0.283 0.099-0.249 0.339-0.419 0.62-0.419 0.367 0 0.667 0.301 0.667 0.667v5.769h7.531c-0.013-0.031-0.027-0.061-0.035-0.091-0.263-0.695-0.436-1.151-0.436-1.68 0-1.651 1.649-3.047 3.603-3.047 1.917 0 3.601 1.459 3.601 3.121 0 0.509-0.159 0.917-0.4 1.531-0.021 0.052-0.043 0.108-0.065 0.165z',
      ),
    );
  }
}