<?php
vc_map( array(
	'name'          => penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Multi Taxonomies Posts Filter', 'soledad' ),
	'base'          => 'multi_taxonomies_posts_filter',
	'html_template' => PENCI_SOLEDAD_DIR . '/inc/js_composer/shortcodes/multi_taxonomies_posts_filter/frontend.php',
	'category'      => penci_get_theme_name( 'Soledad' ),
	'icon'          => PENCI_SOLEDAD_URL . '/images/vc-icon.png',
	'weight'        => 700,
	'params'        => array_merge( array(
		// General
		array(
			'type'             => 'textfield',
			'param_name'       => 'progress_gnr_heading',
			'heading'          => esc_html__( 'General', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Taxonomy Posistion', 'soledad' ),
			'param_name'       => 'tax_position',
			'value'            => array(
				esc_html__( 'Left', 'soledad' )  => 'left',
				esc_html__( 'Right', 'soledad' ) => 'right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Enable Sticky', 'soledad' ),
			'param_name'       => 'tax_sticky',
			'value'            => 'yes',
			'edit_field_class' => 'vc_col-sm-6'
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Taxonomy', 'soledad' ),
			'param_name'       => 'tax',
			'value'            => penci_wpbakery_taxonomies_list_arr(),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'autocomplete',
			'heading'          => esc_html__( 'Select the Post Taxonomies Term.', 'soledad' ),
			'param_name'       => 'taxonomies_in',
			'settings'         => array(
				'multiple'       => true,
				'min_length'     => 1,
				'groups'         => false,
				'unique_values'  => true,
				'display_inline' => true,
				'delay'          => 500,
				'auto_focus'     => true,
				'save_always'    => true,
				'values'         => penci_wpbakery_taxonomies_posts_arr(),
			),
			'edit_field_class' => 'vc_col-sm-6'
		),
		array(
			'type'             => 'autocomplete',
			'heading'          => esc_html__( 'Select the Excluded Post Taxonomies Term.', 'soledad' ),
			'param_name'       => 'taxonomies_ex',
			'settings'         => array(
				'multiple'       => true,
				'min_length'     => 1,
				'groups'         => false,
				'unique_values'  => true,
				'display_inline' => true,
				'delay'          => 500,
				'auto_focus'     => true,
				'save_always'    => true,
				'values'         => penci_wpbakery_taxonomies_posts_arr(),
			),
			'edit_field_class' => 'vc_col-sm-6'
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Limit Terms to Show', 'soledad' ),
			'param_name'       => 'number',
			'edit_field_class' => 'vc_col-sm-6'
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show Posts Count', 'soledad' ),
			'param_name'       => 'count',
			'value'            => 'no',
			'edit_field_class' => 'vc_col-sm-6'
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Taxonomy Order By', 'soledad' ),
			'param_name'       => 'orderby',
			'value'            => array_flip( array(
				'term_id' => __( 'ID', 'soledad' ),
				'name'    => __( 'Name', 'soledad' ),
				'slug'    => __( 'Slug', 'soledad' ),
				'count'   => __( 'Count', 'soledad' ),
			) ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Taxonomy Order', 'soledad' ),
			'param_name'       => 'order',
			'value'            => array_flip( array(
				'ASC'  => __( 'ASC', 'soledad' ),
				'DESC' => __( 'DESC', 'soledad' ),
			) ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Post Order By', 'soledad' ),
			'param_name'       => 'post_orderby',
			'value'            => array_flip( array(
				'date'          => __( 'Published Date', 'soledad' ),
				'ID'            => __( 'Post ID', 'soledad' ),
				'modified'      => __( 'Modified Date', 'soledad' ),
				'title'         => __( 'Post Title', 'soledad' ),
				'rand'          => __( 'Random Posts', 'soledad' ),
				'comment_count' => __( 'Comment Count', 'soledad' ),
				'popular'       => __( 'Most Viewed Posts All Time', 'soledad' ),
				'popular_day'   => __( 'Most Viewed Posts Daily', 'soledad' ),
				'popular7'      => __( 'Most Viewed Posts Once Weekly', 'soledad' ),
				'popular_month' => __( 'Most Viewed Posts Once a Month', 'soledad' ),
			) ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Post Order', 'soledad' ),
			'param_name'       => 'post_order',
			'value'            => array_flip( array(
				'ASC'  => __( 'ASC', 'soledad' ),
				'DESC' => __( 'DESC', 'soledad' ),
			) ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Posts Per Page', 'soledad' ),
			'param_name'       => 'posts_per_page',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Page Navigation Style', 'soledad' ),
			'param_name'       => 'paging',
			'value'            => array(
				esc_html__( 'None', 'soledad' )                   => 'none',
				esc_html__( 'Load More Posts Button', 'soledad' ) => 'loadmore',
				esc_html__( 'Infinite Scroll', 'soledad' )        => 'scroll',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Columns on Desktop:', 'soledad' ),
			'param_name'       => 'column',
			'std'              => '1',
			'value'            => array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
				'6' => '6',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Columns on Tablet', 'soledad' ),
			'param_name'       => 'tab_column',
			'std'              => '2',
			'value'            => array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
				'6' => '6',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Columns on Mobile', 'soledad' ),
			'param_name'       => 'mb_column',
			'value'            => array(
				'1' => '1',
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
				'6' => '6',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Vertical Align', 'soledad' ),
			'param_name'       => 'vertical_position',
			'value'            => array(
				'Top'    => 'top',
				'Middle' => 'middle',
				'Bottom' => 'bottom',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Content Text Align', 'soledad' ),
			'param_name'       => 'text_align',
			'value'            => array(
				'Left'   => 'left',
				'Center' => 'center',
				'Right'  => 'right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Page Navigation Align', 'soledad' ),
			'param_name'       => 'paging_align',
			'value'            => array(
				esc_html__( 'Center', 'soledad' ) => 'align-center',
				esc_html__( 'Left', 'soledad' )   => 'align-left',
				esc_html__( 'Right', 'soledad' )  => 'align-right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		// Image
		array(
			'type'             => 'textfield',
			'param_name'       => 'progress_img_settings',
			'heading'          => esc_html__( 'Image Settings', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'        => 'penci_switch',
			'heading'     => esc_html__( 'Hide Featured Image?', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'hide_thumb',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Image Position', 'soledad' ),
			'param_name'       => 'imgpos',
			'value'            => array(
				esc_html__( 'Left', 'soledad' )  => 'left',
				esc_html__( 'Right', 'soledad' ) => 'right',
				esc_html__( 'Top', 'soledad' )   => 'top',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Image Width', 'soledad' ),
			'param_name'       => 'imgwidth',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Image Align', 'soledad' ),
			'param_name'       => 'image_align',
			'value'            => array(
				esc_html__( 'Center', 'soledad' ) => 'center',
				esc_html__( 'Left', 'soledad' )   => 'left',
				esc_html__( 'Right', 'soledad' )  => 'right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Image Ratio', 'soledad' ),
			'param_name'       => 'img_ratio',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Disable Lazyload Images?', 'soledad' ),
			'param_name'       => 'disable_lazy',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Image Size', 'soledad' ),
			'param_name'       => 'thumb_size',
			'value'            => Penci_Vc_Params_Helper::get_list_image_sizes( true ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Image Size for Mobile', 'soledad' ),
			'param_name'       => 'mthumb_size',
			'value'            => Penci_Vc_Params_Helper::get_list_image_sizes( true ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'No Crop Image?', 'soledad' ),
			'param_name'       => 'nocrop',
			'value'            => 'no',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Move Image Above The Post Meta on Mobile?', 'soledad' ),
			'param_name'       => 'imgtop_mobile',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		// Post Settings
		array(
			'type'             => 'textfield',
			'param_name'       => 'progress_typo_heading',
			'heading'          => esc_html__( 'Post Settings', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'             => 'autocomplete',
			'heading'          => esc_html__( 'Showing Post Meta', 'soledad' ),
			'param_name'       => 'post_meta',
			'settings'         => array(
				'multiple'       => true,
				'min_length'     => 1,
				'groups'         => false,
				'unique_values'  => true,
				'display_inline' => true,
				'delay'          => 500,
				'auto_focus'     => true,
				'save_always'    => true,
				'values'         => array(
					[
						'value' => 'cat',
						'label' => esc_html__( 'Categories', 'soledad' ),
					],
					[
						'value' => 'title',
						'label' => esc_html__( 'Title', 'soledad' ),
					],
					[
						'value' => 'author',
						'label' => esc_html__( 'Author', 'soledad' ),
					],
					[
						'value' => 'date',
						'label' => esc_html__( 'Date', 'soledad' ),
					],
					[
						'value' => 'comment',
						'label' => esc_html__( 'Comments', 'soledad' ),
					],
					[
						'value' => 'views',
						'label' => esc_html__( 'Views', 'soledad' ),
					],
					[
						'value' => 'reading',
						'label' => esc_html__( 'Reading Time', 'soledad' ),
					],
				),
			),
			'description'      => 'Support showing: Categories, Title, Author, Date, Comments, Views, Reading Time',
			'value'            => 'cat,title,date',
			'std'              => 'cat,title,date',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show Primary Category Only', 'soledad' ),
			'param_name'       => 'primary_cat',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Custom Title Words Length', 'soledad' ),
			'param_name'       => 'title_length',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Post Date Position', 'soledad' ),
			'param_name'       => 'date_pos',
			'value'            => array(
				esc_html__( 'Left', 'soledad' )  => 'left',
				esc_html__( 'Right', 'soledad' ) => 'right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Post Date Align', 'soledad' ),
			'param_name'       => 'date_align',
			'value'            => array(
				esc_html__( 'Left', 'soledad' )   => 'left',
				esc_html__( 'Center', 'soledad' ) => 'center',
				esc_html__( 'Right', 'soledad' )  => 'right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Post Date Width', 'soledad' ),
			'param_name'       => 'datewidth',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Post Date Align', 'soledad' ),
			'param_name'       => 'dformat',
			'value'            => array(
				'Default'  => '',
				'Time Ago' => 'timeago',
				'Normal'   => 'normal',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show Post Format Icons', 'soledad' ),
			'param_name'       => 'show_formaticon',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show Review Scores from Penci Review plugin', 'soledad' ),
			'param_name'       => 'show_reviewpie',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show The Post Excerpt?', 'soledad' ),
			'param_name'       => 'show_excerpt',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Custom Excerpt Length', 'soledad' ),
			'param_name'       => 'excerpt_length',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Custom Excerpt Align', 'soledad' ),
			'param_name'       => 'excerpt_align',
			'value'            => array(
				'Left'    => 'left',
				'Center'  => 'center',
				'Right'   => 'right',
				'Justify' => 'justify',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show Read More Button?', 'soledad' ),
			'param_name'       => 'show_readmore',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Read More Button Style', 'soledad' ),
			'param_name'       => 'rmstyle',
			'value'            => array(
				'Default'   => 'filled',
				'Bordered'  => 'bordered',
				'Underline' => 'underline',
				'Text Only' => 'text',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Custom Read More Align', 'soledad' ),
			'param_name'       => 'rm_align',
			'value'            => array(
				'Left'   => 'left',
				'Center' => 'center',
				'Right'  => 'right',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => esc_html__( 'Excerpt & Read More Position', 'soledad' ),
			'param_name'       => 'excerpt_pos',
			'value'            => array(
				'Below of Image' => 'below',
				'Side of Image'  => 'side',
			),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		// Post Settings
		array(
			'type'             => 'textfield',
			'param_name'       => 'progress_typo_heading',
			'heading'          => esc_html__( 'Showing on Mobile', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Hide Post Categories on Mobile?', 'soledad' ),
			'param_name'       => 'hide_cat_mobile',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Hide Post Meta on Mobile?', 'soledad' ),
			'param_name'       => 'hide_meta_mobile',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Hide Post Excerpt on Mobile', 'soledad' ),
			'param_name'       => 'hide_excerpt_mobile',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Hide Post Read More Button on Mobile', 'soledad' ),
			'param_name'       => 'hide_rm_mobile',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		// Carousel Settings
		array(
			'type'             => 'textfield',
			'param_name'       => 'progress_crs_heading',
			'heading'          => esc_html__( 'Carousel Settings', 'soledad' ),
			'value'            => '',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Autoplay', 'soledad' ),
			'param_name'       => 'autoplay',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Carousel Loop', 'soledad' ),
			'param_name'       => 'loop',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Carousel Auto Time ( 1000 = 1s )', 'soledad' ),
			'param_name'       => 'auto_time',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Carousel Speed ( 1000 = 1s )', 'soledad' ),
			'param_name'       => 'speed',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show next/prev buttons', 'soledad' ),
			'param_name'       => 'shownav',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Show dots navigation', 'soledad' ),
			'param_name'       => 'showdots',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),

		// Post Settings
		array(
			'type'             => 'textfield',
			'param_name'       => 'progress_heading_1',
			'heading'          => esc_html__( 'General Style', 'soledad' ),
			'value'            => '',
			'group'            => 'Typo & Color',
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'             => 'penci_switch',
			'heading'          => esc_html__( 'Add Vertical Border Between Post Items', 'soledad' ),
			'param_name'       => 'ver_border',
			'group'            => 'Typo & Color',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'true_state'       => 'yes',
			'false_state'      => 'no',
			'default'          => 'no',
			'std'              => 'no',
		),

		// color
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Post Title Color', 'soledad' ),
			'param_name'       => 'title_color',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Post Title Font Size', 'soledad' ),
			'param_name'       => 'title_fize',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Post Title Hover Color', 'soledad' ),
			'param_name'       => 'title_hcolor',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Post Date Font Size', 'soledad' ),
			'param_name'       => 'date_fize',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Post Date Color', 'soledad' ),
			'param_name'       => 'date_color',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Post Meta Font Size', 'soledad' ),
			'param_name'       => 'meta_fize',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Post Meta Color', 'soledad' ),
			'param_name'       => 'meta_color',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Link Color', 'soledad' ),
			'param_name'       => 'link_color',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Link Hover Color', 'soledad' ),
			'param_name'       => 'link_hcolor',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Post Excerpt Font Size', 'soledad' ),
			'param_name'       => 'excerpt_fize',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Post Excerpt Color', 'soledad' ),
			'param_name'       => 'excerpt_color',
			'edit_field_class' => 'vc_col-sm-6 vc_column',
			'group'            => 'Typo & Color',
		),

	), Penci_Vc_Params_Helper::heading_block_params(), Penci_Vc_Params_Helper::params_heading_filter(), Penci_Vc_Params_Helper::params_custom_meta_fields(), Penci_Vc_Params_Helper::params_heading_filter_style(), Penci_Vc_Params_Helper::params_heading_typo_color(), Penci_Vc_Params_Helper::extra_params(), Penci_Vc_Params_Helper::params_bookmark_icon() )
) );
